/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringListNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.VectorNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.utils.TokenizerFactory;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class CCCCompilerConfiguration
extends BasicCompilerConfiguration {
    public static final int LIBRARY_LEVEL_NONE = 0;
    public static final int LIBRARY_LEVEL_RUNTIME = 1;
    public static final int LIBRARY_LEVEL_CLASSIC = 2;
    public static final int LIBRARY_LEVEL_BINARY = 3;
    public static final int LIBRARY_LEVEL_CONFORMING = 4;
    private static final String[] LIBRARY_LEVEL_NAMES = new String[]{CCCCompilerConfiguration.getString("NoneTxt"), CCCCompilerConfiguration.getString("RuntimeOnlyTxt"), CCCCompilerConfiguration.getString("ClassicIostreamsTxt"), CCCCompilerConfiguration.getString("BinaryStandardTxt"), CCCCompilerConfiguration.getString("ConformingStandardTxt")};
    private static final String[] LIBRARY_LEVEL_OPTIONS = null;
    private IntConfiguration libraryLevel;
    public static final int STANDARDS_OLD = 0;
    public static final int STANDARDS_LEGACY = 1;
    public static final int STANDARDS_DEFAULT = 2;
    public static final int STANDARDS_MODERN = 3;
    private static final String[] STANDARDS_NAMES = new String[]{CCCCompilerConfiguration.getString("OldTxt"), CCCCompilerConfiguration.getString("LegacyTxt"), CCCCompilerConfiguration.getString("DefaultTxt"), CCCCompilerConfiguration.getString("ModernTxt")};
    private static final String[] STANDARD_OPTIONS = null;
    private IntConfiguration standardsEvolution;
    public static final int LANGUAGE_EXT_NONE = 0;
    public static final int LANGUAGE_EXT_DEFAULT = 1;
    public static final int LANGUAGE_EXT_ALL = 2;
    private static final String[] LANGUAGE_EXT_NAMES = new String[]{CCCCompilerConfiguration.getString("NoneTxt"), CCCCompilerConfiguration.getString("DefaultTxt"), CCCCompilerConfiguration.getString("AllTxt")};
    private static final String[] LANGUAGE_EXT_OPTIONS = null;
    private IntConfiguration languageExt;
    private VectorConfiguration<String> includeDirectories;
    private BooleanConfiguration inheritIncludes;
    private VectorConfiguration<String> preprocessorConfiguration;
    private VectorConfiguration<String> preprocessorUndefinedConfiguration;
    private BooleanConfiguration inheritPreprocessor;
    private BooleanConfiguration inheritUndefinedPreprocessor;
    private BooleanConfiguration useLinkerPkgConfigLibraries;
    private MakeConfiguration owner;
    private static final String LIB_FLAG = " --libs ";
    private static final String FLAGS_FLAG = " --cflags ";

    protected CCCCompilerConfiguration(String baseDir, CCCCompilerConfiguration master, MakeConfiguration owner) {
        super(baseDir, master);
        assert (owner != null);
        this.owner = owner;
        this.libraryLevel = new IntConfiguration(master != null ? master.getLibraryLevel() : null, 3, LIBRARY_LEVEL_NAMES, this.getLibraryLevelOptions());
        this.standardsEvolution = new IntConfiguration(master != null ? master.getStandardsEvolution() : null, 2, STANDARDS_NAMES, this.getStandardsEvolutionOptions());
        this.languageExt = new IntConfiguration(master != null ? master.getLanguageExt() : null, 1, LANGUAGE_EXT_NAMES, this.getLanguageExtOptions());
        this.includeDirectories = new VectorConfiguration<String>(master != null ? master.getIncludeDirectories() : null);
        this.inheritIncludes = new BooleanConfiguration(true);
        this.preprocessorConfiguration = new VectorConfiguration<String>(master != null ? master.getPreprocessorConfiguration() : null);
        this.preprocessorUndefinedConfiguration = new VectorConfiguration<String>(master != null ? master.getUndefinedPreprocessorConfiguration() : null);
        this.inheritPreprocessor = new BooleanConfiguration(true);
        this.inheritUndefinedPreprocessor = new BooleanConfiguration(true);
        this.useLinkerPkgConfigLibraries = new BooleanConfiguration(true);
    }

    public void fixupMasterLinks(CCCCompilerConfiguration compilerConfiguration) {
        super.fixupMasterLinks(compilerConfiguration);
        this.getMTLevel().setMaster(compilerConfiguration.getMTLevel());
        this.getLibraryLevel().setMaster(compilerConfiguration.getLibraryLevel());
        this.getStandardsEvolution().setMaster(compilerConfiguration.getStandardsEvolution());
        this.getLanguageExt().setMaster(compilerConfiguration.getLanguageExt());
    }

    @Override
    public boolean getModified() {
        return super.getModified() || this.libraryLevel.getModified() || this.standardsEvolution.getModified() || this.languageExt.getModified() || this.includeDirectories.getModified() || this.inheritIncludes.getModified() || this.preprocessorConfiguration.getModified() || this.inheritPreprocessor.getModified() || this.preprocessorUndefinedConfiguration.getModified() || this.inheritUndefinedPreprocessor.getModified() || this.useLinkerPkgConfigLibraries.getModified();
    }

    protected final String[] getLibraryLevelOptions() {
        return LIBRARY_LEVEL_OPTIONS;
    }

    protected final String[] getStandardsEvolutionOptions() {
        return STANDARD_OPTIONS;
    }

    protected final String[] getLanguageExtOptions() {
        return LANGUAGE_EXT_OPTIONS;
    }

    public void setLibraryLevel(IntConfiguration libraryLevel) {
        this.libraryLevel = libraryLevel;
    }

    public IntConfiguration getLibraryLevel() {
        return this.libraryLevel;
    }

    public void setStandardsEvolution(IntConfiguration standardsEvolution) {
        this.standardsEvolution = standardsEvolution;
    }

    public IntConfiguration getStandardsEvolution() {
        return this.standardsEvolution;
    }

    public void setLanguageExt(IntConfiguration languageExt) {
        this.languageExt = languageExt;
    }

    public IntConfiguration getLanguageExt() {
        return this.languageExt;
    }

    public VectorConfiguration<String> getIncludeDirectories() {
        return this.includeDirectories;
    }

    public void setIncludeDirectories(VectorConfiguration<String> includeDirectories) {
        this.includeDirectories = includeDirectories;
    }

    public BooleanConfiguration getInheritIncludes() {
        return this.inheritIncludes;
    }

    public void setInheritIncludes(BooleanConfiguration inheritIncludes) {
        this.inheritIncludes = inheritIncludes;
    }

    public VectorConfiguration<String> getPreprocessorConfiguration() {
        return this.preprocessorConfiguration;
    }

    public void setPreprocessorConfiguration(VectorConfiguration<String> preprocessorConfiguration) {
        this.preprocessorConfiguration = preprocessorConfiguration;
    }

    public VectorConfiguration<String> getUndefinedPreprocessorConfiguration() {
        return this.preprocessorUndefinedConfiguration;
    }

    public void setUndefinedPreprocessorConfiguration(VectorConfiguration<String> preprocessorUndefinedConfiguration) {
        this.preprocessorUndefinedConfiguration = preprocessorUndefinedConfiguration;
    }

    public BooleanConfiguration getInheritPreprocessor() {
        return this.inheritPreprocessor;
    }

    public void setInheritPreprocessor(BooleanConfiguration inheritPreprocessor) {
        this.inheritPreprocessor = inheritPreprocessor;
    }

    public BooleanConfiguration getInheritUndefinedPreprocessor() {
        return this.inheritUndefinedPreprocessor;
    }

    public void setInheritUndefinedPreprocessor(BooleanConfiguration inheritUndefinedPreprocessor) {
        this.inheritUndefinedPreprocessor = inheritUndefinedPreprocessor;
    }

    public BooleanConfiguration getUseLinkerLibraries() {
        return this.useLinkerPkgConfigLibraries;
    }

    public void setUseLinkerLibraries(BooleanConfiguration useLinkerPkgConfigLibraries) {
        this.useLinkerPkgConfigLibraries = useLinkerPkgConfigLibraries;
    }

    public MakeConfiguration getOwner() {
        return this.owner;
    }

    public void setOwner(MakeConfiguration owner) {
        this.owner = owner;
    }

    protected void assign(CCCCompilerConfiguration conf) {
        super.assign(conf);
        this.getLibraryLevel().assign(conf.getLibraryLevel());
        this.getStandardsEvolution().assign(conf.getStandardsEvolution());
        this.getLanguageExt().assign(conf.getLanguageExt());
        this.getIncludeDirectories().assign(conf.getIncludeDirectories());
        this.getInheritIncludes().assign(conf.getInheritIncludes());
        this.getPreprocessorConfiguration().assign(conf.getPreprocessorConfiguration());
        this.getInheritPreprocessor().assign(conf.getInheritPreprocessor());
        this.getUndefinedPreprocessorConfiguration().assign(conf.getUndefinedPreprocessorConfiguration());
        this.getInheritUndefinedPreprocessor().assign(conf.getInheritUndefinedPreprocessor());
        this.getUseLinkerLibraries().assign(conf.getUseLinkerLibraries());
    }

    protected Sheet.Set getSet(final Project project, final Folder folder, final Item item) {
        OptionToString visitor = new OptionToString(null, null);
        Sheet.Set set1 = new Sheet.Set();
        set1.setName("General");
        set1.setDisplayName(CCCCompilerConfiguration.getString("GeneralTxt"));
        set1.setShortDescription(CCCCompilerConfiguration.getString("GeneralHint"));
        StringBuilder inheritedValues = new StringBuilder();
        CCCCompilerConfiguration master = (CCCCompilerConfiguration)this.getMaster();
        ArrayList<CCCCompilerConfiguration> list = new ArrayList<CCCCompilerConfiguration>();
        while (master != null) {
            list.add(master);
            if (master.getInheritIncludes().getValue()) {
                master = (CCCCompilerConfiguration)master.getMaster();
                continue;
            }
            master = null;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            inheritedValues.append(((CCCCompilerConfiguration)list.get(i)).getIncludeDirectories().toString(visitor, "\n"));
        }
        set1.put((Node.Property)new VectorNodeProp(this.getIncludeDirectories(), this.getMaster() != null ? this.getInheritIncludes() : null, this.owner.getBaseFSPath(), new String[]{"IncludeDirectories", CCCCompilerConfiguration.getString("IncludeDirectoriesTxt"), CCCCompilerConfiguration.getString("IncludeDirectoriesHint"), inheritedValues.toString()}, true, new HelpCtx("AddtlIncludeDirectories")){
            private final TokenizerFactory.Converter converter;
            {
                super(x0, x1, x2, x3, x4, x5);
                this.converter = TokenizerFactory.getPathConverter(project, folder, item);
            }

            @Override
            protected List<String> convertToList(String text) {
                return this.converter.convertToList(text);
            }

            @Override
            protected String convertToString(List<String> list) {
                return this.converter.convertToString(list);
            }
        });
        inheritedValues = new StringBuilder();
        master = (CCCCompilerConfiguration)this.getMaster();
        while (master != null) {
            inheritedValues.append(master.getPreprocessorConfiguration().toString(visitor, "\n"));
            if (master.getInheritPreprocessor().getValue()) {
                master = (CCCCompilerConfiguration)master.getMaster();
                continue;
            }
            master = null;
        }
        set1.put((Node.Property)new StringListNodeProp(this.getPreprocessorConfiguration(), this.getMaster() != null ? this.getInheritPreprocessor() : null, new String[]{"preprocessor-definitions", CCCCompilerConfiguration.getString("PreprocessorDefinitionsTxt"), CCCCompilerConfiguration.getString("PreprocessorDefinitionsHint"), CCCCompilerConfiguration.getString("PreprocessorDefinitionsLbl"), inheritedValues.toString()}, true, new HelpCtx("preprocessor-definitions")){

            @Override
            protected List<String> convertToList(String text) {
                return TokenizerFactory.MACRO_CONVERTER.convertToList(text);
            }

            @Override
            protected String convertToString(List<String> list) {
                return TokenizerFactory.MACRO_CONVERTER.convertToString(list);
            }
        });
        if (this.owner.getConfigurationType().getValue() == 0) {
            inheritedValues = new StringBuilder();
            master = (CCCCompilerConfiguration)this.getMaster();
            while (master != null) {
                inheritedValues.append(master.getUndefinedPreprocessorConfiguration().toString(visitor));
                if (master.getInheritUndefinedPreprocessor().getValue()) {
                    master = (CCCCompilerConfiguration)master.getMaster();
                    continue;
                }
                master = null;
            }
            set1.put((Node.Property)new StringListNodeProp(this.getUndefinedPreprocessorConfiguration(), this.getMaster() != null ? this.getInheritUndefinedPreprocessor() : null, new String[]{"preprocessor-undefined", CCCCompilerConfiguration.getString("PreprocessorUndefinedTxt"), CCCCompilerConfiguration.getString("PreprocessorUndefinedHint"), CCCCompilerConfiguration.getString("PreprocessorUndefinedLbl"), inheritedValues.toString()}, true, new HelpCtx("preprocessor-undefined")){

                @Override
                protected List<String> convertToList(String text) {
                    return TokenizerFactory.UNDEF_CONVERTER.convertToList(text);
                }

                @Override
                protected String convertToString(List<String> list) {
                    return TokenizerFactory.UNDEF_CONVERTER.convertToString(list);
                }
            });
        }
        if (this.getMaster() == null) {
            IntConfiguration configurationType;
            IntConfiguration intConfiguration = configurationType = this.getOwner() == null ? null : this.getOwner().getConfigurationType();
            if (configurationType == null || configurationType.getValue() != 0) {
                set1.put((Node.Property)new BooleanNodeProp(this.getUseLinkerLibraries(), true, "use-linker-libraries", CCCCompilerConfiguration.getString("UseLinkerLibrariesTxt"), CCCCompilerConfiguration.getString("UseLinkerLibrariesHint")));
            }
        }
        return set1;
    }

    private CCCCompilerConfiguration getTopMaster() {
        CCCCompilerConfiguration aMaster = (CCCCompilerConfiguration)this.getMaster();
        if (aMaster == null) {
            return this;
        }
        CCCCompilerConfiguration m;
        while ((m = (CCCCompilerConfiguration)aMaster.getMaster()) != null) {
            aMaster = m;
        }
        return aMaster;
    }

    protected Sheet getSheet(Project project) {
        Sheet sheet = new Sheet();
        sheet.put(this.getSet(project, null, null));
        return sheet;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CCCCompilerConfiguration.class, (String)s);
    }

    protected String getLibrariesFlags() {
        CCCCompilerConfiguration topMaster = this.getTopMaster();
        if (!topMaster.getUseLinkerLibraries().getValue() || topMaster.getOwner() == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (LibraryItem lib : topMaster.getOwner().getLinkerConfiguration().getLibrariesConfiguration().getValue()) {
            int i;
            LibraryItem.OptionItem option;
            String task;
            if (lib.getType() != 4 || (task = (option = (LibraryItem.OptionItem)lib).getLibraryOption()).length() <= 2 || task.charAt(0) != '`' || task.charAt(task.length() - 1) != '`' || (i = task.indexOf(LIB_FLAG)) <= 0) continue;
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(task.substring(0, i));
            buf.append(FLAGS_FLAG);
            buf.append(task.substring(i + LIB_FLAG.length()));
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        return buf.toString();
    }

    protected abstract String getUserIncludeFlag(CompilerSet var1);

    protected abstract String getUserMacroFlag(CompilerSet var1);

    protected static class StringRONodeProp
    extends PropertySupport<String> {
        private String value;

        public StringRONodeProp(String name, String description, String value) {
            super(name, String.class, name, name, true, false);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String v) {
        }
    }

    public static class OptionToString
    implements VectorConfiguration.ToString<String> {
        private final CompilerSet compilerSet;
        private final String prepend;

        public OptionToString(CompilerSet compilerSet, String prepend) {
            this.compilerSet = compilerSet;
            this.prepend = prepend;
        }

        @Override
        public String toString(String item) {
            if (0 < item.length()) {
                if (this.compilerSet != null) {
                    item = CppUtils.normalizeDriveLetter(this.compilerSet, item);
                }
                item = CndPathUtilitities.escapeOddCharacters((String)item);
                return this.prepend == null ? item : this.prepend + item;
            }
            return "";
        }
    }
}

