/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.MakeSources;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.utils.PathPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class AddExistingItemAction
extends NodeAction {
    private static final RequestProcessor RP = new RequestProcessor("AddExistingItemAction", 1);
    private static ResourceBundle bundle;

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        Object o = activatedNodes[0].getValue("Folder");
        if (!(o instanceof Folder)) {
            return false;
        }
        Folder folder = (Folder)o;
        return folder.isProjectFiles();
    }

    public String getName() {
        return AddExistingItemAction.getString("CTL_AddExistingItemAction");
    }

    public void performAction(Node[] activatedNodes) {
        Node n = activatedNodes[0];
        Project project = (Project)n.getValue("Project");
        assert (project != null);
        Folder folder = (Folder)n.getValue("Folder");
        assert (folder != null);
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor projectDescriptor = pdp.getConfigurationDescriptor();
        if (!projectDescriptor.okToChange()) {
            return;
        }
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)projectDescriptor.getBaseDirFileSystem());
        String seed = RemoteFileUtil.getCurrentChooserFile((ExecutionEnvironment)env);
        if (seed == null) {
            seed = projectDescriptor.getBaseDir();
        }
        JFileChooser fileChooser = RemoteFileUtil.createFileChooser((FileSystem)projectDescriptor.getBaseDirFileSystem(), (String)AddExistingItemAction.getString("SelectItem"), (String)AddExistingItemAction.getString("Select"), (int)0, null, (String)seed, (boolean)false);
        PathPanel pathPanel = new PathPanel();
        fileChooser.setAccessory(pathPanel);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getCSourceFileFilter());
        fileChooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getCCSourceFileFilter());
        fileChooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getHeaderSourceFileFilter());
        fileChooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getFortranSourceFileFilter());
        fileChooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getResourceFileFilter());
        fileChooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getQtFileFilter());
        fileChooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getAllSourceFileFilter());
        fileChooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getAllFileFilter());
        fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
        int ret = fileChooser.showOpenDialog(null);
        if (ret == 1) {
            return;
        }
        File[] files = fileChooser.getSelectedFiles();
        this.addFilesWorker(project, projectDescriptor, folder, files);
    }

    private void addFilesWorker(final Project project, final ConfigurationDescriptor projectDescriptor, final Folder folder, final File[] files) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                boolean notifySources = false;
                ArrayList<Item> items = new ArrayList<Item>();
                for (int i = 0; i < files.length; ++i) {
                    String itemPath = ProjectSupport.toProperPath(projectDescriptor.getBaseDir(), files[i].getPath(), project);
                    if (((MakeConfigurationDescriptor)projectDescriptor).findProjectItemByPath(itemPath = CndPathUtilitities.normalizeSlashes((String)itemPath)) != null) {
                        String errormsg = AddExistingItemAction.getString("AlreadyInProjectError", itemPath);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errormsg, 0));
                        continue;
                    }
                    Item item = Item.createInFileSystem(((MakeConfigurationDescriptor)projectDescriptor).getBaseDirFileSystem(), itemPath);
                    folder.addItemAction(item);
                    items.add(item);
                    if (!CndPathUtilitities.isPathAbsolute((CharSequence)itemPath)) continue;
                    notifySources = true;
                }
                MakeLogicalViewProvider.setVisible(project, items.toArray(new Item[items.size()]));
                if (notifySources) {
                    ((MakeSources)ProjectUtils.getSources((Project)project)).descriptorChanged();
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(AddExistingItemAction.class);
        }
        return bundle.getString(s);
    }

    private static String getString(String s, String arg) {
        return NbBundle.getMessage(AddExistingItemAction.class, (String)s, (Object)arg);
    }
}

