/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class RunDialogPanel
extends JPanel
implements PropertyChangeListener {
    private static final boolean TRACE_REMOTE_CREATION = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    public static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.makeproject.api.RunDialogPanel");
    private DocumentListener modifiedValidateDocumentListener = null;
    private Project[] projectChoices = null;
    private JButton actionButton;
    private final boolean isRun;
    private final FileSystem fileSystem;
    private RunProjectAction projectAction;
    private static final RequestProcessor RP;
    private String lastSelectedExecutable = null;
    private Project lastSelectedProject = null;
    private boolean isValidating = false;
    private JLabel argumentLabel;
    private JTextField argumentTextField;
    private JComboBox configurationCombobox;
    private JLabel configurationLabel;
    private JLabel environmentLabel;
    private JTextField environmentTextField;
    private JLabel errorLabel;
    private JButton executableBrowseButton;
    private JLabel executableLabel1;
    private JTextField executableTextField;
    private JTextArea guidanceTextarea;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JComboBox projectComboBox;
    private JTextField projectFolderField;
    private JLabel projectFolderLabel;
    private JComboBox projectKind;
    private JLabel projectLabel;
    private JButton projectLocationButton;
    private JTextField projectLocationField;
    private JLabel projectLocationLabel;
    private JTextField projectNameField;
    private JLabel projectNameLabel;
    private JLabel projectkindLabel;
    private JButton runDirectoryBrowseButton;
    private JLabel runDirectoryLabel;
    private JTextField runDirectoryTextField;

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.getString("RUN_DIALOG_PANEL_AD", new String[0]));
        this.executableTextField.getAccessibleContext().setAccessibleDescription(this.getString("EXECUTABLE_AD", new String[0]));
        this.executableBrowseButton.getAccessibleContext().setAccessibleDescription(this.getString("BROWSE_BUTTON_AD", new String[0]));
        this.projectComboBox.getAccessibleContext().setAccessibleDescription(this.getString("ASSOCIATED_PROJECT_AD", new String[0]));
        this.runDirectoryTextField.getAccessibleContext().setAccessibleDescription(this.getString("RUN_DIRECTORY_LABEL_AD", new String[0]));
        this.runDirectoryBrowseButton.getAccessibleContext().setAccessibleDescription(this.getString("RUN_DIRECTORY_BUTTON_AD", new String[0]));
        this.argumentTextField.getAccessibleContext().setAccessibleDescription(this.getString("ARGUMENTS_LABEL_AD", new String[0]));
        this.environmentTextField.getAccessibleContext().setAccessibleDescription(this.getString("ENVIRONMENT_LABEL_AD", new String[0]));
    }

    public RunDialogPanel(FileObject executableFO, JButton actionButton, boolean isRun) throws FileStateInvalidException {
        this.actionButton = actionButton;
        this.fileSystem = executableFO.getFileSystem();
        this.isRun = isRun;
        this.initialize(executableFO);
        this.initAccessibility();
    }

    private void initialize(FileObject executableFO) {
        this.initComponents();
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText("");
        this.modifiedValidateDocumentListener = new ModifiedValidateDocumentListener();
        if (executableFO != null) {
            this.executableTextField.setText(executableFO.getPath());
        }
        if (this.isRun) {
            this.guidanceTextarea.setText(this.getString("DIALOG_GUIDANCETEXT", new String[0]));
        } else {
            this.guidanceTextarea.setText(this.getString("DIALOG_GUIDANCETEXT_CREATE", new String[0]));
        }
        this.executableTextField.getDocument().addDocumentListener(this.modifiedValidateDocumentListener);
        this.runDirectoryTextField.getDocument().addDocumentListener(this.modifiedValidateDocumentListener);
        this.projectNameField.getDocument().addDocumentListener(this.modifiedValidateDocumentListener);
        this.projectLocationField.getDocument().addDocumentListener(this.modifiedValidateDocumentListener);
        this.initGui();
        this.guidanceTextarea.setBackground(this.getBackground());
        this.setPreferredSize(new Dimension(700, (int)this.getPreferredSize().getHeight()));
    }

    private void initComponents() {
        this.guidanceTextarea = new JTextArea();
        this.executableLabel1 = new JLabel();
        this.executableBrowseButton = new JButton();
        this.executableTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectComboBox = new JComboBox();
        this.errorLabel = new JLabel();
        this.runDirectoryLabel = new JLabel();
        this.runDirectoryTextField = new JTextField();
        this.runDirectoryBrowseButton = new JButton();
        this.argumentLabel = new JLabel();
        this.argumentTextField = new JTextField();
        this.environmentLabel = new JLabel();
        this.environmentTextField = new JTextField();
        this.projectkindLabel = new JLabel();
        this.projectKind = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.projectNameLabel = new JLabel();
        this.projectLocationLabel = new JLabel();
        this.projectFolderLabel = new JLabel();
        this.projectNameField = new JTextField();
        this.projectLocationField = new JTextField();
        this.projectFolderField = new JTextField();
        this.projectLocationButton = new JButton();
        this.configurationLabel = new JLabel();
        this.configurationCombobox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.guidanceTextarea.setEditable(false);
        this.guidanceTextarea.setLineWrap(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle");
        this.guidanceTextarea.setText(bundle.getString("DIALOG_GUIDANCETEXT"));
        this.guidanceTextarea.setWrapStyleWord(true);
        this.guidanceTextarea.setMinimumSize(new Dimension(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.guidanceTextarea, gridBagConstraints);
        this.executableLabel1.setLabelFor(this.executableTextField);
        Mnemonics.setLocalizedText((JLabel)this.executableLabel1, (String)bundle.getString("EXECUTABLE_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.executableLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.executableBrowseButton, (String)bundle.getString("BROWSE_BUTTON_TXT"));
        this.executableBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunDialogPanel.this.executableBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 12);
        this.add((Component)this.executableBrowseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.executableTextField, gridBagConstraints);
        this.projectLabel.setLabelFor(this.projectComboBox);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)bundle.getString("ASSOCIATED_PROJECT_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunDialogPanel.this.projectComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 6, 12);
        this.add((Component)this.projectComboBox, gridBagConstraints);
        this.errorLabel.setText(bundle.getString("ERROR_NOTAEXEFILE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 12, 0, 12);
        this.add((Component)this.errorLabel, gridBagConstraints);
        this.runDirectoryLabel.setLabelFor(this.runDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.runDirectoryLabel, (String)bundle.getString("RUN_DIRECTORY_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.runDirectoryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.runDirectoryTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.runDirectoryBrowseButton, (String)bundle.getString("RUN_DIRECTORY_BUTTON_TXT"));
        this.runDirectoryBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunDialogPanel.this.runDirectoryBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.runDirectoryBrowseButton, gridBagConstraints);
        this.argumentLabel.setLabelFor(this.argumentTextField);
        Mnemonics.setLocalizedText((JLabel)this.argumentLabel, (String)bundle.getString("ARGUMENTS_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.argumentLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.argumentTextField, gridBagConstraints);
        this.environmentLabel.setLabelFor(this.environmentTextField);
        Mnemonics.setLocalizedText((JLabel)this.environmentLabel, (String)bundle.getString("ENVIRONMENT_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.environmentLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.environmentTextField, gridBagConstraints);
        this.projectkindLabel.setLabelFor(this.projectKind);
        Mnemonics.setLocalizedText((JLabel)this.projectkindLabel, (String)NbBundle.getMessage(RunDialogPanel.class, (String)"ProjectKindName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.projectkindLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.projectKind, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 6, 12);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.projectNameLabel.setLabelFor(this.projectNameField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(RunDialogPanel.class, (String)"RunDialogPanel.project.name.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectLocationLabel.setLabelFor(this.projectLocationField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(RunDialogPanel.class, (String)"RunDialogPanel.project.location.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectFolderLabel.setLabelFor(this.projectFolderField);
        this.projectFolderLabel.setText(NbBundle.getMessage(RunDialogPanel.class, (String)"RunDialogPanel.project.folder.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.projectFolderLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.projectNameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.projectLocationField, gridBagConstraints);
        this.projectFolderField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.projectFolderField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.projectLocationButton, (String)NbBundle.getMessage(RunDialogPanel.class, (String)"RunDialogPanel.project.location.button"));
        this.projectLocationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunDialogPanel.this.projectLocationButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.projectLocationButton, gridBagConstraints);
        this.configurationLabel.setLabelFor(this.configurationCombobox);
        Mnemonics.setLocalizedText((JLabel)this.configurationLabel, (String)NbBundle.getMessage(RunDialogPanel.class, (String)"Configuration.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.configurationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.configurationCombobox, gridBagConstraints);
    }

    private void runDirectoryBrowseButtonActionPerformed(ActionEvent evt) {
        String seed = this.runDirectoryTextField.getText().length() > 0 ? this.runDirectoryTextField.getText() : this.getExecutablePath();
        JFileChooser fileChooser = RemoteFileUtil.createFileChooser((FileSystem)this.fileSystem, (String)this.getString("SelectWorkingDir", new String[0]), (String)this.getString("SelectLabel", new String[0]), (int)1, null, (String)seed, (boolean)true);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        this.runDirectoryTextField.setText(fileChooser.getSelectedFile().getPath());
    }

    private void projectComboBoxActionPerformed(ActionEvent evt) {
        int selectedIndex = this.projectComboBox.getSelectedIndex();
        this.clearError();
        this.validateExecutable();
        if (selectedIndex == 0) {
            this.validateProjectLocation();
            FileObject executable = this.fileSystem.findResource(this.getExecutablePath());
            if (executable != null && executable.isValid() && executable.getParent() != null) {
                this.runDirectoryTextField.setText(executable.getParent().getPath());
            } else if (!this.isValidating) {
                this.executableTextField.setText("");
            }
            this.argumentTextField.setText("");
            this.environmentTextField.setText("");
            this.configurationCombobox.setEnabled(false);
            this.projectKind.setEnabled(true);
            this.projectNameField.setEnabled(true);
            this.projectLocationField.setEnabled(true);
            this.projectLocationButton.setEnabled(true);
            this.projectFolderField.setEnabled(true);
            this.projectLocationField.setText(ProjectGenerator.getDefaultProjectFolder(FileSystemProvider.getExecutionEnvironment((FileSystem)this.fileSystem)));
            if (executable != null && executable.isValid()) {
                this.projectNameField.setText(ProjectGenerator.getValidProjectName(this.projectLocationField.getText(), executable.getNameExt()));
            } else {
                this.projectNameField.setText(ProjectGenerator.getValidProjectName(this.projectLocationField.getText(), ""));
            }
        } else {
            this.configurationCombobox.setEnabled(true);
            this.projectKind.setEnabled(false);
            this.projectNameField.setEnabled(false);
            this.projectLocationField.setEnabled(false);
            this.projectLocationButton.setEnabled(false);
            this.projectFolderField.setEnabled(false);
            Project project = this.projectChoices[this.projectComboBox.getSelectedIndex() - 1];
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (pdp == null) {
                return;
            }
            MakeConfigurationDescriptor projectDescriptor = pdp.getConfigurationDescriptor();
            MakeConfiguration conf = projectDescriptor.getActiveConfiguration();
            RunProfile runProfile = conf.getProfile();
            this.runDirectoryTextField.setText(runProfile.getRunDirectory());
            this.argumentTextField.setText(runProfile.getArgsFlat());
            this.environmentTextField.setText(runProfile.getEnvironment().toString());
        }
    }

    private void executableBrowseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser;
        int ret;
        String s;
        ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)this.fileSystem);
        String seed = this.getExecutablePath();
        if (seed.length() == 0 && RemoteFileUtil.getCurrentChooserFile((ExecutionEnvironment)executionEnvironment) != null && (s = RemoteFileUtil.getCurrentChooserFile((ExecutionEnvironment)executionEnvironment)) != null) {
            seed = s;
        }
        if (seed.length() == 0) {
            seed = System.getProperty("user.home");
        }
        FileFilter[] filter = null;
        HostInfo.OSFamily oSFamily = null;
        try {
            oSFamily = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getOSFamily();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ConnectionManager.CancellationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (oSFamily != null) {
            switch (oSFamily) {
                case MACOSX: {
                    filter = new FileFilter[]{FileFilterFactory.getMacOSXExecutableFileFilter()};
                    break;
                }
                case WINDOWS: {
                    filter = new FileFilter[]{FileFilterFactory.getPeExecutableFileFilter()};
                    break;
                }
                case SUNOS: 
                case LINUX: 
                case UNKNOWN: {
                    filter = new FileFilter[]{FileFilterFactory.getElfExecutableFileFilter()};
                }
            }
        }
        if (filter == null) {
            filter = Utilities.isWindows() ? new FileFilter[]{FileFilterFactory.getPeExecutableFileFilter()} : (Utilities.getOperatingSystem() == 4096 ? new FileFilter[]{FileFilterFactory.getMacOSXExecutableFileFilter()} : new FileFilter[]{FileFilterFactory.getElfExecutableFileFilter()});
        }
        if ((ret = (fileChooser = RemoteFileUtil.createFileChooser((FileSystem)this.fileSystem, (String)this.getString("SelectExecutable", new String[0]), (String)this.getString("SelectLabel", new String[0]), (int)0, (FileFilter[])filter, (String)seed, (boolean)false)).showOpenDialog(this)) == 1) {
            return;
        }
        this.executableTextField.setText(fileChooser.getSelectedFile().getPath());
    }

    private void projectLocationButtonActionPerformed(ActionEvent evt) {
        String path = this.projectLocationField.getText();
        JFileChooser chooser = RemoteFileUtil.createFileChooser((FileSystem)this.fileSystem, (String)this.getString("RunDialogPanel.Title_SelectProjectLocation", new String[0]), null, (int)1, null, (String)path, (boolean)true);
        if (0 == chooser.showOpenDialog(this)) {
            this.projectLocationField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private Project[] getOpenedProjects() {
        ArrayList<Project> res = new ArrayList<Project>();
        for (Project p : OpenProjects.getDefault().getOpenProjects()) {
            ConfigurationDescriptorProvider conf = (ConfigurationDescriptorProvider)p.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (conf == null || !conf.gotDescriptor() || !this.fileSystem.equals(conf.getConfigurationDescriptor().getBaseDirFileSystem())) continue;
            res.add(p);
        }
        return res.toArray(new Project[res.size()]);
    }

    private void initGui() {
        int i;
        ActionListener projectComboBoxActionListener = this.projectComboBox.getActionListeners()[0];
        this.projectComboBox.removeActionListener(projectComboBoxActionListener);
        this.projectComboBox.removeAllItems();
        this.projectComboBox.addItem(this.getString("NO_PROJECT", new String[0]));
        int index = 0;
        this.projectChoices = this.getOpenedProjects();
        for (i = 0; i < this.projectChoices.length; ++i) {
            this.projectComboBox.addItem(ProjectUtils.getInformation((Project)this.projectChoices[i]).getName());
        }
        if (this.lastSelectedExecutable != null && this.getExecutablePath().equals(this.lastSelectedExecutable) && this.lastSelectedProject != null) {
            for (i = 0; i < this.projectChoices.length; ++i) {
                if (this.projectChoices[i] != this.lastSelectedProject) continue;
                index = i + 1;
                break;
            }
        }
        if (!this.isRun) {
            index = 0;
        }
        boolean allowSelectProject = this.projectComboBox.getModel().getSize() > 1;
        this.projectComboBox.setVisible(allowSelectProject);
        this.projectLabel.setVisible(allowSelectProject);
        this.configurationLabel.setVisible(allowSelectProject);
        this.configurationCombobox.setVisible(allowSelectProject);
        this.projectComboBox.setSelectedIndex(index);
        this.projectComboBox.addActionListener(projectComboBoxActionListener);
        this.projectComboBoxActionPerformed(null);
        this.projectKind.removeAllItems();
        ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)this.fileSystem);
        if (executionEnvironment.isLocal()) {
            this.projectKind.addItem(new ProjectKindItem(IteratorExtension.ProjectKind.Minimal));
            this.projectKind.addItem(new ProjectKindItem(IteratorExtension.ProjectKind.IncludeDependencies));
            this.projectKind.addItem(new ProjectKindItem(IteratorExtension.ProjectKind.CreateDependencies));
            this.projectKind.setSelectedIndex(1);
        } else {
            this.projectKind.addItem(new ProjectKindItem(IteratorExtension.ProjectKind.IncludeDependencies));
            this.projectKind.setSelectedIndex(0);
        }
        this.configurationCombobox.removeAllItems();
        this.configurationCombobox.addItem(new ConfigurationType(0));
        this.configurationCombobox.addItem(new ConfigurationType(1));
        this.configurationCombobox.addItem(new ConfigurationType(2));
        this.configurationCombobox.setSelectedIndex(0);
    }

    private boolean validateExecutable() {
        String exePath = this.getExecutablePath();
        FileObject exeFile = this.fileSystem.findResource(exePath);
        if (exeFile == null || !exeFile.isValid()) {
            this.setError("ERROR_DONTEXIST", true, new String[0]);
            return false;
        }
        if (exeFile.isFolder()) {
            this.setError("ERROR_NOTAEXEFILE", true, new String[0]);
            return false;
        }
        return true;
    }

    private FileObject getExistingParent(String path) {
        path = PathUtilities.getDirName((String)path);
        FileObject fo = this.fileSystem.findResource(path);
        while (fo == null) {
            if ((path = PathUtilities.getDirName((String)path)) == null || path.length() == 0) {
                return null;
            }
            fo = this.fileSystem.findResource(path);
        }
        return fo;
    }

    private boolean validateProjectLocation() {
        if (!PanelProjectLocationVisual.isValidProjectName(this.projectNameField.getText())) {
            this.setError("RunDialogPanel.MSG_IllegalProjectName", false, new String[0]);
            return false;
        }
        if (!CndPathUtilitities.isPathAbsolute((CharSequence)this.projectLocationField.getText())) {
            this.setError("RunDialogPanel.MSG_IllegalProjectLocation", false, new String[0]);
            return false;
        }
        FileObject projectDirFO = this.fileSystem.findResource(this.projectFolderField.getText());
        if (projectDirFO != null && projectDirFO.isValid()) {
            if (projectDirFO.isData()) {
                this.setError("RunDialogPanel.MSG_NotAFolder", false, new String[0]);
                return false;
            }
            FileObject nbProjFO = projectDirFO.getFileObject("nbproject");
            if (nbProjFO != null && nbProjFO.isValid()) {
                this.setError("RunDialogPanel.MSG_ProjectfolderNotEmpty", false, "nbproject");
                return false;
            }
        } else {
            FileObject existingParent = this.getExistingParent(this.projectFolderField.getText());
            if (existingParent == null) {
                this.setError("RunDialogPanel.MSG_IllegalProjectLocation", false, new String[0]);
                return false;
            }
            if (!existingParent.canWrite()) {
                this.setError("RunDialogPanel.MSG_ProjectFolderReadOnly", false, new String[0]);
                return false;
            }
        }
        return true;
    }

    private void setError(String errorMsg, boolean disable, String ... args) {
        this.setErrorMsg(this.getString(errorMsg, args));
        if (disable) {
            this.runDirectoryBrowseButton.setEnabled(false);
            this.runDirectoryLabel.setEnabled(false);
            this.runDirectoryTextField.setEnabled(false);
            this.argumentLabel.setEnabled(false);
            this.argumentTextField.setEnabled(false);
            this.environmentLabel.setEnabled(false);
            this.environmentTextField.setEnabled(false);
            this.projectComboBox.setEnabled(false);
            this.projectKind.setEnabled(false);
            this.projectNameField.setEnabled(false);
            this.projectLocationField.setEnabled(false);
            this.projectLocationButton.setEnabled(false);
            this.projectFolderField.setEnabled(false);
        }
        this.actionButton.setEnabled(false);
    }

    private void clearError() {
        this.setErrorMsg(" ");
        this.runDirectoryBrowseButton.setEnabled(true);
        this.runDirectoryLabel.setEnabled(true);
        this.runDirectoryTextField.setEnabled(true);
        this.argumentLabel.setEnabled(true);
        this.argumentTextField.setEnabled(true);
        this.environmentLabel.setEnabled(true);
        this.environmentTextField.setEnabled(true);
        this.projectComboBox.setEnabled(true);
        if (this.projectComboBox.getSelectedIndex() == 0) {
            this.projectKind.setEnabled(true);
            this.projectNameField.setEnabled(true);
            this.projectLocationField.setEnabled(true);
            this.projectLocationButton.setEnabled(true);
            this.projectFolderField.setEnabled(true);
        } else {
            this.projectKind.setEnabled(false);
            this.projectNameField.setEnabled(false);
            this.projectLocationField.setEnabled(false);
            this.projectLocationButton.setEnabled(false);
            this.projectFolderField.setEnabled(false);
        }
        this.actionButton.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateFields(DocumentEvent documentEvent) {
        this.isValidating = true;
        try {
            if (documentEvent.getDocument() == this.executableTextField.getDocument()) {
                this.clearError();
                this.projectComboBox.setSelectedIndex(0);
                if (!this.validateExecutable()) {
                    return;
                }
                FileObject executable = this.fileSystem.findResource(this.getExecutablePath());
                if (executable != null && executable.isValid() && executable.getParent() != null) {
                    this.runDirectoryTextField.setText(executable.getParent().getPath());
                }
            } else if (documentEvent.getDocument() == this.projectNameField.getDocument() || documentEvent.getDocument() == this.projectLocationField.getDocument()) {
                this.clearError();
                if (this.projectComboBox.getSelectedIndex() == 0) {
                    String projectName = this.projectNameField.getText().trim();
                    String projectFolder = this.projectLocationField.getText().trim();
                    while (projectFolder.endsWith("/") || projectFolder.endsWith("\\")) {
                        projectFolder = projectFolder.substring(0, projectFolder.length() - 1);
                    }
                    this.projectFolderField.setText(projectFolder + CndFileUtils.getFileSeparatorChar((FileSystem)this.fileSystem) + projectName);
                    if (!this.validateProjectLocation()) {
                        return;
                    }
                }
            }
        }
        finally {
            this.isValidating = false;
        }
    }

    public void getSelectedProject(final RunProjectAction action) {
        this.lastSelectedExecutable = this.getExecutablePath();
        if (this.projectComboBox.getSelectedIndex() > 0) {
            Project project = this.lastSelectedProject = this.projectChoices[this.projectComboBox.getSelectedIndex() - 1];
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            MakeConfigurationDescriptor projectDescriptor = pdp.getConfigurationDescriptor();
            ConfigurationType confType = (ConfigurationType)this.configurationCombobox.getSelectedItem();
            switch (confType.getType()) {
                case 2: {
                    MakeConfiguration active = projectDescriptor.getActiveConfiguration();
                    ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)this.fileSystem);
                    String baseDir = active.getBaseDir();
                    MakeConfiguration conf = new MakeConfiguration(active.getBaseFSPath(), this.getConfigurationName(projectDescriptor), 0, executionEnvironment.getHost());
                    String wd = this.fileSystem.findResource(this.getExecutablePath()).getParent().getPath();
                    wd = CndPathUtilitities.toRelativePath((String)baseDir, (String)wd);
                    wd = CndPathUtilitities.normalizeSlashes((String)wd);
                    conf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(wd);
                    String exe = this.getExecutablePath();
                    exe = CndPathUtilitities.toRelativePath((String)baseDir, (String)exe);
                    exe = CndPathUtilitities.normalizeSlashes((String)exe);
                    conf.getMakefileConfiguration().getOutput().setValue(exe);
                    this.updateRunProfile(baseDir, conf.getProfile());
                    ArrayList<Configuration> list = new ArrayList<Configuration>(projectDescriptor.getConfs().getConfigurations());
                    list.add(conf);
                    conf.setDefault(false);
                    Configurations c = new Configurations();
                    c.init(list.toArray(new Configuration[list.size()]), 0);
                    projectDescriptor.setConfs(c);
                    projectDescriptor.getConfs().setActive(conf);
                    this.fillConfiguration();
                    break;
                }
                case 1: {
                    MakeConfiguration conf = projectDescriptor.getActiveConfiguration();
                    this.updateRunProfile(conf.getBaseDir(), conf.getProfile());
                    this.fillConfiguration();
                    break;
                }
                case 0: {
                    MakeConfiguration conf = projectDescriptor.getActiveConfiguration();
                    this.updateRunProfile(conf.getBaseDir(), conf.getProfile());
                    if (action == null) break;
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            action.run(RunDialogPanel.this.lastSelectedProject);
                        }
                    });
                    break;
                }
            }
        } else {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    RunDialogPanel.this.createNewProject(action);
                }
            });
        }
    }

    private String getConfigurationName(MakeConfigurationDescriptor projectDescriptor) {
        String exe = this.getExecutablePath();
        String[] split = exe.split("\\/");
        String name = split[split.length - 1];
        Configuration[] clonedConfs = projectDescriptor.getConfs().toArray();
        String aName = name;
        int i = 1;
        while (true) {
            boolean found = false;
            for (Configuration c : clonedConfs) {
                if (!aName.equals(c.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                return aName;
            }
            aName = name + "_" + i;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewProject(RunProjectAction action) {
        try {
            ProgressHandle progress = ProgressHandleFactory.createHandle((String)this.getString("CREATING_PROJECT_PROGRESS", new String[0]));
            progress.start();
            try {
                ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)this.fileSystem);
                FileUtil.createFolder((FileObject)this.fileSystem.getRoot(), (String)this.projectFolderField.getText().trim());
                this.projectAction = action;
                if (executionEnvironment.isLocal()) {
                    this.createLocalProject(true);
                } else {
                    FileObject projectCreator = this.findProjectCreator();
                    if (projectCreator == null) {
                        this.createLocalProject(false);
                    } else {
                        Project project = this.createRemoteProject(projectCreator);
                        if (project == null) {
                            this.createLocalProject(false);
                        }
                    }
                }
            }
            finally {
                progress.finish();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Project createLocalProject(boolean isLocal) throws IOException, IllegalArgumentException {
        Project project;
        ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)this.fileSystem);
        String projectName = this.projectNameField.getText().trim();
        String baseDir = this.projectFolderField.getText().trim();
        String hostID = isLocal ? ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment) : ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        MakeConfiguration conf = new MakeConfiguration(new FSPath(this.fileSystem, baseDir), "Default", 0, hostID);
        String wd = this.fileSystem.findResource(this.getExecutablePath()).getParent().getPath();
        wd = CndPathUtilitities.toRelativePath((String)baseDir, (String)wd);
        wd = CndPathUtilitities.normalizeSlashes((String)wd);
        conf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(wd);
        String exe = this.getExecutablePath();
        exe = CndPathUtilitities.toRelativePath((String)baseDir, (String)exe);
        exe = CndPathUtilitities.normalizeSlashes((String)exe);
        conf.getMakefileConfiguration().getOutput().setValue(exe);
        this.updateRunProfile(baseDir, conf.getProfile());
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(projectName, new FSPath(this.fileSystem, baseDir));
        prjParams.setOpenFlag(false).setConfiguration(conf).setHostUID(hostID).setImportantFiles(Collections.singletonList(exe).iterator()).setMakefileName("");
        this.lastSelectedProject = project = ProjectGenerator.createBlankProject(prjParams);
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        OpenProjects.getDefault().open(new Project[]{project}, false);
        return project;
    }

    private Project createRemoteProject(FileObject projectCreator) {
        FileObject projectFO;
        String baseDir;
        FileObject toRefresh;
        ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)this.fileSystem);
        if (TRACE_REMOTE_CREATION) {
            logger.log(Level.INFO, "#{0} --netbeans-project={1} --project-create binary={2} --sources=used", new Object[]{projectCreator.getPath(), this.projectFolderField.getText().trim(), this.getExecutablePath()});
        }
        ProcessUtils.ExitStatus execute = ProcessUtils.execute((ExecutionEnvironment)executionEnvironment, (String)projectCreator.getPath(), (String[])new String[]{"--netbeans-project=" + this.projectFolderField.getText().trim(), "--project-create", "binary=" + this.getExecutablePath(), "--sources=used"});
        if (TRACE_REMOTE_CREATION) {
            logger.log(Level.INFO, "#exitCode={0}", execute.exitCode);
            logger.log(Level.INFO, execute.error);
            logger.log(Level.INFO, execute.output);
        }
        if (!execute.isOK()) {
            String java = null;
            try {
                java = (String)HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getEnvironment().get("JDK_HOME");
                if (java == null || java.isEmpty()) {
                    java = (String)HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getEnvironment().get("JAVA_HOME");
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ConnectionManager.CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (java != null) {
                execute = ProcessUtils.execute((ExecutionEnvironment)executionEnvironment, (String)projectCreator.getPath(), (String[])new String[]{"--jdkhome", java, "--netbeans-project=" + this.projectFolderField.getText().trim(), "--project-create", "binary=" + this.getExecutablePath(), "--sources=used"});
                if (TRACE_REMOTE_CREATION) {
                    logger.log(Level.INFO, "#exitCode={0}", execute.exitCode);
                    logger.log(Level.INFO, execute.error);
                    logger.log(Level.INFO, execute.output);
                }
            }
        }
        if ((toRefresh = this.fileSystem.findResource(PathUtilities.getDirName((String)(baseDir = this.projectFolderField.getText().trim())))) != null) {
            toRefresh.refresh();
        }
        if ((projectFO = this.fileSystem.findResource(baseDir)) == null) {
            return null;
        }
        Project project = null;
        try {
            project = ProjectManager.getDefault().findProject(projectFO);
            if (project == null) {
                return null;
            }
            this.lastSelectedProject = project;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        OpenProjects.getDefault().open(new Project[]{project}, false);
        return project;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("openProjects") && evt.getNewValue() instanceof Project[]) {
            Project[] projects = (Project[])evt.getNewValue();
            if (projects.length == 0) {
                return;
            }
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            if (this.lastSelectedProject == null) {
                return;
            }
            this.fillConfiguration();
        }
    }

    private void fillConfiguration() {
        ExecutionEnvironment executionEnvironment;
        if (this.projectAction != null) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    RunDialogPanel.this.projectAction.run(RunDialogPanel.this.lastSelectedProject);
                    RunDialogPanel.this.projectAction = null;
                }
            });
        }
        if ((executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)this.fileSystem)).isLocal()) {
            IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("DW:buildResult", this.getExecutablePath());
                map.put("DW:consolidationLevel", "file");
                map.put("DW:rootFolder", this.lastSelectedProject.getProjectDirectory().getPath());
                IteratorExtension.ProjectKind kind = ((ProjectKindItem)this.projectKind.getSelectedItem()).kind;
                extension.discoverProject(map, this.lastSelectedProject, kind);
            }
        } else {
            IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension != null) {
                extension.discoverHeadersByModel(this.lastSelectedProject);
            }
        }
    }

    private FileObject findProjectCreator() {
        ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)this.fileSystem);
        for (CompilerSet set : CompilerSetManager.get((ExecutionEnvironment)executionEnvironment).getCompilerSets()) {
            String directory;
            FileObject projectCreator;
            if (!set.getCompilerFlavor().isSunStudioCompiler() || (projectCreator = this.fileSystem.findResource((directory = set.getDirectory()) + "/../lib/ide_project/bin/ide_project")) == null || !projectCreator.isValid()) continue;
            return projectCreator;
        }
        return null;
    }

    private void updateRunProfile(String baseDir, RunProfile runProfile) {
        runProfile.setArgs(this.argumentTextField.getText());
        String wd = this.runDirectoryTextField.getText();
        wd = CndPathUtilitities.toRelativePath((String)baseDir, (String)wd);
        wd = CndPathUtilitities.normalizeSlashes((String)wd);
        runProfile.setRunDirectory(wd);
        Env env = runProfile.getEnvironment();
        env.removeAll();
        env.decode(this.environmentTextField.getText());
    }

    public String getExecutablePath() {
        return this.executableTextField.getText();
    }

    private void setErrorMsg(String msg) {
        this.errorLabel.setText(msg);
    }

    private String getString(String s, String ... args) {
        return NbBundle.getMessage(RunDialogPanel.class, (String)s, (Object[])args);
    }

    static {
        if (TRACE_REMOTE_CREATION) {
            logger.setLevel(Level.ALL);
        }
        RP = new RequestProcessor("RunDialogPanel Worker", 1);
    }

    private final class ConfigurationType {
        public static final int USE_CURRENT_CONFIGURATION = 0;
        public static final int UPDATE_CURRENT_CONFIGURATION = 1;
        public static final int CREATE_NEW_CONFIGURATION = 2;
        private final int type;

        ConfigurationType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return RunDialogPanel.this.getString("USE_CURRENT_CONFIGURATION", new String[0]);
                }
                case 1: {
                    return RunDialogPanel.this.getString("UPDATE_CURRENT_CONFIGURATION", new String[0]);
                }
                case 2: {
                    return RunDialogPanel.this.getString("CREATE_NEW_CONFIGURATION", new String[0]);
                }
            }
            throw new IllegalStateException();
        }
    }

    public static interface RunProjectAction {
        public void run(Project var1);
    }

    private final class ProjectKindItem {
        private final IteratorExtension.ProjectKind kind;

        ProjectKindItem(IteratorExtension.ProjectKind kind) {
            this.kind = kind;
        }

        public String toString() {
            return RunDialogPanel.this.getString("ProjectItemKind_" + (Object)((Object)this.kind), new String[0]);
        }
    }

    private final class ModifiedValidateDocumentListener
    implements DocumentListener {
        private ModifiedValidateDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            RunDialogPanel.this.validateFields(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            RunDialogPanel.this.validateFields(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            RunDialogPanel.this.validateFields(documentEvent);
        }
    }
}

