/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifactProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public class MakeArtifact
implements Cloneable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_DYNAMIC_LIB = 2;
    public static final int TYPE_STATIC_LIB = 3;
    public static final int TYPE_QT_APPLICATION = 4;
    public static final int TYPE_QT_DYNAMIC_LIB = 5;
    public static final int TYPE_QT_STATIC_LIB = 6;
    public static final int TYPE_DB_APPLICATION = 7;
    public static final int TYPE_CUSTOM = 10;
    private String projectLocation;
    private final int configurationType;
    private final String configurationName;
    private final boolean active;
    private MakeConfiguration makeConfiguration;
    private MakeConfiguration parentMakeConfiguration;
    private boolean build;
    private String workingDirectory;
    private String buildCommand;
    private String cleanCommand;
    private String output;

    public MakeArtifact(String projectLocation, int configurationType, String configurationName, boolean active, boolean build, String workingDirectory, String buildCommand, String cleanCommand, String output, MakeConfiguration parentMakeConfiguration) {
        this.projectLocation = projectLocation;
        this.configurationType = configurationType;
        this.configurationName = configurationName;
        this.active = active;
        this.build = build;
        this.workingDirectory = workingDirectory;
        this.buildCommand = buildCommand;
        this.cleanCommand = cleanCommand;
        this.output = output;
        this.parentMakeConfiguration = parentMakeConfiguration;
    }

    private MakeArtifact(String projectLocation, int configurationType, String configurationName, boolean active, boolean build, String workingDirectory, String buildCommand, String cleanCommand, String output, MakeConfiguration parentMakeConfiguration, MakeConfiguration makeConfiguration) {
        this(projectLocation, configurationType, configurationName, active, build, workingDirectory, buildCommand, cleanCommand, output, parentMakeConfiguration);
        this.makeConfiguration = makeConfiguration;
    }

    public MakeArtifact(MakeConfigurationDescriptor pd, MakeConfiguration makeConfiguration) {
        this.projectLocation = makeConfiguration.getBaseDir();
        this.configurationName = makeConfiguration.getName();
        this.active = makeConfiguration.isDefault();
        this.build = true;
        this.makeConfiguration = makeConfiguration;
        if (makeConfiguration.isMakefileConfiguration()) {
            this.workingDirectory = makeConfiguration.getMakefileConfiguration().getAbsBuildCommandWorkingDir();
            this.buildCommand = makeConfiguration.getMakefileConfiguration().getBuildCommand().getValue();
            this.cleanCommand = makeConfiguration.getMakefileConfiguration().getCleanCommand().getValue();
        } else {
            this.workingDirectory = makeConfiguration.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES ? pd.getBaseDir() : this.projectLocation;
            if (!pd.getProjectMakefileName().isEmpty()) {
                this.buildCommand = "${MAKE} " + MakeOptions.getInstance().getMakeOptions() + " -f " + pd.getProjectMakefileName() + " CONF=" + this.configurationName;
                this.cleanCommand = "${MAKE} " + MakeOptions.getInstance().getMakeOptions() + " -f " + pd.getProjectMakefileName() + " CONF=" + this.configurationName + " clean";
            } else {
                this.buildCommand = "${MAKE} " + MakeOptions.getInstance().getMakeOptions() + " CONF=" + this.configurationName;
                this.cleanCommand = "${MAKE} " + MakeOptions.getInstance().getMakeOptions() + " CONF=" + this.configurationName + " clean";
            }
        }
        switch (makeConfiguration.getConfigurationType().getValue()) {
            case 0: {
                this.configurationType = 0;
                break;
            }
            case 1: {
                this.configurationType = 1;
                break;
            }
            case 2: {
                this.configurationType = 2;
                break;
            }
            case 3: {
                this.configurationType = 3;
                break;
            }
            case 4: {
                this.configurationType = 4;
                break;
            }
            case 5: {
                this.configurationType = 5;
                break;
            }
            case 6: {
                this.configurationType = 6;
                break;
            }
            case 7: {
                this.configurationType = 7;
                break;
            }
            case 10: {
                this.configurationType = 10;
                break;
            }
            default: {
                assert (false);
                this.configurationType = -1;
            }
        }
        this.output = makeConfiguration.getOutputValue();
    }

    public String getProjectLocation() {
        return this.projectLocation;
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }

    public int getConfigurationType() {
        return this.configurationType;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean getBuild() {
        return this.build;
    }

    public void setBuild(boolean build) {
        this.build = build;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getBuildCommand() {
        return this.buildCommand;
    }

    public String getBuildCommand(String makeCommand, String makeFlags) {
        return this.subsituteMake(this.getBuildCommand(), makeCommand, makeFlags);
    }

    public String getBuildCommand(String buildCommandFromProjectProperties, String makeCommand, String makeFlags) {
        return this.subsituteMake(buildCommandFromProjectProperties, makeCommand, makeFlags);
    }

    public String getCleanCommand() {
        return this.cleanCommand;
    }

    public String getCleanCommand(String makeCommand, String makeFlags) {
        return this.subsituteMake(this.getCleanCommand(), makeCommand, makeFlags);
    }

    private String subsituteMake(String template, String makeCommand, String makeFlags) {
        if (makeCommand.indexOf(32) > 0 && makeCommand.indexOf(34) != 0 && makeCommand.indexOf(39) != 0) {
            makeCommand = "\"" + makeCommand + "\"";
        }
        int startCommand = template.indexOf("${MAKE}");
        int startFlags = template.indexOf("${MAKEFLAGS}");
        if (startCommand >= 0) {
            if (makeFlags.length() > 0 && startFlags < 0) {
                makeCommand = makeCommand + " " + makeFlags;
            }
            template = template.substring(0, startCommand) + makeCommand + template.substring(startCommand + 7);
        }
        if (startFlags >= 0) {
            startFlags = template.indexOf("${MAKEFLAGS}");
            template = template.substring(0, startFlags) + makeFlags + template.substring(startFlags + 12);
        } else if (startCommand < 0) {
            template = template + " " + makeFlags;
        }
        return template;
    }

    public String getOutput() {
        this.initConfiguration();
        if (this.makeConfiguration != null) {
            return this.makeConfiguration.expandMacros(this.output);
        }
        String val = CndPathUtilitities.expandMacro((String)this.output, (String)"${CND_CONF}", (String)this.configurationName);
        return this.parentMakeConfiguration.expandMacros(val);
    }

    private void initConfiguration() {
        block6: {
            if (this.makeConfiguration == null) {
                try {
                    ProjectConfigurationProvider lookup;
                    Project findProject;
                    FileObject toFileObject;
                    String projectPath = this.projectLocation;
                    FileSystem fs = this.parentMakeConfiguration.getBaseFSPath().getFileSystem();
                    if (!CndPathUtilitities.isPathAbsolute((CharSequence)this.projectLocation)) {
                        projectPath = this.parentMakeConfiguration.getBaseFSPath().getPath() + FileSystemProvider.getFileSeparatorChar((FileSystem)fs) + projectPath;
                    }
                    if ((toFileObject = fs.findResource(projectPath = FileSystemProvider.normalizeAbsolutePath((String)projectPath, (FileSystem)fs))) == null || (findProject = ProjectManager.getDefault().findProject(toFileObject)) == null || (lookup = (ProjectConfigurationProvider)findProject.getLookup().lookup(ProjectConfigurationProvider.class)) == null) break block6;
                    for (Configuration c : lookup.getConfigurations()) {
                        if (!this.configurationName.equals(c.getName())) continue;
                        this.makeConfiguration = (MakeConfiguration)c;
                        break;
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public String getStoredOutput() {
        return this.output;
    }

    public String toString() {
        String ret = this.getConfigurationName();
        if (this.getOutput() != null && this.getOutput().length() > 0) {
            ret = ret + " (" + this.getOutput() + ")";
        }
        return ret;
    }

    public static MakeArtifact[] getMakeArtifacts(Project project) {
        MakeArtifactProvider map = (MakeArtifactProvider)project.getLookup().lookup(MakeArtifactProvider.class);
        if (map != null) {
            return map.getBuildArtifacts();
        }
        return null;
    }

    public MakeArtifact clone() {
        return new MakeArtifact(this.projectLocation, this.configurationType, this.configurationName, this.active, this.build, this.workingDirectory, this.buildCommand, this.cleanCommand, this.output, this.parentMakeConfiguration, this.makeConfiguration);
    }
}

