/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;

public class MakeSharabilityQuery
implements SharabilityQueryImplementation2 {
    private final FileObject baseDirFile;
    private final String baseDir;
    private final int baseDirLength;
    private boolean privateShared;
    private final ConfigurationDescriptorProvider projectDescriptorProvider;
    private static final boolean IGNORE_BINARIES = CndUtils.getBoolean((String)"cnd.vcs.ignore.binaries", (boolean)true);
    private boolean inited = false;
    private Set<String> skippedFiles = new HashSet<String>();

    MakeSharabilityQuery(ConfigurationDescriptorProvider projectDescriptorProvider, FileObject baseDirFile) {
        this.projectDescriptorProvider = projectDescriptorProvider;
        this.baseDirFile = baseDirFile;
        this.baseDir = baseDirFile.getPath();
        this.baseDirLength = this.baseDir.length();
        this.privateShared = false;
    }

    public SharabilityQuery.Sharability getSharability(final URI uri) {
        this.init();
        SharabilityQuery.Sharability ret = (SharabilityQuery.Sharability)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SharabilityQuery.Sharability>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SharabilityQuery.Sharability run() {
                MakeSharabilityQuery makeSharabilityQuery = MakeSharabilityQuery.this;
                synchronized (makeSharabilityQuery) {
                    if (IGNORE_BINARIES && CndFileVisibilityQuery.getDefault().isIgnored(uri.getPath())) {
                        return SharabilityQuery.Sharability.NOT_SHARABLE;
                    }
                    if (MakeSharabilityQuery.this.skippedFiles.contains(uri.getPath())) {
                        return SharabilityQuery.Sharability.NOT_SHARABLE;
                    }
                    boolean sub = uri.getPath().startsWith(MakeSharabilityQuery.this.baseDir);
                    if (!sub) {
                        return SharabilityQuery.Sharability.UNKNOWN;
                    }
                    if (uri.getPath().equals(MakeSharabilityQuery.this.baseDir)) {
                        return SharabilityQuery.Sharability.MIXED;
                    }
                    if (uri.getPath().length() <= MakeSharabilityQuery.this.baseDirLength + 1) {
                        return SharabilityQuery.Sharability.UNKNOWN;
                    }
                    String subString = uri.getPath().substring(MakeSharabilityQuery.this.baseDirLength + 1).replace('\\', '/');
                    if (subString.equals("nbproject")) {
                        return SharabilityQuery.Sharability.MIXED;
                    }
                    if (subString.equals("Makefile")) {
                        return SharabilityQuery.Sharability.SHARABLE;
                    }
                    if (subString.equals("nbproject/configurations.xml")) {
                        return SharabilityQuery.Sharability.SHARABLE;
                    }
                    if (subString.equals("nbproject/private")) {
                        return MakeSharabilityQuery.this.privateShared ? SharabilityQuery.Sharability.SHARABLE : SharabilityQuery.Sharability.NOT_SHARABLE;
                    }
                    if (subString.equals("nbproject/project.properties")) {
                        return SharabilityQuery.Sharability.SHARABLE;
                    }
                    if (subString.equals("nbproject/project.xml")) {
                        return SharabilityQuery.Sharability.SHARABLE;
                    }
                    if (subString.startsWith("nbproject/Makefile-")) {
                        return SharabilityQuery.Sharability.SHARABLE;
                    }
                    if (subString.startsWith("nbproject/Package-")) {
                        return SharabilityQuery.Sharability.SHARABLE;
                    }
                    if (subString.startsWith("nbproject/qt-")) {
                        return subString.endsWith(".pro") ? SharabilityQuery.Sharability.SHARABLE : SharabilityQuery.Sharability.NOT_SHARABLE;
                    }
                    if (subString.startsWith("build/")) {
                        return SharabilityQuery.Sharability.NOT_SHARABLE;
                    }
                    if (subString.startsWith("dist/")) {
                        return SharabilityQuery.Sharability.NOT_SHARABLE;
                    }
                    return SharabilityQuery.Sharability.UNKNOWN;
                }
            }
        });
        return ret;
    }

    public void setPrivateShared(boolean privateShared) {
        this.privateShared = privateShared;
    }

    public boolean getPrivateShared() {
        return this.privateShared;
    }

    public void update() {
        this.inited = false;
        this.init();
    }

    private synchronized void init() {
        MakeConfigurationDescriptor cd;
        if (!this.inited && this.projectDescriptorProvider.gotDescriptor() && (cd = this.projectDescriptorProvider.getConfigurationDescriptor()) != null) {
            Configurations confs = cd.getConfs();
            HashSet<String> newSet = new HashSet<String>();
            for (Configuration conf : confs.getConfigurations()) {
                if (!(conf instanceof MakeConfiguration)) continue;
                newSet.add(CndFileUtils.normalizeAbsolutePath((String)((MakeConfiguration)conf).getAbsoluteOutputValue()));
            }
            this.skippedFiles = newSet;
            this.inited = true;
        }
    }
}

