/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.LogicalFolderItemsInfo;
import org.netbeans.modules.cnd.makeproject.api.LogicalFoldersInfo;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectHelper;
import org.netbeans.modules.cnd.makeproject.ui.wizards.MakeSampleProjectGenerator;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MakeProjectGeneratorImpl {
    private static final String PROP_DBCONN = "dbconn";

    private MakeProjectGeneratorImpl() {
    }

    public static String getDefaultProjectFolder() {
        return ProjectChooser.getProjectsFolder().getPath();
    }

    public static String getDefaultProjectFolder(ExecutionEnvironment env) {
        try {
            if (env.isLocal()) {
                return MakeProjectGeneratorImpl.getDefaultProjectFolder();
            }
            return HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir() + '/' + ProjectChooser.getProjectsFolder().getName();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (ConnectionManager.CancellationException ex) {
            ex.printStackTrace(System.err);
        }
        return null;
    }

    public static String getValidProjectName(String projectFolder) {
        return MakeProjectGeneratorImpl.getValidProjectName(projectFolder, "Project");
    }

    public static String getValidProjectName(String projectFolder, String name) {
        File projectNameFile;
        int baseCount = 0;
        String projectName = null;
        while ((projectNameFile = CndFileUtils.createLocalFile((String)projectFolder, (String)(projectName = baseCount == 0 ? name : name + baseCount))).exists()) {
            ++baseCount;
        }
        return projectName;
    }

    public static MakeProject createBlankProject(ProjectGenerator.ProjectParameters prjParams) throws IOException {
        MakeConfiguration[] confs = prjParams.getConfigurations();
        String projectFolderPath = prjParams.getProjectFolderPath();
        MakeConfiguration[] copyConfs = new MakeConfiguration[confs.length];
        for (int i = 0; i < confs.length; ++i) {
            copyConfs[i] = confs[i].clone();
            copyConfs[i].setBaseFSPath(new FSPath(prjParams.getSourceFileSystem(), projectFolderPath));
            RunProfile profile = (RunProfile)copyConfs[i].getAuxObject("runprofile");
            profile.setBuildFirst(false);
        }
        FileObject dirFO = MakeProjectGeneratorImpl.createProjectDir(prjParams);
        prjParams.setConfigurations(copyConfs);
        MakeProjectGeneratorImpl.createProject(dirFO, prjParams, true);
        MakeProject p = (MakeProject)ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject((Project)p);
        if (prjParams.getOpenFlag()) {
            OpenProjects.getDefault().open(new Project[]{p}, false);
        }
        return p;
    }

    public static MakeProject createProject(ProjectGenerator.ProjectParameters prjParams) throws IOException {
        FileObject dirFO = MakeProjectGeneratorImpl.createProjectDir(prjParams);
        MakeProjectGeneratorImpl.createProject(dirFO, prjParams, false);
        MakeProject p = (MakeProject)ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject((Project)p);
        if (prjParams.getDatabaseConnection() != null) {
            Preferences prefs = ProjectUtils.getPreferences((Project)p, ProjectSupport.class, (boolean)true);
            prefs.put(PROP_DBCONN, prjParams.getDatabaseConnection());
        }
        return p;
    }

    private static MakeProjectHelper createProject(FileObject dirFO, ProjectGenerator.ProjectParameters prjParams, boolean saveNow) throws IOException {
        String name = prjParams.getProjectName();
        String makefileName = prjParams.getMakefileName();
        Configuration[] confs = prjParams.getConfigurations();
        if (prjParams.getCustomizerId() != null) {
            dirFO.createData("cndcustomizerid." + prjParams.getCustomizerId());
        }
        final Iterator<SourceFolderInfo> sourceFolders = prjParams.getSourceFolders();
        String sourceFoldersFilter = prjParams.getSourceFoldersFilter();
        final Iterator<SourceFolderInfo> testFolders = prjParams.getTestFolders();
        final Iterator<String> importantItems = prjParams.getImportantFiles();
        final Iterator<LogicalFolderItemsInfo> logicalFolderItems = prjParams.getLogicalFolderItems();
        final Iterator<LogicalFoldersInfo> logicalFolders = prjParams.getLogicalFolders();
        String mainFile = prjParams.getMainFile();
        MakeProjectHelper h = null;
        try {
            h = MakeProjectGenerator.createProject(dirFO, "org.netbeans.modules.cnd.makeproject");
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        FileObject sourceBaseFO = dirFO;
        h.putPrimaryConfigurationData(data, true);
        final MakeConfigurationDescriptor projectDescriptor = new MakeConfigurationDescriptor(dirFO, sourceBaseFO);
        if (makefileName != null) {
            projectDescriptor.setProjectMakefileName(makefileName);
        }
        projectDescriptor.init(confs);
        projectDescriptor.setState(ConfigurationDescriptor.State.READY);
        Project project = projectDescriptor.getProject();
        projectDescriptor.setProject(project);
        final CreateMainParams mainFileParams = MakeProjectGeneratorImpl.prepareMainIfNeeded(mainFile, dirFO, prjParams.getTemplateParams());
        if (sourceFoldersFilter != null && !"^(nbproject|build|test|tests)$".equals(sourceFoldersFilter)) {
            projectDescriptor.setFolderVisibilityQuery(sourceFoldersFilter);
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                projectDescriptor.initLogicalFolders(sourceFolders, sourceFolders == null, testFolders, logicalFolders, logicalFolderItems, importantItems, mainFileParams.mainFilePath, mainFileParams.templateDO, false);
                projectDescriptor.save();
                mainFileParams.doPostProjectCreationWork();
                projectDescriptor.closed();
                projectDescriptor.clean();
            }
        };
        task.run();
        if (!prjParams.isMakefileProject()) {
            FileObject baseDirFileObject = projectDescriptor.getBaseDirFileObject();
            FileObject createData = baseDirFileObject.createData(projectDescriptor.getProjectMakefileName());
            MakeProjectGeneratorImpl.copyURLFile("nbresloc:/org/netbeans/modules/cnd/makeproject/resources/MasterMakefile", createData.getOutputStream());
        }
        return h;
    }

    private static void copyURLFile(String fromURL, OutputStream os) throws IOException {
        InputStream is = null;
        try {
            URL url = new URL(fromURL);
            is = url.openStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is != null) {
            MakeProjectGeneratorImpl.copy(is, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream is, OutputStream os) throws IOException {
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            bw = new BufferedWriter(new OutputStreamWriter(os));
            while ((line = br.readLine()) != null) {
                bw.write(line + "\n");
            }
            bw.flush();
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
    }

    private static FileObject createProjectDir(ProjectGenerator.ProjectParameters prjParams) throws IOException {
        String projectFolderPath = prjParams.getProjectFolderPath();
        MakeSampleProjectGenerator.FOPath fopath = new MakeSampleProjectGenerator.FOPath(projectFolderPath);
        FileObject dirFO = fopath.root != null ? FileUtil.createFolder((FileObject)fopath.root, (String)fopath.relPath) : FileUtil.createFolder((FileObject)prjParams.getSourceFileSystem().getRoot(), (String)projectFolderPath);
        assert (dirFO != null) : "No such dir on disk: " + prjParams.getProjectFolderPath();
        assert (dirFO.isValid()) : "No such dir on disk: " + prjParams.getProjectFolderPath();
        assert (dirFO.isFolder()) : "Not really a dir: " + prjParams.getProjectFolderPath();
        return dirFO;
    }

    private static CreateMainParams prepareMainIfNeeded(String mainFile, FileObject srcFolder, Map<String, Object> templateParams) throws IOException {
        String createdMainName;
        if (mainFile.length() == 0) {
            return new CreateMainParams(null, null, null);
        }
        String mainName = mainFile.substring(0, mainFile.indexOf(124));
        String template = mainFile.substring(mainFile.indexOf(124) + 1);
        if (mainName.length() == 0) {
            return new CreateMainParams(null, null, null);
        }
        FileObject mainTemplate = FileUtil.getConfigFile((String)template);
        if (mainTemplate == null) {
            return new CreateMainParams(null, null, null);
        }
        if (mainName.indexOf(92) > 0 || mainName.indexOf(47) > 0) {
            String absPath = CndPathUtilitities.toAbsolutePath((FileObject)srcFolder, (String)mainName);
            absPath = FileSystemProvider.getCanonicalPath((FileSystem)srcFolder.getFileSystem(), (String)absPath);
            srcFolder = FileUtil.createFolder((FileObject)srcFolder, (String)CndPathUtilitities.getDirName((String)mainName));
            createdMainName = CndPathUtilitities.getBaseName((String)absPath);
        } else {
            createdMainName = mainName;
        }
        final DataObject mt = DataObject.find((FileObject)mainTemplate);
        final DataFolder pDf = DataFolder.findFolder((FileObject)srcFolder);
        final HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("freeFileExtension", true);
        params.putAll(templateParams);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    mt.createFromTemplate(pDf, createdMainName, params);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        return new CreateMainParams(mainName, mt, runnable);
    }

    private static final class CreateMainParams {
        final String mainFilePath;
        final DataObject templateDO;
        private final Runnable postProjectSaveWorker;

        public CreateMainParams(String mainName, DataObject dob, Runnable postProjectSaveWorker) {
            this.mainFilePath = mainName;
            this.templateDO = dob;
            this.postProjectSaveWorker = postProjectSaveWorker;
        }

        private void doPostProjectCreationWork() {
            if (this.postProjectSaveWorker != null) {
                this.postProjectSaveWorker.run();
            }
        }
    }
}

