/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.util.RequestProcessor;

public class MakeProjectConfigurationProvider
implements ProjectConfigurationProvider<Configuration>,
PropertyChangeListener {
    private final Project project;
    private ConfigurationDescriptorProvider projectDescriptorProvider;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final RequestProcessor RP = new RequestProcessor("Make configuration provider RP", 1);

    public MakeProjectConfigurationProvider(Project project, ConfigurationDescriptorProvider projectDescriptorProvider, PropertyChangeListener info) {
        this.project = project;
        this.projectDescriptorProvider = projectDescriptorProvider;
        this.pcs.addPropertyChangeListener(info);
    }

    public Collection<Configuration> getConfigurations() {
        if (!this.projectDescriptorProvider.gotDescriptor()) {
            return Collections.emptySet();
        }
        MakeConfigurationDescriptor configurationDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor();
        if (configurationDescriptor == null) {
            return Collections.emptySet();
        }
        return configurationDescriptor.getConfs().getConfigurations();
    }

    public Configuration getActiveConfiguration() {
        if (!this.projectDescriptorProvider.gotDescriptor()) {
            return null;
        }
        MakeConfigurationDescriptor configurationDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor();
        if (configurationDescriptor == null) {
            return null;
        }
        return configurationDescriptor.getConfs().getActive();
    }

    public void setActiveConfiguration(Configuration configuration) throws IllegalArgumentException, IOException {
        MakeConfigurationDescriptor configurationDescriptor;
        if (configuration != null && this.projectDescriptorProvider != null && this.projectDescriptorProvider.gotDescriptor() && (configurationDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor()) != null) {
            configurationDescriptor.getConfs().setActive(configuration);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.pcs.addPropertyChangeListener(lst);
        if (this.projectDescriptorProvider != null) {
            this.RP.post(new Runnable(){

                @Override
                public void run() {
                    MakeConfigurationDescriptor makeConfigurationDescriptor;
                    if (MakeProjectConfigurationProvider.this.projectDescriptorProvider != null && (makeConfigurationDescriptor = MakeProjectConfigurationProvider.this.projectDescriptorProvider.getConfigurationDescriptor()) != null && makeConfigurationDescriptor.getState() != ConfigurationDescriptor.State.BROKEN) {
                        makeConfigurationDescriptor.getConfs().addPropertyChangeListener(MakeProjectConfigurationProvider.this);
                        MakeProjectConfigurationProvider.this.pcs.firePropertyChange("configurations", null, MakeProjectConfigurationProvider.this.getConfigurations());
                        MakeProjectConfigurationProvider.this.pcs.firePropertyChange("activeConfiguration", null, MakeProjectConfigurationProvider.this.getActiveConfiguration());
                    }
                }
            });
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        MakeConfigurationDescriptor makeConfigurationDescriptor;
        this.pcs.removePropertyChangeListener(lst);
        if (this.projectDescriptorProvider != null && this.projectDescriptorProvider.gotDescriptor() && this.projectDescriptorProvider != null && (makeConfigurationDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor()) != null && makeConfigurationDescriptor.getState() != ConfigurationDescriptor.State.BROKEN) {
            makeConfigurationDescriptor.getConfs().addPropertyChangeListener(this);
        }
    }

    public boolean hasCustomizer() {
        return this.projectDescriptorProvider != null && this.projectDescriptorProvider.gotDescriptor() && this.projectDescriptorProvider.getConfigurationDescriptor() != null;
    }

    public void customize() {
        MakeCustomizerProvider makeCustomizer = (MakeCustomizerProvider)this.project.getLookup().lookup(MakeCustomizerProvider.class);
        makeCustomizer.showCustomizer("Build");
    }

    public boolean configurationsAffectAction(String command) {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        assert (this.pcs != null);
        this.pcs.firePropertyChange("activeConfiguration", null, null);
        this.pcs.firePropertyChange("configurations", null, null);
    }
}

