/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeSources;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakSet;

public class MakeProjectClassPathProvider
implements ClassPathProvider {
    private static final Set<MakeSources> PROJECT_SOURCES = new WeakSet();
    private static final ReadWriteLock PROJECT_LOCK = new ReentrantReadWriteLock();

    public static void addProjectSources(final MakeSources makeSources) {
        MakeProjectClassPathProvider.runUnderWriteLock(new Runnable(){

            @Override
            public void run() {
                PROJECT_SOURCES.add(makeSources);
            }
        });
    }

    public static void removeProjectSources(final MakeSources makeSources) {
        MakeProjectClassPathProvider.runUnderWriteLock(new Runnable(){

            @Override
            public void run() {
                PROJECT_SOURCES.remove(makeSources);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath findClassPath(FileObject file, String type) {
        if ("org.netbeans.modules.cnd.makeproject/SOURCES".equals(type)) {
            PROJECT_LOCK.readLock().lock();
            try {
                for (MakeSources sources : PROJECT_SOURCES) {
                    for (SourceGroup sg : sources.getSourceGroups("generic")) {
                        if (!sg.contains(file)) continue;
                        ClassPath classPath = ClassPathSupport.createClassPath(Arrays.asList(new MakeProject.PathResourceImpl(ClassPathSupport.createResource((URL)sg.getRootFolder().toURL()))));
                        return classPath;
                    }
                }
            }
            finally {
                PROJECT_LOCK.readLock().unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runUnderWriteLock(Runnable runnable) {
        PROJECT_LOCK.writeLock().lock();
        try {
            runnable.run();
        }
        finally {
            PROJECT_LOCK.writeLock().unlock();
        }
    }
}

