/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.ServerDetails;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AddDomainLocationVisualPanel
extends JPanel {
    private final transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private ButtonGroup buttonGroup1;
    private JComboBox domainField;
    private JLabel domainFieldLabel;
    private JLabel explanationLabel;
    private JTextField hostNameField;
    private JLabel hostNameLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField portValueField;
    private JLabel portValueLabel;
    private JRadioButton registerLocalRB;
    private JRadioButton registerRemoteRB;
    private JTextField targetValueField;
    private JLabel targetValueLabel;
    private JCheckBox useDefaultPortsCB;
    private JTextField userNameField;
    private JLabel userNameLabel;

    public AddDomainLocationVisualPanel() {
        this.initComponents();
        this.registerLocalRB.setSelected(true);
        this.registerRemoteRB.setSelected(false);
        this.hostNameField.setEnabled(false);
        this.portValueField.setEnabled(false);
        this.setName(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"TITLE_DomainLocation"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initModels(String gfRoot) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        File domainsDir = new File(gfRoot, "domains");
        File[] candidates = domainsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File dir) {
                File logsDir = new File(dir, "logs");
                return Utils.canWrite(logsDir);
            }
        });
        if (null != candidates) {
            for (File f : candidates) {
                model.addElement(f.getName());
            }
        }
        if (model.getSize() == 0) {
            FileObject userHome = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(System.getProperty("user.home"))));
            String defaultItem = FileUtil.findFreeFolderName((FileObject)userHome, (String)"personal_domain");
            model.addElement(System.getProperty("user.home") + File.separator + defaultItem);
        }
        this.domainField.setModel(model);
        MyKeyListener kl = new MyKeyListener();
        this.domainField.getEditor().getEditorComponent().addKeyListener(kl);
        this.domainField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddDomainLocationVisualPanel.this.domainField.getEditor().setItem(AddDomainLocationVisualPanel.this.domainField.getSelectedItem());
                AddDomainLocationVisualPanel.this.fireChangeEvent();
            }
        });
        this.useDefaultPortsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDomainLocationVisualPanel.this.fireChangeEvent();
            }
        });
        boolean defaultPortsAreOpen = true;
        ServerSocket adminPort = null;
        ServerSocket httpPort = null;
        try {
            adminPort = new ServerSocket(4848);
            httpPort = new ServerSocket(8080);
        }
        catch (IOException ex) {
            defaultPortsAreOpen = false;
            this.useDefaultPortsCB.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.useDefaultPortsCB.text2"));
            if (null == adminPort) {
                this.useDefaultPortsCB.setToolTipText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"TIP_ADMIN_IN_USE"));
            } else {
                this.useDefaultPortsCB.setToolTipText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"TIP_HTTP_IN_USE"));
            }
        }
        finally {
            if (null != adminPort) {
                try {
                    adminPort.close();
                }
                catch (IOException ioe) {}
            }
            if (null != httpPort) {
                try {
                    httpPort.close();
                }
                catch (IOException ioe) {}
            }
        }
        this.useDefaultPortsCB.setEnabled(defaultPortsAreOpen);
        this.useDefaultPortsCB.setSelected(defaultPortsAreOpen);
        this.registerLocalRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDomainLocationVisualPanel.this.hostNameField.setEnabled(!AddDomainLocationVisualPanel.this.registerLocalRB.isSelected());
                AddDomainLocationVisualPanel.this.portValueField.setEnabled(!AddDomainLocationVisualPanel.this.registerLocalRB.isSelected());
                AddDomainLocationVisualPanel.this.domainField.setEnabled(!AddDomainLocationVisualPanel.this.registerRemoteRB.isSelected());
                AddDomainLocationVisualPanel.this.useDefaultPortsCB.setEnabled(!AddDomainLocationVisualPanel.this.registerRemoteRB.isSelected());
                AddDomainLocationVisualPanel.this.fireChangeEvent();
            }
        });
        this.registerRemoteRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDomainLocationVisualPanel.this.hostNameField.setEnabled(!AddDomainLocationVisualPanel.this.registerLocalRB.isSelected());
                AddDomainLocationVisualPanel.this.portValueField.setEnabled(!AddDomainLocationVisualPanel.this.registerLocalRB.isSelected());
                AddDomainLocationVisualPanel.this.domainField.setEnabled(!AddDomainLocationVisualPanel.this.registerRemoteRB.isSelected());
                AddDomainLocationVisualPanel.this.useDefaultPortsCB.setEnabled(!AddDomainLocationVisualPanel.this.registerRemoteRB.isSelected());
                AddDomainLocationVisualPanel.this.fireChangeEvent();
            }
        });
        this.hostNameField.addKeyListener(kl);
        this.portValueField.addKeyListener(kl);
        if (ServerDetails.getVersionFromInstallDirectory(new File(gfRoot)) < ServerDetails.GLASSFISH_SERVER_3_1.getVersion()) {
            this.targetValueField.setText("");
            this.targetValueField.setEnabled(false);
        } else {
            this.targetValueField.setText("");
            this.targetValueField.setEnabled(true);
        }
        this.targetValueField.addKeyListener(kl);
        this.userNameField.addKeyListener(kl);
        this.passwordField.addKeyListener(kl);
    }

    String getDomainField() {
        return (String)this.domainField.getEditor().getItem();
    }

    String getHostName() {
        return this.hostNameField.getText().trim();
    }

    String getPortValue() {
        return this.portValueField.getText().trim();
    }

    String getTargetValue() {
        return this.targetValueField.getText().trim();
    }

    String getUserNameValue() {
        return this.userNameField.getText().trim();
    }

    String getPasswordValue() {
        return new String(this.passwordField.getPassword());
    }

    boolean getUseDefaultPorts() {
        return this.useDefaultPortsCB.isEnabled() && this.useDefaultPortsCB.isSelected();
    }

    private String initPortValue() {
        return Integer.toString(4848);
    }

    private String initUserNameValue() {
        return "";
    }

    private String initPasswordValue() {
        return "";
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChangeEvent() {
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    boolean registerLocalDomain() {
        return this.registerLocalRB.isSelected();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.registerLocalRB = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.domainFieldLabel = new JLabel();
        this.domainField = new JComboBox();
        this.explanationLabel = new JLabel();
        this.useDefaultPortsCB = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.hostNameLabel = new JLabel();
        this.hostNameField = new JTextField();
        this.portValueLabel = new JLabel();
        this.portValueField = new JTextField();
        this.targetValueLabel = new JLabel();
        this.targetValueField = new JTextField();
        this.userNameLabel = new JLabel();
        this.userNameField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.registerRemoteRB = new JRadioButton();
        this.setPreferredSize(new Dimension(438, 353));
        this.buttonGroup1.add(this.registerLocalRB);
        Mnemonics.setLocalizedText((AbstractButton)this.registerLocalRB, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.registerLocalRB.text"));
        this.domainFieldLabel.setLabelFor(this.domainField);
        Mnemonics.setLocalizedText((JLabel)this.domainFieldLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.domainFieldLabel.text"));
        this.domainField.setEditable(true);
        this.domainField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.explanationLabel.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.explanationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.useDefaultPortsCB, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.useDefaultPortsCB.text"));
        this.useDefaultPortsCB.setToolTipText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.useDefaultPortsCB.toolTipText"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.domainFieldLabel).addGap(30, 30, 30).addComponent(this.domainField, 0, -1, Short.MAX_VALUE)).addComponent(this.explanationLabel, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.useDefaultPortsCB).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.domainFieldLabel).addComponent(this.domainField, -2, -1, -2)).addGap(2, 2, 2).addComponent(this.explanationLabel, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.useDefaultPortsCB).addContainerGap()));
        this.domainField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.domainField.AccessibleContext.accessibleDescription"));
        this.explanationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.explanationLabel.AccessibleContext.accessibleDescription"));
        this.useDefaultPortsCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.useDefaultPortsCB.AccessibleContext.accessibleDescription"));
        this.hostNameLabel.setLabelFor(this.hostNameField);
        Mnemonics.setLocalizedText((JLabel)this.hostNameLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostNameLabel.text"));
        this.hostNameField.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostNameField.text"));
        this.hostNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddDomainLocationVisualPanel.this.hostNameFieldActionPerformed(evt);
            }
        });
        this.portValueLabel.setLabelFor(this.portValueField);
        Mnemonics.setLocalizedText((JLabel)this.portValueLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.portValueLabel.text"));
        this.portValueField.setText(this.initPortValue());
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostNameLabel, -2, 82, -2).addComponent(this.portValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostNameField).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.portValueField, -2, 137, -2).addGap(0, 169, Short.MAX_VALUE)))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostNameLabel).addComponent(this.hostNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portValueLabel).addComponent(this.portValueField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.hostNameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostNameField.AccessibleContext.accessibleDescription"));
        this.portValueField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.portValueField.AccessibleContext.accessibleDescription"));
        this.targetValueLabel.setLabelFor(this.portValueField);
        Mnemonics.setLocalizedText((JLabel)this.targetValueLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.targetValueLabel.text"));
        this.targetValueField.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.targetValueField.text"));
        Mnemonics.setLocalizedText((JLabel)this.userNameLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.userNameLabel.text"));
        this.userNameField.setText(this.initUserNameValue());
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.passwordLabel.text"));
        this.passwordField.setText(this.initPasswordValue());
        this.buttonGroup1.add(this.registerRemoteRB);
        Mnemonics.setLocalizedText((AbstractButton)this.registerRemoteRB, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.registerRemoteRB.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(38, 38, 38).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.registerRemoteRB).addComponent(this.registerLocalRB))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passwordLabel).addComponent(this.userNameLabel).addComponent(this.targetValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.userNameField, -1, 162, Short.MAX_VALUE).addComponent(this.targetValueField, -1, 162, Short.MAX_VALUE).addComponent(this.passwordField)))).addContainerGap(170, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.registerLocalRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.registerRemoteRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.targetValueField, -2, -1, -2).addComponent(this.targetValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userNameLabel).addComponent(this.userNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.registerLocalRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.registerLocalRB.AccessibleContext.accessibleDescription"));
        this.registerRemoteRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.registerRemoteRB.AccessibleContext.accessibleDescription"));
    }

    private void hostNameFieldActionPerformed(ActionEvent evt) {
    }

    class MyKeyListener
    implements KeyListener {
        MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
            AddDomainLocationVisualPanel.this.fireChangeEvent();
        }
    }
}

