/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.JrePicker;
import org.netbeans.modules.glassfish.spi.RegisteredDerbyServer;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class VmCustomizer
extends JPanel {
    private static int PORT_MIN = 0;
    private static int PORT_MAX = 65535;
    GlassfishModule gm;
    JrePicker picker = null;
    private JSpinner addressValue;
    private ButtonGroup buttonGroup1;
    private JPanel debugSettingsPanel;
    private JLabel jLabel1;
    private JTextField javaExecutableField;
    private JLabel javaInstallLabel;
    private JButton openDirectoryBrowser;
    private JPanel pickerPanel;
    private JCheckBox useIDEProxyInfo;
    private JRadioButton useSharedMemRB;
    private JRadioButton useSocketRB;
    private JCheckBox useUserDefinedAddress;

    public VmCustomizer(GlassfishModule commonSupport) {
        this.gm = commonSupport;
        this.initComponents();
    }

    private void initFields() {
        if (null != this.picker) {
            throw new UnsupportedOperationException("not implemented yet");
        }
        this.javaExecutableField.setText(this.gm.getInstanceProperties().get("java.platform"));
        String address = this.gm.getInstanceProperties().get("debugPort");
        SpinnerNumberModel addressModel = (SpinnerNumberModel)this.addressValue.getModel();
        if (null == address || "0".equals(address) || "".equals(address)) {
            this.useUserDefinedAddress.setSelected(false);
        } else {
            this.useUserDefinedAddress.setSelected(true);
            this.setAddressValue(address);
        }
        if (Utilities.isWindows() && !this.gm.isRemote()) {
            this.useSharedMemRB.setSelected("true".equals(this.gm.getInstanceProperties().get("use.shared.mem")));
            this.useSocketRB.setSelected(!"true".equals(this.gm.getInstanceProperties().get("use.shared.mem")));
        } else {
            this.useSharedMemRB.setEnabled(false);
            this.useSharedMemRB.setSelected(false);
            this.useSocketRB.setSelected(true);
        }
        this.useIDEProxyInfo.setSelected("true".equals(this.gm.getInstanceProperties().get("useIDEProxyOn")));
        boolean isLocalDomain = this.gm.getInstanceProperties().get("domainsfolder") != null;
        this.javaExecutableField.setEnabled(isLocalDomain);
        this.useIDEProxyInfo.setEnabled(isLocalDomain);
        this.useSharedMemRB.setEnabled(isLocalDomain);
    }

    private Number getAddressValue() {
        return ((SpinnerNumberModel)this.addressValue.getModel()).getNumber();
    }

    private void setAddressValue(String number) {
        try {
            this.addressValue.setValue(new Integer(number));
        }
        catch (NumberFormatException nfe) {
            this.addressValue.setValue(new Integer(0));
        }
    }

    private void setAddressValue(Integer number) {
        this.addressValue.setValue(number != null ? number : new Integer(0));
    }

    private void persistFields() {
        if (null == this.picker) {
            File dir;
            File dbdir;
            File f;
            this.gm.setEnvironmentProperty("java.platform", this.javaExecutableField.getText(), true);
            RegisteredDerbyServer db = (RegisteredDerbyServer)Lookup.getDefault().lookup(RegisteredDerbyServer.class);
            if (null != db && (f = new File(this.javaExecutableField.getText().trim())).exists() && f.canRead() && (dbdir = new File(dir = f.getParentFile().getParentFile(), "db")).exists() && dbdir.isDirectory() && dbdir.canRead()) {
                db.initialize(dbdir.getAbsolutePath());
            }
        } else {
            throw new UnsupportedOperationException("not implemented yet");
        }
        this.gm.setEnvironmentProperty("use.shared.mem", Boolean.toString(this.useSharedMemRB.isSelected()), true);
        this.gm.setEnvironmentProperty("useIDEProxyOn", Boolean.toString(this.useIDEProxyInfo.isSelected()), true);
        this.gm.setEnvironmentProperty("debugPort", this.getAddressValue().toString(), true);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initFields();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.persistFields();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.debugSettingsPanel = new JPanel();
        this.useSocketRB = new JRadioButton();
        this.useSharedMemRB = new JRadioButton();
        this.useUserDefinedAddress = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.addressValue = new JSpinner();
        this.pickerPanel = new JPanel();
        this.javaInstallLabel = new JLabel();
        this.openDirectoryBrowser = new JButton();
        this.javaExecutableField = new JTextField();
        this.useIDEProxyInfo = new JCheckBox();
        this.setName(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.name"));
        this.debugSettingsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.debugSettingsPanel.border.title.text")));
        this.buttonGroup1.add(this.useSocketRB);
        Mnemonics.setLocalizedText((AbstractButton)this.useSocketRB, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useSocketRB.text"));
        this.buttonGroup1.add(this.useSharedMemRB);
        Mnemonics.setLocalizedText((AbstractButton)this.useSharedMemRB, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useSharedMemRB.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.useUserDefinedAddress, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useUserDefinedAddress.text", (Object[])new Object[0]));
        this.useUserDefinedAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VmCustomizer.this.toggleAddressUsage(evt);
            }
        });
        this.jLabel1.setLabelFor(this.addressValue);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.jLabel1.text"));
        this.addressValue.setModel(new SpinnerNumberModel(0, 0, 65535, 1));
        this.addressValue.setEditor(new JSpinner.NumberEditor(this.addressValue, "#####"));
        GroupLayout debugSettingsPanelLayout = new GroupLayout(this.debugSettingsPanel);
        this.debugSettingsPanel.setLayout(debugSettingsPanelLayout);
        debugSettingsPanelLayout.setHorizontalGroup(debugSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(debugSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(debugSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(debugSettingsPanelLayout.createSequentialGroup().addGroup(debugSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useSharedMemRB).addComponent(this.useSocketRB)).addContainerGap(490, Short.MAX_VALUE)).addGroup(debugSettingsPanelLayout.createSequentialGroup().addComponent(this.useUserDefinedAddress).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addressValue, -2, 99, -2).addGap(0, 0, Short.MAX_VALUE)))));
        debugSettingsPanelLayout.setVerticalGroup(debugSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(debugSettingsPanelLayout.createSequentialGroup().addComponent(this.useSharedMemRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useSocketRB).addGap(8, 8, 8).addGroup(debugSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useUserDefinedAddress).addComponent(this.jLabel1).addComponent(this.addressValue, -2, -1, -2)).addContainerGap()));
        this.useSocketRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_UseSockets"));
        this.useSharedMemRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_SharedMem"));
        this.useUserDefinedAddress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_UseSelectedAddress"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_AddressLabel"));
        this.javaInstallLabel.setLabelFor(this.javaExecutableField);
        Mnemonics.setLocalizedText((JLabel)this.javaInstallLabel, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.javaInstallLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.openDirectoryBrowser, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.openDirectoryBrowser.text"));
        this.openDirectoryBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VmCustomizer.this.openInstallChooser(evt);
            }
        });
        this.javaExecutableField.setText(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.javaExecutableField.text"));
        GroupLayout pickerPanelLayout = new GroupLayout(this.pickerPanel);
        this.pickerPanel.setLayout(pickerPanelLayout);
        pickerPanelLayout.setHorizontalGroup(pickerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pickerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.javaInstallLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.javaExecutableField, -2, 308, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openDirectoryBrowser).addContainerGap()));
        pickerPanelLayout.setVerticalGroup(pickerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pickerPanelLayout.createSequentialGroup().addContainerGap().addGroup(pickerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaInstallLabel).addComponent(this.javaExecutableField, -2, -1, -2).addComponent(this.openDirectoryBrowser)).addContainerGap()));
        this.javaInstallLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_JavaLabel"));
        this.openDirectoryBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_Browse"));
        this.javaExecutableField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.javaExecutableField.accessiblename"));
        this.javaExecutableField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_JavaField"));
        Mnemonics.setLocalizedText((AbstractButton)this.useIDEProxyInfo, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useIDEProxyInfo.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pickerPanel, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.useIDEProxyInfo)).addComponent(this.debugSettingsPanel, -2, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pickerPanel, -2, -1, -2).addGap(9, 9, 9).addComponent(this.debugSettingsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.useIDEProxyInfo).addContainerGap()));
        this.useIDEProxyInfo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_UseIdeProxySettings"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_JavaPanel"));
    }

    private void openInstallChooser(ActionEvent evt) {
        JFileChooser f = new JFileChooser();
        f.setSelectedFile(new File(this.javaExecutableField.getText()));
        f.setFileSelectionMode(0);
        f.setMultiSelectionEnabled(false);
        final String TESTNAME = File.separatorChar == '/' ? "java" : "java.exe";
        f.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return true;
                }
                if (arg0.getName().equalsIgnoreCase(TESTNAME)) {
                    if (VmCustomizer.this.gm.getInstanceProvider().equals(GlassfishInstanceProvider.getEe6())) {
                        return Util.appearsToBeJdk6OrBetter(arg0);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.filechooser.description");
            }
        });
        int retVal = f.showOpenDialog(this);
        if (retVal == 0) {
            this.javaExecutableField.setText(f.getSelectedFile().getAbsolutePath());
        }
    }

    private void toggleAddressUsage(ActionEvent evt) {
        if (this.useUserDefinedAddress.isSelected()) {
            this.addressValue.setEnabled(true);
            int debugPort = 9009;
            try {
                ServerSocket t = new ServerSocket(0);
                debugPort = t.getLocalPort();
                t.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setAddressValue(new Integer(debugPort));
        } else {
            this.setAddressValue(new Integer(0));
            this.addressValue.setEnabled(false);
        }
    }
}

