/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes;

import java.awt.Image;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.nodes.Refreshable;
import org.netbeans.modules.glassfish.common.nodes.actions.DeployDirectoryCookie;
import org.netbeans.modules.glassfish.common.nodes.actions.DisableModulesAction;
import org.netbeans.modules.glassfish.common.nodes.actions.DisableModulesCookie;
import org.netbeans.modules.glassfish.common.nodes.actions.EditDetailsAction;
import org.netbeans.modules.glassfish.common.nodes.actions.EnableModulesAction;
import org.netbeans.modules.glassfish.common.nodes.actions.EnableModulesCookie;
import org.netbeans.modules.glassfish.common.nodes.actions.OpenTestURLAction;
import org.netbeans.modules.glassfish.common.nodes.actions.OpenURLAction;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesAction;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.glassfish.common.nodes.actions.UndeployModuleAction;
import org.netbeans.modules.glassfish.common.nodes.actions.UndeployModuleCookie;
import org.netbeans.modules.glassfish.common.nodes.actions.UnregisterResourceAction;
import org.netbeans.modules.glassfish.spi.Decorator;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.ResourceDecorator;
import org.openide.actions.CopyAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class Hk2ItemNode
extends AbstractNode {
    protected final Decorator decorator;
    private static final String RESOURCES_ICON = "org/netbeans/modules/glassfish/common/resources/resources.gif";
    private static final String WS_ICON = "org/netbeans/modules/glassfish/common/resources/webservice.png";
    public static final Decorator J2EE_APPLICATION_FOLDER = new Decorator(){

        @Override
        public boolean isRefreshable() {
            return true;
        }

        @Override
        public boolean canDeployTo() {
            return true;
        }
    };
    public static final Decorator RESOURCES_FOLDER = new Decorator(){

        @Override
        public boolean isRefreshable() {
            return true;
        }

        @Override
        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)Hk2ItemNode.RESOURCES_ICON);
        }

        @Override
        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    };
    public static final Decorator WS_FOLDER = new Decorator(){

        @Override
        public boolean isRefreshable() {
            return true;
        }
    };
    public static final Decorator WS_ENDPOINT = new Decorator(){

        @Override
        public boolean canTest() {
            return true;
        }

        @Override
        public boolean canCopy() {
            return true;
        }

        @Override
        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)Hk2ItemNode.WS_ICON);
        }

        @Override
        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    };
    public static final Decorator J2EE_APPLICATION = new Decorator(){

        @Override
        public boolean canUndeploy() {
            return true;
        }

        @Override
        public boolean canEnable() {
            return true;
        }

        @Override
        public boolean canDisable() {
            return true;
        }

        @Override
        public boolean canShowBrowser() {
            return true;
        }
    };
    public static final Decorator REFRESHABLE_FOLDER = new Decorator(){

        @Override
        public boolean isRefreshable() {
            return true;
        }

        @Override
        public boolean canDeployTo() {
            return true;
        }
    };
    public static final Decorator JDBC_MANAGED_DATASOURCES = new ResourceDecorator(){

        @Override
        public boolean canUnregister() {
            return true;
        }

        @Override
        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)Hk2ItemNode.RESOURCES_ICON);
        }

        @Override
        public String getCmdPropertyName() {
            return "jdbc_resource_name";
        }
    };
    public static final Decorator CONNECTION_POOLS = new ResourceDecorator(){

        @Override
        public boolean canUnregister() {
            return true;
        }

        @Override
        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)Hk2ItemNode.RESOURCES_ICON);
        }

        @Override
        public String getCmdPropertyName() {
            return "jdbc_connection_pool_id";
        }

        @Override
        public boolean isCascadeDelete() {
            return true;
        }
    };

    protected Hk2ItemNode(Children children, final Lookup lookup, final String name, Decorator decorator) {
        super(children);
        this.decorator = decorator;
        if (decorator.isRefreshable()) {
            this.getCookieSet().add((Node.Cookie)new RefreshModulesCookie(){

                @Override
                public void refresh() {
                    this.refresh(null, null);
                }

                @Override
                public void refresh(String expected, String unexpected) {
                    Children children = Hk2ItemNode.this.getChildren();
                    if (children instanceof Refreshable) {
                        ((Refreshable)children).updateKeys();
                        boolean foundExpected = expected == null;
                        boolean foundUnexpected = false;
                        for (Node node : children.getNodes()) {
                            if (!foundExpected && node.getDisplayName().equals(expected)) {
                                foundExpected = true;
                            }
                            if (foundUnexpected || !node.getDisplayName().equals(unexpected)) continue;
                            foundUnexpected = true;
                        }
                        if (!foundExpected) {
                            Logger.getLogger("glassfish").log(Level.WARNING, null, new IllegalStateException("did not find a child node, named " + expected));
                        }
                        if (foundUnexpected) {
                            Logger.getLogger("glassfish").log(Level.WARNING, null, new IllegalStateException("found unexpected child node, named " + unexpected));
                        }
                    }
                }
            });
        }
        if (decorator.canDeployTo()) {
            this.getCookieSet().add((Node.Cookie)new DeployDirectoryCookie(){

                @Override
                public void deployDirectory() {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle(NbBundle.getMessage(Hk2ItemNode.class, (String)"LBL_ChooseButton"));
                    chooser.setDialogType(2);
                    chooser.setFileSelectionMode(1);
                    chooser.setMultiSelectionEnabled(false);
                    int returnValue = chooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(Hk2ItemNode.class, (String)"LBL_ChooseButton"));
                    if (returnValue != 0) {
                        return;
                    }
                    File dir = new File(chooser.getSelectedFile().getAbsolutePath());
                    CommonServerSupport commonModule = (CommonServerSupport)lookup.lookup(CommonServerSupport.class);
                    if (commonModule != null) {
                        CommandRunner mgr = new CommandRunner(true, commonModule.getCommandFactory(), commonModule.getInstance(), new OperationStateListener[0]);
                        mgr.deploy(dir);
                    }
                }
            });
        }
        if (decorator.canUndeploy()) {
            this.getCookieSet().add((Node.Cookie)new UndeployModuleCookie(){
                private volatile WeakReference<Future<GlassfishModule.OperationState>> status;

                @Override
                public Future<GlassfishModule.OperationState> undeploy() {
                    Future<GlassfishModule.OperationState> result = null;
                    CommonServerSupport commonModule = (CommonServerSupport)lookup.lookup(CommonServerSupport.class);
                    if (commonModule != null) {
                        CommandRunner mgr = new CommandRunner(true, commonModule.getCommandFactory(), commonModule.getInstance(), new OperationStateListener[0]);
                        result = mgr.undeploy(name);
                        this.status = new WeakReference<Future<GlassfishModule.OperationState>>(result);
                    }
                    return result;
                }

                @Override
                public boolean isRunning() {
                    WeakReference<Future<GlassfishModule.OperationState>> localref = this.status;
                    if (localref == null) {
                        return false;
                    }
                    Future cmd = (Future)localref.get();
                    return cmd != null && !cmd.isDone();
                }
            });
        }
        if (decorator.canEnable()) {
            this.getCookieSet().add((Node.Cookie)new EnableModulesCookie(){
                private volatile WeakReference<Future<GlassfishModule.OperationState>> status;

                @Override
                public Future<GlassfishModule.OperationState> enableModule() {
                    Future<GlassfishModule.OperationState> result = null;
                    CommonServerSupport commonModule = (CommonServerSupport)lookup.lookup(CommonServerSupport.class);
                    if (commonModule != null) {
                        CommandRunner mgr = new CommandRunner(true, commonModule.getCommandFactory(), commonModule.getInstance(), new OperationStateListener[0]);
                        result = mgr.enable(name);
                        this.status = new WeakReference<Future<GlassfishModule.OperationState>>(result);
                    }
                    return result;
                }

                @Override
                public boolean isRunning() {
                    WeakReference<Future<GlassfishModule.OperationState>> localref = this.status;
                    if (localref == null) {
                        return false;
                    }
                    Future cmd = (Future)localref.get();
                    return cmd != null && !cmd.isDone();
                }
            });
        }
        if (decorator.canDisable()) {
            this.getCookieSet().add((Node.Cookie)new DisableModulesCookie(){
                private volatile WeakReference<Future<GlassfishModule.OperationState>> status;

                @Override
                public Future<GlassfishModule.OperationState> disableModule() {
                    Future<GlassfishModule.OperationState> result = null;
                    CommonServerSupport commonModule = (CommonServerSupport)lookup.lookup(CommonServerSupport.class);
                    if (commonModule != null) {
                        CommandRunner mgr = new CommandRunner(true, commonModule.getCommandFactory(), commonModule.getInstance(), new OperationStateListener[0]);
                        result = mgr.disable(name);
                        this.status = new WeakReference<Future<GlassfishModule.OperationState>>(result);
                    }
                    return result;
                }

                @Override
                public boolean isRunning() {
                    WeakReference<Future<GlassfishModule.OperationState>> localref = this.status;
                    if (localref == null) {
                        return false;
                    }
                    Future cmd = (Future)localref.get();
                    return cmd != null && !cmd.isDone();
                }
            });
        }
    }

    public Hk2ItemNode(Lookup lookup, Children children, String name, Decorator type) {
        this(children, lookup, name, type);
        this.setDisplayName(name);
    }

    public Image getIcon(int type) {
        Image badge = this.decorator.getIconBadge();
        Image image = badge != null ? (null == this.decorator.getIcon(type) ? Hk2ItemNode.badgeFolder(badge, false) : Hk2ItemNode.badgeIcon(badge, this.decorator.getIcon(type))) : this.decorator.getIcon(type);
        return image != null ? image : Hk2ItemNode.getIconDelegate().getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        Image badge = this.decorator.getIconBadge();
        Image image = badge != null ? Hk2ItemNode.badgeFolder(badge, true) : this.decorator.getOpenedIcon(type);
        return image != null ? image : Hk2ItemNode.getIconDelegate().getOpenedIcon(type);
    }

    public Action[] getActions(boolean context) {
        ArrayList<SystemAction> actions = new ArrayList<SystemAction>();
        if (this.decorator.isRefreshable()) {
            actions.add(SystemAction.get(RefreshModulesAction.class));
        }
        if (this.decorator.canDeployTo()) {
            // empty if block
        }
        if (this.decorator.canUndeploy()) {
            actions.add(SystemAction.get(UndeployModuleAction.class));
        }
        if (this.decorator.canEnable()) {
            actions.add(SystemAction.get(EnableModulesAction.class));
        }
        if (this.decorator.canDisable()) {
            actions.add(SystemAction.get(DisableModulesAction.class));
        }
        if (this.decorator.canUnregister()) {
            actions.add(SystemAction.get(UnregisterResourceAction.class));
        }
        if (this.decorator.canShowBrowser()) {
            actions.add(SystemAction.get(OpenURLAction.class));
        }
        if (this.decorator.canTest()) {
            actions.add(SystemAction.get(OpenTestURLAction.class));
        }
        if (this.decorator.canCopy()) {
            actions.add(SystemAction.get(CopyAction.class));
        }
        if (this.decorator.canEditDetails()) {
            actions.add(SystemAction.get(EditDetailsAction.class));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public static Node createWaitNode() {
        AbstractNode node = new AbstractNode(Children.LEAF);
        node.setName(NbBundle.getMessage(Hk2ItemNode.class, (String)"LBL_WaitNode_DisplayName"));
        node.setIconBaseWithExtension("org/openide/src/resources/wait.gif");
        return node;
    }

    public static Image badgeFolder(Image badge, boolean opened) {
        Node folderNode = Hk2ItemNode.getIconDelegate();
        Image folder = opened ? folderNode.getOpenedIcon(1) : folderNode.getIcon(1);
        return ImageUtilities.mergeImages((Image)folder, (Image)badge, (int)7, (int)7);
    }

    public static Image badgeIcon(Image badge, Image icon) {
        return ImageUtilities.mergeImages((Image)icon, (Image)badge, (int)7, (int)7);
    }

    private static Node getIconDelegate() {
        return DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
    }
}

