/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tools.ide.admin.ResultString;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.server.ServerTasks;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.GlassFishStatus;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;

public class StopTask
extends BasicTask<GlassfishModule.OperationState> {
    private final CommonServerSupport support;

    public StopTask(CommonServerSupport support, OperationStateListener ... stateListener) {
        super(support.getInstance(), stateListener);
        this.support = support;
    }

    @Override
    public GlassfishModule.OperationState call() {
        Logger.getLogger("glassfish").log(Level.FINEST, "StopTask.call() called on thread \"{0}\"", Thread.currentThread().getName());
        long start = System.currentTimeMillis();
        String host = this.instance.getProperty("host");
        if (host == null || host.length() == 0) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_NOHOST", this.instanceName);
        }
        try {
            int port = Integer.valueOf(this.instance.getProperty("adminPort"));
            if (port < 0 || port > 65535) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
            }
        }
        catch (NumberFormatException ex) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
        }
        String target = Util.computeTarget(this.instance.getProperties());
        if (!Util.isDefaultOrServerTarget(this.instance.getProperties())) {
            return this.stopClusterOrInstance(target);
        }
        ResultString result = ServerTasks.stopServer((GlassFishServer)this.instance);
        if (TaskState.FAILED.equals((Object)result.getState())) {
            this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_STOP_SERVER_FAILED", this.instanceName);
        }
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_STOP_SERVER_IN_PROGRESS", this.instanceName);
        while (System.currentTimeMillis() - start < 10000L) {
            if (!GlassFishStatus.isReady(this.instance, false)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                LogViewMgr.removeServerLogStream(this.instance);
                LogViewMgr logger = LogViewMgr.getInstance(this.instance.getProperty("url"));
                logger.stopReaders();
                return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_STOPPED", this.instanceName);
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_STOP_SERVER_IN_PROGRESS", this.instanceName);
        }
        return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_STOP_SERVER_FAILED", this.instanceName);
    }

    private GlassfishModule.OperationState stopClusterOrInstance(String target) {
        ResultString result = ServerTasks.stopCluster((GlassFishServer)this.instance, (String)target);
        if (TaskState.FAILED.equals((Object)result.getState()) && TaskState.FAILED.equals((Object)(result = ServerTasks.stopServerInstance((GlassFishServer)this.instance, (String)target)).getState())) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_STOP_TARGET_FAILED", this.instanceName, target);
        }
        return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_STOPPED", this.instanceName);
    }
}

