/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.awt.Dialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.glassfish.tools.ide.admin.ResultProcess;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.StartupArgs;
import org.glassfish.tools.ide.data.StartupArgsEntity;
import org.glassfish.tools.ide.server.FetchLog;
import org.glassfish.tools.ide.server.FetchLogSimple;
import org.glassfish.tools.ide.server.ServerTasks;
import org.glassfish.tools.ide.utils.ServerUtils;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.Commands;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.EnableComet;
import org.netbeans.modules.glassfish.common.GlassFishStatus;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.common.ProcessCreationException;
import org.netbeans.modules.glassfish.common.ServerDetails;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RegisteredDerbyServer;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.modules.glassfish.spi.VMIntrospector;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class StartTask
extends BasicTask<GlassfishModule.OperationState> {
    private static final String MAIN_CLASS = "com.sun.enterprise.glassfish.bootstrap.ASMain";
    private final CommonServerSupport support;
    private List<Recognizer> recognizers;
    private FileObject jdkHome = null;
    private List<String> jvmArgs = null;
    private static final int LOWEST_USER_PORT = Utilities.isWindows() ? 1 : 1025;
    private final VMIntrospector vmi;
    private static RequestProcessor NODE_REFRESHER = new RequestProcessor("nodes to refresh");

    private static String[] removeEscapes(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].replace("\\\"", "");
        }
        return args;
    }

    private static StartupExtender.StartMode getMode(String gfMode) {
        if ("profileMode".equals(gfMode)) {
            return StartupExtender.StartMode.PROFILE;
        }
        if ("debugMode".equals(gfMode)) {
            return StartupExtender.StartMode.DEBUG;
        }
        return StartupExtender.StartMode.NORMAL;
    }

    public StartTask(CommonServerSupport support, List<Recognizer> recognizers, VMIntrospector vmi, OperationStateListener ... stateListener) {
        this(support, recognizers, vmi, (FileObject)null, (String[])null, stateListener);
    }

    public StartTask(final CommonServerSupport support, List<Recognizer> recognizers, VMIntrospector vmi, FileObject jdkRoot, String[] jvmArgs, OperationStateListener ... stateListener) {
        super(support.getInstance(), stateListener);
        ArrayList<OperationStateListener> listeners = new ArrayList<OperationStateListener>();
        listeners.addAll(Arrays.asList(stateListener));
        listeners.add(new OperationStateListener(){

            @Override
            public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                if (GlassfishModule.OperationState.COMPLETED.equals((Object)newState)) {
                    RequestProcessor.getDefault().post((Runnable)new EnableComet(support));
                }
            }
        });
        this.stateListener = listeners.toArray(new OperationStateListener[listeners.size()]);
        this.support = support;
        this.recognizers = recognizers;
        this.jdkHome = jdkRoot;
        this.jvmArgs = jvmArgs != null ? Arrays.asList(StartTask.removeEscapes(jvmArgs)) : null;
        this.vmi = vmi;
        Logger.getLogger("glassfish").log(Level.FINE, "VMI == {0}", vmi);
    }

    @Override
    public GlassfishModule.OperationState call() {
        Logger.getLogger("glassfish").log(Level.FINEST, "StartTask.call() called on thread \"{0}\"", Thread.currentThread().getName());
        long start = System.currentTimeMillis();
        String adminHost = this.instance.getProperty("host");
        if (adminHost == null || adminHost.length() == 0) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_NOHOST", this.instanceName);
        }
        int adminPort = Integer.valueOf(this.instance.getProperty("adminPort"));
        if (adminPort < 0 || adminPort > 65535) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
        }
        if (this.support.isRemote()) {
            if (GlassFishStatus.isReady(this.instance, false)) {
                if (Util.isDefaultOrServerTarget(this.instance.getProperties())) {
                    return this.restartDAS(adminHost, adminPort, start);
                }
                return this.startClusterOrInstance(adminHost, adminPort);
            }
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_DASDOWN", this.instanceName);
        }
        if (!GlassFishStatus.isReady(this.instance, false)) {
            return this.startDASAndClusterOrInstance(adminHost, adminPort);
        }
        return this.startClusterOrInstance(adminHost, adminPort);
    }

    private GlassfishModule.OperationState restartDAS(String adminHost, int adminPort, final long start) {
        CommandRunner mgr = new CommandRunner(true, this.support.getCommandFactory(), this.instance, new OperationStateListener(){

            @Override
            public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                if (newState == GlassfishModule.OperationState.RUNNING) {
                    StartTask.this.support.setServerState(GlassfishModule.ServerState.STARTING);
                }
                if (newState == GlassfishModule.OperationState.FAILED) {
                    StartTask.this.fireOperationStateChanged(newState, message, StartTask.this.instanceName);
                    StartTask.this.support.setServerState(GlassfishModule.ServerState.STOPPED);
                } else if (newState == GlassfishModule.OperationState.COMPLETED) {
                    if (message.matches("[sg]et\\?.*\\=configs\\..*")) {
                        return;
                    }
                    long startTime = System.currentTimeMillis();
                    GlassfishModule.OperationState state = GlassfishModule.OperationState.RUNNING;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    while (GlassfishModule.OperationState.RUNNING == state && System.currentTimeMillis() - start < 120000L) {
                        boolean httpLive = GlassFishStatus.isReady(StartTask.this.instance, false);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (!httpLive) continue;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        state = GlassfishModule.OperationState.COMPLETED;
                    }
                    if (state == GlassfishModule.OperationState.COMPLETED) {
                        StartTask.this.support.setServerState(GlassfishModule.ServerState.RUNNING);
                    } else {
                        StartTask.this.support.setServerState(GlassfishModule.ServerState.STOPPED);
                    }
                }
            }
        });
        int debugPort = -1;
        if ("debugMode".equals(this.instance.getProperty("jvmMode"))) {
            try {
                debugPort = Integer.parseInt(this.instance.getProperty("debugPort"));
                if (debugPort < LOWEST_USER_PORT || debugPort > 65535) {
                    this.support.setEnvironmentProperty("debugPort", "9009", true);
                    debugPort = 9009;
                    Logger.getLogger("glassfish").log(Level.INFO, "converted debug port to 9009 for {0}", this.instanceName);
                }
            }
            catch (NumberFormatException nfe) {
                this.support.setEnvironmentProperty("debugPort", "9009", true);
                this.support.setEnvironmentProperty("use.shared.mem", "false", true);
                debugPort = 9009;
                Logger.getLogger("glassfish").log(Level.INFO, "converted debug type to socket and port to 9009 for {0}", this.instanceName);
            }
        }
        String restartQ = "";
        if (this.support.supportsRestartInDebug()) {
            restartQ = -1 == debugPort ? "debug=false" : "debug=true";
        }
        mgr.restartServer(debugPort, restartQ);
        return this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_START_SERVER_IN_PROGRESS", this.instanceName);
    }

    private GlassfishModule.OperationState startDASAndClusterOrInstance(String adminHost, int adminPort) {
        Process serverProcess;
        long start = System.currentTimeMillis();
        try {
            RegisteredDerbyServer db;
            if (null == this.jdkHome) {
                this.jdkHome = this.getJavaPlatformRoot(this.support);
            }
            if (null != (db = (RegisteredDerbyServer)Lookup.getDefault().lookup(RegisteredDerbyServer.class)) && "true".equals(this.instance.getProperty("derbyStartOn"))) {
                db.start();
            }
            int testPort = 0;
            String portCandidate = this.support.getAdminPort();
            try {
                testPort = Integer.parseInt(portCandidate);
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger("glassfish").log(Level.INFO, "could not parse {0} as an Inetger", portCandidate);
            }
            Logger.getLogger("glassfish").log(Level.FINEST, "Checking if GlassFish {0} is running. Timeout set to 20000 ms", this.instance.getName());
            if (GlassFishStatus.isReady(this.instance, false)) {
                GlassfishModule.OperationState result = GlassfishModule.OperationState.COMPLETED;
                if ("profileMode".equals(this.instance.getProperty("jvmMode"))) {
                    result = GlassfishModule.OperationState.FAILED;
                }
                return this.fireOperationStateChanged(result, "MSG_START_SERVER_OCCUPIED_PORT", this.instanceName);
            }
            if (testPort != 0 && Utils.isLocalPortOccupied(testPort)) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_OCCUPIED_PORT", this.instanceName);
            }
            if (this.upgradeFailed()) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_DOMAIN_UPGRADE_FAILED", this.instanceName);
            }
            serverProcess = this.createProcess();
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger("glassfish").log(Level.INFO, this.instance.getProperty("httpportnumber"), nfe);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
        }
        catch (IOException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_PASS_THROUGH", ex.getLocalizedMessage());
        }
        catch (ProcessCreationException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_PASS_THROUGH", ex.getLocalizedMessage());
        }
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_START_SERVER_IN_PROGRESS", this.instanceName);
        LogViewMgr logger = LogViewMgr.getInstance(this.instance.getProperty("url"));
        String debugPort = this.instance.getProperty("debugPort");
        logger.readInputStreams(this.recognizers, false, null, new FetchLog[]{new FetchLogSimple(serverProcess.getInputStream()), new FetchLogSimple(serverProcess.getErrorStream())});
        Logger.getLogger("glassfish").log(Level.FINER, "Waiting for server to start for {0} ms", new Object[]{Integer.toString(120000)});
        while (System.currentTimeMillis() - start < 120000L) {
            boolean httpLive = CommonServerSupport.isRunning("localhost", adminPort, "localhost");
            Logger.getLogger("glassfish").log(Level.FINEST, "{0} DAS port {1} {2} alive", new Object[]{this.instance.getName(), Integer.toString(adminPort), httpLive ? "is" : "is not"});
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (httpLive) {
                if (!GlassFishStatus.isReady(this.instance, true, GlassFishStatus.Mode.STARTUP)) {
                    GlassfishModule.OperationState state = GlassfishModule.OperationState.FAILED;
                    String messageKey = "MSG_START_SERVER_FAILED";
                    Logger.getLogger("glassfish").log(Level.INFO, "{0} is not responding, killing the process.", new Object[]{this.instance.getName()});
                    LogViewMgr.removeServerLogStream(this.instance);
                    serverProcess.destroy();
                    logger.stopReaders();
                    return this.fireOperationStateChanged(state, messageKey, this.instanceName);
                }
                return this.startClusterOrInstance(adminHost, adminPort);
            }
            if (null != this.jvmArgs) {
                Logger.getLogger("glassfish").log(Level.FINE, "Profiling mode status hack for {0}", new Object[]{this.instance.getName()});
                this.support.setLocalStartProcess(serverProcess);
                NODE_REFRESHER.post(new Runnable(){

                    @Override
                    public void run() {
                        while (!GlassFishStatus.isReady(StartTask.this.instance, false)) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StartTask.this.support.refresh();
                            }
                        });
                    }
                });
                return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_STARTED", this.instanceName);
            }
            if (null == this.vmi || null == debugPort || !this.vmi.isSuspended(adminHost, debugPort)) continue;
            start = System.currentTimeMillis();
        }
        Logger.getLogger("glassfish").log(Level.INFO, "{0} Failed to start, killing process {1} after {2} ms", new Object[]{this.instance.getName(), serverProcess, System.currentTimeMillis() - start});
        LogViewMgr.removeServerLogStream(this.instance);
        serverProcess.destroy();
        logger.stopReaders();
        return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED2", this.instanceName, adminHost, adminPort + "");
    }

    private GlassfishModule.OperationState startClusterOrInstance(String adminHost, int adminPort) {
        String target = Util.computeTarget(this.instance.getProperties());
        if (Util.isDefaultOrServerTarget(this.instance.getProperties())) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_STARTED", this.instanceName);
        }
        Object retVal = null;
        CommandRunner inner = new CommandRunner(true, this.support.getCommandFactory(), this.instance, new OperationStateListener(){

            @Override
            public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
            }
        });
        Future<GlassfishModule.OperationState> result = inner.execute(new Commands.StartCluster(target));
        GlassfishModule.OperationState state = null;
        try {
            state = result.get();
        }
        catch (InterruptedException ie) {
            Logger.getLogger("glassfish").log(Level.INFO, "start-cluster", ie);
        }
        catch (ExecutionException ie) {
            Logger.getLogger("glassfish").log(Level.INFO, "start-cluster", ie);
        }
        if (state == GlassfishModule.OperationState.FAILED) {
            inner = new CommandRunner(true, this.support.getCommandFactory(), this.instance, new OperationStateListener(){

                @Override
                public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                }
            });
            result = inner.execute(new Commands.StartInstance(target));
            try {
                state = result.get();
            }
            catch (InterruptedException ie) {
                Logger.getLogger("glassfish").log(Level.INFO, "start-instance", ie);
            }
            catch (ExecutionException ie) {
                Logger.getLogger("glassfish").log(Level.INFO, "start-instance", ie);
            }
            if (state == GlassfishModule.OperationState.FAILED) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_TARGET_FAILED", this.instanceName, target);
            }
        }
        this.support.updateHttpPort();
        return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_STARTED", this.instanceName);
    }

    private FileObject getJavaPlatformRoot(CommonServerSupport support) throws IOException {
        FileObject retVal;
        String javaInstall = support.getInstanceProperties().get("java.platform");
        if (null == javaInstall || javaInstall.trim().length() < 1) {
            File dir = new File(this.getJdkHome());
            retVal = FileUtil.createFolder((File)FileUtil.normalizeFile((File)dir));
        } else {
            File f = new File(javaInstall);
            if (f.exists()) {
                File dir = f.getParentFile().getParentFile();
                retVal = FileUtil.createFolder((File)FileUtil.normalizeFile((File)dir));
            } else {
                throw new FileNotFoundException(NbBundle.getMessage(StartTask.class, (String)"MSG_INVALID_JAVA", (Object)this.instanceName, (Object)javaInstall));
            }
        }
        return retVal;
    }

    private String getJdkHome() {
        String result;
        if (null != this.jdkHome) {
            result = FileUtil.toFile((FileObject)this.jdkHome).getAbsolutePath();
        } else {
            result = System.getProperty("java.home");
            if (result.endsWith(File.separatorChar + "jre")) {
                result = result.substring(0, result.length() - 4);
            }
        }
        return result;
    }

    private StartupArgs createProcessDescriptor() throws ProcessCreationException {
        ArrayList<String> glassfishArgs = new ArrayList<String>(2);
        String domainDir = Util.quote(this.getDomainFolder().getAbsolutePath());
        glassfishArgs.add(ServerUtils.cmdLineArgument((String)ServerUtils.GF_DOMAIN_ARG, (String)this.getDomainName()));
        glassfishArgs.add(ServerUtils.cmdLineArgument((String)ServerUtils.GF_DOMAIN_DIR_ARG, (String)domainDir));
        ArrayList<String> optList = new ArrayList<String>();
        if ("debugMode".equals(this.instance.getProperty("jvmMode"))) {
            this.appendDebugOptions(optList);
        }
        this.appendStartupExtenderParams(optList);
        return new StartupArgsEntity(glassfishArgs, optList, (Map)null, FileUtil.toFile((FileObject)this.jdkHome).getAbsolutePath());
    }

    private void appendDebugOptions(List<String> optList) throws ProcessCreationException {
        int t;
        String debugPortString = this.instance.getProperty("debugPort");
        String debugTransport = "dt_socket";
        if ("true".equals(this.instance.getProperty("use.shared.mem"))) {
            debugTransport = "dt_shmem";
        } else if (null != debugPortString && debugPortString.trim().length() > 0 && (t = Integer.parseInt(debugPortString)) != 0 && (t < LOWEST_USER_PORT || t > 65535)) {
            throw new NumberFormatException();
        }
        if (null == debugPortString || "0".equals(debugPortString) || "".equals(debugPortString)) {
            if ("true".equals(this.instance.getProperty("use.shared.mem"))) {
                debugPortString = Integer.toString(Math.abs((this.instance.getProperty("homefolder") + this.instance.getDomainsRoot() + this.instance.getProperty("domainname")).hashCode() + 1));
            } else {
                try {
                    debugPortString = this.selectDebugPort();
                }
                catch (IOException ioe) {
                    throw new ProcessCreationException(ioe, "MSG_START_SERVER_FAILED_INVALIDPORT", this.instanceName, debugPortString);
                }
            }
            DialogDescriptor note = new DialogDescriptor((Object)NbBundle.getMessage(StartTask.class, (String)"MSG_SELECTED_PORT", (Object)debugPortString), NbBundle.getMessage(StartTask.class, (String)"TITLE_MESSAGE"), false, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
            Dialog d = DialogDisplayer.getDefault().createDialog(note);
            d.setVisible(true);
        }
        this.support.setEnvironmentProperty("debugPort", debugPortString, true);
        optList.add("-Xdebug");
        StringBuilder opt = new StringBuilder();
        opt.append("-Xrunjdwp:transport=");
        opt.append(debugTransport);
        opt.append(",address=");
        opt.append(debugPortString);
        opt.append(",server=y,suspend=n");
        optList.add(opt.toString());
    }

    private void appendStartupExtenderParams(List<String> optList) {
        for (StartupExtender args : StartupExtender.getExtenders((Lookup)Lookups.singleton((Object)this.support.getInstanceProvider().getInstance(this.instance.getProperty("url"))), (StartupExtender.StartMode)StartTask.getMode(this.instance.getProperty("jvmMode")))) {
            for (String arg : args.getArguments()) {
                String[] argSplitted = arg.trim().split("\\s+(?=-)");
                optList.addAll(Arrays.asList(argSplitted));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String selectDebugPort() throws IOException {
        int debugPort = 9009;
        ServerSocket t = null;
        try {
            t = new ServerSocket(debugPort);
            String string = Integer.toString(debugPort);
            return string;
        }
        catch (IOException ex) {
            Logger.getLogger("glassfish").fine("9009 is in use... going random");
        }
        finally {
            if (null != t) {
                try {
                    t.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            t = new ServerSocket(0);
            debugPort = t.getLocalPort();
            String string = Integer.toString(debugPort);
            return string;
        }
        finally {
            if (null != t) {
                try {
                    t.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private Process createProcess() throws ProcessCreationException {
        StartupArgs args = this.createProcessDescriptor();
        ResultProcess process = ServerTasks.startServer((GlassFishServer)this.instance, (StartupArgs)args);
        if (process.getState() != TaskState.COMPLETED) {
            throw new ProcessCreationException(null, "MSG_START_SERVER_FAILED_PD", this.instanceName);
        }
        return process.getValue().getProcess();
    }

    private File getDomainFolder() {
        return new File(this.support.getDomainsRoot() + File.separatorChar + this.getDomainName());
    }

    private String getDomainName() {
        return this.instance.getProperty("domainname");
    }

    private boolean upgradeFailed() {
        File glassfishDir = new File(this.support.getGlassfishRoot());
        int installVersion = ServerDetails.getVersionFromInstallDirectory(glassfishDir);
        if (installVersion < 0) {
            return false;
        }
        File domainXmlFile = new File(this.getDomainFolder(), "config" + File.separator + "domain.xml");
        int domainVersion = ServerDetails.getVersionFromDomainXml(domainXmlFile);
        if (domainVersion < 0) {
            return false;
        }
        if (domainVersion / 10 < installVersion / 10 && domainVersion < 310) {
            return this.executeUpgradeProcess() != 0;
        }
        return false;
    }

    private int executeUpgradeProcess() {
        int retVal = -1;
        File asadmin = this.findFirstExecutableFile(new File(this.support.getGlassfishRoot()), "asadmin", "bin");
        if (null == asadmin) {
            return retVal;
        }
        NbProcessDescriptor upgrader = new NbProcessDescriptor(asadmin.getAbsolutePath(), "start-domain --upgrade --domaindir " + Util.quote(this.support.getDomainsRoot()) + " " + this.support.getDomainName());
        try {
            Process p = upgrader.exec();
            p.waitFor();
            retVal = p.exitValue();
        }
        catch (InterruptedException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, upgrader.toString(), ex);
        }
        catch (IOException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, upgrader.toString(), ex);
        }
        return retVal;
    }

    private File findFirstExecutableFile(File installRoot, String executableName, String ... directories) {
        File result = null;
        if (installRoot != null && installRoot.exists()) {
            for (String dir : directories) {
                File launcherPath;
                File updateCenterBin = new File(installRoot, dir);
                if (!updateCenterBin.exists()) continue;
                if (Utilities.isWindows()) {
                    launcherPath = new File(updateCenterBin, executableName + ".exe");
                    result = launcherPath.exists() ? launcherPath : ((launcherPath = new File(updateCenterBin, executableName + ".bat")).exists() ? launcherPath : null);
                } else {
                    launcherPath = new File(updateCenterBin, executableName);
                    File file = result = launcherPath.exists() ? launcherPath : null;
                }
                if (null != result) break;
            }
        }
        return result;
    }
}

