/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.event.ChangeListener;
import org.glassfish.tools.ide.data.GlassFishVersion;
import org.glassfish.tools.ide.utils.ServerUtils;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.ui.WarnPanel;
import org.netbeans.modules.glassfish.spi.CommandFactory;
import org.netbeans.modules.glassfish.spi.RegisteredDDCatalog;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.lookup.Lookups;

public final class GlassfishInstanceProvider
implements ServerInstanceProvider,
LookupListener {
    public static final String GLASSFISH_AUTOREGISTERED_INSTANCE = "glassfish_autoregistered_instance";
    static final String INSTANCE_FO_ATTR = "InstanceFOPath";
    private static final String AUTOINSTANCECOPIED = "autoinstance-copied";
    private static volatile GlassfishInstanceProvider ee6Provider;
    private static volatile GlassfishInstanceProvider preludeProvider;
    public static final String EE6_DEPLOYER_FRAGMENT = "deployer:gfv3ee6";
    public static final String EE6WC_DEPLOYER_FRAGMENT = "deployer:gfv3ee6wc";
    public static final String PRELUDE_DEPLOYER_FRAGMENT = "deployer:gfv3";
    private static String EE6_INSTANCES_PATH;
    private static String EE6WC_INSTANCES_PATH;
    private static String PRELUDE_INSTANCES_PATH;
    public static String PRELUDE_DEFAULT_NAME;
    public static String EE6WC_DEFAULT_NAME;
    public static final Set<String> activeRegistrationSet;
    private final Map<String, GlassfishInstance> instanceMap = Collections.synchronizedMap(new HashMap());
    private static final Set<String> activeDisplayNames;
    private final ChangeSupport support = new ChangeSupport((Object)this);
    private final String[] instancesDirNames;
    private final String displayName;
    private final String[] uriFragments;
    private final boolean needsJdk6;
    private final String[] javadocFilenames;
    private final List<String> noPasswordOptions;
    private final CommandFactory cf;
    private final Lookup.Result<RegisteredDDCatalog> lookupResult = Lookups.forPath((String)"Servers/GlassFish").lookupResult(RegisteredDDCatalog.class);

    public static List<GlassfishInstanceProvider> getProviders(boolean initialize) {
        ArrayList<GlassfishInstanceProvider> providerList = new ArrayList<GlassfishInstanceProvider>();
        if (initialize) {
            GlassfishInstanceProvider.getPrelude();
            GlassfishInstanceProvider.getEe6();
        }
        if (preludeProvider != null) {
            providerList.add(preludeProvider);
        }
        if (ee6Provider != null) {
            providerList.add(ee6Provider);
        }
        return providerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlassfishInstanceProvider getEe6() {
        if (ee6Provider != null) {
            return ee6Provider;
        }
        boolean runInit = false;
        Class<GlassfishInstanceProvider> clazz = GlassfishInstanceProvider.class;
        synchronized (GlassfishInstanceProvider.class) {
            if (ee6Provider == null) {
                runInit = true;
                ee6Provider = new GlassfishInstanceProvider(new String[]{EE6_DEPLOYER_FRAGMENT, EE6WC_DEPLOYER_FRAGMENT}, new String[]{EE6_INSTANCES_PATH, EE6WC_INSTANCES_PATH}, null, true, new String[]{"docs/javaee6-doc-api.zip"}, new String[]{"--nopassword"}, new CommandFactory(){

                    @Override
                    public ServerCommand.SetPropertyCommand getSetPropertyCommand(String name, String value) {
                        return new ServerCommand.SetPropertyCommand(name, value, "DEFAULT={0}={1}");
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (runInit) {
                ee6Provider.init();
            }
            return ee6Provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlassfishInstanceProvider getPrelude() {
        if (preludeProvider != null) {
            return preludeProvider;
        }
        boolean runInit = false;
        Class<GlassfishInstanceProvider> clazz = GlassfishInstanceProvider.class;
        synchronized (GlassfishInstanceProvider.class) {
            if (preludeProvider == null) {
                runInit = true;
                preludeProvider = new GlassfishInstanceProvider(new String[]{PRELUDE_DEPLOYER_FRAGMENT}, new String[]{PRELUDE_INSTANCES_PATH}, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_PRELUDE_SERVER_NAME", (Object[])new Object[0]), false, new String[]{"docs/javaee6-doc-api.zip"}, null, new CommandFactory(){

                    @Override
                    public ServerCommand.SetPropertyCommand getSetPropertyCommand(String name, String value) {
                        return new ServerCommand.SetPropertyCommand(name, value, "target={0}&value={1}");
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (runInit) {
                preludeProvider.init();
            }
            return preludeProvider;
        }
    }

    private GlassfishInstanceProvider(String[] uriFragments, String[] instancesDirNames, String displayName, boolean needsJdk6, String[] javadocFilenames, String[] noPasswordOptionsArray, CommandFactory cf) {
        this.instancesDirNames = instancesDirNames;
        this.displayName = displayName;
        this.uriFragments = uriFragments;
        this.needsJdk6 = needsJdk6;
        this.javadocFilenames = javadocFilenames;
        this.noPasswordOptions = new ArrayList<String>();
        if (null != noPasswordOptionsArray) {
            this.noPasswordOptions.addAll(Arrays.asList(noPasswordOptionsArray));
        }
        this.cf = cf;
        this.lookupResult.allInstances();
        this.lookupResult.addLookupListener((LookupListener)this);
    }

    public void resultChanged(LookupEvent ev) {
        Logger.getLogger("glassfish").log(Level.FINE, "***** resultChanged fired ********  {0}", this.hashCode());
        RegisteredDDCatalog catalog = GlassfishInstanceProvider.getDDCatalog();
        if (null != catalog) {
            if (this.equals(preludeProvider)) {
                catalog.registerPreludeRunTimeDDCatalog(this);
            } else {
                catalog.registerEE6RunTimeDDCatalog(this);
            }
        }
        GlassfishInstanceProvider.refreshCatalogFromFirstInstance(this, GlassfishInstanceProvider.getDDCatalog());
    }

    public static synchronized boolean initialized() {
        return preludeProvider != null || ee6Provider != null;
    }

    public static Logger getLogger() {
        return Logger.getLogger("glassfish");
    }

    private static RegisteredDDCatalog getDDCatalog() {
        return (RegisteredDDCatalog)Lookups.forPath((String)"Servers/GlassFish").lookup(RegisteredDDCatalog.class);
    }

    private static void refreshCatalogFromFirstInstance(GlassfishInstanceProvider gip, RegisteredDDCatalog catalog) {
        GlassfishInstance firstInstance = gip.getFirstServerInstance();
        if (null != firstInstance) {
            catalog.refreshRunTimeDDCatalog(gip, firstInstance.getGlassfishRoot());
        }
    }

    public String[] getAssociatedJavaDoc() {
        return (String[])this.javadocFilenames.clone();
    }

    private GlassfishInstance getFirstServerInstance() {
        if (!this.instanceMap.isEmpty()) {
            return this.instanceMap.values().iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerInstance(GlassfishInstance si) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                RegisteredDDCatalog catalog;
                this.instanceMap.put(si.getDeployerUri(), si);
                activeDisplayNames.add(si.getDisplayName());
                if (this.instanceMap.size() == 1 && null != (catalog = GlassfishInstanceProvider.getDDCatalog())) {
                    catalog.refreshRunTimeDDCatalog(this, si.getGlassfishRoot());
                }
                this.writeInstanceToFile(si, true);
            }
            catch (IOException ex) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, ex);
            }
        }
        this.support.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServerInstance(GlassfishInstance si) {
        boolean result = false;
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            if (this.instanceMap.remove(si.getDeployerUri()) != null) {
                RegisteredDDCatalog catalog;
                result = true;
                this.removeInstanceFromFile(si.getDeployerUri());
                activeDisplayNames.remove(si.getDisplayName());
                if (this.instanceMap.isEmpty() && null != (catalog = GlassfishInstanceProvider.getDDCatalog())) {
                    catalog.refreshRunTimeDDCatalog(this, null);
                }
            }
        }
        if (result) {
            this.support.fireChange();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookupFor(ServerInstance instance) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance gfInstance : this.instanceMap.values()) {
                if (!gfInstance.getCommonInstance().equals(instance)) continue;
                return gfInstance.getLookup();
            }
            return null;
        }
    }

    public ServerInstanceImplementation getInternalInstance(String uri) {
        return this.instanceMap.get(uri);
    }

    public <T> T getInstanceByCapability(String uri, Class<T> serverFacadeClass) {
        Object result = null;
        GlassfishInstance instance = this.instanceMap.get(uri);
        if (instance != null) {
            result = instance.getLookup().lookup(serverFacadeClass);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getInstancesByCapability(Class<T> serverFacadeClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance instance : this.instanceMap.values()) {
                Object serverFacade = instance.getLookup().lookup(serverFacadeClass);
                if (serverFacade == null) continue;
                result.add(serverFacade);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerInstance> getInstances() {
        ArrayList<ServerInstance> result = new ArrayList<ServerInstance>();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance instance : this.instanceMap.values()) {
                ServerInstance si = instance.getCommonInstance();
                if (null != si) {
                    result.add(si);
                    continue;
                }
                String message = "invalid commonInstance for " + instance.getDeployerUri();
                Logger.getLogger("glassfish").log(Level.WARNING, message);
                if (null == instance.getDeployerUri()) continue;
                this.instanceMap.remove(instance.getDeployerUri());
            }
        }
        return result;
    }

    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    public boolean hasServer(String uri) {
        return this.getInstance(uri) != null;
    }

    public ServerInstance getInstance(String uri) {
        ServerInstance rv = null;
        GlassfishInstance instance = this.instanceMap.get(uri);
        if (null != instance && null == (rv = instance.getCommonInstance())) {
            String message = "invalid commonInstance for " + instance.getDeployerUri();
            Logger.getLogger("glassfish").log(Level.WARNING, message);
            if (null != instance.getDeployerUri()) {
                this.instanceMap.remove(instance.getDeployerUri());
            }
        }
        return rv;
    }

    String getInstancesDirName() {
        return this.instancesDirNames[0];
    }

    Collection<GlassfishInstance> getInternalInstances() {
        return this.instanceMap.values();
    }

    boolean requiresJdk6OrHigher() {
        return this.needsJdk6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                this.loadServerInstances();
            }
            catch (RuntimeException ex) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, ex);
            }
            RegisteredDDCatalog catalog = GlassfishInstanceProvider.getDDCatalog();
            if (null != catalog) {
                if (this.equals(preludeProvider)) {
                    catalog.registerPreludeRunTimeDDCatalog(this);
                } else {
                    catalog.registerEE6RunTimeDDCatalog(this);
                }
                GlassfishInstanceProvider.refreshCatalogFromFirstInstance(this, catalog);
            }
        }
        for (GlassfishInstance gi : this.instanceMap.values()) {
            GlassfishInstance.updateModuleSupport(gi);
        }
    }

    private void loadServerInstances() {
        FileObject installedInstance = null;
        int savedj = -1;
        for (int j = 0; j < this.instancesDirNames.length; ++j) {
            FileObject[] instanceFOs;
            FileObject dir = this.getRepositoryDir(this.instancesDirNames[j], false);
            if (dir == null || (instanceFOs = dir.getChildren()) == null || instanceFOs.length <= 0) continue;
            for (int i = 0; i < instanceFOs.length; ++i) {
                try {
                    if (GLASSFISH_AUTOREGISTERED_INSTANCE.equals(instanceFOs[i].getName())) {
                        installedInstance = instanceFOs[i];
                        savedj = j;
                        continue;
                    }
                    GlassfishInstance si = this.readInstanceFromFile(instanceFOs[i], this.uriFragments[j]);
                    if (si != null) {
                        activeDisplayNames.add(si.getDisplayName());
                        continue;
                    }
                    GlassfishInstanceProvider.getLogger().log(Level.FINER, "Unable to create glassfish instance for {0}", instanceFOs[i].getPath());
                    continue;
                }
                catch (IOException ex) {
                    GlassfishInstanceProvider.getLogger().log(Level.INFO, null, ex);
                }
            }
        }
        if (null != installedInstance && null == NbPreferences.forModule(this.getClass()).get(AUTOINSTANCECOPIED, null)) {
            try {
                GlassfishInstance igi = this.readInstanceFromFile(installedInstance, this.uriFragments[savedj]);
                try {
                    NbPreferences.forModule(this.getClass()).put(AUTOINSTANCECOPIED, "true");
                    NbPreferences.forModule(this.getClass()).flush();
                }
                catch (BackingStoreException ex) {
                    Logger.getLogger("glassfish").log(Level.INFO, "auto-registered instance may reappear", ex);
                }
                activeDisplayNames.add(igi.getDisplayName());
            }
            catch (IOException ex) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, ex);
            }
        }
    }

    private void fixImportedAttributes(Map<String, String> ip, FileObject fo) {
        if (!ip.containsKey("nb73ImportFixed")) {
            String password = ip.get("password");
            if (password != null) {
                boolean local;
                boolean bl = local = ip.get("domainsfolder") != null;
                if (local && "adminadmin".equals(password)) {
                    ip.put("password", "");
                    GlassfishInstanceProvider.setStringAttribute(fo, "password", "");
                }
            }
            ip.put("nb73ImportFixed", Boolean.toString(true));
        }
    }

    private GlassfishInstance readInstanceFromFile(FileObject instanceFO, String uriFragment) throws IOException {
        GlassfishInstance instance = null;
        String installRoot = GlassfishInstanceProvider.getStringAttribute(instanceFO, "installfolder");
        String glassfishRoot = GlassfishInstanceProvider.getStringAttribute(instanceFO, "homefolder");
        if (installRoot == null) {
            installRoot = glassfishRoot;
        }
        if (GlassfishInstanceProvider.isValidHomeFolder(installRoot) && GlassfishInstanceProvider.isValidGlassfishFolder(glassfishRoot)) {
            HashMap<String, String> ip = new HashMap<String, String>();
            Enumeration iter = instanceFO.getAttributes();
            while (iter.hasMoreElements()) {
                String name = (String)iter.nextElement();
                String value = GlassfishInstanceProvider.getStringAttribute(instanceFO, name);
                ip.put(name, value);
            }
            ip.put(INSTANCE_FO_ATTR, instanceFO.getName());
            this.fixImportedAttributes(ip, instanceFO);
            instance = GlassfishInstance.create(ip, this, false);
            if (ServerUtils.getServerVersion((String)glassfishRoot) == GlassFishVersion.GF_3_1_2) {
                WarnPanel.gf312WSWarning(instance.getName());
            }
        } else {
            GlassfishInstanceProvider.getLogger().log(Level.FINER, "GlassFish folder {0} is not a valid install.", instanceFO.getPath());
            instanceFO.delete();
        }
        return instance;
    }

    private void writeInstanceToFile(GlassfishInstance instance, boolean search) throws IOException {
        String glassfishRoot = instance.getGlassfishRoot();
        if (glassfishRoot == null) {
            GlassfishInstanceProvider.getLogger().log(Level.SEVERE, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"MSG_NullServerFolder"));
            return;
        }
        String url = instance.getDeployerUri();
        FileObject dir = this.getRepositoryDir(this.instancesDirNames[0], true);
        FileObject[] instanceFOs = dir.getChildren();
        FileObject instanceFO = null;
        for (int i = 0; search && i < instanceFOs.length; ++i) {
            if (!url.equals(instanceFOs[i].getAttribute("url"))) continue;
            instanceFO = instanceFOs[i];
        }
        if (instanceFO == null) {
            String name = FileUtil.findFreeFileName((FileObject)dir, (String)"instance", null);
            instanceFO = dir.createData(name);
        }
        Map<String, String> attrMap = instance.getProperties();
        for (Map.Entry<String, String> entry : attrMap.entrySet()) {
            Object currentValue;
            String key = entry.getKey();
            if (GlassfishInstanceProvider.filterKey(key) || null != (currentValue = instanceFO.getAttribute(key)) && currentValue.equals(entry.getValue())) continue;
            if (key.equals("password")) {
                String serverName = attrMap.get("displayName");
                String userName = attrMap.get("username");
                Keyring.save((String)GlassfishInstance.passwordKey(serverName, userName), (char[])entry.getValue().toCharArray(), (String)"GlassFish administrator user password");
                continue;
            }
            instanceFO.setAttribute(key, (Object)entry.getValue());
        }
        instance.putProperty(INSTANCE_FO_ATTR, instanceFO.getName());
        instance.getCommonSupport().setFileObject(instanceFO);
    }

    private static boolean filterKey(String key) {
        return INSTANCE_FO_ATTR.equals(key);
    }

    private void removeInstanceFromFile(String url) {
        FileObject instanceFO = this.getInstanceFileObject(url);
        if (instanceFO != null && instanceFO.isValid()) {
            try {
                instanceFO.delete();
            }
            catch (IOException ex) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, ex);
            }
        }
    }

    private FileObject getInstanceFileObject(String url) {
        for (String instancesDirName : this.instancesDirNames) {
            FileObject dir = this.getRepositoryDir(instancesDirName, false);
            if (dir == null) continue;
            FileObject[] installedServers = dir.getChildren();
            for (int i = 0; i < installedServers.length; ++i) {
                String val = GlassfishInstanceProvider.getStringAttribute(installedServers[i], "url");
                if (val == null || !val.equals(url) || GLASSFISH_AUTOREGISTERED_INSTANCE.equals(installedServers[i].getName())) continue;
                return installedServers[i];
            }
        }
        return null;
    }

    private FileObject getRepositoryDir(String path, boolean create) {
        FileObject dir = FileUtil.getConfigFile((String)path);
        if (dir == null && create) {
            try {
                dir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)path);
            }
            catch (IOException ex) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, ex);
            }
        }
        return dir;
    }

    private static boolean isValidHomeFolder(String folderName) {
        boolean result = false;
        if (folderName != null) {
            File f = new File(folderName);
            result = f.exists();
            result = result && f.isDirectory();
            result = result && f.canRead();
        }
        return result;
    }

    private static boolean isValidGlassfishFolder(String folderName) {
        boolean result = false;
        if (folderName != null) {
            File f = new File(folderName);
            result = f.exists();
            result = result && f.isDirectory();
            result = result && f.canRead();
        }
        return result;
    }

    private static String getStringAttribute(FileObject fo, String attrName) {
        return GlassfishInstanceProvider.getStringAttribute(fo, attrName, null);
    }

    private static String getStringAttribute(FileObject fo, String attrName, String defValue) {
        String result = defValue;
        Object attr = fo.getAttribute(attrName);
        if (attr instanceof String) {
            result = (String)attr;
        }
        return result;
    }

    private static void setStringAttribute(FileObject fo, String key, String value) {
        try {
            fo.setAttribute(key, (Object)value);
        }
        catch (IOException ioe) {
            GlassfishInstanceProvider.getLogger().log(Level.WARNING, "Cannot update file object value: {0} -> {1} in {2}", new Object[]{key, value, fo.getPath()});
        }
    }

    String[] getNoPasswordCreatDomainCommand(String startScript, String jarLocation, String domainDir, String portBase, String uname, String domain) {
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.addAll(Arrays.asList(startScript, "-client", "-jar", jarLocation, "create-domain", "--user", uname, "--domaindir", domainDir));
        if (null != portBase) {
            retVal.add("--portbase");
            retVal.add(portBase);
        }
        if (this.noPasswordOptions.size() > 0) {
            retVal.addAll(this.noPasswordOptions);
        }
        retVal.add(domain);
        return retVal.toArray(new String[retVal.size()]);
    }

    CommandFactory getCommandFactory() {
        return this.cf;
    }

    String getDisplayName(String deployerUri) {
        if (null == this.displayName) {
            return deployerUri.contains(EE6WC_DEPLOYER_FRAGMENT) ? NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_V31_SERVER_NAME", (Object[])new Object[0]) : NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_V3_SERVER_NAME", (Object[])new Object[0]);
        }
        return this.displayName;
    }

    static {
        EE6_INSTANCES_PATH = "/GlassFishEE6/Instances";
        EE6WC_INSTANCES_PATH = "/GlassFishEE6WC/Instances";
        PRELUDE_INSTANCES_PATH = "/GlassFish/Instances";
        PRELUDE_DEFAULT_NAME = "GlassFish_v3_Prelude";
        EE6WC_DEFAULT_NAME = "GlassFish_Server_3.1";
        activeRegistrationSet = Collections.synchronizedSet(new HashSet());
        activeDisplayNames = Collections.synchronizedSet(new HashSet());
    }
}

