/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.glassfish.tools.ide.data.GlassFishAdminInterface;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.GlassFishVersion;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.CreateDomain;
import org.netbeans.modules.glassfish.common.GlassFishStatus;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.common.PortCollection;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.common.nodes.Hk2InstanceNode;
import org.netbeans.modules.glassfish.common.ui.InstanceCustomizer;
import org.netbeans.modules.glassfish.common.ui.VmCustomizer;
import org.netbeans.modules.glassfish.spi.CustomizerCookie;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModuleFactory;
import org.netbeans.modules.glassfish.spi.RemoveCookie;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.InputOutput;

public class GlassfishInstance
implements ServerInstanceImplementation,
Lookup.Provider,
LookupListener,
GlassFishServer {
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String DEFAULT_ADMIN_NAME = "admin";
    public static final String DEFAULT_ADMIN_PASSWORD = "";
    public static final String OLD_DEFAULT_ADMIN_PASSWORD = "adminadmin";
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final int DEFAULT_HTTPS_PORT = 8181;
    public static final int DEFAULT_ADMIN_PORT = 4848;
    public static final String DEFAULT_DOMAINS_FOLDER = "domains";
    public static final String DEFAULT_DOMAIN_NAME = "domain1";
    static final String KEYRING_NAME_SPACE = "GlassFish.admin";
    static final String KEYRING_NAME_SEPARATOR = ".";
    static final String KEYRING_IDENT_SEPARATOR = ":";
    private boolean removable = true;
    private transient Map<String, String> properties;
    private transient GlassFishVersion version;
    private transient InstanceContent ic;
    private transient Lookup localLookup;
    private transient Lookup full;
    private final transient Lookup.Result<GlassfishModuleFactory> lookupResult = Lookups.forPath((String)"Servers/GlassFish").lookupResult(GlassfishModuleFactory.class);
    private transient Collection<? extends GlassfishModuleFactory> currentFactories = Collections.emptyList();
    private ServerInstance commonInstance;
    private GlassfishInstanceProvider instanceProvider;

    public static String passwordKey(String serverName, String userName) {
        StringBuilder pwKey = new StringBuilder(KEYRING_NAME_SPACE.length() + KEYRING_NAME_SEPARATOR.length() + "password".length() + KEYRING_IDENT_SEPARATOR.length() + (serverName != null ? serverName.length() : 0) + KEYRING_IDENT_SEPARATOR.length() + (userName != null ? userName.length() : 0));
        pwKey.append(KEYRING_NAME_SPACE);
        pwKey.append(KEYRING_NAME_SEPARATOR);
        pwKey.append("password");
        pwKey.append(KEYRING_IDENT_SEPARATOR);
        pwKey.append(serverName != null ? serverName : DEFAULT_ADMIN_PASSWORD);
        pwKey.append(KEYRING_IDENT_SEPARATOR);
        pwKey.append(userName != null ? userName : DEFAULT_ADMIN_PASSWORD);
        return pwKey.toString();
    }

    static void updateModuleSupport(GlassfishInstance instance) {
        instance.updateFactories();
        instance.lookupResult.addLookupListener((LookupListener)instance);
    }

    private static void tagUnderConstruction(String url) {
        if (url != null) {
            GlassfishInstanceProvider.activeRegistrationSet.add(url);
        }
    }

    private static void untagUnderConstruction(String url) {
        if (url != null) {
            GlassfishInstanceProvider.activeRegistrationSet.remove(url);
        }
    }

    public static GlassfishInstance create(String displayName, String installRoot, String glassfishRoot, String domainsDir, String domainName, int httpPort, int adminPort, String userName, String password, String target, String url, GlassfishInstanceProvider gip) {
        String[] urlParts;
        HashMap<String, String> ip = new HashMap<String, String>();
        ip.put("displayName", displayName);
        ip.put("installfolder", installRoot);
        ip.put("homefolder", glassfishRoot);
        ip.put("domainsfolder", domainsDir);
        ip.put("domainname", domainName);
        ip.put("httpportnumber", Integer.toString(httpPort));
        ip.put("adminPort", Integer.toString(adminPort));
        ip.put("target", target);
        ip.put("username", userName != null ? userName : DEFAULT_ADMIN_NAME);
        ip.put("password", password != null ? password : DEFAULT_ADMIN_PASSWORD);
        ip.put("url", url);
        String[] bigUrlParts = url.split("]");
        if (null != bigUrlParts && bigUrlParts.length > 1 && null != (urlParts = bigUrlParts[1].split(KEYRING_IDENT_SEPARATOR)) && urlParts.length > 2) {
            ip.put("host", urlParts[2]);
            ip.put("httphostname", urlParts[2]);
        }
        return GlassfishInstance.create(ip, gip, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlassfishInstance create(Map<String, String> ip, GlassfishInstanceProvider gip, boolean updateNow) {
        String deployerUri = ip.get("url");
        GlassfishInstance instance = null;
        try {
            instance = new GlassfishInstance(ip, gip);
            GlassfishInstance.tagUnderConstruction(deployerUri);
            CommonServerSupport commonSupport = new CommonServerSupport(instance);
            if (!instance.isPublicAccess()) {
                instance.ic.add((Object)commonSupport);
                instance.allowPublicAccess();
            }
            if (updateNow) {
                GlassfishInstance.updateModuleSupport(instance);
            }
        }
        finally {
            GlassfishInstance.untagUnderConstruction(deployerUri);
        }
        return instance;
    }

    public static GlassfishInstance create(Map<String, String> ip, GlassfishInstanceProvider gip) {
        return GlassfishInstance.create(ip, gip, true);
    }

    private static String updateString(Map<String, String> map, String key, String value) {
        String result = map.get(key);
        if (result == null) {
            map.put(key, value);
            result = value;
        }
        return result;
    }

    private static int updateInt(Map<String, String> map, String key, int value) {
        int result;
        String storedValue = map.get(key);
        try {
            result = Integer.parseInt(storedValue);
        }
        catch (NumberFormatException ex) {
            map.put(key, Integer.toString(value));
            result = value;
        }
        return result;
    }

    private GlassfishInstance(Map<String, String> ip, GlassfishInstanceProvider instanceProvider) {
        PortCollection pc;
        File domainDir;
        String deployerUri = ip.get("url");
        this.version = null;
        this.ic = new InstanceContent();
        this.full = this.localLookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        this.instanceProvider = instanceProvider;
        String domainDirPath = ip.get("domainsfolder");
        String domainName = ip.get("domainname");
        if (null != domainDirPath && null != domainName && Util.readServerConfiguration(domainDir = new File(domainDirPath, domainName), pc = new PortCollection())) {
            ip.put("adminPort", Integer.toString(pc.getAdminPort()));
            ip.put("httpportnumber", Integer.toString(pc.getHttpPort()));
        }
        this.properties = this.prepareProperties(ip);
        if (!this.isPublicAccess()) {
            this.ic.add((Object)this);
            this.commonInstance = ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)this);
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Props properties) {
        this.properties = properties;
    }

    Lookup localLookup() {
        return this.localLookup;
    }

    public GlassfishInstanceProvider getInstanceProvider() {
        return this.instanceProvider;
    }

    public String getName() {
        return this.properties.get("displayName");
    }

    public String getHost() {
        return this.properties.get("host");
    }

    public int getPort() {
        return this.intProperty("httpportnumber");
    }

    public int getAdminPort() {
        return this.intProperty("adminPort");
    }

    public String getAdminUser() {
        return this.properties.get("username");
    }

    public String getAdminPassword() {
        return this.properties.get("password");
    }

    public String getDomainsFolder() {
        return this.properties.get("domainsfolder");
    }

    public String setDomainsFolder(String domainsFolder) {
        return this.properties.put("domainsfolder", domainsFolder);
    }

    public String getDomainName() {
        return this.properties.get("domainname");
    }

    public String getUrl() {
        return this.properties.get("url");
    }

    public String getServerHome() {
        return this.properties.get("homefolder");
    }

    public String getServerRoot() {
        return this.properties.get("installfolder");
    }

    public GlassFishVersion getVersion() {
        return this.version;
    }

    public GlassFishAdminInterface getAdminInterface() {
        return GlassFishAdminInterface.HTTP;
    }

    boolean isRemote() {
        return this.properties.get("domainsfolder") == null;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String putProperty(String key, String value) {
        return this.properties.put(key, value);
    }

    public String getHttpPort() {
        return this.properties.get("httpportnumber");
    }

    public String getHttpAdminPort() {
        return this.properties.get("adminPort");
    }

    public String getPassword() {
        String retVal = this.properties.get("password");
        String key = this.properties.get("url");
        char[] retChars = Keyring.read((String)key);
        if (null == retChars || retChars.length < 1 || !"this really long string is used to identify a password that has been stored in the Keyring".equals(retVal)) {
            retChars = retVal.toCharArray();
            if (null != key) {
                Keyring.save((String)key, (char[])retChars, (String)"a Glassfish/SJSAS passord");
                this.properties.put("password", "this really long string is used to identify a password that has been stored in the Keyring");
            }
        } else {
            retVal = String.copyValueOf(retChars);
        }
        return retVal;
    }

    public String getInstallRoot() {
        return this.properties.get("installfolder");
    }

    public String getGlassfishRoot() {
        return this.properties.get("homefolder");
    }

    public String getDisplayName() {
        return this.properties.get("displayName");
    }

    public String getDeployerUri() {
        return this.properties.get("url");
    }

    public String getUserName() {
        return this.properties.get("username");
    }

    public synchronized String getDomainsRoot() {
        String retVal = this.getDomainsFolder();
        if (null == retVal) {
            return null;
        }
        File candidate = new File(retVal);
        if (candidate.exists() && !Utils.canWrite(candidate)) {
            String foldername = FileUtil.findFreeFolderName((FileObject)FileUtil.getConfigRoot(), (String)"GF3");
            FileObject destdir = null;
            try {
                destdir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)foldername);
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, "could not create a writable domain dir", ex);
            }
            if (null != destdir) {
                candidate = new File(candidate, this.getDomainName());
                FileObject source = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)candidate));
                try {
                    Utils.doCopy(source, destdir);
                    retVal = FileUtil.toFile((FileObject)destdir).getAbsolutePath();
                    this.setDomainsFolder(retVal);
                }
                catch (IOException ex) {
                    foldername = FileUtil.findFreeFolderName((FileObject)FileUtil.getConfigRoot(), (String)"GF3");
                    try {
                        destdir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)foldername);
                    }
                    catch (IOException ioe) {
                        Logger.getLogger("glassfish").log(Level.INFO, "could not create a writable second domain dir", ioe);
                        return retVal;
                    }
                    File destdirFile = FileUtil.toFile((FileObject)destdir);
                    this.setDomainsFolder(destdirFile.getAbsolutePath());
                    retVal = destdirFile.getAbsolutePath();
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            CreateDomain cd = new CreateDomain("anonymous", GlassfishInstance.DEFAULT_ADMIN_PASSWORD, new File(GlassfishInstance.this.getServerHome()), GlassfishInstance.this.properties, GlassfishInstanceProvider.getEe6(), false, true, "INSTALL_ROOT_KEY");
                            cd.start();
                        }
                    }, 100);
                }
            }
        }
        return retVal;
    }

    @Deprecated
    public final CommonServerSupport getCommonSupport() {
        return (CommonServerSupport)this.localLookup.lookup(CommonServerSupport.class);
    }

    @Deprecated
    public final void addChangeListener(ChangeListener listener) {
        this.getCommonSupport().addChangeListener(listener);
    }

    @Deprecated
    public final void removeChangeListener(ChangeListener listener) {
        this.getCommonSupport().removeChangeListener(listener);
    }

    @Deprecated
    public final GlassfishModule.ServerState getServerState() {
        return this.getCommonSupport().getServerState();
    }

    @Deprecated
    final void stopIfStartedByIde(long timeout) {
        CommonServerSupport commonSupport = this.getCommonSupport();
        if (commonSupport.isStartedByIde()) {
            GlassfishModule.ServerState state = commonSupport.getServerState();
            if (state == GlassfishModule.ServerState.STARTING || state == GlassfishModule.ServerState.RUNNING && GlassFishStatus.isReady(this, false)) {
                try {
                    GlassfishModule.OperationState opState;
                    Future<GlassfishModule.OperationState> stopServerTask = commonSupport.stopServer(null);
                    if (timeout > 0L && (opState = stopServerTask.get(timeout, TimeUnit.MILLISECONDS)) != GlassfishModule.OperationState.COMPLETED) {
                        Logger.getLogger("glassfish").info("Stop server failed...");
                    }
                }
                catch (TimeoutException ex) {
                    Logger.getLogger("glassfish").log(Level.FINE, "Server {0} timed out sending stop-domain command.", this.getDeployerUri());
                }
                catch (Exception ex) {
                    Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        } else {
            commonSupport.disableStop();
        }
    }

    private Map<String, String> prepareProperties(Map<String, String> properties) {
        boolean isRemote = properties.get("domainsfolder") == null;
        String deployerUri = properties.get("url");
        GlassfishInstance.updateString(properties, "host", DEFAULT_HOST_NAME);
        GlassfishInstance.updateString(properties, "homefolder", DEFAULT_ADMIN_PASSWORD);
        GlassfishInstance.updateInt(properties, "httpportnumber", 8080);
        GlassfishInstance.updateString(properties, "displayName", "Bogus display name");
        GlassfishInstance.updateInt(properties, "adminPort", 4848);
        GlassfishInstance.updateString(properties, "preserveSessionsOn", "true");
        GlassfishInstance.updateString(properties, "derbyStartOn", isRemote ? "false" : "true");
        GlassfishInstance.updateString(properties, "useIDEProxyOn", "true");
        GlassfishInstance.updateString(properties, "driverDeployOn", "true");
        GlassfishInstance.updateString(properties, "httphostname", DEFAULT_HOST_NAME);
        properties.put("jvmMode", isRemote && !deployerUri.contains("deployer:gfv3ee6wc") ? "debugMode" : "normalMode");
        GlassfishInstance.updateString(properties, "username", DEFAULT_ADMIN_NAME);
        GlassfishInstance.updateString(properties, "nb73ImportFixed", Boolean.toString(true));
        Props newProperties = new Props(properties);
        return newProperties;
    }

    private boolean isPublicAccess() {
        return this.instanceProvider.getInternalInstance(this.getUrl()) != null;
    }

    private void allowPublicAccess() {
        if (!this.isPublicAccess()) {
            this.instanceProvider.addServerInstance(this);
        }
    }

    private int intProperty(String name) {
        String property = this.properties.get(name);
        if (property == null) {
            Logger.getLogger("glassfish").log(Level.WARNING, "Cannot convert null value to a number");
            return -1;
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger("glassfish").log(Level.WARNING, "Cannot convert " + property + " to a number: ", nfe);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFactories() {
        Properties asenvProps = new Properties();
        String homeFolder = this.getGlassfishRoot();
        File asenvConf = new File(homeFolder, "config/asenv.conf");
        if (asenvConf.exists()) {
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(asenvConf));
                asenvProps.load(is);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, null, ex);
                asenvProps.clear();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
            }
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, "{0} does not exist", asenvConf.getAbsolutePath());
        }
        HashSet added = new HashSet();
        Lookup.Result<GlassfishModuleFactory> result = this.lookupResult;
        synchronized (result) {
            Collection factories = this.lookupResult.allInstances();
            added.addAll(factories);
            added.removeAll(this.currentFactories);
            this.currentFactories = factories;
            ArrayList<Lookup> proxies = new ArrayList<Lookup>();
            proxies.add(this.localLookup);
            for (GlassfishModuleFactory moduleFactory : added) {
                if (!moduleFactory.isModuleSupported(homeFolder, asenvProps)) continue;
                Object t = moduleFactory.createModule(this.localLookup);
                if (null == t) {
                    Logger.getLogger("glassfish").log(Level.WARNING, "{0} created a null module", moduleFactory);
                    continue;
                }
                this.ic.add(t);
                if (!(t instanceof Lookup.Provider)) continue;
                proxies.add(Lookups.proxy((Lookup.Provider)((Lookup.Provider)t)));
            }
            if (!proxies.isEmpty()) {
                this.full = new ProxyLookup(proxies.toArray(new Lookup[proxies.size()]));
            }
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.updateFactories();
    }

    public ServerInstance getCommonInstance() {
        return this.commonInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        Lookup.Result<GlassfishModuleFactory> result = this.lookupResult;
        synchronized (result) {
            return this.full;
        }
    }

    public String getServerDisplayName() {
        return this.instanceProvider.getDisplayName(this.getDeployerUri());
    }

    public Node getFullNode() {
        Logger.getLogger("glassfish").finer("Creating GF Instance node [FULL]");
        return new Hk2InstanceNode(this, true);
    }

    public Node getBasicNode() {
        Logger.getLogger("glassfish").finer("Creating GF Instance node [BASIC]");
        return new Hk2InstanceNode(this, false);
    }

    public JComponent getCustomizer() {
        CommonServerSupport commonSupport = this.getCommonSupport();
        InstanceCustomizer commonCustomizer = new InstanceCustomizer(commonSupport);
        VmCustomizer vmCustomizer = new VmCustomizer(commonSupport);
        LinkedList<JPanel> pages = new LinkedList<JPanel>();
        Collection lookupAll = this.localLookup.lookupAll(CustomizerCookie.class);
        for (CustomizerCookie cookie : lookupAll) {
            pages.addAll(cookie.getCustomizerPages());
        }
        pages.add(vmCustomizer);
        JComponent tabbedPane = null;
        for (JPanel page : pages) {
            if (tabbedPane == null) {
                tabbedPane = new JTabbedPane();
                ((JTabbedPane)tabbedPane).add(commonCustomizer);
            }
            ((JTabbedPane)tabbedPane).add(page);
        }
        return tabbedPane != null ? tabbedPane : commonCustomizer;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void remove() {
        if (!this.removable) {
            return;
        }
        this.stopIfStartedByIde(3000L);
        String uri = this.getDeployerUri();
        InputOutput io = LogViewMgr.getServerIO(uri);
        if (io != null && !io.isClosed()) {
            io.closeInputOutput();
        }
        Collection lookupAll = this.localLookup.lookupAll(RemoveCookie.class);
        for (RemoveCookie cookie : lookupAll) {
            cookie.removeInstance(this.getDeployerUri());
        }
        this.instanceProvider.removeServerInstance(this);
        this.ic.remove((Object)this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GlassfishInstance)) {
            return false;
        }
        GlassfishInstance other = (GlassfishInstance)obj;
        if (null == this.getDeployerUri()) {
            return false;
        }
        if (null == other.getDeployerUri()) {
            return false;
        }
        if (null == this.getDomainName()) {
            return false;
        }
        if (null == this.getDomainName()) {
            return false;
        }
        return this.getDeployerUri().replace("127.0.0.1", DEFAULT_HOST_NAME).equals(other.getDeployerUri().replace("127.0.0.1", DEFAULT_HOST_NAME)) && this.getDomainName().equals(other.getDomainName()) && this.getDomainsRoot().equals(other.getDomainsRoot()) && this.getHttpPort().equals(other.getHttpPort());
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder(this.getDeployerUri().replace("127.0.0.1", DEFAULT_HOST_NAME));
        sb.append(this.getHttpPort());
        sb.append(this.getDomainsRoot());
        sb.append(this.getDomainName());
        return sb.toString().hashCode();
    }

    public class Props
    implements Map<String, String> {
        private final Map<String, String> delegate;

        public Props(Map<String, String> map) {
            if (map == null) {
                throw new NullPointerException("Source Map shall not be null.");
            }
            this.delegate = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<String> values() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return Collections.unmodifiableCollection(this.delegate.values());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> keySet() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return Collections.unmodifiableSet(this.delegate.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return Collections.unmodifiableSet(this.delegate.entrySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String remove(Object key) {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                this.delegate.putAll(m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String put(String key, String value) {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return ((Object)this.delegate).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map) {
                Map<String, String> map = this.delegate;
                synchronized (map) {
                    return ((Object)this.delegate).equals(o);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Map<String, String> map = this.delegate;
            synchronized (map) {
                this.delegate.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get(Object key) {
            if ("password".equals(key)) {
                String value;
                Map<String, String> map = this.delegate;
                synchronized (map) {
                    value = this.delegate.get(key);
                }
                if (value == null) {
                    char[] passwordChars = Keyring.read((String)GlassfishInstance.passwordKey(this.delegate.get("displayName"), this.delegate.get("username")));
                    value = passwordChars != null ? new String(passwordChars) : GlassfishInstance.DEFAULT_ADMIN_PASSWORD;
                    Map<String, String> map2 = this.delegate;
                    synchronized (map2) {
                        this.delegate.put((String)key, value);
                    }
                }
                return value;
            }
            Map<String, String> map = this.delegate;
            synchronized (map) {
                return this.delegate.get(key);
            }
        }
    }
}

