/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tools.ide.admin.ResultMap;
import org.glassfish.tools.ide.admin.ResultString;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.GlassFishVersion;
import org.glassfish.tools.ide.server.ServerStatus;
import org.glassfish.tools.ide.utils.ServerUtils;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.ui.WarnPanel;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class GlassFishStatus {
    private static final int STARTUP_TIMEOUT = 600000;
    private static final int RETRY_DELAY = 2000;
    private static final String LOG_RETRY = "Keep trying while server {0} is not yet ready. Retry {1} and time remaining: {2} ms";
    private static final String LOG_THREAD_INTERRUPTED = "Thread sleep interrupted while checking {0}: {1}";
    private static final String LOG_LOCATIONS_RESPONSE = "Server {0} locations response returned {1} records";
    private static final String LOG_LOCATIONS_RESPONSE_ITEM = "Server {0} locations response {1} = {2}";
    private static final String LOG_VERSION_TASK_FAIL = "Version task failed: {0}";
    private static final String LOG_VERSION_RESPONSE = "Server {0} version response: {1}";
    private static final String LOG_SERVER_STARTUP = "Server {0} is still starting up";
    private static final String LOG_LOCAL_LOCATIONS_CHECK = "Checked local instance {0} domain root {1} {2} value {3} from locations command";
    private static final String LOG_REMOTE_LOCATIONS_CHECK = "Checked remote instance {0} domain root value {1} from locations command, which is {2}";

    private static void logLocationsResponse(GlassfishInstance instance, ResultMap<String, String> result) {
        Map values = result != null ? result.getValue() : null;
        Logger.getLogger("glassfish").log(Level.FINEST, LOG_LOCATIONS_RESPONSE, new Object[]{instance.getName(), values != null ? values.size() : 0});
        if (values != null) {
            for (String key : values.keySet()) {
                String value = (String)values.get(key);
                Logger.getLogger("glassfish").log(Level.FINEST, LOG_LOCATIONS_RESPONSE_ITEM, new Object[]{instance.getName(), key, value});
            }
        }
    }

    private static boolean processReadyLocationsResult(GlassfishInstance instance, ResultMap<String, String> result) {
        boolean isReady;
        String domainRoot = instance.getDomainsRoot() + File.separator + instance.getDomainName();
        String targetDomainRoot = (String)result.getValue().get("Domain-Root_value");
        if (instance.getDomainsRoot() != null && targetDomainRoot != null) {
            File installDir = FileUtil.normalizeFile((File)new File(domainRoot));
            File targetInstallDir = FileUtil.normalizeFile((File)new File(targetDomainRoot));
            isReady = installDir.equals(targetInstallDir);
            Logger.getLogger("glassfish").log(Level.FINEST, LOG_LOCAL_LOCATIONS_CHECK, new Object[]{instance.getName(), domainRoot, isReady ? "matches" : "not matches", targetDomainRoot});
        } else {
            isReady = null != targetDomainRoot;
            Logger.getLogger("glassfish").log(Level.FINEST, LOG_REMOTE_LOCATIONS_CHECK, new Object[]{instance.getName(), targetDomainRoot, isReady ? "correct" : "not correct"});
        }
        if (isReady) {
            instance.getCommonSupport().updateHttpPort();
        }
        return isReady;
    }

    private static ResultString processVersionTaskResult(GlassfishInstance instance, ServerStatus.ResultVersion versionTaskResult, Mode mode) {
        ResultString versionCommandResult;
        switch (versionTaskResult.getStatus()) {
            case SUCCESS: {
                versionCommandResult = versionTaskResult.getResult();
                break;
            }
            case TIMEOUT: {
                if (mode == Mode.REFRESH && instance.isRemote()) {
                    String message = NbBundle.getMessage(CommonServerSupport.class, (String)"MSG_COMMAND_SSL_ERROR", (Object)"version", (Object)instance.getName(), (Object)Integer.toString(instance.getAdminPort()));
                    CommonServerSupport.displayPopUpMessage(instance.getCommonSupport(), message);
                }
            }
            default: {
                Logger.getLogger("glassfish").log(Level.INFO, LOG_VERSION_TASK_FAIL, versionTaskResult.getStatus());
                versionCommandResult = null;
            }
        }
        return versionCommandResult;
    }

    private static void handleGlassFishWarnings(GlassfishInstance instance, ServerStatus status, Mode mode) {
        GlassFishVersion version = status.getVersion();
        if (mode == Mode.STARTUP && version == GlassFishVersion.GF_3_1_2 && !instance.isRemote()) {
            WarnPanel.gf312WSWarning(instance.getName());
        }
    }

    private static void retrySleep(GlassfishInstance instance, long begTm, long actTm, int tries) {
        Logger.getLogger("glassfish").log(Level.FINEST, LOG_RETRY, new Object[]{instance.getName(), Integer.toString(tries), Long.toString(600000L - actTm + begTm)});
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            Logger.getLogger("glassfish").log(Level.INFO, LOG_THREAD_INTERRUPTED, new Object[]{instance.getName(), ie.getLocalizedMessage()});
        }
    }

    public static boolean isReady(GlassfishInstance instance, boolean retry) {
        return GlassFishStatus.isReady(instance, retry, Mode.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady(GlassfishInstance instance, boolean retry, Mode mode) {
        long begTm;
        boolean isReady = false;
        int maxTries = retry ? 3 : 1;
        int tries = 0;
        boolean notYetReady = false;
        long actTm = begTm = System.currentTimeMillis();
        ServerStatus status = new ServerStatus((GlassFishServer)instance, mode == Mode.STARTUP);
        try {
            block7: while (!isReady && (tries++ < maxTries || notYetReady && (actTm = System.currentTimeMillis()) - begTm < 600000L)) {
                ServerStatus.ResultLocations locationsTaskResult;
                if (tries > 1) {
                    GlassFishStatus.retrySleep(instance, begTm, actTm, tries);
                }
                status.check();
                ServerStatus.Result adminPortResult = status.getAdminPortResult();
                if (adminPortResult.getStatus() != ServerStatus.Status.SUCCESS) continue;
                ResultString versionCommandResult = GlassFishStatus.processVersionTaskResult(instance, status.getVersionResult(), mode);
                if (versionCommandResult != null) {
                    String value = versionCommandResult.getValue();
                    Logger.getLogger("glassfish").log(Level.FINEST, LOG_VERSION_RESPONSE, new Object[]{instance.getName(), value});
                    switch (versionCommandResult.getState()) {
                        case FAILED: {
                            notYetReady = ServerUtils.notYetReadyMsg((String)value);
                            if (!notYetReady) break;
                            Logger.getLogger("glassfish").log(Level.FINEST, LOG_SERVER_STARTUP, instance.getName());
                            continue block7;
                        }
                        case COMPLETED: {
                            isReady = true;
                            GlassFishStatus.handleGlassFishWarnings(instance, status, mode);
                        }
                    }
                }
                if ((locationsTaskResult = status.getLocationsResult()).getStatus() != ServerStatus.Status.SUCCESS) continue;
                ResultMap locationsCommandResult = locationsTaskResult.getResult();
                GlassFishStatus.logLocationsResponse(instance, (ResultMap<String, String>)locationsCommandResult);
                if (locationsCommandResult.getState() != TaskState.COMPLETED) continue;
                isReady = GlassFishStatus.processReadyLocationsResult(instance, (ResultMap<String, String>)locationsCommandResult);
            }
        }
        finally {
            status.close();
        }
        return isReady;
    }

    public static enum Mode {
        DEFAULT,
        STARTUP,
        REFRESH;


        public String toString() {
            switch (this) {
                case DEFAULT: {
                    return "DEFAULT";
                }
                case STARTUP: {
                    return "STARTUP";
                }
                case REFRESH: {
                    return "REFRESH";
                }
            }
            throw new IllegalStateException("Unknown Mode value");
        }
    }
}

