/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.glassfish.tools.ide.admin.TaskEvent;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.admin.TaskStateListener;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.GlassFishStatus;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.NoopTask;
import org.netbeans.modules.glassfish.common.RestartTask;
import org.netbeans.modules.glassfish.common.StartTask;
import org.netbeans.modules.glassfish.common.StopProfilingTask;
import org.netbeans.modules.glassfish.common.StopTask;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.CommandFactory;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModule3;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RecognizerCookie;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.modules.glassfish.spi.VMIntrospector;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class CommonServerSupport
implements GlassfishModule3,
RefreshModulesCookie {
    private static final int STARTUP_TIMEOUT = 600000;
    private static final int STARTUP_RETRY_DELAY = 2000;
    private final GlassfishInstance instance;
    private volatile GlassfishModule.ServerState serverState = GlassfishModule.ServerState.UNKNOWN;
    private final Object stateMonitor = new Object();
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject instanceFO;
    private volatile boolean startedByIde = false;
    private transient boolean isRemote = false;
    private boolean stopDisabled = false;
    private Process localStartProcess;
    private static final RequestProcessor RP = new RequestProcessor("CommonServerSupport - start/stop/refresh", 5);
    private final AtomicBoolean refreshRunning = new AtomicBoolean(false);
    private long latestWarningDisplayTime = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void displayPopUpMessage(CommonServerSupport css, String message) {
        CommonServerSupport commonServerSupport = css;
        synchronized (commonServerSupport) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            css.setLatestWarningDisplayTime(System.currentTimeMillis());
            Logger.getLogger("glassfish").log(Level.INFO, message);
        }
    }

    CommonServerSupport(GlassfishInstance instance) {
        this.instance = instance;
        this.isRemote = instance.isRemote();
        this.instanceFO = this.getInstanceFileObject();
    }

    public GlassfishInstance getInstance() {
        return this.instance;
    }

    private FileObject getInstanceFileObject() {
        String instanceFN;
        FileObject dir = FileUtil.getConfigFile((String)this.instance.getInstanceProvider().getInstancesDirName());
        if (dir != null && (instanceFN = this.instance.getProperty("InstanceFOPath")) != null) {
            return dir.getFileObject(instanceFN);
        }
        return null;
    }

    @Override
    public String getPassword() {
        return this.instance.getPassword();
    }

    @Deprecated
    public String getInstallRoot() {
        return this.instance.getInstallRoot();
    }

    @Deprecated
    public String getGlassfishRoot() {
        return this.instance.getGlassfishRoot();
    }

    @Deprecated
    public String getDisplayName() {
        return this.instance.getDisplayName();
    }

    @Deprecated
    public String getDeployerUri() {
        return this.instance.getDeployerUri();
    }

    @Deprecated
    public String getUserName() {
        return this.instance.getUserName();
    }

    @Deprecated
    public String getAdminPort() {
        return this.instance.getHttpAdminPort();
    }

    @Deprecated
    public String getHttpPort() {
        return this.instance.getHttpPort();
    }

    @Deprecated
    public int getHttpPortNumber() {
        return this.instance.getPort();
    }

    @Deprecated
    public int getAdminPortNumber() {
        return this.instance.getAdminPort();
    }

    @Deprecated
    public String getHostName() {
        return this.instance.getProperty("host");
    }

    @Deprecated
    public String getDomainsRoot() {
        return this.instance.getDomainsRoot();
    }

    @Deprecated
    public String getDomainName() {
        return this.instance.getDomainName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerState(GlassfishModule.ServerState newState) {
        boolean fireChange = false;
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.serverState != newState) {
                this.serverState = newState;
                fireChange = true;
            }
        }
        if (fireChange) {
            this.changeSupport.fireChange();
        }
    }

    boolean isStartedByIde() {
        return this.startedByIde;
    }

    @Override
    public Map<String, String> getInstanceProperties() {
        this.getDomainsRoot();
        return Collections.unmodifiableMap(this.instance.getProperties());
    }

    @Override
    public GlassfishInstanceProvider getInstanceProvider() {
        return this.instance.getInstanceProvider();
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    @Override
    public Future<GlassfishModule.OperationState> startServer(OperationStateListener stateListener, GlassfishModule.ServerState endState) {
        String[] stringArray;
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.startServer called on thread \"{0}\"", Thread.currentThread().getName());
        StartOperationStateListener startServerListener = new StartOperationStateListener(endState);
        VMIntrospector vmi = (VMIntrospector)Lookups.forPath((String)"Servers/GlassFish").lookup(VMIntrospector.class);
        List<Recognizer> list = this.getRecognizers();
        FileObject fileObject = null;
        if (endState == GlassfishModule.ServerState.STOPPED_JVM_PROFILER) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = null;
        }
        FutureTask<GlassfishModule.OperationState> task = new FutureTask<GlassfishModule.OperationState>(new StartTask(this, list, vmi, fileObject, stringArray, startServerListener, stateListener));
        RP.post(task);
        return task;
    }

    private List<Recognizer> getRecognizers() {
        List<Recognizer> recognizers;
        Collection cookies = this.instance.localLookup().lookupAll(RecognizerCookie.class);
        if (!cookies.isEmpty()) {
            recognizers = new LinkedList();
            for (RecognizerCookie cookie : cookies) {
                recognizers.addAll(cookie.getRecognizers());
            }
            recognizers = Collections.unmodifiableList(recognizers);
        } else {
            recognizers = Collections.emptyList();
        }
        return recognizers;
    }

    @Override
    public Future<GlassfishModule.OperationState> stopServer(OperationStateListener stateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.stopServer called on thread \"{0}\"", Thread.currentThread().getName());
        OperationStateListener stopServerListener = new OperationStateListener(){

            @Override
            public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                if (newState == GlassfishModule.OperationState.RUNNING) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPING);
                } else if (newState == GlassfishModule.OperationState.COMPLETED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                } else if (newState == GlassfishModule.OperationState.FAILED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                }
            }
        };
        FutureTask<GlassfishModule.OperationState> task = !this.isRemote() || !Util.isDefaultOrServerTarget(this.instance.getProperties()) ? (this.getServerState() == GlassfishModule.ServerState.STOPPED_JVM_PROFILER ? new FutureTask<GlassfishModule.OperationState>(new StopProfilingTask(this, stateListener)) : new FutureTask<GlassfishModule.OperationState>(new StopTask(this, stopServerListener, stateListener))) : new FutureTask<GlassfishModule.OperationState>(new NoopTask(this, stopServerListener, stateListener));
        if (this.stopDisabled) {
            stopServerListener.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "");
            if (null != stateListener) {
                stateListener.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "");
            }
            return task;
        }
        RP.post(task);
        return task;
    }

    @Override
    public Future<GlassfishModule.OperationState> restartServer(OperationStateListener stateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.restartServer called on thread \"{0}\"", Thread.currentThread().getName());
        FutureTask<GlassfishModule.OperationState> task = new FutureTask<GlassfishModule.OperationState>(new RestartTask(this, stateListener));
        RP.post(task);
        return task;
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name) {
        return this.deploy(stateListener, application, name, null);
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name, String contextRoot) {
        return this.deploy(stateListener, application, name, contextRoot, null);
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name, String contextRoot, Map<String, String> properties) {
        return this.deploy(stateListener, application, name, contextRoot, null, new File[0]);
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name, String contextRoot, Map<String, String> properties, File[] libraries) {
        CommandRunner mgr = new CommandRunner(GlassFishStatus.isReady(this.instance, false), this.getCommandFactory(), this.instance, stateListener);
        return mgr.deploy(application, name, contextRoot, properties, libraries);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener stateListener, String name, boolean resourcesChanged) {
        return this.redeploy(stateListener, name, null, resourcesChanged);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener stateListener, String name, String contextRoot, boolean resourcesChanged) {
        return this.redeploy(stateListener, name, contextRoot, new File[0], resourcesChanged);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener stateListener, String name, String contextRoot, File[] libraries, boolean resourcesChanged) {
        CommandRunner mgr = new CommandRunner(GlassFishStatus.isReady(this.instance, false), this.getCommandFactory(), this.instance, stateListener);
        return mgr.redeploy(name, contextRoot, libraries, resourcesChanged);
    }

    @Override
    public Future<GlassfishModule.OperationState> undeploy(OperationStateListener stateListener, String name) {
        CommandRunner mgr = new CommandRunner(GlassFishStatus.isReady(this.instance, false), this.getCommandFactory(), this.instance, stateListener);
        return mgr.undeploy(name);
    }

    @Override
    public Future<GlassfishModule.OperationState> enable(OperationStateListener stateListener, String name) {
        CommandRunner mgr = new CommandRunner(GlassFishStatus.isReady(this.instance, false), this.getCommandFactory(), this.instance, stateListener);
        return mgr.enable(name);
    }

    @Override
    public Future<GlassfishModule.OperationState> disable(OperationStateListener stateListener, String name) {
        CommandRunner mgr = new CommandRunner(GlassFishStatus.isReady(this.instance, false), this.getCommandFactory(), this.instance, stateListener);
        return mgr.disable(name);
    }

    @Override
    public Future<GlassfishModule.OperationState> execute(ServerCommand command) {
        CommandRunner mgr = new CommandRunner(GlassFishStatus.isReady(this.instance, false), this.getCommandFactory(), this.instance, new OperationStateListener[0]);
        return mgr.execute(command);
    }

    private Future<GlassfishModule.OperationState> execute(boolean irr, ServerCommand command) {
        CommandRunner mgr = new CommandRunner(irr, this.getCommandFactory(), this.instance, new OperationStateListener[0]);
        return mgr.execute(command);
    }

    private Future<GlassfishModule.OperationState> execute(boolean irr, ServerCommand command, OperationStateListener ... osl) {
        CommandRunner mgr = new CommandRunner(irr, this.getCommandFactory(), this.instance, osl);
        return mgr.execute(command);
    }

    @Override
    public AppDesc[] getModuleList(String container) {
        CommandRunner mgr = new CommandRunner(GlassFishStatus.isReady(this.instance, false), this.getCommandFactory(), this.instance, new OperationStateListener[0]);
        int total = 0;
        Map<String, List<AppDesc>> appMap = mgr.getApplications(container);
        Collection<List<AppDesc>> appLists = appMap.values();
        for (List<AppDesc> appList : appLists) {
            total += appList.size();
        }
        AppDesc[] result = new AppDesc[total];
        int index = 0;
        for (List<AppDesc> appList : appLists) {
            for (AppDesc app : appList) {
                result[index++] = app;
            }
        }
        return result;
    }

    @Override
    public Map<String, ResourceDesc> getResourcesMap(String type) {
        CommandRunner mgr = new CommandRunner(GlassFishStatus.isReady(this.instance, false), this.getCommandFactory(), this.instance, new OperationStateListener[0]);
        HashMap<String, ResourceDesc> resourcesMap = new HashMap<String, ResourceDesc>();
        List<ResourceDesc> resourcesList = mgr.getResources(type);
        for (ResourceDesc resource : resourcesList) {
            resourcesMap.put(resource.getName(), resource);
        }
        return resourcesMap;
    }

    @Override
    public GlassfishModule.ServerState getServerState() {
        if (this.serverState == GlassfishModule.ServerState.UNKNOWN) {
            this.refresh();
        }
        return this.serverState;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setEnvironmentProperty(String name, String value, boolean overwrite) {
        String result;
        Map<String, String> map = this.instance.getProperties();
        synchronized (map) {
            result = this.instance.getProperty(name);
            if (result == null || overwrite) {
                this.instance.putProperty(name, value);
                this.setInstanceAttr(name, value);
                result = value;
            }
        }
        return result;
    }

    void setProperty(String key, String value) {
        this.instance.putProperty(key, value);
    }

    void getProperty(String key) {
        this.instance.getProperty(key);
    }

    boolean setInstanceAttr(String name, String value) {
        boolean retVal = false;
        if (this.instanceFO == null || !this.instanceFO.isValid()) {
            this.instanceFO = this.getInstanceFileObject();
        }
        if (this.instanceFO != null && this.instanceFO.canWrite()) {
            try {
                Object currentValue = this.instanceFO.getAttribute(name);
                if (null == currentValue || !currentValue.equals(value)) {
                    this.instanceFO.setAttribute(name, (Object)value);
                }
                retVal = true;
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute " + name + " in " + this.instanceFO.getPath() + " for " + this.getDeployerUri(), ex);
            }
        } else if (null == this.instanceFO) {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute {0} for {1} in {3}. Instance file is writable? {2}", new Object[]{name, this.getDeployerUri(), false, "null"});
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute {0} for {1} in {3}. Instance file is writable? {2}", new Object[]{name, this.getDeployerUri(), this.instanceFO.canWrite(), this.instanceFO.getPath()});
        }
        return retVal;
    }

    void setFileObject(FileObject fo) {
        this.instanceFO = fo;
    }

    public static boolean isRunning(String host, int port, String name, int timeout) {
        if (null == host) {
            return false;
        }
        try {
            InetSocketAddress isa = new InetSocketAddress(host, port);
            Socket socket = new Socket();
            Logger.getLogger("glassfish-socket-connect-diagnostic").log(Level.FINE, "Using socket.connect", new Exception());
            socket.connect(isa, timeout);
            socket.setSoTimeout(timeout);
            try {
                socket.close();
            }
            catch (IOException ioe) {
                Logger.getLogger("glassfish").log(Level.INFO, "Socket closing failed: {0}", ioe.getMessage());
            }
            return true;
        }
        catch (ConnectException ex) {
            return false;
        }
        catch (SocketTimeoutException ste) {
            return false;
        }
        catch (IOException ioe) {
            String message = NbBundle.getMessage(CommonServerSupport.class, (String)(name == null || "".equals(name.trim()) ? "MSG_FLAKEY_NETWORK" : "MSG_FLAKEY_NETWORK2"), (Object)host, (Object)Integer.toString(port), (Object)ioe.getLocalizedMessage());
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            Logger.getLogger("glassfish").log(Level.INFO, "Evidence of network flakiness: {0}", ioe.getMessage());
            return false;
        }
    }

    public static boolean isRunning(String host, int port, String name) {
        return CommonServerSupport.isRunning(host, port, name, 2000);
    }

    @Override
    public final void refresh() {
        this.refresh(null, null);
    }

    @Override
    public void refresh(String expected, String unexpected) {
        if (this.refreshRunning.compareAndSet(false, true)) {
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        GlassfishModule.ServerState currentState;
                        boolean isRunning = GlassFishStatus.isReady(CommonServerSupport.this.instance, false, GlassFishStatus.Mode.REFRESH);
                        if (isRunning && !Util.isDefaultOrServerTarget(CommonServerSupport.this.instance.getProperties())) {
                            isRunning = CommonServerSupport.this.pingHttp(1);
                        }
                        if (((currentState = CommonServerSupport.this.getServerState()) == GlassfishModule.ServerState.STOPPED || currentState == GlassfishModule.ServerState.UNKNOWN) && isRunning) {
                            CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                        } else if (!(currentState != GlassfishModule.ServerState.RUNNING && currentState != GlassfishModule.ServerState.UNKNOWN || isRunning)) {
                            CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                        } else if (currentState == GlassfishModule.ServerState.STOPPED_JVM_PROFILER && isRunning) {
                            CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger("glassfish").log(Level.WARNING, ex.getMessage());
                    }
                    finally {
                        CommonServerSupport.this.refreshRunning.set(false);
                    }
                }
            });
        }
    }

    void disableStop() {
        this.stopDisabled = true;
    }

    void setLocalStartProcess(Process process) {
        this.localStartProcess = process;
    }

    Process getLocalStartProcess() {
        return this.localStartProcess;
    }

    void stopLocalStartProcess() {
        this.localStartProcess.destroy();
        this.localStartProcess = null;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.instance.getInstanceProvider().getCommandFactory();
    }

    @Override
    public String getResourcesXmlName() {
        return Utils.useGlassfishPrefix(this.getDeployerUri()) ? "glassfish-resources" : "sun-resources";
    }

    @Override
    public boolean supportsRestartInDebug() {
        return this.getDeployerUri().contains("deployer:gfv3ee6wc");
    }

    @Override
    public boolean isRestfulLogAccessSupported() {
        return this.getDeployerUri().contains("deployer:gfv3ee6wc");
    }

    @Override
    public boolean isWritable() {
        return null == this.instanceFO ? false : this.instanceFO.canWrite();
    }

    private long getLatestWarningDisplayTime() {
        return this.latestWarningDisplayTime;
    }

    private void setLatestWarningDisplayTime(long currentTime) {
        this.latestWarningDisplayTime = currentTime;
    }

    void updateHttpPort() {
        ServerCommand.GetPropertyCommand gpc;
        String target = Util.computeTarget(this.instance.getProperties());
        if (Util.isDefaultOrServerTarget(this.instance.getProperties())) {
            gpc = new ServerCommand.GetPropertyCommand("*.server-config.*.http-listener-1.port");
            this.setEnvironmentProperty("httphostname", this.instance.getProperty("host"), true);
        } else {
            String server = this.getServerFromTarget(target);
            String adminHost = this.instance.getProperty("host");
            this.setEnvironmentProperty("httphostname", this.getHttpHostFromServer(server, adminHost), true);
            gpc = new ServerCommand.GetPropertyCommand("servers.server." + server + ".system-property.HTTP_LISTENER_PORT.value", true);
        }
        Future<GlassfishModule.OperationState> result2 = this.execute(true, gpc);
        try {
            boolean didSet = false;
            if (result2.get(10L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                Map<String, String> retVal = gpc.getData();
                for (Map.Entry<String, String> entry : retVal.entrySet()) {
                    String val = entry.getValue();
                    try {
                        if (null == val || val.trim().length() <= 0) continue;
                        Integer.parseInt(val);
                        this.setEnvironmentProperty("httpportnumber", val, true);
                        didSet = true;
                    }
                    catch (NumberFormatException nfe) {}
                }
            }
            if (!didSet && !Util.isDefaultOrServerTarget(this.instance.getProperties())) {
                this.setEnvironmentProperty("httpportnumber", "28080", true);
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
        }
        catch (TimeoutException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, "could not get http port value in 10 seconds from the server", ex);
        }
    }

    private String getServerFromTarget(String target) {
        String retVal;
        block5: {
            retVal = target;
            ServerCommand.GetPropertyCommand gpc = new ServerCommand.GetPropertyCommand("clusters.cluster." + target + ".server-ref.*.ref", true);
            Future<GlassfishModule.OperationState> result2 = this.execute(true, gpc);
            try {
                if (result2.get(10L, TimeUnit.SECONDS) != GlassfishModule.OperationState.COMPLETED) break block5;
                Map<String, String> data = gpc.getData();
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    String val = entry.getValue();
                    if (null == val || val.trim().length() <= 0) continue;
                    retVal = val;
                    break;
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            }
            catch (TimeoutException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, "could not get http port value in 10 seconds from the server", ex);
            }
        }
        return retVal;
    }

    private String getHttpHostFromServer(String server, String nameOfLocalhost) {
        String retVal;
        block7: {
            retVal = "localhostFAIL";
            ServerCommand.GetPropertyCommand gpc = new ServerCommand.GetPropertyCommand("servers.server." + server + ".node-ref");
            String refVal = null;
            Future<GlassfishModule.OperationState> result2 = this.execute(true, gpc);
            try {
                String val;
                Map<String, String> data;
                if (result2.get(10L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                    data = gpc.getData();
                    for (Map.Entry<String, String> entry : data.entrySet()) {
                        val = entry.getValue();
                        if (null == val || val.trim().length() <= 0) continue;
                        refVal = val;
                        break;
                    }
                }
                if ((result2 = this.execute(true, gpc = new ServerCommand.GetPropertyCommand("nodes.node." + refVal + ".node-host"))).get(10L, TimeUnit.SECONDS) != GlassfishModule.OperationState.COMPLETED) break block7;
                data = gpc.getData();
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    val = entry.getValue();
                    if (null == val || val.trim().length() <= 0) continue;
                    retVal = val;
                    break;
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            }
            catch (TimeoutException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, "could not get http port value in 10 seconds from the server", ex);
            }
        }
        return "localhost".equals(retVal) ? nameOfLocalhost : retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pingHttp(int maxTries) {
        boolean retVal = false;
        URL url = null;
        int tries = 0;
        while (!retVal && tries < maxTries) {
            ++tries;
            HttpURLConnection httpConn = null;
            try {
                url = new URL("http://" + this.getInstanceProperties().get("httphostname") + ":" + this.getInstanceProperties().get("httpportnumber") + "/");
                httpConn = (HttpURLConnection)url.openConnection();
                retVal = httpConn.getResponseCode() > 0;
            }
            catch (MalformedURLException mue) {
                Logger.getLogger("glassfish").log(Level.INFO, null, mue);
            }
            catch (ConnectException ce) {
                Logger.getLogger("glassfish").log(Level.FINE, url.toString(), ce);
            }
            catch (IOException ioe) {
                Logger.getLogger("glassfish").log(Level.INFO, url.toString(), ioe);
            }
            finally {
                if (null != httpConn) {
                    httpConn.disconnect();
                }
            }
            try {
                if (tries >= maxTries) continue;
                Thread.sleep(300L);
            }
            catch (InterruptedException ex) {}
        }
        Logger.getLogger("glassfish").log(Level.FINE, "pingHttp returns {0}", retVal);
        return retVal;
    }

    class StartOperationStateListener
    implements OperationStateListener {
        private GlassfishModule.ServerState endState;

        StartOperationStateListener(GlassfishModule.ServerState endState) {
            this.endState = endState;
        }

        @Override
        public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
            if (newState == GlassfishModule.OperationState.RUNNING) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STARTING);
            } else if (newState == GlassfishModule.OperationState.COMPLETED) {
                CommonServerSupport.this.startedByIde = CommonServerSupport.this.isRemote ? false : GlassFishStatus.isReady(CommonServerSupport.this.instance, false);
                CommonServerSupport.this.setServerState(this.endState);
            } else if (newState == GlassfishModule.OperationState.FAILED) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            }
        }
    }

    private static class LocationsTaskStateListener
    implements TaskStateListener {
        final CommonServerSupport css;

        LocationsTaskStateListener(CommonServerSupport css) {
            this.css = css;
        }

        private String adminCommandFailedMsg(String resName, String[] args) {
            String serverName = args[0];
            String command = args[1];
            String exMessage = args.length > 2 ? args[2] : null;
            return args.length > 2 ? NbBundle.getMessage(CommonServerSupport.class, (String)resName, (Object)args[0], (Object)args[1], (Object)args[2]) : NbBundle.getMessage(CommonServerSupport.class, (String)resName, (Object)args[0], (Object)args[1]);
        }

        public void operationStateChanged(TaskState newState, TaskEvent event, String[] args) {
            if (args.length > 1) {
                boolean display;
                String exMessage = args.length > 2 ? args[2] : null;
                boolean bl = display = args.length > 3 ? Boolean.parseBoolean(args[3]) : false;
                if (display) {
                    long lastDisplayed = this.css.getLatestWarningDisplayTime();
                    long currentTime = System.currentTimeMillis();
                    if (TaskState.FAILED == newState && currentTime - lastDisplayed > 5000L) {
                        String message;
                        switch (event) {
                            case EXCEPTION: {
                                if (exMessage != null && exMessage.length() > 0) {
                                    message = this.adminCommandFailedMsg("MSG_ADMIN_EXCEPTION", args);
                                    break;
                                }
                                message = this.adminCommandFailedMsg("MSG_ADMIN_FAILED", args);
                                break;
                            }
                            case LOCAL_AUTH_FAILED: {
                                message = this.adminCommandFailedMsg("MSG_ADMIN_LOCAL_AUTH_FAILED", args);
                                break;
                            }
                            case REMOTE_AUTH_FAILED: {
                                message = this.adminCommandFailedMsg("MSG_ADMIN_LOCAL_AUTH_FAILED", args);
                                break;
                            }
                            default: {
                                message = this.adminCommandFailedMsg("MSG_ADMIN_FAILED", args);
                            }
                        }
                        CommonServerSupport.displayPopUpMessage(this.css, message);
                    }
                }
            }
        }
    }
}

