/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbBundle;

public class Utils {
    public static final String IS_LIBRARY = "is_library";
    public static final String IS_EMBEDDED = "is_embedded";

    private Utils() {
    }

    public static String browseFolder(JComponent parent, String oldValue, String title) {
        return Utils.browseFilter(parent, oldValue, title, 1, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.exists() && f.canRead() && f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(Utils.class, (String)"LBL_Utils_FolderFilter");
            }
        });
    }

    public static String browseFilter(JComponent parent, String oldValue, String title, int fileSelection, FileFilter filter) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(fileSelection);
        chooser.setFileFilter(filter);
        if (oldValue != null) {
            chooser.setSelectedFile(new File(oldValue));
        }
        chooser.setDialogTitle(title);
        if (chooser.showOpenDialog(parent) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static File findSubFile(File[] files, String fileName) {
        String lowerCaseFileName = fileName.toLowerCase();
        File aprox = null;
        if (files != null) {
            for (int a = 0; a < files.length; ++a) {
                File file = files[a];
                String name = file.getName();
                if (fileName.equals(name)) {
                    return file;
                }
                if (!lowerCaseFileName.equals(name.toLowerCase())) continue;
                aprox = file;
            }
        }
        return aprox;
    }

    public static File findAnyFile(File[] files, String ext) {
        ext = ext.toLowerCase();
        if (files != null) {
            for (int a = 0; a < files.length; ++a) {
                File file = files[a];
                String name = file.getName();
                int i = name.lastIndexOf(46);
                if (i < 0 || !ext.equals(name.substring(i + 1).toLowerCase())) continue;
                return file;
            }
        }
        return null;
    }
}

