/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.NewProjectIterator;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformInstallPanel;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ProjectPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class SampleProjectIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 4589834546983L;
    boolean platformInstall;
    int currentIndex;
    PlatformInstallPanel.WizardPanel platformPanel;
    ProjectPanel.WizardPanel projectPanel;
    PlatformSelectionPanel psPanel;

    static Object create() {
        return new SampleProjectIterator();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel current() {
        if (this.platformInstall) {
            switch (this.currentIndex) {
                case 0: {
                    return this.platformPanel;
                }
                case 1: {
                    return this.projectPanel;
                }
                case 2: {
                    return this.psPanel;
                }
            }
        } else {
            switch (this.currentIndex) {
                case 0: {
                    return this.projectPanel;
                }
                case 1: {
                    return this.psPanel;
                }
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        if (this.platformInstall) {
            return this.currentIndex < 2;
        }
        return this.currentIndex < 1;
    }

    public boolean hasPrevious() {
        return this.currentIndex > 0;
    }

    public void initialize(TemplateWizard templateWizard) {
        FileObject fo;
        this.platformInstall = PlatformInstallPanel.isPlatformInstalled("j2me") ^ true;
        if (this.platformInstall) {
            this.platformPanel = new PlatformInstallPanel.WizardPanel("j2me");
            ((JComponent)this.platformPanel.getComponent()).putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(NewProjectIterator.class, (String)"TXT_SampleProject"));
        }
        this.projectPanel = new ProjectPanel.WizardPanel(false);
        ((JComponent)this.projectPanel.getComponent()).putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(NewProjectIterator.class, (String)"TXT_SampleProject"));
        this.psPanel = new PlatformSelectionPanel();
        String configuration = null;
        String profile = null;
        DataObject dao = templateWizard.getTemplate();
        if (dao != null && (fo = dao.getPrimaryFile()) != null) {
            configuration = (String)fo.getAttribute("MicroEdition-Configuration");
            profile = (String)fo.getAttribute("MicroEdition-Profile");
            templateWizard.putProperty("ProjectName", (Object)(fo.getName() + '1'));
        }
        templateWizard.putProperty("RequiredConfiguration", configuration);
        templateWizard.putProperty("RequiredProfile", profile);
        templateWizard.putProperty("PlatformDescription", null);
        this.currentIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.platformPanel = null;
        this.projectPanel = null;
        this.psPanel = null;
        this.currentIndex = -1;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        File projectLocation = (File)templateWizard.getProperty("ProjectLocation");
        String name = (String)templateWizard.getProperty("ProjectName");
        PlatformSelectionPanel.PlatformDescription platform = (PlatformSelectionPanel.PlatformDescription)templateWizard.getProperty("PlatformDescription");
        if (platform == null) {
            this.psPanel.readSettings(templateWizard);
            this.psPanel.storeSettings(templateWizard);
            platform = (PlatformSelectionPanel.PlatformDescription)templateWizard.getProperty("PlatformDescription");
        }
        AntProjectHelper helper = J2MEProjectGenerator.createProjectFromTemplate(templateWizard.getTemplate().getPrimaryFile(), projectLocation, name, platform);
        FileObject projectDir = helper.getProjectDirectory();
        return Collections.singleton(DataObject.find((FileObject)projectDir));
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        this.updateStepsList();
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentIndex;
        this.updateStepsList();
    }

    void updateStepsList() {
        JComponent component = (JComponent)this.current().getComponent();
        if (component == null) {
            return;
        }
        String[] list = this.platformInstall ? new String[]{NbBundle.getMessage(PlatformInstallPanel.class, (String)"TITLE_Platform"), NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_PlatformSelection")} : new String[]{NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_PlatformSelection")};
        component.putClientProperty("WizardPanel_contentData", list);
        component.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.currentIndex));
    }
}

