/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mobility.project.ui.wizard.Utils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ProjectPanel
extends JPanel {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    public static final String PROJECT_NAME = "ProjectName";
    public static final String PROJECTS_HOME = "ProjectsHome";
    public static final String PROJECT_LOCATION = "ProjectLocation";
    public static final String PROJECT_CREATE_MIDLET = "CreateMidlet";
    public static final String PROJECT_COPY_SOURCES = "CopySources";
    private static final int WINDOWS_MAX_PATH_LENGTH = 255;
    private JButton bBrowse;
    private ButtonGroup buttonGroup1;
    private JCheckBox cCreateMIDlet;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel2;
    private JRadioButton jRadioCopySrc;
    private JRadioButton jRadioEmptySrc;
    private JSeparator jSeparator1;
    private JTextField tCreated;
    private JTextField tHome;
    private JTextField tName;

    public ProjectPanel(boolean showCreateMIDlet, boolean showCopySources) {
        this.initComponents();
        this.initAccessibility();
        this.cCreateMIDlet.setVisible(showCreateMIDlet);
        this.jLabel4.setVisible(showCopySources);
        this.jRadioCopySrc.setVisible(showCopySources);
        this.jRadioEmptySrc.setVisible(showCopySources);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tName.requestFocus();
    }

    public void addListeners(DocumentListener documentListener, ItemListener itemListener) {
        this.tName.getDocument().addDocumentListener(documentListener);
        this.tHome.getDocument().addDocumentListener(documentListener);
        this.cCreateMIDlet.addItemListener(itemListener);
    }

    public void removeListeners(DocumentListener documentListener, ItemListener itemListener) {
        this.tName.getDocument().removeDocumentListener(documentListener);
        this.tHome.getDocument().removeDocumentListener(documentListener);
        this.cCreateMIDlet.removeItemListener(itemListener);
    }

    private static String camelize(String input) {
        StringBuffer output = new StringBuffer();
        boolean upper = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == ' ') {
                upper = true;
                continue;
            }
            if (upper) {
                c = Character.toUpperCase(c);
                upper = false;
            }
            output.append(c);
        }
        return output.toString();
    }

    public void readData(WizardDescriptor object) {
        boolean embedded;
        String tmp = (String)object.getProperty(PROJECT_NAME);
        if (tmp == null) {
            tmp = "My Project";
        }
        this.tName.setText(ProjectPanel.camelize(tmp));
        File location = (File)object.getProperty(PROJECT_LOCATION);
        if (location != null) {
            this.tCreated.setText(location.getAbsolutePath());
        } else {
            File home = ProjectChooser.getProjectsFolder();
            this.tHome.setText(home != null ? home.getAbsolutePath() : System.getProperty("user.home", ""));
            if (this.testIfProjectNameExists()) {
                String name = this.getProjectName();
                if (name.endsWith("1")) {
                    name = name.substring(0, name.length() - 1);
                }
                int i = 2;
                while (true) {
                    this.tName.setText(name + i);
                    if (!this.testIfProjectNameExists()) break;
                    ++i;
                }
            }
            this.tName.selectAll();
        }
        Boolean b = (Boolean)object.getProperty("is_embedded");
        boolean bl = embedded = b == null ? false : b;
        if (embedded) {
            Mnemonics.setLocalizedText((AbstractButton)this.cCreateMIDlet, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Project_CreateIMlet"));
        }
        this.cCreateMIDlet.setSelected((b = (Boolean)object.getProperty(PROJECT_CREATE_MIDLET)) == null ? true : b);
        b = (Boolean)object.getProperty(PROJECT_COPY_SOURCES);
        this.jRadioEmptySrc.setSelected(b == null ? true : b == false);
        this.jRadioCopySrc.setSelected(b == null ? false : b);
    }

    private boolean testIfProjectNameExists() {
        boolean valid;
        File home = new File(this.getProjectsHome());
        boolean bl = valid = home.exists() && home.isDirectory() && home.canWrite();
        if (!valid) {
            return false;
        }
        return new File(home, this.getProjectName()).exists();
    }

    public void storeData(WizardDescriptor object) {
        object.putProperty(PROJECT_NAME, (Object)this.tName.getText().trim());
        object.putProperty(PROJECTS_HOME, (Object)this.tHome.getText());
        object.putProperty(PROJECT_LOCATION, (Object)new File(this.tCreated.getText()).getAbsoluteFile());
        object.putProperty(PROJECT_CREATE_MIDLET, (Object)(this.cCreateMIDlet.isVisible() && this.cCreateMIDlet.isSelected() ? 1 : 0));
        object.putProperty(PROJECT_COPY_SOURCES, (Object)(this.jRadioCopySrc.isVisible() && this.jRadioCopySrc.isSelected() ? 1 : 0));
    }

    public String getProjectName() {
        return this.tName.getText().trim();
    }

    public String getProjectsHome() {
        return this.tHome.getText();
    }

    public void setCreated(String created) {
        this.tCreated.setText(created);
    }

    public String getCreated() {
        return this.tCreated.getText();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.tName = new JTextField();
        this.jLabel2 = new JLabel();
        this.tHome = new JTextField();
        this.bBrowse = new JButton();
        this.jLabel3 = new JLabel();
        this.tCreated = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.cCreateMIDlet = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jRadioEmptySrc = new JRadioButton();
        this.jRadioCopySrc = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.setName(NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project"));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.tName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Project_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 6, 6);
        this.add((Component)this.tName, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tHome);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Projects_Home"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 6, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 6, 6);
        this.add((Component)this.tHome, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowse, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Project_Browse"));
        this.bBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.bBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 6, 0);
        this.add((Component)this.bBrowse, gridBagConstraints);
        this.jLabel3.setLabelFor(this.tCreated);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Project_Created"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 6, 6);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.tCreated.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 6, 6);
        this.add((Component)this.tCreated, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.cCreateMIDlet.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cCreateMIDlet, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Project_CreateMIDlet"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 6, 0);
        this.add((Component)this.cCreateMIDlet, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_ProjectSources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioEmptySrc);
        this.jRadioEmptySrc.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioEmptySrc, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_EmptySources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jRadioEmptySrc, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioCopySrc);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioCopySrc, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_CopySources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 6, 0);
        this.add((Component)this.jRadioCopySrc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectPanel.class, (String)"ACSN_Project"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectPanel.class, (String)"ACSD_Project"));
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bBrowseActionPerformed(ActionEvent evt) {
        String folder = Utils.browseFolder(this, this.tHome.getText(), NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project_Home"));
        if (folder != null) {
            this.tHome.setText(folder);
        }
    }

    static boolean isIllegalName(String name) {
        return name.length() == 0 || name.indexOf(47) >= 0 || name.indexOf(92) >= 0 || name.indexOf(58) >= 0 || name.indexOf("\"") >= 0 || name.indexOf(60) >= 0 || name.indexOf(62) >= 0;
    }

    public static class WizardPanel
    implements WizardDescriptor.FinishablePanel,
    DocumentListener,
    ItemListener {
        ProjectPanel component;
        TemplateWizard wizard;
        private boolean embedded;
        Collection<ChangeListener> listeners = new ArrayList<ChangeListener>();
        boolean valid = false;
        boolean showCreateMIDlet;
        boolean showCopySources;

        public WizardPanel(boolean showCreateMIDlet) {
            this(showCreateMIDlet, false);
        }

        public WizardPanel(boolean showCreateMIDlet, boolean showCopySources) {
            this.showCreateMIDlet = showCreateMIDlet;
            this.showCopySources = showCopySources;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new ProjectPanel(this.showCreateMIDlet, this.showCopySources);
                this.component.addListeners(this, this);
                this.checkValid();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(ProjectPanel.class.getName() + (this.embedded ? "Embedded" : ""));
        }

        public boolean isFinishPanel() {
            return true;
        }

        public void showError(String message) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
            }
        }

        private boolean isLatin1(String s) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c >= ' ' && c <= '\u007f') continue;
                return false;
            }
            return true;
        }

        private File getCanonicalFile(File f) {
            try {
                return f.getCanonicalFile();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public boolean isValid() {
            File projLoc;
            String projectName = this.component.getProjectName();
            if (ProjectPanel.isIllegalName(projectName)) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_InvalidProjectsName"));
                return false;
            }
            File home = this.getCanonicalFile(new File(this.component.getProjectsHome()).getAbsoluteFile());
            if (home == null) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_InvalidProjectsHome"));
                return false;
            }
            File destFolder = this.getCanonicalFile(new File(this.component.getCreated()).getAbsoluteFile());
            if (destFolder == null) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_InvalidProjectsName"));
                return false;
            }
            for (projLoc = destFolder; projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
            }
            if (projLoc == null || !projLoc.canWrite()) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_ProjectFolderReadOnly"));
                return false;
            }
            if (FileUtil.toFileObject((File)(projLoc = FileUtil.normalizeFile((File)projLoc))) == null) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_InvalidProjectsHome"));
                return false;
            }
            File[] kids = destFolder.listFiles();
            if (destFolder.exists() && kids != null && kids.length > 0) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_ProjectAlreadyExists"));
                return false;
            }
            if (!this.isLatin1(this.component.getProjectName())) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"WARN_Project_InvalidCharacters"));
            } else if (Utilities.isWindows() && this.component.getCreated().length() > 255) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"WARN_Project_PathLengthExceeding"));
            } else {
                this.showError(null);
            }
            return true;
        }

        public void readSettings(Object obj) {
            this.wizard = (TemplateWizard)obj;
            ((ProjectPanel)this.getComponent()).readData((WizardDescriptor)this.wizard);
            this.embedded = this.wizard.getProperty("is_embedded") == null ? false : (Boolean)this.wizard.getProperty("is_embedded");
            Component component = this.getComponent();
            Object substitute = ((JComponent)component).getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.wizard.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object obj) {
            this.wizard = (TemplateWizard)obj;
            ((ProjectPanel)this.getComponent()).storeData((WizardDescriptor)this.wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] ll;
            WizardPanel wizardPanel = this;
            synchronized (wizardPanel) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (int i = 0; i < ll.length; ++i) {
                ll[i].stateChanged(ev);
            }
        }

        void checkValid() {
            this.updateCreatedFolderPath();
            if (this.isValid() != this.valid) {
                this.valid ^= true;
                this.fireStateChange();
            }
        }

        public void updateCreatedFolderPath() {
            String projectName = this.component.getProjectName();
            String projectFolder = this.component.getProjectsHome();
            String projFolderPath = FileUtil.normalizeFile((File)new File(projectFolder)).getAbsolutePath();
            if (projFolderPath.endsWith(File.separator)) {
                this.component.setCreated(projFolderPath + projectName);
            } else {
                this.component.setCreated(projFolderPath + File.separator + projectName);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.checkValid();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkValid();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }
    }
}

