/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.awt.Mnemonics;
import org.openide.loaders.TemplateWizard;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

public class PlatformSelectionPanelGUI
extends JPanel
implements ActionListener {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private final DefaultComboBoxModel deviceModel;
    private final HashMap<String, J2MEPlatform.J2MEProfile> name2profile;
    private Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private String reqCfg;
    private String reqProf;
    private boolean embedded;
    private TemplateWizard wiz;
    private int firstConfigWidth = -1;
    private boolean finishable = true;
    private ButtonGroup cfgGroup;
    private JComboBox jComboBoxTarget;
    private JComboBox jComboDevice;
    private JLabel jLabelConfig;
    private JLabel jLabelDevice;
    private JLabel jLabelProfile;
    private JLabel jLabelTarget;
    private JPanel jPanelConfig;
    private JPanel jPanelProfile;
    private JSeparator jSeparator1;
    private ButtonGroup profGroup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void setFinishable(boolean finishable) {
        this.finishable = finishable;
        this.fireChangeEvent();
    }

    public boolean getFinishable() {
        return this.finishable;
    }

    public PlatformSelectionPanelGUI() {
        this.name2profile = new HashMap();
        this.initComponents();
        this.initAccessibility();
        this.deviceModel = new DefaultComboBoxModel();
        this.jComboDevice.setModel(this.deviceModel);
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
        Arrays.sort(platforms, new Comparator<JavaPlatform>(){

            @Override
            public int compare(JavaPlatform o1, JavaPlatform o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        this.jComboBoxTarget.setModel(new DefaultComboBoxModel<JavaPlatform>(platforms));
        HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> cfg = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
        HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> prof = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
        for (int i = 0; i < platforms.length; ++i) {
            if (!(platforms[i] instanceof J2MEPlatform)) continue;
            J2MEPlatform platform = (J2MEPlatform)platforms[i];
            Profile[] profiles = platform.getSpecification().getProfiles();
            for (int j = 0; j < profiles.length; ++j) {
                if (!(profiles[j] instanceof J2MEPlatform.J2MEProfile)) continue;
                J2MEPlatform.J2MEProfile p = (J2MEPlatform.J2MEProfile)profiles[j];
                if ("configuration".equals(p.getType())) {
                    p = this.takeBetter(p, (J2MEPlatform.J2MEProfile)cfg.remove(p));
                    cfg.put(p, p);
                    continue;
                }
                if (!"profile".equals(p.getType())) continue;
                p = this.takeBetter(p, (J2MEPlatform.J2MEProfile)prof.remove(p));
                prof.put(p, p);
            }
        }
        J2MEPlatform.J2MEProfile[] arr = cfg.values().toArray(new J2MEPlatform.J2MEProfile[cfg.size()]);
        this.initAllConfigurations(arr);
        arr = prof.values().toArray(new J2MEPlatform.J2MEProfile[prof.size()]);
        this.initAllProfiles(arr);
        this.jComboBoxTarget.addActionListener(this);
        this.jComboDevice.addActionListener(this);
    }

    private J2MEPlatform.J2MEProfile takeBetter(J2MEPlatform.J2MEProfile p1, J2MEPlatform.J2MEProfile p2) {
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        return p1.getDisplayNameWithVersion().length() > p2.getDisplayNameWithVersion().length() ? p1 : p2;
    }

    private void initAllConfigurations(J2MEPlatform.J2MEProfile[] cfgs) {
        Arrays.sort(cfgs);
        for (int i = 0; i < cfgs.length; ++i) {
            JRadioButton btn = new JRadioButton(cfgs[i].toString());
            btn.setToolTipText(cfgs[i].getDisplayNameWithVersion());
            btn.setActionCommand(cfgs[i].toString());
            this.cfgGroup.add(btn);
            this.jPanelConfig.add(btn);
            Dimension preferredSize = btn.getPreferredSize();
            if (this.firstConfigWidth == -1) {
                this.firstConfigWidth = preferredSize.width + 30;
                btn.setPreferredSize(new Dimension(this.firstConfigWidth, preferredSize.height));
            } else {
                btn.setPreferredSize(new Dimension(this.firstConfigWidth, preferredSize.height));
            }
            btn.addActionListener(this);
        }
    }

    private void initAllProfiles(J2MEPlatform.J2MEProfile[] profs) {
        Arrays.sort(profs);
        for (int i = 0; i < profs.length; ++i) {
            JRadioButton btn = new JRadioButton(profs[i].toString());
            btn.setToolTipText(profs[i].getDisplayNameWithVersion());
            btn.setActionCommand(profs[i].toString());
            this.profGroup.add(btn);
            btn.setPreferredSize(new Dimension(this.firstConfigWidth, btn.getPreferredSize().height));
            this.jPanelProfile.add(btn);
            btn.addActionListener(this);
        }
    }

    public synchronized void setValues(TemplateWizard wiz, J2MEPlatform platform, J2MEPlatform.Device device, String config, String profile, boolean embedded) {
        this.wiz = wiz;
        this.reqCfg = config;
        this.reqProf = profile;
        this.embedded = embedded;
        this.jComboBoxTarget.setSelectedItem(platform);
        this.updateDevices(device, config, profile);
    }

    private synchronized void updateDevices(J2MEPlatform.Device device, String config, String profile) {
        J2MEPlatform.Device oldDevice;
        String deviceName;
        J2MEPlatform platform = this.getPlatform();
        String string = deviceName = device == null ? null : device.getName();
        if (deviceName == null && (oldDevice = this.getDevice()) != null) {
            deviceName = oldDevice.getName();
        }
        this.deviceModel.setSelectedItem(null);
        this.deviceModel.removeAllElements();
        if (platform != null) {
            int j;
            J2MEPlatform.J2MEProfile[] p;
            int i;
            J2MEPlatform.Device select = null;
            J2MEPlatform.Device[] devices = platform.getDevices();
            for (i = 0; i < devices.length; ++i) {
                p = devices[i].getProfiles();
                for (j = 0; j < p.length; ++j) {
                    if (this.embedded && profile != null && (!p[j].isDefault() || !"profile".equals(p[j].getType()) || !p[j].getName().equals(profile))) continue;
                    this.deviceModel.addElement(devices[i]);
                    if (devices[i].getName().equals(deviceName)) {
                        this.deviceModel.setSelectedItem(devices[i]);
                    }
                    if (select == null) {
                        select = devices[i];
                    }
                    j = p.length;
                }
            }
            if (this.embedded && profile != null && profile.equals("IMP-NG") && select == null) {
                for (i = 0; i < devices.length; ++i) {
                    p = devices[i].getProfiles();
                    for (j = 0; j < p.length; ++j) {
                        if (!p[j].isDefault() || !"profile".equals(p[j].getType()) || !p[j].getName().equals("IMP")) continue;
                        this.deviceModel.addElement(devices[i]);
                        if (devices[i].getName().equals(deviceName)) {
                            this.deviceModel.setSelectedItem(devices[i]);
                        }
                        if (select == null) {
                            select = devices[i];
                        }
                        j = p.length;
                    }
                }
            }
            if (this.deviceModel.getSelectedItem() == null && select != null) {
                this.deviceModel.setSelectedItem(select);
            }
        }
        this.updateConfigsAndProfiles(config, profile);
    }

    private synchronized void updateConfigsAndProfiles(String config, String profile) {
        J2MEPlatform.Device device = this.getDevice();
        String defCfg = null;
        String defProf = null;
        this.name2profile.clear();
        if (device != null) {
            J2MEPlatform.J2MEProfile[] p = device.getProfiles();
            for (int i = 0; i < p.length; ++i) {
                this.name2profile.put(p[i].toString(), p[i]);
                if (!p[i].isDefault()) continue;
                if ("configuration".equals(p[i].getType())) {
                    defCfg = p[i].toString();
                    continue;
                }
                if (!"profile".equals(p[i].getType())) continue;
                defProf = p[i].toString();
            }
        }
        this.updateGroup(this.cfgGroup, config, this.name2profile.keySet(), defCfg);
        this.updateGroup(this.profGroup, profile, this.name2profile.keySet(), defProf);
        this.updateErrorMessage();
    }

    private void updateGroup(ButtonGroup grp, String selected, Set<String> enabled, String def) {
        Enumeration<AbstractButton> en = grp.getElements();
        AbstractButton defB = null;
        while (en.hasMoreElements()) {
            JRadioButton btn = (JRadioButton)en.nextElement();
            String name = btn.getActionCommand();
            btn.setEnabled(enabled.contains(name));
            if (selected != null && selected.equals(name)) {
                grp.setSelected(btn.getModel(), true);
            }
            if (def == null || !def.equals(name)) continue;
            defB = btn;
        }
        ButtonModel m = grp.getSelection();
        if (!(m != null && m.isEnabled() || defB == null)) {
            grp.setSelected(defB.getModel(), true);
        }
    }

    private String extractProfileName(String profile) {
        assert (profile != null);
        int pos = profile.lastIndexOf("-");
        if (pos >= 0) {
            try {
                if (profile.substring(pos + 1).equals("NG")) {
                    return profile.substring(0, pos + 3);
                }
                return profile.substring(0, pos);
            }
            catch (StringIndexOutOfBoundsException se) {
                return "";
            }
        }
        return profile;
    }

    private SpecificationVersion extractProfileVersion(String profile) {
        assert (profile != null);
        int pos = profile.lastIndexOf("-");
        if (pos >= 0) {
            try {
                SpecificationVersion sv = new SpecificationVersion(profile.substring(pos + 1));
                if (sv != null) {
                    return sv;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new SpecificationVersion("1.0");
    }

    private boolean isProfileCompatible(String required, String current) {
        assert (required != null);
        assert (current != null);
        if (required.equals(current)) {
            return true;
        }
        String reqName = this.extractProfileName(required);
        String curName = this.extractProfileName(current);
        SpecificationVersion reqVer = this.extractProfileVersion(required);
        SpecificationVersion curVer = this.extractProfileVersion(current);
        return !reqName.isEmpty() && (reqName.equals(curName) && curVer.compareTo((Object)reqVer) >= 0 || reqName.equals("IMP") && (curName.equals("IMP-NG") || curName.equals("MIDP")) || reqName.equals("IMP-NG") && reqVer.equals((Object)new SpecificationVersion("1.0")) && curName.equals("MIDP") && curVer.compareTo((Object)new SpecificationVersion("2.0")) >= 0);
    }

    private boolean isSupportedProfile(String required) {
        for (String p : this.name2profile.keySet()) {
            if (!this.isProfileCompatible(required, p)) continue;
            return true;
        }
        return false;
    }

    public void updateErrorMessage() {
        boolean profError;
        boolean cfgError = this.reqCfg != null && !this.isSupportedProfile(this.reqCfg);
        boolean bl = profError = this.reqProf != null && !this.isSupportedProfile(this.reqProf);
        if (this.wiz != null) {
            String message = null;
            if (cfgError && profError) {
                message = NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ERR_PlatformSelection_Platform_does_not_support_2", (Object)this.reqCfg, (Object)this.reqProf);
            } else if (cfgError) {
                message = NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ERR_PlatformSelection_Platform_does_not_support_1", (Object)this.reqCfg);
            } else if (profError) {
                message = NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ERR_PlatformSelection_Platform_does_not_support_1", (Object)this.reqProf);
            }
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)message);
            this.setFinishable(!cfgError && !profError);
        }
    }

    public J2MEPlatform getPlatform() {
        return (J2MEPlatform)this.jComboBoxTarget.getSelectedItem();
    }

    public J2MEPlatform.Device getDevice() {
        return (J2MEPlatform.Device)this.deviceModel.getSelectedItem();
    }

    public J2MEPlatform.J2MEProfile getConfiguration() {
        ButtonModel m = this.cfgGroup.getSelection();
        return m == null ? null : this.name2profile.get(m.getActionCommand());
    }

    public J2MEPlatform.J2MEProfile getProfile() {
        ButtonModel m = this.profGroup.getSelection();
        return m == null ? null : this.name2profile.get(m.getActionCommand());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.jComboBoxTarget.equals(e.getSource())) {
            this.updateDevices(null, null, null);
        } else if (this.jComboDevice.equals(e.getSource())) {
            this.updateConfigsAndProfiles(null, null);
        }
    }

    private void initComponents() {
        this.cfgGroup = new ButtonGroup();
        this.profGroup = new ButtonGroup();
        this.jLabelTarget = new JLabel();
        this.jComboBoxTarget = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jLabelDevice = new JLabel();
        this.jComboDevice = new JComboBox();
        this.jLabelConfig = new JLabel();
        this.jPanelConfig = new JPanel();
        this.jLabelProfile = new JLabel();
        this.jPanelProfile = new JPanel();
        this.setName(NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"TITLE_PlatformSelection"));
        this.setLayout(new GridBagLayout());
        this.jLabelTarget.setLabelFor(this.jComboBoxTarget);
        Mnemonics.setLocalizedText((JLabel)this.jLabelTarget, (String)NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"LBL_PlatformSelection_TargetPlatform"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabelTarget, gridBagConstraints);
        this.jLabelTarget.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ACSD_PlatSel_Platform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jComboBoxTarget, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabelDevice.setLabelFor(this.jComboDevice);
        Mnemonics.setLocalizedText((JLabel)this.jLabelDevice, (String)NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"LBL_PlatformSelection_Device"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabelDevice, gridBagConstraints);
        this.jLabelDevice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ACSD_PlatSel_Device"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.jComboDevice, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelConfig, (String)NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"LBL_PlatformSelection_DeviceConfiguration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabelConfig, gridBagConstraints);
        this.jPanelConfig.setLayout(new GridLayout(1, 0, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.jPanelConfig, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelProfile, (String)NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"LBL_PlatformSelection_DeviceProfile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.jLabelProfile, gridBagConstraints);
        this.jPanelProfile.setLayout(new GridLayout(1, 0, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 12, 0);
        this.add((Component)this.jPanelProfile, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ACSN_PlatformSelection"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ACSD_PlatformSelection"));
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }
}

