/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PlatformInstallPanel
extends JPanel {
    ActionListener listener = null;
    private String platformType;
    private JButton bInstall;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;

    public PlatformInstallPanel(String pt) {
        this.platformType = pt.toUpperCase();
        try {
            this.platformType = NbBundle.getMessage(PlatformInstallPanel.class, (String)("LBL_PlatformType_" + this.platformType));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.initComponents();
        this.initAccessibility();
    }

    public void setActionListener(ActionListener listener) {
        this.listener = listener;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.bInstall = new JButton();
        this.jPanel1 = new JPanel();
        this.setName(NbBundle.getMessage(PlatformInstallPanel.class, (String)"TITLE_Platform"));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PlatformInstallPanel.class, (String)"LBL_Platform_Info1"));
        this.jLabel1.setMaximumSize(new Dimension(500, 60));
        this.jLabel1.setMinimumSize(new Dimension(500, 30));
        this.jLabel1.setPreferredSize(new Dimension(500, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PlatformInstallPanel.class, (String)"LBL_Platform_Info2", (Object)this.platformType));
        this.jLabel2.setMaximumSize(new Dimension(500, 60));
        this.jLabel2.setMinimumSize(new Dimension(500, 30));
        this.jLabel2.setPreferredSize(new Dimension(500, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 6, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PlatformInstallPanel.class, (String)"LBL_Platform_Info3"));
        this.jLabel3.setMaximumSize(new Dimension(500, 60));
        this.jLabel3.setMinimumSize(new Dimension(500, 30));
        this.jLabel3.setPreferredSize(new Dimension(500, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 6, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bInstall, (String)NbBundle.getMessage(PlatformInstallPanel.class, (String)"LBL_Platform_Install"));
        this.bInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlatformInstallPanel.this.bInstallActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 6, 0);
        this.add((Component)this.bInstall, gridBagConstraints);
        this.bInstall.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformInstallPanel.class, (String)"ACSD_PlatInst_Install"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PlatformInstallPanel.class, (String)"ACSN_PlatformInstall"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformInstallPanel.class, (String)"ACSD_PlatformInstall"));
    }

    private void bInstallActionPerformed(ActionEvent evt) {
        PlatformInstallPanel.openPlatformInstallWizard();
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public static void openPlatformInstallWizard() {
        PlatformsCustomizer.showCustomizer(null);
    }

    public static boolean isPlatformInstalled(String subType, String platformType) {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification(platformType, null));
        if (subType == null || !platformType.equals("cdc") && !platformType.equals("j2me")) {
            int cnt = platforms.length;
            for (JavaPlatform javaPlatform : platforms) {
                if (!javaPlatform.getInstallFolders().isEmpty()) continue;
                --cnt;
            }
            return cnt > 0;
        }
        for (JavaPlatform platform : platforms) {
            if (platform.getInstallFolders().isEmpty()) continue;
            if (platform instanceof J2MEPlatform && subType.equals(((J2MEPlatform)platform).getType())) {
                return true;
            }
            if (!(platform instanceof CDCPlatform) || !subType.equals(((CDCPlatform)platform).getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlatformInstalled(String platformType) {
        return JavaPlatformManager.getDefault().getPlatforms(null, new Specification(platformType, null)).length != 0;
    }

    public static class WizardPanel
    implements WizardDescriptor.FinishablePanel,
    ActionListener {
        PlatformInstallPanel component;
        TemplateWizard wizard;
        Collection<ChangeListener> listeners = new ArrayList<ChangeListener>();
        boolean valid = false;
        final String platformType;
        final String platformSubType;

        public WizardPanel(String platType) {
            this.platformType = platType;
            this.platformSubType = null;
        }

        public WizardPanel(String name, String platType) {
            this.platformType = platType;
            this.platformSubType = name;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new PlatformInstallPanel(this.platformType);
                this.component.setActionListener(this);
                this.checkValid();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(PlatformInstallPanel.class.getName());
        }

        public boolean isFinishPanel() {
            return false;
        }

        public void showError(String message) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
            }
        }

        public boolean isValid() {
            boolean valid = PlatformInstallPanel.isPlatformInstalled(this.platformSubType, this.platformType);
            if (!valid) {
                this.showError(NbBundle.getMessage(PlatformInstallPanel.class, (String)"ERR_Platform_NoPlatform", (Object)this.platformType.toUpperCase()));
            } else {
                this.showError(null);
            }
            return valid;
        }

        public void readSettings(Object obj) {
            this.wizard = (TemplateWizard)obj;
            Component component = this.getComponent();
            Object substitute = ((JComponent)component).getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.wizard.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object obj) {
            this.wizard = (TemplateWizard)obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] ll;
            WizardPanel wizardPanel = this;
            synchronized (wizardPanel) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (int i = 0; i < ll.length; ++i) {
                ll[i].stateChanged(ev);
            }
        }

        void checkValid() {
            if (this.isValid() != this.valid) {
                this.valid ^= true;
                this.fireStateChange();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.checkValid();
        }
    }
}

