/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.project.ui.customizer.CustomizerConfigManager;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.NewConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.customizer.VisualConfigSupport;
import org.netbeans.spi.mobility.project.ui.customizer.ComposedCustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.HelpCtxCallback;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class J2MECustomizer
extends JPanel
implements Runnable,
HelpCtxCallback {
    private static final String REGISTRATION_FOLDER = "Customizer/org.netbeans.modules.kjava.j2meproject";
    private static final ProjectConfiguration ADD_CONFIGURATION = new ProjectConfiguration(){
        private final String name = NbBundle.getMessage(J2MECustomizer.class, (String)"LBL_Customizer_AddConfiguration");

        public String getDisplayName() {
            return this.name;
        }
    };
    public static final String ADD_CONFIG_DIALOG = "AddConfigDialog";
    private J2MEProjectProperties props;
    private CategoryView categoryView;
    private DialogDescriptor descriptor;
    private String startPanel = "";
    private JPanel categoryPanel;
    private JComboBox configurationCombo;
    private JPanel configurationPanel;
    private JPanel customizerPanel;
    private JButton jButtonEdit;
    private JLabel jLabelCategory;
    private JLabel jLabelConfig;
    private JSeparator jSeparator2;

    public J2MECustomizer(J2MEProjectProperties j2meProperties, String startPanel) {
        this(j2meProperties);
        this.startPanel = startPanel;
    }

    public J2MECustomizer(J2MEProjectProperties j2meProperties) {
        this.initComponents();
        this.configurationCombo.setRenderer(new ConfigurationCellRenderer());
        this.props = j2meProperties;
        this.categoryView = new CategoryView(this.createRootNode());
        this.categoryPanel.add((Component)this.categoryView, "Center");
        this.initAccessibility();
        this.setConfigurationCombo();
    }

    public void setDialogDescriptor(DialogDescriptor dd) {
        this.descriptor = dd;
    }

    @Override
    public void updateHelpCtx(HelpCtx help) {
        if (this.descriptor != null) {
            this.descriptor.setHelpCtx(help);
        }
    }

    public final void setConfigurationCombo() {
        ProjectConfiguration sel;
        Vector<ProjectConfiguration> configs = new Vector<ProjectConfiguration>(Arrays.asList(this.props.getConfigurations()));
        if (!configs.contains(sel = this.props.getActiveConfiguration())) {
            sel = configs.get(0);
            this.props.setActiveConfiguration(sel);
        }
        configs.add(ADD_CONFIGURATION);
        this.configurationCombo.setModel(new DefaultComboBoxModel<ProjectConfiguration>(configs));
        this.configurationCombo.setSelectedItem(sel);
    }

    private void initComponents() {
        this.configurationPanel = new JPanel();
        this.jLabelConfig = new JLabel();
        this.configurationCombo = new JComboBox();
        this.jButtonEdit = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jLabelCategory = new JLabel();
        this.categoryPanel = new JPanel();
        this.customizerPanel = new JPanel();
        this.setMinimumSize(new Dimension(760, 500));
        this.setPreferredSize(new Dimension(760, 530));
        this.setLayout(new GridBagLayout());
        this.configurationPanel.setLayout(new GridBagLayout());
        this.jLabelConfig.setLabelFor(this.configurationCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabelConfig, (String)NbBundle.getMessage(J2MECustomizer.class, (String)"LBL_Customizer_Configuration"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.configurationPanel.add((Component)this.jLabelConfig, gridBagConstraints);
        this.configurationCombo.setMinimumSize(new Dimension(220, 24));
        this.configurationCombo.setPreferredSize(new Dimension(220, 24));
        this.configurationCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MECustomizer.this.configurationComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 6, 0, 0);
        this.configurationPanel.add((Component)this.configurationCombo, gridBagConstraints);
        this.configurationCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MECustomizer.class, (String)"ACSD_Customizer_Configuration"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonEdit, (String)NbBundle.getMessage(J2MECustomizer.class, (String)"LBL_Customizer_Edit"));
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MECustomizer.this.jButtonEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 5, 0, 8);
        this.configurationPanel.add((Component)this.jButtonEdit, gridBagConstraints);
        this.jButtonEdit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MECustomizer.class, (String)"ACSD_Customizer_ManageCfgButton"));
        this.jSeparator2.setMinimumSize(new Dimension(0, 5));
        this.jSeparator2.setPreferredSize(new Dimension(0, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 8, 0, 8);
        this.configurationPanel.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.configurationPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelCategory, (String)NbBundle.getMessage(J2MECustomizer.class, (String)"LBL_Customizer_Category"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.add((Component)this.jLabelCategory, gridBagConstraints);
        this.jLabelCategory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MECustomizer.class, (String)"ACSD_Customizer_Category"));
        this.categoryPanel.setBorder(BorderFactory.createEtchedBorder());
        this.categoryPanel.setMinimumSize(new Dimension(220, 24));
        this.categoryPanel.setPreferredSize(new Dimension(220, 24));
        this.categoryPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 8, 8, 8);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        this.customizerPanel.setMinimumSize(new Dimension(530, 10));
        this.customizerPanel.setPreferredSize(new Dimension(530, 10));
        this.customizerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.customizerPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2MECustomizer.class, (String)"ACSN_Customizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MECustomizer.class, (String)"ACSD_Customizer"));
        this.jLabelCategory.setLabelFor((Component)this.categoryView.getBeanTreeView());
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        CustomizerConfigManager ccm = new CustomizerConfigManager(this.props, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)ccm, NbBundle.getMessage(J2MECustomizer.class, (String)"Title_ProjectConfigurationManager"), true, new Object[]{NotifyDescriptor.CLOSED_OPTION}, NotifyDescriptor.CLOSED_OPTION, 0, new HelpCtx(CustomizerConfigManager.class), null));
        this.setConfigurationCombo();
    }

    private void configurationComboActionPerformed(ActionEvent evt) {
        if (ADD_CONFIGURATION.equals(this.configurationCombo.getSelectedItem())) {
            RequestProcessor.getDefault().post((Runnable)this);
        } else {
            this.props.setActiveConfiguration((ProjectConfiguration)this.configurationCombo.getSelectedItem());
            this.categoryView.updateCustomizerPanel();
        }
    }

    @Override
    public void run() {
        if (!this.isShowing()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        final NewConfigurationPanel p = new NewConfigurationPanel(this.props.getAllIdentifiers());
        DialogDescriptor dd = new DialogDescriptor((Object)p, NbBundle.getMessage(J2MECustomizer.class, (String)"Title_Customizer_AddConfiguration"), true, 2, NotifyDescriptor.OK_OPTION, null);
        p.setDialogDescriptor(dd);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd))) {
            ProjectConfiguration cfg = new ProjectConfiguration(){
                private final String name;
                {
                    this.name = p.getName();
                }

                public String getDisplayName() {
                    return this.name;
                }
            };
            ProjectConfiguration[] cfgs = this.props.getConfigurations();
            ProjectConfiguration[] ncfgs = new ProjectConfiguration[cfgs.length + 1];
            System.arraycopy(cfgs, 0, ncfgs, 0, cfgs.length);
            ncfgs[ncfgs.length - 1] = cfg;
            this.props.setConfigurations(ncfgs);
            VisualConfigSupport.createFromTemplate(this.props, p.getName(), p.getTemplate());
            this.props.setActiveConfiguration(cfg);
            this.setConfigurationCombo();
        } else {
            if (this.props.getActiveConfiguration() == null) {
                this.configurationCombo.setSelectedIndex(0);
            } else {
                this.configurationCombo.setSelectedItem(this.props.getActiveConfiguration());
            }
            this.categoryView.updateCustomizerPanel();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (ADD_CONFIG_DIALOG.equals(this.startPanel)) {
            SwingUtilities.invokeLater(this);
        }
    }

    private Node createRootNode() {
        DataFolder df = DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)REGISTRATION_FOLDER));
        return new FNode(df.getNodeDelegate(), Children.create((ChildFactory)new ConfigurationChildFactory(df), (boolean)true));
    }

    private static class ConfigurationCellRenderer
    extends DefaultListCellRenderer {
        private ConfigurationCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ProjectConfiguration) {
                this.setText(((ProjectConfiguration)value).getDisplayName());
            }
            return this;
        }
    }

    private static final class ConfigurationChildFactory
    extends ChildFactory<DataFolder> {
        private final DataFolder parent;

        private ConfigurationChildFactory(DataFolder parent) {
            this.parent = parent;
        }

        protected boolean createKeys(List<DataFolder> toPopulate) {
            for (DataObject dob : this.parent.getChildren()) {
                if (!(dob instanceof DataFolder)) continue;
                toPopulate.add((DataFolder)dob);
            }
            return true;
        }

        protected Node createNodeForKey(DataFolder key) {
            return new FNode(key.getNodeDelegate(), Children.create((ChildFactory)new ConfigurationChildFactory(key), (boolean)true));
        }
    }

    private static class FNode
    extends FilterNode {
        public FNode(Node original, Children children) {
            super(original, children);
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canRename() {
            return false;
        }
    }

    private class CategoryView
    extends JPanel
    implements ExplorerManager.Provider,
    ChangeListener {
        protected final ExplorerManager manager;
        private final BeanTreeView btv;
        private HashMap<Node, Integer> tabSelections = new HashMap();

        CategoryView(Node rootNode) {
            this.manager = new ExplorerManager();
            this.setLayout(new BorderLayout());
            Dimension size = new Dimension(220, 4);
            this.btv = new BeanTreeView();
            try {
                Field f = BeanTreeView.class.getDeclaredField("tree");
                f.setAccessible(true);
                J2MECustomizer.this.jLabelCategory.setLabelFor((Component)f.get(this.btv));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.btv.setSelectionMode(1);
            this.btv.setPopupAllowed(false);
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(false);
            this.btv.setMinimumSize(size);
            this.btv.setPreferredSize(size);
            this.btv.setMaximumSize(size);
            this.add((Component)this.btv, "Center");
            rootNode.addNodeListener((NodeListener)new NL(rootNode));
            this.manager.setRootContext(rootNode);
            this.selectFirstNode();
            this.btv.expandAll();
            this.manager.addPropertyChangeListener((PropertyChangeListener)new ManagerChangeListener());
            JLabel waitLabel = new JLabel(NbBundle.getMessage(CategoryView.class, (String)"MSG_LOADING"));
            waitLabel.setHorizontalTextPosition(0);
            waitLabel.setVerticalTextPosition(0);
            J2MECustomizer.this.customizerPanel.add((Component)waitLabel, "Center");
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public BeanTreeView getBeanTreeView() {
            return this.btv;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.btv.expandAll();
        }

        private void selectFirstNode() {
            Node[] nodes;
            Children ch = this.manager.getRootContext().getChildren();
            if (ch != null && (nodes = ch.getNodes()) != null && nodes.length > 1) {
                try {
                    this.manager.setSelectedNodes(new Node[]{nodes[1]});
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void updateCustomizerPanel() {
            Object cfg = J2MECustomizer.this.configurationCombo.getSelectedItem();
            String configuration = J2MECustomizer.this.configurationCombo.getSelectedIndex() == 0 || cfg == null || !(cfg instanceof ProjectConfiguration) ? null : ((ProjectConfiguration)cfg).getDisplayName();
            Node[] nodes = this.manager.getSelectedNodes();
            if (nodes == null || nodes.length <= 0) {
                return;
            }
            Node node = nodes[0];
            J2MECustomizer.this.customizerPanel.removeAll();
            DataFolder df = (DataFolder)node.getCookie(DataFolder.class);
            if (df == null) {
                return;
            }
            JComponent c = (JComponent)df.getPrimaryFile().getAttribute("customizerPanelClass");
            if (c != null) {
                J2MECustomizer.this.updateHelpCtx(new HelpCtx(c.getClass()));
                c.setBorder(BorderFactory.createEmptyBorder(5, 8, 8, 8));
                J2MECustomizer.this.customizerPanel.add((Component)c, "Center");
                J2MECustomizer.this.configurationCombo.setEnabled(c instanceof VisualPropertyGroup);
                if (c instanceof CustomizerPanel) {
                    ((CustomizerPanel)((Object)c)).initValues(J2MECustomizer.this.props, configuration);
                }
                if (c instanceof ComposedCustomizerPanel) {
                    ((ComposedCustomizerPanel)((Object)c)).setHelpContextCallback(J2MECustomizer.this);
                }
            } else {
                DataObject[] dob = df.getChildren();
                JTabbedPane tab = new JTabbedPane();
                tab.setBorder(BorderFactory.createEmptyBorder(5, 8, 8, 8));
                boolean cfgSensitive = false;
                for (int i = 0; i < dob.length; ++i) {
                    String state;
                    FileObject fob = dob[i].getPrimaryFile();
                    String triggerName = (String)fob.getAttribute("triggerPropertyName");
                    String triggerValue = triggerName == null ? null : (String)fob.getAttribute("triggerPropertyValue");
                    cfgSensitive |= triggerValue != null;
                    String string = state = triggerValue == null ? null : this.evaluatePropertyRaw(configuration, triggerName);
                    if (triggerValue != null && !triggerValue.equalsIgnoreCase(state) || (c = (JComponent)fob.getAttribute("customizerPanelClass")) == null) continue;
                    c.setBorder(BorderFactory.createEmptyBorder(5, 8, 8, 8));
                    tab.add(dob[i].getNodeDelegate().getDisplayName(), c);
                    cfgSensitive |= c instanceof VisualPropertyGroup;
                    if (!(c instanceof CustomizerPanel)) continue;
                    ((CustomizerPanel)((Object)c)).initValues(J2MECustomizer.this.props, configuration);
                }
                J2MECustomizer.this.configurationCombo.setEnabled(cfgSensitive);
                if (tab.getComponentCount() > 0) {
                    J2MECustomizer.this.updateHelpCtx(new HelpCtx(tab.getComponent(0).getClass()));
                    J2MECustomizer.this.customizerPanel.add(tab.getComponentCount() == 1 ? tab.getComponent(0) : tab, "Center");
                    tab.addChangeListener(this);
                    Integer i = this.tabSelections.get(node);
                    if (i != null && i < tab.getTabCount()) {
                        tab.setSelectedIndex(i);
                    }
                } else {
                    J2MECustomizer.this.updateHelpCtx(null);
                }
            }
            J2MECustomizer.this.customizerPanel.validate();
            J2MECustomizer.this.customizerPanel.repaint();
        }

        private String evaluatePropertyRaw(String configuration, String name) {
            String s;
            if (configuration != null && (s = J2MECustomizer.this.props.getPropertyRawValue(VisualPropertySupport.prefixPropertyName(configuration, name))) != null) {
                return s;
            }
            return J2MECustomizer.this.props.getPropertyRawValue(name);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane p = (JTabbedPane)e.getSource();
            Node[] nodes = this.manager.getSelectedNodes();
            if (nodes != null && nodes.length == 1) {
                this.tabSelections.put(nodes[0], p.getSelectedIndex());
            }
            J2MECustomizer.this.updateHelpCtx(new HelpCtx(p.getSelectedComponent().getClass()));
        }

        private class ManagerChangeListener
        implements PropertyChangeListener {
            private ManagerChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() != CategoryView.this.manager) {
                    return;
                }
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    CategoryView.this.updateCustomizerPanel();
                }
            }
        }

        private final class NL
        extends NodeAdapter
        implements Runnable {
            private final Node listenedTo;
            private boolean done;

            NL(Node listenedTo) {
                this.listenedTo = listenedTo;
            }

            private void post() {
                this.done = false;
                RequestProcessor.getDefault().post((Runnable)this, 150);
            }

            private void change() {
                this.done = true;
                this.listenedTo.removeNodeListener((NodeListener)this);
                CategoryView.this.selectFirstNode();
            }

            public void childrenAdded(NodeMemberEvent ev) {
                this.change();
            }

            @Override
            public void run() {
                if (!this.done) {
                    if (!J2MECustomizer.this.isShowing()) {
                        return;
                    }
                    if (CategoryView.this.manager.getRootContext().getChildren().getNodesCount() > 1) {
                        this.change();
                    } else if (J2MECustomizer.this.isShowing()) {
                        this.post();
                    }
                }
            }
        }
    }
}

