/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class CustomizerMIDP
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ActionListener {
    private static final String[] PROPERTY_GROUP = new String[]{"platform.active", "platform.active.description", "platform.device", "platform.configuration", "platform.profile", "platform.apis", "platform.bootclasspath", "javac.source", "javac.target"};
    private static final Comparator<J2MEPlatform.J2MEProfile> OPTIONAL_API_COMPARATOR = new Comparator<J2MEPlatform.J2MEProfile>(){

        @Override
        public int compare(J2MEPlatform.J2MEProfile o1, J2MEPlatform.J2MEProfile o2) {
            return o1.getDisplayNameWithVersion().compareTo(o2.getDisplayNameWithVersion());
        }
    };
    private Map<String, Object> props;
    private VisualPropertySupport vps;
    private String configuration;
    private String[] platformNames;
    private HashMap<String, J2MEPlatform> name2platform;
    private HashMap<String, J2MEPlatform.Device> name2device;
    private HashMap<String, J2MEPlatform.J2MEProfile> name2profile;
    private Set<String> optionDefaults;
    private HashMap<String, J2MEPlatform.J2MEProfile> name2profileAll;
    private ArrayList<JCheckBox> optional;
    private boolean useDefault;
    private final transient Object lock = new Object();
    private ButtonGroup cfgGroup;
    private JButton jButtonEdit;
    private JComboBox jComboBoxTarget;
    private JComboBox jComboDevice;
    private JLabel jLabelConfig;
    private JLabel jLabelDevice;
    private JLabel jLabelOptional;
    private JLabel jLabelProfile;
    private JLabel jLabelTarget;
    private JPanel jPanelConfig;
    private JPanel jPanelOptional;
    private JPanel jPanelProfile;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private ButtonGroup profGroup;
    private int firstConfigWidth = -1;

    public CustomizerMIDP() {
        this.initComponents();
        this.initAccessibility();
        this.initAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAll() {
        Object object = this.lock;
        synchronized (object) {
            this.jPanelConfig.removeAll();
            this.jPanelProfile.removeAll();
            this.jPanelOptional.removeAll();
            this.cfgGroup = new ButtonGroup();
            this.profGroup = new ButtonGroup();
            this.initAll();
            this.initGroupValues(this.useDefault);
            this.jPanelConfig.invalidate();
            this.jPanelProfile.invalidate();
            this.jPanelOptional.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAll() {
        Object object = this.lock;
        synchronized (object) {
            this.optional = new ArrayList();
            this.name2platform = new HashMap();
            this.name2device = new HashMap();
            this.name2profile = new HashMap();
            this.optionDefaults = new HashSet<String>();
            this.name2profileAll = new HashMap();
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
            HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> cfg = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
            HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> prof = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
            HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> opt = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
            for (int i = 0; i < platforms.length; ++i) {
                J2MEPlatform platform;
                if (!(platforms[i] instanceof J2MEPlatform) || !(platform = (J2MEPlatform)platforms[i]).isValid()) continue;
                this.name2platform.put(platform.getDisplayName(), platform);
                Profile[] profiles = platform.getSpecification().getProfiles();
                for (int j = 0; j < profiles.length; ++j) {
                    if (!(profiles[j] instanceof J2MEPlatform.J2MEProfile)) continue;
                    J2MEPlatform.J2MEProfile p = (J2MEPlatform.J2MEProfile)profiles[j];
                    if ("configuration".equals(p.getType())) {
                        p = this.takeBetter(p, (J2MEPlatform.J2MEProfile)cfg.remove(p));
                        cfg.put(p, p);
                        continue;
                    }
                    if ("profile".equals(p.getType())) {
                        p = this.takeBetter(p, (J2MEPlatform.J2MEProfile)prof.remove(p));
                        prof.put(p, p);
                        continue;
                    }
                    if (!"optional".equals(p.getType())) continue;
                    p = this.takeBetter(p, (J2MEPlatform.J2MEProfile)opt.remove(p));
                    opt.put(p, p);
                    this.name2profileAll.put(p.toString(), p);
                }
            }
            this.platformNames = this.name2platform.keySet().toArray(new String[this.name2platform.size()]);
            Arrays.sort(this.platformNames);
            J2MEPlatform.J2MEProfile[] arr = cfg.values().toArray(new J2MEPlatform.J2MEProfile[cfg.size()]);
            this.initConfigurations(arr);
            arr = prof.values().toArray(new J2MEPlatform.J2MEProfile[prof.size()]);
            this.initProfiles(arr);
            arr = opt.values().toArray(new J2MEPlatform.J2MEProfile[opt.size()]);
            this.initOptional(arr);
        }
    }

    private J2MEPlatform.J2MEProfile takeBetter(J2MEPlatform.J2MEProfile p1, J2MEPlatform.J2MEProfile p2) {
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        return p1.getDisplayNameWithVersion().length() > p2.getDisplayNameWithVersion().length() ? p1 : p2;
    }

    private void initConfigurations(J2MEPlatform.J2MEProfile[] cfgs) {
        Arrays.sort(cfgs);
        for (int i = 0; i < cfgs.length; ++i) {
            JRadioButton btn = new JRadioButton(cfgs[i].toString());
            btn.setToolTipText(cfgs[i].getDisplayNameWithVersion());
            btn.setActionCommand(cfgs[i].toString());
            this.cfgGroup.add(btn);
            this.jPanelConfig.add(btn);
            Dimension preferredSize = btn.getPreferredSize();
            if (this.firstConfigWidth == -1) {
                this.firstConfigWidth = preferredSize.width + 10;
                btn.setPreferredSize(new Dimension(this.firstConfigWidth, preferredSize.height));
                btn.setMinimumSize(new Dimension(this.firstConfigWidth, preferredSize.height));
            } else {
                btn.setPreferredSize(new Dimension(this.firstConfigWidth, preferredSize.height));
                btn.setMinimumSize(new Dimension(this.firstConfigWidth, preferredSize.height));
            }
            btn.addActionListener(this);
        }
    }

    private void initProfiles(J2MEPlatform.J2MEProfile[] profs) {
        Arrays.sort(profs);
        for (int i = 0; i < profs.length; ++i) {
            JRadioButton btn = new JRadioButton(profs[i].toString());
            btn.setToolTipText(profs[i].getDisplayNameWithVersion());
            btn.setActionCommand(profs[i].toString());
            btn.setPreferredSize(new Dimension(this.firstConfigWidth, btn.getPreferredSize().height));
            btn.setMinimumSize(new Dimension(this.firstConfigWidth, btn.getPreferredSize().height));
            this.profGroup.add(btn);
            this.jPanelProfile.add(btn);
            btn.addActionListener(this);
        }
    }

    private void initOptional(J2MEPlatform.J2MEProfile[] opts) {
        Arrays.sort(opts, OPTIONAL_API_COMPARATOR);
        for (int i = 0; i < opts.length; ++i) {
            String dName = opts[i].isNameIsJarFileName() ? opts[i].getDisplayName() : opts[i].getDisplayNameWithVersion();
            JCheckBox cb = new JCheckBox(dName);
            cb.setToolTipText(dName);
            cb.setActionCommand(opts[i].toString());
            this.optional.add(cb);
            cb.addActionListener(this);
        }
    }

    @Override
    public void initValues(ProjectProperties props, String configuration) {
        this.props = props;
        this.vps = VisualPropertySupport.getDefault(props);
        this.configuration = configuration;
    }

    @Override
    public void initGroupValues(boolean useDefault) {
        this.jComboBoxTarget.removeActionListener(this);
        if (this.platformNames.length > 0) {
            this.vps.register(this.jComboBoxTarget, this.platformNames, "platform.active", useDefault);
            this.useDefault = useDefault;
            this.jComboBoxTarget.addActionListener(this);
        } else {
            this.jComboBoxTarget.removeAllItems();
            String errorMessage = NbBundle.getMessage(CustomizerMIDP.class, (String)"ERR_CustMIDP_NoPlatform");
            this.jComboBoxTarget.addItem(errorMessage);
            this.jComboBoxTarget.setSelectedItem(errorMessage);
            this.jComboBoxTarget.setEnabled(false);
        }
        this.initDevices((String)this.jComboBoxTarget.getSelectedItem(), false);
        this.enableLabels(!useDefault);
        this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "javac.source", useDefault), "1.3");
        this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "javac.target", useDefault), "1.3");
    }

    private void enableLabels(boolean enabled) {
        this.jLabelDevice.setEnabled(enabled);
        this.jLabelConfig.setEnabled(enabled);
        this.jLabelTarget.setEnabled(enabled);
        this.jLabelOptional.setEnabled(enabled);
        this.jLabelProfile.setEnabled(enabled);
        this.jButtonEdit.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.jComboBoxTarget.equals(e.getSource())) {
            this.initDevices((String)this.jComboBoxTarget.getSelectedItem(), true);
        } else if (this.jComboDevice.equals(e.getSource())) {
            this.initAllProfiles((String)this.jComboDevice.getSelectedItem(), true);
        } else if (e.getSource() instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)e.getSource();
            if (cb.isSelected()) {
                this.detectCollisions(cb.getActionCommand(), this.optionDefaults);
            } else {
                this.optionDefaults.remove(cb.getActionCommand());
            }
            this.saveOptionalAPIs();
            this.saveClassPath();
        } else if (e.getSource() instanceof JRadioButton) {
            this.saveClassPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDevices(String platformName, boolean reset) {
        Object object = this.lock;
        synchronized (object) {
            J2MEPlatform platform = this.name2platform.get(platformName);
            if (platform != null) {
                this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "platform.active.description", this.useDefault), platform.getDisplayName());
                this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "platform.type", this.useDefault), platform.getType());
                J2MEPlatform.Device[] devices = platform.getDevices();
                this.jComboDevice.removeActionListener(this);
                this.name2device = new HashMap();
                for (int i = 0; i < devices.length; ++i) {
                    if (!devices[i].isValid()) continue;
                    this.name2device.put(devices[i].getName(), devices[i]);
                }
                Object[] devNames = this.name2device.keySet().toArray(new String[this.name2device.size()]);
                Arrays.sort(devNames);
                this.vps.register(this.jComboDevice, devNames, "platform.device", this.useDefault);
                this.initAllProfiles((String)this.jComboDevice.getSelectedItem(), reset);
                this.jComboDevice.addActionListener(this);
            } else {
                this.jComboDevice.removeAllItems();
                this.jComboDevice.setEnabled(false);
                this.enableLabels(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAllProfiles(String deviceName, boolean reset) {
        Object object = this.lock;
        synchronized (object) {
            JRadioButton rb;
            int i;
            HashMap<String, J2MEPlatform.J2MEProfile> optProfiles = new HashMap<String, J2MEPlatform.J2MEProfile>();
            J2MEPlatform.Device device = this.name2device.get(deviceName);
            HashSet<String> profNames = new HashSet<String>();
            String defaultCfg = null;
            String defaultProf = null;
            HashSet<String> defaultOpts = new HashSet<String>();
            this.name2profile = new HashMap();
            if (device != null) {
                J2MEPlatform.J2MEProfile[] prof = device.getProfiles();
                for (i = 0; i < prof.length; ++i) {
                    profNames.add(prof[i].toString());
                    this.name2profile.put(prof[i].toString(), prof[i]);
                    if ("configuration".equals(prof[i].getType()) && prof[i].isDefault()) {
                        defaultCfg = prof[i].toString();
                        continue;
                    }
                    if ("profile".equals(prof[i].getType()) && prof[i].isDefault()) {
                        defaultProf = prof[i].toString();
                        continue;
                    }
                    if (!"optional".equals(prof[i].getType()) || !prof[i].isDefault()) continue;
                    optProfiles.put(prof[i].toString(), prof[i]);
                    defaultOpts.add(prof[i].toString());
                }
            }
            Component[] c = this.jPanelConfig.getComponents();
            for (i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof JRadioButton)) continue;
                rb = (JRadioButton)c[i];
                this.vps.register(rb, "platform.configuration", this.useDefault);
                if (profNames.contains(rb.getActionCommand())) {
                    rb.setEnabled(!this.useDefault);
                    continue;
                }
                rb.setEnabled(false);
            }
            if (reset && defaultCfg != null) {
                this.selectDefault(this.jPanelConfig, defaultCfg, "platform.configuration");
            }
            reset = (c = this.jPanelProfile.getComponents()).length > 0;
            for (i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof JRadioButton)) continue;
                rb = (JRadioButton)c[i];
                this.vps.register(rb, "platform.profile", this.useDefault);
                if (profNames.contains(rb.getActionCommand())) {
                    rb.setEnabled(!this.useDefault);
                } else {
                    rb.setEnabled(false);
                }
                if (!rb.isSelected() || !rb.isEnabled()) continue;
                reset = false;
            }
            if (reset && defaultCfg != null) {
                this.selectDefault(this.jPanelProfile, defaultProf, "platform.profile");
            }
            this.optionDefaults = this.getOptionalValues(true);
            Set<String> optValues = this.getOptionalValues(false);
            this.jPanelOptional.setVisible(false);
            this.jPanelOptional.removeAll();
            for (JCheckBox cb : this.removeDuplicateOptProfiles(optProfiles)) {
                String APIname = cb.getActionCommand();
                boolean defaultSelected = this.optionDefaults.contains(APIname);
                boolean selected = (reset ? defaultOpts : optValues).contains(APIname);
                if (selected && !defaultSelected) {
                    this.optionDefaults.add(APIname);
                }
                this.jPanelOptional.add((Component)cb, new GridBagConstraints(0, -1, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
                cb.setEnabled(!this.useDefault);
                cb.setSelected(selected || defaultSelected);
            }
            this.jPanelOptional.add((Component)new JPanel(), new GridBagConstraints(0, -1, 0, 0, 1.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelOptional.setVisible(true);
            this.jPanelOptional.repaint();
            this.jPanelOptional.validate();
            this.saveOptionalAPIs();
            this.saveClassPath();
        }
    }

    private List<JCheckBox> removeDuplicateOptProfiles(Map<String, J2MEPlatform.J2MEProfile> profiles) {
        ArrayList<JCheckBox> result = new ArrayList<JCheckBox>(this.optional.size());
        for (JCheckBox checkBox : this.optional) {
            if (profiles.get(checkBox.getActionCommand()) == null) continue;
            JCheckBox box = new JCheckBox(checkBox.getText());
            box.setToolTipText(checkBox.getToolTipText());
            box.setActionCommand(checkBox.getActionCommand());
            box.addActionListener(this);
            result.add(box);
        }
        Collection<J2MEPlatform.J2MEProfile> values = profiles.values();
        HashMap<String, LinkedList<J2MEPlatform.J2MEProfile>> classpaths = new HashMap<String, LinkedList<J2MEPlatform.J2MEProfile>>();
        for (J2MEPlatform.J2MEProfile profile : values) {
            String classpath = profile.getClassPath();
            LinkedList<J2MEPlatform.J2MEProfile> list = (LinkedList<J2MEPlatform.J2MEProfile>)classpaths.get(classpath);
            if (list == null) {
                list = new LinkedList<J2MEPlatform.J2MEProfile>();
                classpaths.put(classpath, list);
            }
            list.add(profile);
        }
        ArrayList<JCheckBox> res = new ArrayList<JCheckBox>(result.size());
        HashMap<String, JCheckBox> classPath2checkBox = new HashMap<String, JCheckBox>();
        StringBuilder textBuilder = new StringBuilder();
        StringBuilder tooltipBuilder = new StringBuilder();
        for (JCheckBox option : result) {
            String command = option.getActionCommand();
            J2MEPlatform.J2MEProfile profile = profiles.get(command);
            String classPath = profile.getClassPath();
            List list = (List)classpaths.get(classPath);
            if (list.size() > 1) {
                JCheckBox checkBox = (JCheckBox)classPath2checkBox.get(classPath);
                if (checkBox == null) {
                    classPath2checkBox.put(classPath, option);
                    res.add(option);
                    continue;
                }
                String text = checkBox.getText();
                String tooltip = checkBox.getToolTipText();
                textBuilder.setLength(0);
                tooltipBuilder.setLength(0);
                if (!text.contains(option.getText())) {
                    textBuilder.append(text);
                    textBuilder.append(", ");
                    textBuilder.append(option.getText());
                    checkBox.setText(textBuilder.toString());
                }
                if (tooltip.contains(option.getToolTipText())) continue;
                tooltipBuilder.append(tooltip);
                tooltipBuilder.append(", ");
                tooltipBuilder.append(option.getToolTipText());
                checkBox.setToolTipText(tooltipBuilder.toString());
                continue;
            }
            res.add(option);
        }
        return res;
    }

    private Set<String> getOptionalValues(boolean shared) {
        String s = (String)this.props.get(VisualPropertySupport.translatePropertyName(this.configuration, shared ? "platform.apis.defaults" : "platform.apis", this.useDefault));
        HashSet<String> vals = new HashSet<String>();
        if (s == null) {
            return vals;
        }
        StringTokenizer stk = new StringTokenizer(s, ",");
        while (stk.hasMoreTokens()) {
            vals.add(stk.nextToken());
        }
        return vals;
    }

    private void selectDefault(JPanel panel, String name, String property) {
        Component[] c = panel.getComponents();
        for (int i = 0; i < c.length; ++i) {
            JRadioButton rb;
            if (!(c[i] instanceof JRadioButton) || !name.equals((rb = (JRadioButton)c[i]).getActionCommand())) continue;
            this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, property, this.useDefault), name);
            this.vps.register(rb, property, this.useDefault);
        }
    }

    private void detectCollisions(String apiName, Set<String> options) {
        J2MEPlatform.J2MEProfile newProfile = this.name2profile.get(apiName);
        if (newProfile == null) {
            return;
        }
        Component[] c = this.jPanelOptional.getComponents();
        for (int i = 0; i < c.length - 1; ++i) {
            J2MEPlatform.J2MEProfile profile;
            JCheckBox cb = (JCheckBox)c[i];
            if (!cb.isSelected() || (profile = this.name2profile.get(cb.getActionCommand())) == null || profile.equals((Object)newProfile) || !profile.getName().equals(newProfile.getName()) || !cb.isEnabled()) continue;
            cb.setSelected(false);
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String s : options) {
            J2MEPlatform.J2MEProfile profile = this.name2profileAll.get(s);
            if (profile == null || profile.equals((Object)newProfile) || !profile.getName().equals(newProfile.getName())) continue;
            toRemove.add(s);
        }
        options.removeAll(toRemove);
        options.add(apiName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOptionalAPIs() {
        Object object = this.lock;
        synchronized (object) {
            StringBuffer sb = new StringBuffer();
            Component[] c = this.jPanelOptional.getComponents();
            for (int i = 0; i < c.length - 1; ++i) {
                JCheckBox cb = (JCheckBox)c[i];
                if (!cb.isSelected()) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(cb.getActionCommand());
            }
            String propName = VisualPropertySupport.translatePropertyName(this.configuration, "platform.apis", this.useDefault);
            this.props.put(propName, sb.toString());
            StringBuffer sb2 = new StringBuffer();
            for (String s : this.optionDefaults) {
                if (sb2.length() > 0) {
                    sb2.append(',');
                }
                sb2.append(s);
            }
            String propName2 = VisualPropertySupport.translatePropertyName(this.configuration, "platform.apis.defaults", this.useDefault);
            this.props.put(propName2, sb2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveClassPath() {
        Object object = this.lock;
        synchronized (object) {
            J2MEPlatform.J2MEProfile profile;
            JRadioButton rb;
            int i;
            StringBuffer classpath = new StringBuffer();
            Component[] c = this.jPanelConfig.getComponents();
            for (i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof JRadioButton) || !(rb = (JRadioButton)c[i]).isSelected() || (profile = this.name2profile.get(rb.getActionCommand())) == null) continue;
                if (classpath.length() > 0) {
                    classpath.append(':');
                }
                classpath.append(profile.getClassPath());
            }
            c = this.jPanelProfile.getComponents();
            for (i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof JRadioButton) || !(rb = (JRadioButton)c[i]).isSelected() || (profile = this.name2profile.get(rb.getActionCommand())) == null) continue;
                if (classpath.length() > 0) {
                    classpath.append(':');
                }
                classpath.append(profile.getClassPath());
            }
            c = this.jPanelOptional.getComponents();
            for (i = 0; i < c.length - 1; ++i) {
                JCheckBox cb = (JCheckBox)c[i];
                if (!cb.isSelected() || (profile = this.name2profile.get(cb.getActionCommand())) == null) continue;
                if (classpath.length() > 0) {
                    classpath.append(':');
                }
                classpath.append(profile.getClassPath());
            }
            J2MEPlatform.Device device = this.name2device.get(this.jComboDevice.getSelectedItem());
            this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "platform.bootclasspath", this.useDefault), device == null ? classpath.toString() : device.sortClasspath(classpath.toString()));
        }
    }

    private void initComponents() {
        this.cfgGroup = new ButtonGroup();
        this.profGroup = new ButtonGroup();
        this.jLabelTarget = new JLabel();
        this.jComboBoxTarget = new JComboBox();
        this.jButtonEdit = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabelDevice = new JLabel();
        this.jComboDevice = new JComboBox();
        this.jLabelConfig = new JLabel();
        this.jPanelConfig = new JPanel();
        this.jLabelProfile = new JLabel();
        this.jPanelProfile = new JPanel();
        this.jLabelOptional = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelOptional = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabelTarget.setLabelFor(this.jComboBoxTarget);
        Mnemonics.setLocalizedText((JLabel)this.jLabelTarget, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_TargetPlatform"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelTarget, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jComboBoxTarget, gridBagConstraints);
        this.jComboBoxTarget.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDP.class, (String)"ACSD_CustMIDP_Platform"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonEdit, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_Edit"));
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerMIDP.this.jButtonEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jButtonEdit, gridBagConstraints);
        this.jButtonEdit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDP.class, (String)"ACSD_CustMIDP_Edit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabelDevice.setLabelFor(this.jComboDevice);
        Mnemonics.setLocalizedText((JLabel)this.jLabelDevice, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_Device"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabelDevice, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.jComboDevice, gridBagConstraints);
        this.jComboDevice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDP.class, (String)"ACSD_CustMIDP_Device"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelConfig, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_Configuration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabelConfig, gridBagConstraints);
        this.jPanelConfig.setLayout(new GridLayout(1, 0, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.add((Component)this.jPanelConfig, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelProfile, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_Profile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabelProfile, gridBagConstraints);
        this.jPanelProfile.setLayout(new GridLayout(1, 0, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.jPanelProfile, gridBagConstraints);
        this.jLabelOptional.setLabelFor(this.jPanelOptional);
        Mnemonics.setLocalizedText((JLabel)this.jLabelOptional, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_Optional"));
        this.jLabelOptional.setToolTipText(NbBundle.getMessage(CustomizerMIDP.class, (String)"WARN_Optional_Packages"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabelOptional, gridBagConstraints);
        this.jPanelOptional.setToolTipText(NbBundle.getMessage(CustomizerMIDP.class, (String)"WARN_Optional_Packages"));
        this.jPanelOptional.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanelOptional);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerMIDP.class, (String)"ACSN_CustMIDP"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDP.class, (String)"ACSD_CustMIDP"));
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.name2platform.get(this.jComboBoxTarget.getSelectedItem())));
        this.refreshAll();
    }

    @Override
    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }
}

