/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.mobility.project.PropertyDescriptor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.mobility.project.CDCMainClassHelper;
import org.netbeans.modules.mobility.project.J2MEActionProvider;
import org.netbeans.modules.mobility.project.J2MEProjectOperations;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.MIDletsCacheHelper;
import org.netbeans.modules.mobility.project.PreprocessorFileFilterImplementation;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.TextSwitcher;
import org.netbeans.modules.mobility.project.classpath.J2MEClassPathProvider;
import org.netbeans.modules.mobility.project.classpath.J2MEProjectClassPathExtender;
import org.netbeans.modules.mobility.project.deployment.DeploymentPropertiesHandler;
import org.netbeans.modules.mobility.project.queries.CompiledSourceForBinaryQuery;
import org.netbeans.modules.mobility.project.queries.FileBuiltQueryImpl;
import org.netbeans.modules.mobility.project.queries.FileEncodingQueryImpl;
import org.netbeans.modules.mobility.project.queries.JavadocForBinaryQueryImpl;
import org.netbeans.modules.mobility.project.queries.SourceLevelQueryImpl;
import org.netbeans.modules.mobility.project.security.KeyStoreRepository;
import org.netbeans.modules.mobility.project.ui.J2MECustomizerProvider;
import org.netbeans.modules.mobility.project.ui.J2MEPhysicalViewProvider;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.mobility.deployment.DeploymentPlugin;
import org.netbeans.spi.mobility.project.ProjectLookupProvider;
import org.netbeans.spi.mobility.project.ProjectPropertiesDescriptor;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class J2MEProject
implements Project,
AntProjectListener {
    final Icon J2ME_PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mobility/project/ui/resources/mobile-project.png", (boolean)false);
    private static final URLStreamHandler COMPOSED_STREAM_HANDLER = new URLStreamHandler(){

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new ComposedConnection(u);
        }
    };
    static final String CONFIGS_NAME = "configurations";
    static final String CONFIG_NAME = "configuration";
    static final String CONFIGS_NS = "http://www.netbeans.org/ns/project-configurations/1";
    static final String CLASSPATH = "classpath";
    final AuxiliaryConfiguration aux;
    final AntProjectHelper helper;
    final GeneratedFilesHelper genFilesHelper;
    Lookup lookup;
    final MIDletsCacheHelper midletsCacheHelper;
    final ProjectConfigurationsHelper configHelper;
    private static final Set<FileObject> roots = new HashSet<FileObject>();
    private static final Map<FileObject, Boolean> folders = new WeakHashMap<FileObject, Boolean>();
    private static final RequestProcessor RP = new RequestProcessor();
    private final ReferenceHelper refHelper;
    private final PropertyChangeSupport pcs;
    private final RequestProcessor rp;
    private TextSwitcher textSwitcher;
    private static final String LOOK_FOR_PROJECT = ".*<type>org.netbeans.modules.kjava.j2meproject</type>";
    private static final Pattern PROJECT_PATTERN = Pattern.compile(".*<type>org.netbeans.modules.kjava.j2meproject</type>", 32);
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static boolean isJ2MEFile(FileObject fo) {
        if (fo == null) {
            return false;
        }
        FileObject archiveRoot = FileUtil.getArchiveFile((FileObject)fo);
        if (archiveRoot != null) {
            fo = archiveRoot;
        }
        return J2MEProject.isJ2MEFolder(fo.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isJ2MEFolder(FileObject fo) {
        Boolean result;
        if (fo == null) {
            return false;
        }
        Set<FileObject> set = roots;
        synchronized (set) {
            if (roots.contains(fo)) {
                return true;
            }
        }
        Map<FileObject, Boolean> map = folders;
        synchronized (map) {
            result = folders.get(fo);
        }
        if (result == null) {
            Object object;
            FileObject xml;
            if (fo.isFolder() && (xml = fo.getFileObject("nbproject/project.xml")) != null) {
                result = J2MEProject.isJ2MEProjectXML(xml);
                if (result.booleanValue()) {
                    object = roots;
                    synchronized (object) {
                        roots.add(fo);
                    }
                }
            } else {
                result = J2MEProject.isJ2MEFolder(fo.getParent());
            }
            object = folders;
            synchronized (object) {
                folders.put(fo, result);
            }
        }
        return result;
    }

    public boolean isConfigBroken(ProjectConfiguration cfg) {
        cfg = cfg == null ? this.configHelper.getActiveConfiguration() : cfg;
        String[] breakableConfigProperties = this.getBreakableProperties(cfg);
        String[] breakableConfigPlatformProperties = this.getBreakablePlatformProperties(cfg);
        boolean result = BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper, (ReferenceHelper)this.refHelper, (String[])breakableConfigProperties, (String[])breakableConfigPlatformProperties);
        return result || breakableConfigProperties != null && breakableConfigProperties[1] != null && breakableConfigProperties[1].contains("${");
    }

    public RequestProcessor getRequestProcessor() {
        return this.rp;
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper, (ReferenceHelper)this.refHelper, (String[])this.getBreakableProperties(), (String[])this.getBreakablePlatformProperties());
    }

    private String[] getBreakableProperties(ProjectConfiguration cfg) {
        String[] s = new String[]{"src.dir", this.usedLibs(cfg), this.configHelper.getDefaultConfiguration().equals(cfg) ? "sign.keystore" : "configs." + cfg.getDisplayName() + "." + "sign.keystore"};
        return s;
    }

    private String usedActive(ProjectConfiguration cfg) {
        String libs;
        libs = cfg.equals(this.getConfigurationHelper().getDefaultConfiguration()) ? "platform.active" : ((libs = this.helper.getStandardPropertyEvaluator().getProperty("configs." + cfg.getDisplayName() + "." + "platform.active")) == null ? "platform.active" : "configs." + cfg.getDisplayName() + "." + "platform.active");
        return libs;
    }

    private String[] getBreakablePlatformProperties(ProjectConfiguration cfg) {
        String[] s = new String[]{this.usedActive(cfg)};
        return s;
    }

    public String[] getBreakableProperties() {
        ProjectConfiguration[] pc = this.configHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
        String[] s = new String[2 * pc.length + 1];
        s[0] = "src.dir";
        for (int i = 0; i < pc.length; ++i) {
            if (this.configHelper.getDefaultConfiguration().equals(pc[i])) {
                s[2 * i + 1] = "libs.classpath";
                s[2 * i + 2] = "sign.keystore";
                continue;
            }
            s[2 * i + 1] = "configs." + pc[i].getDisplayName() + "." + "libs.classpath";
            s[2 * i + 2] = "configs." + pc[i].getDisplayName() + "." + "sign.keystore";
        }
        return s;
    }

    public String[] getBreakablePlatformProperties() {
        ProjectConfiguration[] pc = this.configHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
        String[] s = new String[pc.length];
        for (int i = 0; i < pc.length; ++i) {
            s[i] = this.configHelper.getDefaultConfiguration().equals(pc[i]) ? "platform.active" : "configs." + pc[i].getDisplayName() + "." + "platform.active";
        }
        return s;
    }

    public boolean isUsingDefaultLibs(ProjectConfiguration config) {
        ProjectConfiguration cfg;
        ProjectConfiguration projectConfiguration = cfg = config == null ? this.getConfigurationHelper().getActiveConfiguration() : config;
        return cfg == null ? false : this.usedLibs(cfg) == null;
    }

    public boolean canModifyLibraries(ProjectConfiguration config) {
        return !this.isUsingDefaultLibs(config);
    }

    public boolean isInDefaultConfiguration() {
        return this.configHelper.getDefaultConfiguration().equals(this.configHelper.getActiveConfiguration());
    }

    public String usedLibs(ProjectConfiguration cfg) {
        if (cfg == null) {
            return null;
        }
        String libs = cfg.getDisplayName().equals(this.getConfigurationHelper().getDefaultConfiguration().getDisplayName()) ? this.helper.getStandardPropertyEvaluator().getProperty("libs.classpath") : this.helper.getStandardPropertyEvaluator().getProperty("configs." + cfg.getDisplayName() + "." + "libs.classpath");
        return libs;
    }

    protected static void addRoots(AntProjectHelper helper) {
        String src = helper.getStandardPropertyEvaluator().getProperty("src.dir");
        if (src != null) {
            J2MEProject.addRoot(helper.resolveFileObject(src));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRoot(final FileObject fo) {
        if (fo != null && !J2MEProject.isJ2MEFile(fo)) {
            Set<FileObject> set = roots;
            synchronized (set) {
                if (roots.add(fo)) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            Enumeration en = fo.getChildren(true);
                            while (en.hasMoreElements()) {
                                try {
                                    FileObject f2 = (FileObject)en.nextElement();
                                    if (!f2.getExt().equals("java")) continue;
                                    DataObject.find((FileObject)f2).setValid(false);
                                }
                                catch (Exception exception) {}
                            }
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isJ2MEProjectXML(FileObject fo) {
        boolean result;
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            return false;
        }
        FileInputStream in = null;
        AbstractInterruptibleChannel channel = null;
        try {
            in = new FileInputStream(file);
            channel = in.getChannel();
            ByteBuffer buf = ByteBuffer.allocate((int)file.length());
            ((FileChannel)channel).read(buf);
            buf.rewind();
            CharBuffer chars = UTF8.decode(buf);
            result = PROJECT_PATTERN.matcher(chars).lookingAt();
        }
        catch (IOException ioe) {
            result = false;
            Exceptions.printStackTrace((Throwable)ioe);
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    result = false;
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    result = false;
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return result;
    }

    public J2MEProject(AntProjectHelper helper) {
        this.rp = new RequestProcessor("RP for " + helper.getProjectDirectory().getPath(), 2, true);
        this.helper = helper;
        J2MEProject.addRoots(helper);
        this.aux = helper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(helper, this.aux, helper.getStandardPropertyEvaluator());
        this.configHelper = new ProjectConfigurationsHelper(helper, this);
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        this.midletsCacheHelper = new MIDletsCacheHelper(helper, this.configHelper);
        helper.addAntProjectListener((AntProjectListener)new CDCMainClassHelper(helper));
        this.pcs = new PropertyChangeSupport(this);
        this.lookup = this.createLookup(this.aux);
        helper.addAntProjectListener((AntProjectListener)this);
    }

    public void hookNewProjectCreated() {
        this.midletsCacheHelper.refresh();
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ProjectConfigurationsHelper getConfigurationHelper() {
        return this.configHelper;
    }

    private Lookup createLookup(AuxiliaryConfiguration aux) {
        Lookup base;
        SourcesHelper sourcesHelper = new SourcesHelper((Project)this, this.helper, this.helper.getStandardPropertyEvaluator());
        sourcesHelper.addPrincipalSourceRoot("${src.dir}", NbBundle.getMessage(J2MEProject.class, (String)"LBL_J2MEProject_Source_Packages"), null, null);
        sourcesHelper.addTypedSourceRoot("${src.dir}", "java", NbBundle.getMessage(J2MEProject.class, (String)"LBL_J2MEProject_Source_Packages"), null, null);
        SubprojectProvider spp = this.refHelper.createSubprojectProvider();
        J2MEActionProvider actionProvider = new J2MEActionProvider(this, this.helper);
        Object[] stdLookups = new Object[]{this, new Info(), this.rp, aux, spp, this.configHelper, this.helper, this.midletsCacheHelper, this.refHelper, new FileBuiltQueryImpl(this.helper, this.configHelper), actionProvider, new J2MEPhysicalViewProvider(this, this.helper, this.refHelper, this.configHelper), new J2MECustomizerProvider(this, this.helper, this.refHelper, this.configHelper), new J2MEClassPathProvider(this.helper), new CompiledSourceForBinaryQuery(this, this.helper), new AntArtifactProviderImpl(), new ProjectXmlSavedHookImpl(), new ProjectOpenedHookImpl(), new JavadocForBinaryQueryImpl(this, this.helper), this.helper.createSharabilityQuery(this.helper.getStandardPropertyEvaluator(), new String[]{"${src.dir}"}, new String[]{"${dist.root.dir}", "${build.root.dir}", "${deployment.copy.target}"}), sourcesHelper.createSources(), new RecommendedTemplatesImpl(), new SourceLevelQueryImpl(this.helper), new J2MEProjectClassPathExtender(this, this.helper, this.refHelper, this.configHelper), new J2MEProjectOperations(this, this.helper, this.refHelper, actionProvider), new PreprocessorFileFilterImplementation(this.configHelper, this.helper), new FileEncodingQueryImpl(this.helper), LookupProviderSupport.createActionProviderMerger()};
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(stdLookups));
        for (ProjectLookupProvider provider : Lookup.getDefault().lookupAll(ProjectLookupProvider.class)) {
            list.addAll(provider.createLookupElements(this, this.helper, this.refHelper, this.configHelper));
        }
        this.lookup = base = Lookups.fixed((Object[])list.toArray());
        return LookupProviderSupport.createCompositeLookup((Lookup)base, (String)"Projects/org-netbeans-modules-mobility-project/Lookup");
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                Element nameEl;
                Element data = J2MEProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2me-project", "name");
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/j2me-project", "name");
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                J2MEProject.this.helper.putPrimaryConfigurationData(data, true);
                return null;
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        if (ev.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    protected void refreshPrivateProperties() throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() {
                    boolean modified = false;
                    EditableProperties proj = J2MEProject.this.helper.getProperties("nbproject/project.properties");
                    EditableProperties priv = J2MEProject.this.helper.getProperties("nbproject/private/private.properties");
                    priv.setProperty("netbeans.user", System.getProperty("netbeans.user"));
                    for (ProjectPropertiesDescriptor p : Lookup.getDefault().lookup(new Lookup.Template(ProjectPropertiesDescriptor.class)).allInstances()) {
                        for (PropertyDescriptor d : p.getPropertyDescriptors()) {
                            EditableProperties ep;
                            if (d.getDefaultValue() == null || (ep = d.isShared() ? proj : priv).containsKey((Object)d.getName())) continue;
                            ep.setProperty(d.getName(), d.getDefaultValue());
                            modified = true;
                        }
                    }
                    Set cfgs = J2MEProject.this.removeConfigurationsFromProjectXml();
                    if (!cfgs.isEmpty()) {
                        modified = true;
                        cfgs.addAll(Arrays.asList(proj.getProperty("all.configurations").split(",")));
                        cfgs.remove(" ");
                        cfgs.remove("");
                        StringBuffer sb = new StringBuffer(" ");
                        for (String s : cfgs) {
                            sb.append(',').append(s);
                        }
                        proj.setProperty("all.configurations", sb.toString());
                    }
                    J2MEProject.this.helper.putProperties("nbproject/private/private.properties", priv);
                    if (modified) {
                        J2MEProject.this.helper.putProperties("nbproject/project.properties", proj);
                    }
                    try {
                        J2MEProject.this.refHelper.addExtraBaseDirectory("netbeans.user");
                    }
                    catch (IllegalArgumentException iae) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
        try {
            ProjectManager.getDefault().saveProject((Project)this);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private Set<String> removeConfigurationsFromProjectXml() {
        TreeSet<String> cfgs = new TreeSet<String>();
        Element configs = this.aux.getConfigurationFragment(CONFIGS_NAME, CONFIGS_NS, true);
        if (configs != null) {
            try {
                NodeList subEls = configs.getElementsByTagNameNS(CONFIGS_NS, CONFIG_NAME);
                for (int i = 0; i < subEls.getLength(); ++i) {
                    NodeList l = subEls.item(i).getChildNodes();
                    for (int j = 0; j < l.getLength(); ++j) {
                        if (l.item(j).getNodeType() != 3) continue;
                        cfgs.add(((Text)l.item(j)).getNodeValue());
                    }
                }
                this.aux.removeConfigurationFragment(CONFIGS_NAME, CONFIGS_NS, true);
            }
            catch (IllegalArgumentException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return cfgs;
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                Element data = J2MEProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2me-project", "name");
                if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                    return ((Text)nl.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    private void refreshBuildScripts(final boolean checkForProjectXmlModified) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                final FileObject root = FileUtil.getConfigFile((String)"Buildsystem/org.netbeans.modules.kjava.j2meproject");
                final LinkedList<FileObject> files = new LinkedList<FileObject>();
                files.addAll(Arrays.asList(root.getChildren()));
                ProjectManager.mutex().postWriteRequest(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            ProjectManager.getDefault().saveProject((Project)J2MEProject.this);
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().notify((Throwable)ioe);
                        }
                        URL u = null;
                        while (!files.isEmpty()) {
                            try {
                                FileObject fo = (FileObject)files.removeFirst();
                                if (fo.getExt().equals("xml") && J2MEProject.isAuthorized(fo)) {
                                    u = fo.isData() ? fo.getURL() : new URL("", null, -1, fo.getPath(), COMPOSED_STREAM_HANDLER);
                                    J2MEProject.this.genFilesHelper.refreshBuildScript(FileUtil.getRelativePath((FileObject)root, (FileObject)fo), u, checkForProjectXmlModified);
                                    continue;
                                }
                                if (!fo.isFolder()) continue;
                                files.addAll(Arrays.asList(fo.getChildren()));
                            }
                            catch (IOException ioe) {
                                ErrorManager.getDefault().notify((Throwable)ioe);
                                BufferedReader br = null;
                                if (u == null) continue;
                                try {
                                    String s;
                                    br = new BufferedReader(new InputStreamReader(u.openStream()));
                                    while ((s = br.readLine()) != null) {
                                        ErrorManager.getDefault().log(65536, s);
                                    }
                                }
                                catch (Exception e) {}
                                continue;
                                finally {
                                    if (br == null) continue;
                                    try {
                                        br.close();
                                    }
                                    catch (IOException e) {}
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private static boolean isAuthorized(FileObject fo) {
        return true;
    }

    private static String normalizePath(File path, File jdkHome, String propName) {
        String loc;
        String jdkLoc = jdkHome.getAbsolutePath();
        if (!jdkLoc.endsWith(File.separator)) {
            jdkLoc = jdkLoc + File.separator;
        }
        if ((loc = path.getAbsolutePath()).startsWith(jdkLoc)) {
            return "${" + propName + "}" + File.separator + loc.substring(jdkLoc.length());
        }
        return loc;
    }

    private List<ProjectConfiguration> getMatchingConfigs(String actualPlatformId) {
        ArrayList<ProjectConfiguration> configs = new ArrayList<ProjectConfiguration>();
        for (ProjectConfiguration config : this.getConfigurationHelper().getConfigurations()) {
            boolean useDef = config.equals(this.getConfigurationHelper().getDefaultConfiguration());
            String platformProp = VisualPropertySupport.translatePropertyName(config.getDisplayName(), "platform.active", useDef);
            String platformId = this.helper.getProperties("nbproject/project.properties").getProperty(platformProp);
            if (platformId == null || !platformId.equals(actualPlatformId)) continue;
            configs.add(config);
        }
        return configs;
    }

    private void generatePlatformProperties(CDCPlatform platform, ProjectConfiguration config, String activeDevice, String activeProfile, EditableProperties props) {
        Collection installFolders = platform.getInstallFolders();
        if (installFolders.size() > 0) {
            File jdkHome = FileUtil.toFile((FileObject)((FileObject)installFolders.iterator().next()));
            StringBuffer sbootcp = new StringBuffer();
            ClassPath bootCP = platform.getBootstrapLibrariesForProfile(activeDevice, activeProfile);
            for (ClassPath.Entry entry : bootCP.entries()) {
                URL url = entry.getURL();
                if ("jar".equals(url.getProtocol())) {
                    url = FileUtil.getArchiveFile((URL)url);
                }
                File root = new File(URI.create(url.toExternalForm()));
                if (sbootcp.length() > 0) {
                    sbootcp.append(File.pathSeparator);
                }
                sbootcp.append(J2MEProject.normalizePath(root, jdkHome, "platform.home"));
            }
            boolean useDef = config.equals(this.getConfigurationHelper().getDefaultConfiguration());
            props.setProperty(VisualPropertySupport.translatePropertyName(config.getDisplayName(), "platform.bootclasspath", useDef), sbootcp.toString());
        }
    }

    private void updateBootClassPathProperty(List<ProjectConfiguration> configs, CDCPlatform platform) {
        if (configs != null) {
            try {
                EditableProperties props = this.helper.getProperties("nbproject/project.properties");
                for (ProjectConfiguration config : configs) {
                    boolean useDef = config.equals(this.getConfigurationHelper().getDefaultConfiguration());
                    this.generatePlatformProperties(platform, config, props.getProperty(VisualPropertySupport.translatePropertyName(config.getDisplayName(), "platform.device", useDef)), props.getProperty(VisualPropertySupport.translatePropertyName(config.getDisplayName(), "platform.profile", useDef)), props);
                }
                this.helper.putProperties("nbproject/project.properties", props);
                ProjectManager.getDefault().saveProject((Project)this);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    public String toString() {
        return super.toString() + "[root=" + this.helper.getProjectDirectory().getPath() + ']';
    }

    private static final class ComposedConnection
    extends URLConnection {
        private static WeakHashMap<URL, byte[]> cache = new WeakHashMap();

        public ComposedConnection(URL u) {
            super(u);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized InputStream getInputStream() throws IOException {
            boolean log = Boolean.getBoolean("mobility.report.composed.stylesheets");
            byte[] data = cache.get(this.getURL());
            if (data == null) {
                DataFolder root = DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)this.getURL().getPath()));
                DataObject[] mainParts = root.getChildren();
                StringBuffer sb = new StringBuffer();
                String lastTarget = "";
                for (int i = 0; i < mainParts.length; ++i) {
                    if (mainParts[i] instanceof DataFolder) {
                        DataObject[] subParts = ((DataFolder)mainParts[i]).getChildren();
                        StringBuffer subTargets = new StringBuffer(lastTarget);
                        for (int j = 0; j < subParts.length; ++j) {
                            FileObject fo = subParts[j].getPrimaryFile();
                            if (!fo.isData() || !J2MEProject.isAuthorized(fo)) continue;
                            String s = this.read(subParts[j].getPrimaryFile(), lastTarget);
                            sb.append(s);
                            subTargets.append(',').append(subParts[j].getName());
                            if (!log) continue;
                            ErrorManager.getDefault().log(16, fo.getURL().toExternalForm() + '\n' + s + '\n');
                        }
                        lastTarget = subTargets.toString();
                        continue;
                    }
                    FileObject fo = mainParts[i].getPrimaryFile();
                    if (!J2MEProject.isAuthorized(fo)) continue;
                    String s = this.read(fo, lastTarget);
                    sb.append(s);
                    lastTarget = mainParts[i].getName();
                    if (!log) continue;
                    ErrorManager.getDefault().log(16, fo.getURL().toExternalForm() + '\n' + s + '\n');
                }
                data = sb.toString().getBytes("UTF-8");
                WeakHashMap<URL, byte[]> weakHashMap = cache;
                synchronized (weakHashMap) {
                    cache.put(this.getURL(), data);
                }
                if (log) {
                    ErrorManager.getDefault().log(16, this.getURL().toExternalForm() + '\n' + sb.toString() + '\n');
                }
            }
            return new ByteArrayInputStream(data);
        }

        @Override
        public void connect() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String read(FileObject fo, String dependencies) throws IOException {
            int i = (int)fo.getSize();
            byte[] buff = new byte[i];
            DataInputStream in = new DataInputStream(fo.getInputStream());
            try {
                in.readFully(buff);
                assert (in.read() == -1);
            }
            finally {
                in.close();
            }
            return new String(buff, "UTF-8").replace("__DEPENDS__", dependencies);
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String LOCATION = "RecommendedTemplates/org.netbeans.modules.kjava.j2meproject";

        private RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            FileObject root = FileUtil.getConfigFile((String)LOCATION);
            HashSet<String> result = new HashSet<String>();
            for (FileObject fo : root.getChildren()) {
                String s = (String)fo.getAttribute("RecommendedTemplates");
                if (s == null) continue;
                result.addAll(Arrays.asList(s.split(",")));
            }
            return result.toArray(new String[result.size()]);
        }

        public String[] getPrivilegedTemplates() {
            DataFolder root = DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)LOCATION));
            ArrayList<String> result = new ArrayList<String>();
            for (DataObject ch : root.getChildren()) {
                String s = (String)ch.getPrimaryFile().getAttribute("PriviledgedTemplates");
                if (s == null) continue;
                result.addAll(Arrays.asList(s.split(",")));
            }
            return result.toArray(new String[result.size()]);
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String prop) {
            this.pcs.firePropertyChange(prop, null, null);
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)J2MEProject.this.getName());
        }

        public String getDisplayName() {
            return J2MEProject.this.getName();
        }

        public Icon getIcon() {
            return J2MEProject.this.J2ME_PROJECT_ICON;
        }

        public Project getProject() {
            return J2MEProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    private class J2MEAntArtifact
    extends AntArtifact {
        private final String configuration;

        public J2MEAntArtifact(String configuration) {
            this.configuration = configuration;
        }

        public String getCleanTargetName() {
            return "clean";
        }

        public File getScriptLocation() {
            return J2MEProject.this.helper.resolveFile("build.xml");
        }

        public String getTargetName() {
            return "jar";
        }

        public String getType() {
            return "jar";
        }

        public Project getProject() {
            return J2MEProject.this;
        }

        public String getID() {
            return this.configuration == null ? super.getID() : super.getID() + "." + this.configuration;
        }

        public URI[] getArtifactLocations() {
            String locationResolved;
            PropertyEvaluator eval = J2MEProject.this.helper.getStandardPropertyEvaluator();
            String path = "dist/";
            if (this.configuration != null) {
                path = path + this.configuration + "/";
            }
            if ((locationResolved = eval.evaluate(path + J2MEProjectUtils.evaluateProperty(J2MEProject.this.helper, "dist.jar", this.configuration))) == null) {
                return new URI[0];
            }
            return new URI[]{this.getScriptLocation().getParentFile().toURI().relativize(J2MEProject.this.helper.resolveFile(locationResolved).toURI())};
        }

        public Properties getProperties() {
            Properties p = new Properties();
            p.put("config.active", this.configuration == null ? "" : this.configuration);
            return p;
        }
    }

    private final class AntArtifactProviderImpl
    implements AntArtifactProvider {
        private AntArtifactProviderImpl() {
        }

        public AntArtifact[] getBuildArtifacts() {
            ProjectConfiguration[] cfgs = J2MEProject.this.configHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
            AntArtifact[] art = new AntArtifact[cfgs.length];
            for (int i = 0; i < cfgs.length; ++i) {
                art[i] = new J2MEAntArtifact(J2MEProject.this.configHelper.getDefaultConfiguration().equals(cfgs[i]) ? null : cfgs[i].getDisplayName());
            }
            return art;
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook
    implements LookupListener {
        private boolean skipCloseHook = false;
        private PropertyChangeListener platformListener;
        private Lookup.Result deployments;

        ProjectOpenedHookImpl() {
        }

        protected synchronized void projectOpened() {
            Project other;
            this.deployments = Lookup.getDefault().lookup(new Lookup.Template(DeploymentPlugin.class));
            this.deployments.addLookupListener((LookupListener)this);
            this.resultChanged(new LookupEvent(this.deployments));
            KeyStoreRepository.getDefault();
            J2MEProject.addRoots(J2MEProject.this.helper);
            final SourcesHelper sourcesHelper = (SourcesHelper)J2MEProject.this.getLookup().lookup(SourcesHelper.class);
            String srcDir = J2MEProject.this.helper.getStandardPropertyEvaluator().getProperty("src.dir");
            final FileObject srcRoot = srcDir == null ? null : J2MEProject.this.helper.resolveFileObject(srcDir);
            Project project = other = srcRoot == null ? null : FileOwnerQuery.getOwner((FileObject)srcRoot);
            if (other != null && !J2MEProject.this.equals(other.getLookup().lookup(J2MEProject.class)) && Arrays.asList(OpenProjects.getDefault().getOpenProjects()).contains(other)) {
                String name = ProjectUtils.getInformation((Project)other).getDisplayName();
                if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(J2MEProject.class, (String)"MSG_ClashingSourceRoots", (Object)J2MEProject.this.getName(), (Object)name), 2, 2)))) {
                    OpenProjects.getDefault().close(new Project[]{other});
                } else {
                    this.skipCloseHook = true;
                    OpenProjects.getDefault().close(new Project[]{J2MEProject.this});
                    return;
                }
            }
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (sourcesHelper != null) {
                            sourcesHelper.registerExternalRoots(0);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    if (srcRoot != null) {
                        FileOwnerQuery.markExternalOwner((FileObject)srcRoot, (Project)J2MEProject.this, (int)0);
                    }
                }
            });
            try {
                J2MEProject.this.refreshBuildScripts(true);
                J2MEProject.this.refreshPrivateProperties();
                this.refreshBootClasspath();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            J2MEClassPathProvider cpProvider = (J2MEClassPathProvider)J2MEProject.this.lookup.lookup(J2MEClassPathProvider.class);
            assert (cpProvider != null);
            GlobalPathRegistry.getDefault().register("classpath/boot", new ClassPath[]{cpProvider.getBootClassPath()});
            GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{cpProvider.getSourcepath()});
            GlobalPathRegistry.getDefault().register("classpath/compile", new ClassPath[]{cpProvider.getCompileTimeClasspath()});
            J2MEProject.this.configHelper.addPropertyChangeListener(J2MEProject.this.textSwitcher = new TextSwitcher(J2MEProject.this, J2MEProject.this.helper));
            J2MEPhysicalViewProvider phvp = (J2MEPhysicalViewProvider)J2MEProject.this.lookup.lookup(J2MEPhysicalViewProvider.class);
            J2MEProject.this.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    if (J2MEProject.this.hasBrokenLinks()) {
                        BrokenReferencesSupport.showAlert();
                    }
                    J2MEProject.this.midletsCacheHelper.refresh();
                }
            });
        }

        protected synchronized void projectClosed() {
            if (this.skipCloseHook) {
                return;
            }
            this.deployments.removeLookupListener((LookupListener)this);
            try {
                ProjectManager.getDefault().saveProject((Project)J2MEProject.this);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            J2MEProject.this.configHelper.removePropertyChangeListener(J2MEProject.this.textSwitcher);
            J2MEClassPathProvider cpProvider = (J2MEClassPathProvider)J2MEProject.this.lookup.lookup(J2MEClassPathProvider.class);
            this.unregisterPath("classpath/boot", new ClassPath[]{cpProvider.getBootClassPath()});
            this.unregisterPath("classpath/source", new ClassPath[]{cpProvider.getSourcepath()});
            this.unregisterPath("classpath/compile", new ClassPath[]{cpProvider.getCompileTimeClasspath()});
            JavaPlatformManager.getDefault().removePropertyChangeListener(this.platformListener);
        }

        private void unregisterPath(String type, ClassPath[] paths) {
            try {
                GlobalPathRegistry.getDefault().unregister(type, paths);
            }
            catch (IllegalArgumentException iae) {
                Logger.getLogger(J2MEProject.class.getName()).log(Level.INFO, "Issue http://www.netbeans.org/nonav/issues/show_bug.cgi?id=150469 - unregistering non-existent path", iae);
            }
        }

        private void refreshBootClasspath() {
            JavaPlatform[] installedPlatforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("cdc", null));
            this.platformListener = new PlatformInstalledListener(installedPlatforms);
            JavaPlatformManager.getDefault().addPropertyChangeListener(this.platformListener);
        }

        public void resultChanged(LookupEvent e) {
            final Collection result = ((Lookup.Result)e.getSource()).allInstances();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    DeploymentPropertiesHandler.loadDeploymentProperties(result);
                }
            }, 200);
        }

        private final class PlatformInstalledListener
        implements PropertyChangeListener {
            final List<JavaPlatform> knownPlatforms;
            private final PropertyChangeListener platformChange = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CDCPlatform platform;
                    if (J2MEProject.CLASSPATH.equals(evt.getPropertyName()) && evt.getSource() instanceof CDCPlatform && (platform = (CDCPlatform)evt.getSource()) != null) {
                        List configs = J2MEProject.this.getMatchingConfigs((String)platform.getProperties().get("platform.ant.name"));
                        J2MEProject.this.updateBootClassPathProperty(configs, platform);
                    }
                }
            };

            PlatformInstalledListener(JavaPlatform[] known) {
                this.knownPlatforms = new ArrayList<JavaPlatform>(Arrays.asList(known));
                for (JavaPlatform plat : this.knownPlatforms) {
                    plat.addPropertyChangeListener(this.platformChange);
                    List configs = J2MEProject.this.getMatchingConfigs((String)plat.getProperties().get("platform.ant.name"));
                    J2MEProject.this.updateBootClassPathProperty(configs, (CDCPlatform)plat);
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("installedPlatforms")) {
                    JavaPlatform[] known = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("cdc", null));
                    List<JavaPlatform> list = Arrays.asList(known);
                    ArrayList<JavaPlatform> added = new ArrayList<JavaPlatform>(Arrays.asList(known));
                    added.removeAll(this.knownPlatforms);
                    this.knownPlatforms.removeAll(list);
                    for (JavaPlatform platform : this.knownPlatforms) {
                        platform.removePropertyChangeListener(this.platformChange);
                    }
                    for (JavaPlatform platform : added) {
                        platform.addPropertyChangeListener(this.platformChange);
                    }
                    this.knownPlatforms.clear();
                    this.knownPlatforms.addAll(list);
                }
            }
        }
    }

    private final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
            J2MEProject.this.refreshBuildScripts(false);
        }
    }
}

