/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.folding;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.folding.APTFoldingUtils;

class APTFoldingCommentFilter
implements TokenStream {
    private static final int COMMENTS_FOLD = 3;
    private static final int INITIAL_COMMENT_FOLD = 1;
    private static final int BLOCK_COMMENT_FOLD = 2;
    private static final int BEFORE_FIRST_TOKEN_STATE = 0;
    private static final int INIT_STATE = 1;
    private static final int AFTER_LINE_COMMENT = 3;
    private final TokenStream orig;
    private int state = 0;
    private int lastTokenLine = -1;
    private CppFoldRecord initialCommentFold = null;
    private List<CppFoldRecord> blockCommentFolds = new ArrayList<CppFoldRecord>();
    private List<CppFoldRecord> lineCommentFolds = new ArrayList<CppFoldRecord>();
    private APTToken firstLineComment = null;
    private APTToken lastLineComment = null;

    public APTFoldingCommentFilter(TokenStream orig) {
        this.orig = orig;
    }

    public Token nextToken() throws TokenStreamException {
        APTToken next = null;
        boolean needNext = true;
        block5: while (needNext) {
            next = (APTToken)this.orig.nextToken();
            switch (next.getType()) {
                case 467: {
                    this.createBlockCommentsFold(next);
                    continue block5;
                }
                case 468: {
                    if (this.lastTokenLine == next.getLine()) continue block5;
                    if (this.firstLineComment == null) {
                        this.firstLineComment = next;
                        this.state = 3;
                    }
                    this.lastLineComment = next;
                    continue block5;
                }
                case 1: {
                    needNext = false;
                    this.createLineCommentsFoldIfNeeded();
                    continue block5;
                }
            }
            needNext = false;
            this.lastTokenLine = next.getEndLine();
            this.createLineCommentsFoldIfNeeded();
        }
        return next;
    }

    public String toString() {
        String retValue = this.orig.toString();
        return retValue;
    }

    public void onPreprocNode(APT apt) {
        switch (this.state) {
            case 0: {
                this.state = 1;
                break;
            }
            case 3: {
                this.createLineCommentsFoldIfNeeded();
            }
        }
    }

    public List<CppFoldRecord> getFolders() {
        ArrayList<CppFoldRecord> out = new ArrayList<CppFoldRecord>(this.blockCommentFolds.size() + this.lineCommentFolds.size() + 1);
        if (this.initialCommentFold != null) {
            out.add(this.initialCommentFold);
        }
        out.addAll(this.blockCommentFolds);
        out.addAll(this.lineCommentFolds);
        return out;
    }

    private void createLineCommentsFoldIfNeeded() {
        if (this.state == 3) {
            if (this.firstLineComment != this.lastLineComment) {
                assert (this.firstLineComment != null);
                assert (this.lastLineComment != null);
                if (this.firstLineComment.getLine() != this.lastLineComment.getEndLine()) {
                    this.lineCommentFolds.add(this.createFoldRecord(3, this.firstLineComment, this.lastLineComment));
                }
            }
            this.firstLineComment = null;
            this.lastLineComment = null;
            this.state = 1;
        }
    }

    private void createBlockCommentsFold(APTToken token) {
        this.createLineCommentsFoldIfNeeded();
        if (token.getLine() != token.getEndLine()) {
            if (this.state == 0) {
                assert (this.initialCommentFold == null) : "how there could be two copyrights?";
                this.initialCommentFold = this.createFoldRecord(1, token, token);
            } else {
                this.blockCommentFolds.add(this.createFoldRecord(2, token, token));
            }
        }
        this.state = 1;
    }

    private CppFoldRecord createFoldRecord(int folderKind, APTToken begin, APTToken end) {
        if (APTFoldingUtils.isStandalone()) {
            return new CppFoldRecord(folderKind, begin.getLine(), begin.getOffset(), end.getEndLine(), end.getEndOffset());
        }
        return new CppFoldRecord(folderKind, begin.getOffset(), end.getEndOffset());
    }
}

