/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.DiffViewAction;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.junit.output.JUnitTestcase;
import org.netbeans.modules.junit.output.JumpAction;
import org.netbeans.modules.junit.output.OutputUtils;
import org.netbeans.modules.junit.output.TestMethodNodeAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class JUnitTestMethodNode
extends TestMethodNode {
    public JUnitTestMethodNode(Testcase testcase, Project project, Lookup lookup) {
        super(testcase, project, lookup);
    }

    public JUnitTestMethodNode(Testcase testcase, Project project) {
        super(testcase, project);
    }

    public Action[] getActions(boolean context) {
        FileObject testFO;
        ArrayList<Action> actions = new ArrayList<Action>();
        Action preferred = this.getPreferredAction();
        if (preferred != null) {
            actions.add(preferred);
        }
        if ((testFO = ((JUnitTestcase)this.testcase).getClassFileObject()) != null) {
            ActionProvider actionProvider;
            boolean parameterized = false;
            try {
                String text = testFO.asText();
                if (text != null && ((text = text.replaceAll("\n", "").replaceAll(" ", "")).contains("@RunWith") || text.contains("@org.junit.runner.RunWith")) && text.contains("Parameterized.class)")) {
                    parameterized = true;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (!parameterized && (actionProvider = OutputUtils.getActionProvider(testFO)) != null) {
                List<String> supportedActions = Arrays.asList(actionProvider.getSupportedActions());
                SingleMethod methodSpec = new SingleMethod(testFO, this.testcase.getName());
                Lookup nodeContext = Lookups.singleton((Object)methodSpec);
                if (supportedActions.contains("run.single.method") && actionProvider.isActionEnabled("run.single.method", nodeContext)) {
                    actions.add(new TestMethodNodeAction(actionProvider, nodeContext, "run.single.method", "LBL_RerunTest"));
                }
                if (supportedActions.contains("debug.single.method") && actionProvider.isActionEnabled("debug.single.method", nodeContext)) {
                    actions.add(new TestMethodNodeAction(actionProvider, nodeContext, "debug.single.method", "LBL_DebugTest"));
                }
            }
        }
        if (this.testcase.getTrouble() != null && this.testcase.getTrouble().getComparisonFailure() != null) {
            actions.add((Action)new DiffViewAction(this.testcase));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public Action getPreferredAction() {
        return new JumpAction((Node)this, null);
    }

    public JUnitTestcase getTestcase() {
        return (JUnitTestcase)this.testcase;
    }
}

