/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.actions;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.openide.filesystems.FileObject;

final class TestClassInfoTask
implements CancellableTask<CompilationController> {
    private FileObject fileObject;
    private final int caretPosition;
    private String className;
    private String methodName;
    private static String ANNOTATION = "org.junit.Test";
    private static String TESTCASE = "junit.framework.TestCase";

    TestClassInfoTask(int caretPosition) {
        this.caretPosition = caretPosition;
    }

    public void cancel() {
    }

    public void run(CompilationController controller) throws Exception {
        TreePath tp;
        Elements elements;
        TypeElement testcase;
        controller.toPhase(JavaSource.Phase.RESOLVED);
        this.fileObject = controller.getFileObject();
        TypeElement typeElement22 = null;
        List topLevelElements = controller.getTopLevelElements();
        for (TypeElement typeElement22 : topLevelElements) {
            if (typeElement22.getKind() != ElementKind.CLASS) continue;
            this.className = typeElement22.getSimpleName().toString();
            break;
        }
        boolean junit3 = (testcase = (elements = controller.getElements()).getTypeElement(TESTCASE)) != null && typeElement22 != null ? controller.getTypes().isSubtype(typeElement22.asType(), testcase.asType()) : false;
        for (tp = controller.getTreeUtilities().pathFor(this.caretPosition); tp != null && tp.getLeaf().getKind() != Tree.Kind.METHOD; tp = tp.getParentPath()) {
        }
        if (tp != null) {
            Element element = controller.getTrees().getElement(tp);
            String mn = element.getSimpleName().toString();
            if (junit3) {
                this.methodName = mn.startsWith("test") ? mn : null;
            } else {
                List<? extends AnnotationMirror> allAnnotationMirrors = elements.getAllAnnotationMirrors(element);
                for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
                    typeElement22 = (TypeElement)annotationMirror.getAnnotationType().asElement();
                    if (!typeElement22.getQualifiedName().contentEquals(ANNOTATION)) continue;
                    this.methodName = mn;
                    break;
                }
            }
        }
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    String getClassName() {
        return this.className;
    }

    String getMethodName() {
        return this.methodName;
    }
}

