/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules.source;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.CallEjbGenerator;
import org.netbeans.modules.j2ee.ejbcore.util._RetoucheUtil;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.spi.ejbjar.support.EjbReferenceSupport;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class UseInjectionInsteadOfInstantionRule {
    private UseInjectionInsteadOfInstantionRule() {
    }

    public static ErrorDescription useInjectionInsteadOfInstantion(final HintContext ctx) {
        CompilationInfo cpi = ctx.getInfo();
        TreePath clazzTreePath = (TreePath)ctx.getVariables().get("$clazz");
        if (clazzTreePath == null) {
            return null;
        }
        final TypeElement javaClass = (TypeElement)cpi.getTrees().getElement(clazzTreePath);
        if (javaClass == null) {
            return null;
        }
        final EjbJar ejbJar = UseInjectionInsteadOfInstantionRule.getEjbJarForFileObject(ctx.getInfo().getFileObject());
        if (ejbJar == null) {
            return null;
        }
        try {
            return (ErrorDescription)ejbJar.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, ErrorDescription>(){

                public ErrorDescription run(EjbJarMetadata metadata) {
                    String ejbVersion = metadata.getRoot().getVersion().toString();
                    if (!"3.0".equals(ejbVersion) && !"3.1".equals(ejbVersion)) {
                        return null;
                    }
                    Ejb ejb = metadata.findByEjbClass(ElementUtilities.getBinaryName((TypeElement)javaClass));
                    if (ejb != null) {
                        ReplaceInstantionByInjectionFix fix = new ReplaceInstantionByInjectionFix(ctx, ejbJar);
                        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)NbBundle.getMessage(UseInjectionInsteadOfInstantionRule.class, (String)"ERR_UseInjectionInsteadOfInstantion"), (Fix[])new Fix[]{fix});
                    }
                    return null;
                }
            });
        }
        catch (MetadataModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private static EjbJar getEjbJarForFileObject(FileObject fileObject) {
        Project prj = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (prj == null) {
            return null;
        }
        J2eeProjectCapabilities projCap = J2eeProjectCapabilities.forProject((Project)prj);
        if (projCap == null || !projCap.isEjb30Supported() && !projCap.isEjb31LiteSupported()) {
            return null;
        }
        return EjbJar.getEjbJar((FileObject)fileObject);
    }

    private static class ReplaceInstantionByInjectionFix
    implements Fix {
        private final HintContext context;
        private final EjbJar ejbJar;

        public ReplaceInstantionByInjectionFix(HintContext context, EjbJar ejbJar) {
            this.context = context;
            this.ejbJar = ejbJar;
        }

        public String getText() {
            return NbBundle.getMessage(UseInjectionInsteadOfInstantionRule.class, (String)"FIX_UseInjectionInsteadOfInstantion");
        }

        public ChangeInfo implement() throws Exception {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    TypeElement element = null;
                    for (Tree next : ReplaceInstantionByInjectionFix.this.context.getPath()) {
                        if (next.getKind() != Tree.Kind.CLASS) continue;
                        TreePath path = ReplaceInstantionByInjectionFix.this.context.getInfo().getTrees().getPath(ReplaceInstantionByInjectionFix.this.context.getInfo().getCompilationUnit(), next);
                        element = (TypeElement)ReplaceInstantionByInjectionFix.this.context.getInfo().getTrees().getElement(path);
                        break;
                    }
                    try {
                        Fix removeFromParent = JavaFixUtilities.removeFromParent((HintContext)ReplaceInstantionByInjectionFix.this.context, null, (TreePath)ReplaceInstantionByInjectionFix.this.context.getPath());
                        removeFromParent.implement();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    try {
                        if (element != null) {
                            TypeElement javaClass = (TypeElement)ReplaceInstantionByInjectionFix.this.context.getInfo().getTrees().getElement((TreePath)ReplaceInstantionByInjectionFix.this.context.getVariables().get("$clazz"));
                            FileObject referencingFO = ReplaceInstantionByInjectionFix.this.context.getInfo().getFileObject();
                            String referencingBN = ElementUtilities.getBinaryName((TypeElement)element);
                            String referencedSN = javaClass.getSimpleName().toString();
                            String name = _RetoucheUtil.uniqueMemberName((FileObject)referencingFO, (String)referencingBN, (String)referencedSN, (String)referencedSN);
                            CallEjbGenerator generator = CallEjbGenerator.create((EjbReference)EjbReferenceSupport.createEjbReference((EjbJar)ReplaceInstantionByInjectionFix.this.ejbJar, (String)javaClass.toString()), (String)name, (boolean)true);
                            generator.addReference(referencingFO, referencingBN, SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)javaClass), (ClasspathInfo)ReplaceInstantionByInjectionFix.this.context.getInfo().getClasspathInfo()), ElementUtilities.getBinaryName((TypeElement)javaClass), null, EjbReference.EjbRefIType.NO_INTERFACE, false, FileOwnerQuery.getOwner((FileObject)ReplaceInstantionByInjectionFix.this.context.getInfo().getFileObject()));
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            return null;
        }
    }
}

