/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.search;

import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.DocUtils;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class DocumentFinder {
    private static final Logger LOG = Logger.getLogger(EditorFindSupport.class.getName());

    private DocumentFinder() {
    }

    /*
     * Unable to fully structure code
     */
    private static DocFinder getFinder(Document doc, Map searchProps, boolean oppositeDir, boolean blocksFinder) {
        text = (String)searchProps.get("find-what");
        if (text == null || text.length() == 0) {
            if (blocksFinder) {
                return FalseBlocksFinder.INSTANCE;
            }
            return FalseFinder.INSTANCE;
        }
        b = (Boolean)searchProps.get("find-backward-search");
        v0 = bwdSearch = b != null && b != false;
        if (oppositeDir) {
            bwdSearch = bwdSearch == false;
        }
        matchCase = (b = (Boolean)searchProps.get("find-match-case")) != null && b != false;
        b = (Boolean)searchProps.get("find-smart-case");
        smartCase = b != null && b != false;
        b = (Boolean)searchProps.get("find-whole-words");
        v1 = wholeWords = b != null && b != false;
        if (smartCase && !matchCase) {
            cnt = text.length();
            for (i = 0; i < cnt; ++i) {
                if (!Character.isUpperCase(text.charAt(i))) continue;
                matchCase = true;
            }
        }
        regExpSearch = (b = (Boolean)searchProps.get("find-reg-exp")) != null && b != false;
        pattern = null;
        if (regExpSearch) {
            try {
                pattern = PatternCache.getPattern(text, matchCase);
                if (pattern != null) ** GOTO lbl39
                pattern = matchCase != false ? Pattern.compile(text, 8) : Pattern.compile(text, 10);
                PatternCache.putPattern(text, matchCase, pattern);
            }
            catch (PatternSyntaxException pse) {
                if (!blocksFinder) {
                    msg = new NotifyDescriptor.Message((Object)(NbBundle.getMessage(DocumentFinder.class, (String)"pattern-error-dialog-content") + "\n" + pse.getDescription()), 0);
                    msg.setTitle(NbBundle.getMessage(DocumentFinder.class, (String)"pattern-error-dialog-title"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                }
                PatternCache.putPattern(text, matchCase, null);
                return null;
            }
        } else {
            PatternCache.clear();
        }
lbl39:
        // 3 sources

        if (blocksFinder) {
            if (wholeWords && !regExpSearch) {
                wholeWordsBlocksFinder = new WholeWordsBlocksFinder();
                wholeWordsBlocksFinder.setParams(doc, text, matchCase);
                return wholeWordsBlocksFinder;
            }
            if (regExpSearch) {
                regExpBlocksFinder = new RegExpBlocksFinder();
                regExpBlocksFinder.setParams(pattern, matchCase);
                return regExpBlocksFinder;
            }
            stringBlocksFinder = new StringBlocksFinder();
            stringBlocksFinder.setParams(text, matchCase);
            return stringBlocksFinder;
        }
        if (wholeWords && !regExpSearch) {
            if (bwdSearch) {
                wholeWordsBwdFinder = new WholeWordsBwdFinder();
                wholeWordsBwdFinder.setParams(doc, text, matchCase);
                return wholeWordsBwdFinder;
            }
            wholeWordsFwdFinder = new WholeWordsFwdFinder();
            wholeWordsFwdFinder.setParams(doc, text, matchCase);
            return wholeWordsFwdFinder;
        }
        if (regExpSearch) {
            if (bwdSearch) {
                regExpBwdFinder = new RegExpBwdFinder();
                regExpBwdFinder.setParams(pattern, matchCase);
                return regExpBwdFinder;
            }
            regExpFwdFinder = new RegExpFwdFinder();
            regExpFwdFinder.setParams(pattern, matchCase);
            return regExpFwdFinder;
        }
        if (bwdSearch) {
            stringBwdFinder = new StringBwdFinder();
            stringBwdFinder.setParams(text, matchCase);
            return stringBwdFinder;
        }
        stringFwdFinder = new StringFwdFinder();
        stringFwdFinder.setParams(text, matchCase);
        return stringFwdFinder;
    }

    private static FindReplaceResult findReplaceImpl(String replaceText, Document doc, int startOffset, int endOffset, Map props, boolean oppositeDir) throws BadLocationException {
        Matcher matcher;
        int initOffset;
        CharSequence blockText;
        Position pos;
        int blockSearchEndOffset;
        int blockSearchStartOffset;
        boolean back;
        DocFinder finder;
        int[] ret = new int[2];
        if (endOffset == -1) {
            endOffset = doc.getLength();
        }
        if ((finder = DocumentFinder.getFinder(doc, props, oppositeDir, false)) == null) {
            return null;
        }
        finder.reset();
        Boolean b = (Boolean)props.get("find-backward-search");
        boolean bl = back = b != null && b != false;
        if (oppositeDir) {
            back = !back;
        }
        boolean blockSearch = (b = (Boolean)props.get("find-block-search")) != null && b != false;
        Position blockStartPos = (Position)props.get("find-block-search-start");
        int n = blockSearchStartOffset = blockStartPos != null ? blockStartPos.getOffset() : 0;
        if (blockSearchStartOffset > doc.getLength()) {
            blockSearchStartOffset = 0;
        }
        int n2 = blockSearchEndOffset = (pos = (Position)props.get("find-block-search-end")) != null ? pos.getOffset() : doc.getLength();
        if (blockSearchEndOffset > doc.getLength()) {
            blockSearchEndOffset = doc.getLength();
        }
        if (blockSearchStartOffset > blockSearchEndOffset) {
            LOG.log(Level.WARNING, "end=" + blockSearchEndOffset + " < start=" + blockSearchStartOffset);
            int tmp = blockSearchStartOffset;
            blockSearchStartOffset = blockSearchEndOffset;
            blockSearchEndOffset = tmp;
        }
        CharSequence docText = DocumentUtilities.getText((Document)doc).subSequence(0, doc.getLength());
        CharSequence charSequence = blockText = blockSearch ? docText.subSequence(blockSearchStartOffset, blockSearchEndOffset) : docText;
        if (blockSearch && endOffset < startOffset) {
            int temp = endOffset;
            endOffset = startOffset;
            startOffset = temp;
        }
        if ((initOffset = back && blockSearch ? endOffset - startOffset : (!back && blockSearch ? startOffset - blockSearchStartOffset : startOffset)) < 0 || initOffset > blockText.length()) {
            LOG.log(Level.INFO, "Index: " + initOffset + "\nOffset: " + startOffset + "-" + endOffset + "\nBlock: " + blockSearchStartOffset + "-" + blockSearchEndOffset + "\nLength : " + blockText.length());
            initOffset = Math.max(initOffset, 0);
            initOffset = Math.min(initOffset, blockText.length());
        }
        int findRet = finder.find(initOffset, blockText);
        if (!finder.isFound()) {
            ret[0] = -1;
            return new FindReplaceResult(ret, replaceText);
        }
        ret[0] = blockSearch ? blockSearchStartOffset + findRet : findRet;
        if (finder instanceof StringFinder) {
            int length = ((StringFinder)finder).getFoundLength();
            ret[1] = ret[0] + length;
        }
        if (finder instanceof RegExpFinder && (matcher = ((RegExpFinder)finder).getMatcher()) != null && replaceText != null) {
            CharSequence foundString = docText.subSequence(ret[0], ret[1]);
            matcher.reset(foundString);
            if (matcher.find()) {
                try {
                    replaceText = matcher.replaceFirst(DocumentFinder.convertStringForMatcher(replaceText));
                }
                catch (IndexOutOfBoundsException ioobe) {
                    DocumentFinder.notifyRegexpException(ioobe);
                    return null;
                }
                catch (IllegalArgumentException iae) {
                    DocumentFinder.notifyRegexpException(iae);
                    return null;
                }
            }
        }
        return new FindReplaceResult(ret, replaceText);
    }

    public static int[] find(Document doc, int startOffset, int endOffset, Map props, boolean oppositeDir) throws BadLocationException {
        FindReplaceResult result = DocumentFinder.findReplaceImpl(null, doc, startOffset, endOffset, props, oppositeDir);
        if (result == null) {
            return null;
        }
        return result.getFoundPositions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] findBlocks(Document doc, int startOffset, int endOffset, Map props, int[] blocks) throws BadLocationException {
        BlocksFinder finder = (BlocksFinder)DocumentFinder.getFinder(doc, props, false, true);
        if (finder == null) {
            return blocks;
        }
        CharSequence cs = DocumentUtilities.getText((Document)doc, (int)startOffset, (int)(endOffset - startOffset));
        if (cs == null) {
            return null;
        }
        BlocksFinder blocksFinder = finder;
        synchronized (blocksFinder) {
            finder.reset();
            finder.setBlocks(blocks);
            finder.find(startOffset, cs);
            int[] ret = finder.getBlocks();
            return ret;
        }
    }

    public static FindReplaceResult findReplaceResult(String replaceString, Document doc, int startOffset, int endOffset, Map props, boolean oppositeDir) throws BadLocationException {
        FindReplaceResult findReplaceImpl = DocumentFinder.findReplaceImpl(replaceString, doc, startOffset, endOffset, props, oppositeDir);
        return DocumentFinder.preserveCaseImpl(findReplaceImpl, replaceString, doc, props);
    }

    private static void notifyRegexpException(Exception ex) throws MissingResourceException {
        String additionalHint = "";
        if (ex instanceof IllegalArgumentException) {
            additionalHint = "\n" + NbBundle.getBundle(DocumentFinder.class).getString("pattern-error-missing-escape-hint");
        }
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)(NbBundle.getMessage(DocumentFinder.class, (String)"pattern-error-dialog-content") + "\n" + ex.getLocalizedMessage() + additionalHint), 0);
        msg.setTitle(NbBundle.getBundle(DocumentFinder.class).getString("pattern-error-dialog-title"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }

    private static boolean getBoolFromEditorFindSupport(Map searchProps, String editorFindSupportConstant) {
        Boolean b = (Boolean)searchProps.get(editorFindSupportConstant);
        return b != null && b != false;
    }

    private static boolean getMatchCaseFromEditorFindSupport(Map searchProps, String text) {
        boolean matchCase = DocumentFinder.getBoolFromEditorFindSupport(searchProps, "find-match-case");
        boolean smartCase = DocumentFinder.getBoolFromEditorFindSupport(searchProps, "find-smart-case");
        if (smartCase && !matchCase) {
            for (int i = 0; i < text.length(); ++i) {
                if (!Character.isUpperCase(text.charAt(i))) continue;
                matchCase = true;
                break;
            }
        }
        return matchCase;
    }

    private static FindReplaceResult preserveCaseImpl(FindReplaceResult findReplaceResult, String replaceString, Document doc, Map searchProps) throws BadLocationException {
        if (replaceString == null || findReplaceResult == null || findReplaceResult.getFoundPositions()[0] == -1) {
            return findReplaceResult;
        }
        boolean regExpSearch = DocumentFinder.getBoolFromEditorFindSupport(searchProps, "find-reg-exp");
        boolean preserveCase = DocumentFinder.getBoolFromEditorFindSupport(searchProps, "find-preserve-case");
        boolean matchCase = DocumentFinder.getMatchCaseFromEditorFindSupport(searchProps, replaceString);
        if (preserveCase && !regExpSearch && !matchCase) {
            assert (findReplaceResult.getFoundPositions()[0] <= findReplaceResult.getFoundPositions()[1]);
            int length = findReplaceResult.getFoundPositions()[1] - findReplaceResult.getFoundPositions()[0];
            String findStr = doc.getText(findReplaceResult.getFoundPositions()[0], length);
            String replStr = replaceString.toString();
            if (findStr.equals(findStr.toUpperCase())) {
                replStr = replStr.toUpperCase();
            } else if (findStr.equals(findStr.toLowerCase())) {
                replStr = replStr.toLowerCase();
            } else if (Character.isUpperCase(findStr.charAt(0))) {
                replStr = Character.toUpperCase(replStr.charAt(0)) + replStr.substring(1);
            } else if (Character.isLowerCase(findStr.charAt(0))) {
                replStr = findStr.substring(1).equals(findStr.substring(1).toUpperCase()) ? Character.toLowerCase(replStr.charAt(0)) + replStr.substring(1).toUpperCase() : Character.toLowerCase(replStr.charAt(0)) + replStr.substring(1);
            }
            return new FindReplaceResult(findReplaceResult.getFoundPositions(), replStr);
        }
        return findReplaceResult;
    }

    private static String convertStringForMatcher(String text) {
        String res = null;
        if (text != null) {
            String[] sGroups = text.split("\\\\\\\\", text.length());
            res = "";
            for (int i = 0; i < sGroups.length; ++i) {
                String tmp = sGroups[i];
                tmp = tmp.replace("\\r", "\r");
                tmp = tmp.replace("\\n", "\n");
                tmp = tmp.replace("\\t", "\t");
                res = res + tmp;
                if (i == sGroups.length - 1) continue;
                res = res + "\\\\";
            }
        }
        return res;
    }

    public static class FindReplaceResult {
        private int[] positions;
        private String replacedString;

        public FindReplaceResult(int[] positions, String replacedString) {
            this.positions = positions;
            this.replacedString = replacedString;
        }

        public String getReplacedString() {
            return this.replacedString;
        }

        public int[] getFoundPositions() {
            return this.positions;
        }
    }

    private static class PatternCache {
        private static String cache_str;
        private static boolean cache_matchCase;
        private static Pattern cache_pattern;

        private PatternCache() {
        }

        public static void putPattern(String str, boolean matchCase, Pattern pattern) {
            cache_str = str;
            cache_matchCase = matchCase;
            cache_pattern = pattern;
        }

        public static Pattern getPattern(String str, boolean matchCase) {
            if (str == null) {
                return null;
            }
            if (str.equals(cache_str) && matchCase == cache_matchCase) {
                return cache_pattern;
            }
            return null;
        }

        public static void clear() {
            cache_str = null;
            cache_matchCase = false;
            cache_pattern = null;
        }
    }

    private static final class RegExpBlocksFinder
    extends AbstractBlocksFinder {
        Pattern pattern;
        int stringInd;
        boolean matchCase;

        public void setParams(Pattern pattern, boolean matchCase) {
            this.pattern = pattern;
            this.matchCase = matchCase;
        }

        @Override
        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        @Override
        public int find(int initOffset, CharSequence data) {
            Matcher matcher = this.pattern.matcher(data);
            int ret = 0;
            while (matcher.find()) {
                int start = initOffset + matcher.start();
                int end = initOffset + matcher.end();
                this.addBlock(start, end);
                ret = start;
            }
            return ret;
        }
    }

    private static final class RegExpFwdFinder
    extends RegExpFinder {
        Pattern pattern;
        boolean matchCase;
        int length = 0;
        Matcher matcher;

        @Override
        public Matcher getMatcher() {
            return this.matcher;
        }

        public void setParams(Pattern pattern, boolean matchCase) {
            this.matchCase = matchCase;
            this.pattern = pattern;
        }

        @Override
        public int getFoundLength() {
            return this.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.length = 0;
        }

        @Override
        public int find(int initOffset, CharSequence chars) {
            this.matcher = this.pattern.matcher(chars);
            if (this.matcher.find(initOffset)) {
                this.found = true;
                int start = this.matcher.start();
                int end = this.matcher.end();
                this.length = end - start;
                if (this.length <= 0) {
                    this.found = false;
                    while (++initOffset < chars.length() && this.matcher.find(initOffset) && this.matcher.end() - this.matcher.start() == 0) {
                    }
                    if (this.matcher.find(initOffset) && this.matcher.end() - this.matcher.start() > 0) {
                        return this.find(initOffset, chars);
                    }
                    return -1;
                }
                return start;
            }
            return -1;
        }
    }

    private static class RegExpBwdFinder
    extends RegExpFinder {
        boolean matchCase;
        Pattern pattern;
        int length = 0;
        Matcher matcher;

        @Override
        public Matcher getMatcher() {
            return this.matcher;
        }

        public void setParams(Pattern pattern, boolean matchCase) {
            this.matchCase = matchCase;
            this.pattern = pattern;
        }

        @Override
        public int getFoundLength() {
            return this.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.length = 0;
        }

        private int lineFind(int lineStart, int lineEnd, CharSequence chars) {
            this.matcher = this.pattern.matcher(chars.subSequence(lineStart, lineEnd));
            int ret = -1;
            while (this.matcher.find()) {
                int start = this.matcher.start();
                int end = this.matcher.end();
                this.length = end - start;
                if (this.length <= 0) {
                    this.found = false;
                    return -1;
                }
                ret = start;
            }
            return ret;
        }

        @Override
        public int find(int initOffset, CharSequence chars) {
            int charsEnd;
            int lineEnd = charsEnd = initOffset != 0 ? initOffset - 1 : chars.length() - 1;
            int lineStart = charsEnd;
            for (int i = charsEnd; i >= 0; --i) {
                char ch = chars.charAt(i);
                if (ch == '\n' || i == 0) {
                    int retFind = this.lineFind(lineStart + (i == 0 ? 0 : 1), lineEnd + 1, chars);
                    if (retFind != -1) {
                        this.found = true;
                        return i + retFind + (i == 0 ? 0 : 1);
                    }
                    lineEnd = --lineStart;
                    continue;
                }
                --lineStart;
            }
            return -1;
        }
    }

    private static abstract class RegExpFinder
    extends AbstractFinder
    implements StringFinder {
        private RegExpFinder() {
        }

        public abstract Matcher getMatcher();
    }

    private static final class StringFwdFinder
    extends GenericFwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;

        public void setParams(String s, boolean matchCase) {
            this.matchCase = matchCase;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
        }

        @Override
        public int getFoundLength() {
            return this.chars.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        @Override
        protected int scan(char ch, boolean lastChar) {
            if (!this.matchCase) {
                ch = Character.toLowerCase(ch);
            }
            if (ch == this.chars[this.stringInd]) {
                ++this.stringInd;
                if (this.stringInd == this.chars.length) {
                    this.found = true;
                    return 1 - this.stringInd;
                }
                return 1;
            }
            if (this.stringInd == 0) {
                return 1;
            }
            int back = 1 - this.stringInd;
            this.stringInd = 0;
            return back;
        }
    }

    private static class StringBwdFinder
    extends GenericBwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        int endInd;

        public void setParams(String s, boolean matchCase) {
            this.matchCase = matchCase;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
            this.endInd = this.chars.length - 1;
        }

        @Override
        public int getFoundLength() {
            return this.chars.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.stringInd = this.endInd;
        }

        @Override
        protected int scan(char ch, boolean lastChar) {
            if (!this.matchCase) {
                ch = Character.toLowerCase(ch);
            }
            if (ch == this.chars[this.stringInd]) {
                --this.stringInd;
                if (this.stringInd == -1) {
                    this.found = true;
                    return 0;
                }
                return -1;
            }
            if (this.stringInd == this.endInd) {
                return -1;
            }
            int back = this.chars.length - 2 - this.stringInd;
            this.stringInd = this.endInd;
            return back;
        }
    }

    private static final class WholeWordsFwdFinder
    extends GenericFwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        Document doc;
        boolean insideWord;
        boolean firstCharWordPart;
        boolean wordFound;

        public void setParams(Document doc, String s, boolean matchCase) {
            this.doc = doc;
            this.matchCase = matchCase;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
            this.firstCharWordPart = DocUtils.isIdentifierPart(doc, this.chars[0]);
        }

        @Override
        public int getFoundLength() {
            return this.chars.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = 0;
        }

        @Override
        protected int scan(char ch, boolean lastChar) {
            if (!this.matchCase) {
                ch = Character.toLowerCase(ch);
            }
            if (this.wordFound) {
                if (DocUtils.isIdentifierPart(this.doc, ch)) {
                    this.wordFound = false;
                    this.insideWord = this.firstCharWordPart;
                    this.stringInd = 0;
                    return 1 - this.chars.length;
                }
                this.found = true;
                return -this.chars.length;
            }
            if (this.stringInd == 0) {
                if (ch != this.chars[0] || this.insideWord) {
                    this.insideWord = DocUtils.isIdentifierPart(this.doc, ch);
                    return 1;
                }
                this.stringInd = 1;
                if (this.chars.length == 1) {
                    if (lastChar) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return 1;
                }
                return 1;
            }
            if (ch == this.chars[this.stringInd]) {
                ++this.stringInd;
                if (this.stringInd == this.chars.length) {
                    if (lastChar) {
                        this.found = true;
                        return 1 - this.chars.length;
                    }
                    this.wordFound = true;
                    return 1;
                }
                return 1;
            }
            int back = 1 - this.stringInd;
            this.stringInd = 0;
            this.insideWord = this.firstCharWordPart;
            return back;
        }
    }

    private static abstract class GenericBwdFinder
    extends AbstractFinder {
        private GenericBwdFinder() {
        }

        @Override
        public final int find(int initOffset, CharSequence chars) {
            int offset;
            int limitPos = 0;
            int limitOffset = chars.length();
            for (offset = initOffset - 1; offset >= 0 && offset < limitOffset; offset += this.scan(chars.charAt(offset), offset == limitPos)) {
                if (!this.found) continue;
                break;
            }
            return offset;
        }

        protected abstract int scan(char var1, boolean var2);
    }

    private static abstract class GenericFwdFinder
    extends AbstractFinder {
        private GenericFwdFinder() {
        }

        @Override
        public final int find(int initOffset, CharSequence chars) {
            int offset;
            int limitPos = chars.length();
            int limitOffset = limitPos - 1;
            for (offset = initOffset; offset >= 0 && offset < limitPos; offset += this.scan(chars.charAt(offset), offset == limitOffset)) {
                if (!this.found) continue;
                break;
            }
            return offset;
        }

        protected abstract int scan(char var1, boolean var2);
    }

    private static final class WholeWordsBwdFinder
    extends GenericBwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        boolean insideWord;
        boolean lastCharWordPart;
        boolean wordFound;
        int endInd;
        Document doc;

        public void setParams(Document doc, String s, boolean matchCase) {
            this.doc = doc;
            this.matchCase = matchCase;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
            this.endInd = this.chars.length - 1;
            this.lastCharWordPart = DocUtils.isIdentifierPart(doc, this.chars[this.endInd]);
        }

        @Override
        public int getFoundLength() {
            return this.chars.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = this.endInd;
        }

        @Override
        protected int scan(char ch, boolean lastChar) {
            if (!this.matchCase) {
                ch = Character.toLowerCase(ch);
            }
            if (this.wordFound) {
                if (DocUtils.isIdentifierPart(this.doc, ch)) {
                    this.wordFound = false;
                    this.insideWord = this.lastCharWordPart;
                    this.stringInd = this.endInd;
                    return this.endInd;
                }
                this.found = true;
                return 1;
            }
            if (this.stringInd == this.endInd) {
                if (ch != this.chars[this.endInd] || this.insideWord) {
                    this.insideWord = DocUtils.isIdentifierPart(this.doc, ch);
                    return -1;
                }
                this.stringInd = this.endInd - 1;
                if (this.chars.length == 1) {
                    if (lastChar) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return -1;
                }
                return -1;
            }
            if (ch == this.chars[this.stringInd]) {
                --this.stringInd;
                if (this.stringInd == -1) {
                    if (lastChar) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return -1;
                }
                return -1;
            }
            int back = this.chars.length - 2 - this.stringInd;
            this.stringInd = this.endInd;
            this.insideWord = this.lastCharWordPart;
            return back;
        }
    }

    private static final class StringBlocksFinder
    extends AbstractBlocksFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;

        public void setParams(String s, boolean matchCase) {
            this.matchCase = matchCase;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
        }

        @Override
        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        @Override
        public int find(int initOffset, CharSequence data) {
            int offset = 0;
            int endPos = data.length();
            while (offset >= 0 && offset < endPos) {
                char ch = data.charAt(offset);
                if (!this.matchCase) {
                    ch = Character.toLowerCase(ch);
                }
                if (ch == this.chars[this.stringInd]) {
                    ++this.stringInd;
                    if (this.stringInd == this.chars.length) {
                        int blkEnd = initOffset + offset + 1;
                        this.addBlock(blkEnd - this.stringInd, blkEnd);
                        this.stringInd = 0;
                    }
                    ++offset;
                    continue;
                }
                offset += 1 - this.stringInd;
                this.stringInd = 0;
            }
            return offset;
        }
    }

    private static final class WholeWordsBlocksFinder
    extends AbstractBlocksFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        boolean insideWord;
        boolean firstCharWordPart;
        boolean wordFound;
        Document doc;

        public void setParams(Document doc, String s, boolean matchCase) {
            this.matchCase = matchCase;
            this.doc = doc;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
            this.firstCharWordPart = DocUtils.isIdentifierPart(doc, this.chars[0]);
        }

        @Override
        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = 0;
        }

        @Override
        public int find(int initOffset, CharSequence data) {
            int offset = 0;
            int limitPos = data.length();
            int limitOffset = limitPos - 1;
            while (offset >= 0 && offset < limitPos) {
                int blkEnd;
                char ch = data.charAt(offset);
                if (!this.matchCase) {
                    ch = Character.toLowerCase(ch);
                }
                if (this.wordFound) {
                    if (DocUtils.isIdentifierPart(this.doc, ch)) {
                        this.insideWord = this.firstCharWordPart;
                        offset -= this.chars.length - 1;
                    } else {
                        blkEnd = initOffset + offset;
                        this.addBlock(blkEnd - this.chars.length, blkEnd);
                        this.insideWord = false;
                        ++offset;
                    }
                    this.wordFound = false;
                    this.stringInd = 0;
                    continue;
                }
                if (this.stringInd == 0) {
                    if (ch != this.chars[0] || this.insideWord) {
                        this.insideWord = DocUtils.isIdentifierPart(this.doc, ch);
                        ++offset;
                        continue;
                    }
                    this.stringInd = 1;
                    if (this.chars.length == 1) {
                        if (offset == limitOffset) {
                            int blkStart = initOffset + offset;
                            this.addBlock(blkStart, blkStart + 1);
                        } else {
                            this.wordFound = true;
                        }
                    }
                    ++offset;
                    continue;
                }
                if (ch == this.chars[this.stringInd]) {
                    ++this.stringInd;
                    if (this.stringInd == this.chars.length) {
                        if (offset == limitOffset) {
                            blkEnd = initOffset + offset + 1;
                            this.addBlock(blkEnd - this.chars.length, blkEnd);
                        } else {
                            this.wordFound = true;
                        }
                    }
                    ++offset;
                    continue;
                }
                offset += 1 - this.stringInd;
                this.stringInd = 0;
                this.insideWord = this.firstCharWordPart;
            }
            return offset;
        }
    }

    private static interface StringFinder
    extends DocFinder {
        public int getFoundLength();
    }

    private static abstract class AbstractFinder
    implements DocFinder {
        protected boolean found;

        private AbstractFinder() {
        }

        @Override
        public final boolean isFound() {
            return this.found;
        }

        @Override
        public void reset() {
            this.found = false;
        }
    }

    private static interface BlocksFinder
    extends DocFinder {
        public void setBlocks(int[] var1);

        public int[] getBlocks();
    }

    private static abstract class AbstractBlocksFinder
    extends AbstractFinder
    implements BlocksFinder {
        private static int[] EMPTY_INT_ARRAY = new int[0];
        private int[] blocks = EMPTY_INT_ARRAY;
        private int blocksInd;
        private boolean closed;

        private AbstractBlocksFinder() {
        }

        @Override
        public void reset() {
            super.reset();
            this.blocksInd = 0;
            this.closed = false;
        }

        @Override
        public final int[] getBlocks() {
            if (!this.closed) {
                this.closeBlocks();
                this.closed = true;
            }
            return this.blocks;
        }

        @Override
        public final void setBlocks(int[] blocks) {
            this.blocks = blocks;
            this.blocksInd = 0;
            this.closed = false;
        }

        protected final void addBlock(int blkStartPos, int blkEndPos) {
            if (this.blocksInd + 2 > this.blocks.length) {
                int[] dbl = new int[Math.max(10, (this.blocksInd + 1) * 2)];
                System.arraycopy(this.blocks, 0, dbl, 0, this.blocks.length);
                this.blocks = dbl;
            }
            this.blocks[this.blocksInd] = blkStartPos;
            this.blocks[this.blocksInd + 1] = blkEndPos;
            this.blocksInd += 2;
        }

        protected final void closeBlocks() {
            this.addBlock(-1, -1);
        }

        public final String debugBlocks() {
            StringBuffer buf = new StringBuffer();
            int ind = 0;
            while (this.blocks[ind] != -1) {
                buf.append(ind / 2 + 1 + ": [" + this.blocks[ind] + ", " + this.blocks[ind + 1] + "]\n");
                ind += 2;
            }
            return buf.toString();
        }
    }

    private static class FalseFinder
    extends AbstractFinder
    implements StringFinder {
        public static final FalseFinder INSTANCE = new FalseFinder();

        @Override
        public int find(int initOffset, CharSequence data) {
            return -1;
        }

        @Override
        public int getFoundLength() {
            return 0;
        }

        private FalseFinder() {
        }
    }

    private static final class FalseBlocksFinder
    extends AbstractBlocksFinder {
        public static final FalseBlocksFinder INSTANCE = new FalseBlocksFinder();

        @Override
        public int find(int initOffset, CharSequence data) {
            return -1;
        }

        private FalseBlocksFinder() {
        }
    }

    private static interface DocFinder {
        public int find(int var1, CharSequence var2);

        public boolean isFound();

        public void reset();
    }
}

