/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2.mi;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommandManager;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIUserInteraction;

public abstract class MICommand {
    private final int routingToken;
    private final String command;
    private MICommandManager manager;
    private int token;
    private List<String> logStream;
    private List<String> consoleStream;
    private final boolean consoleCommand;

    public MICommand(int routingToken, String command) {
        this.routingToken = routingToken;
        this.command = command;
        this.consoleCommand = !command.startsWith("-");
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.routingToken != 0) {
            res.append('(');
            res.append(this.routingToken);
            res.append(')');
        }
        res.append(this.token);
        res.append(this.command);
        return res.toString();
    }

    public int routingToken() {
        return this.routingToken;
    }

    public String command() {
        return this.command;
    }

    protected abstract void onDone(MIRecord var1);

    protected abstract void onRunning(MIRecord var1);

    protected abstract void onError(MIRecord var1);

    protected abstract void onExit(MIRecord var1);

    protected abstract void onStopped(MIRecord var1);

    protected abstract void onOther(MIRecord var1);

    protected abstract void onUserInteraction(MIUserInteraction var1);

    protected void finish() {
        if (this.manager == null) {
            return;
        }
        this.manager.finish(this);
    }

    void setManagerData(MICommandManager manager, int token) {
        assert (manager != null);
        assert (this.manager == null) : "MICommand can only be sent once";
        this.manager = manager;
        this.token = token;
    }

    public int getToken() {
        assert (this.token != 0) : "MICommand.getToken(): cannot access before command has been sent";
        return this.token;
    }

    void recordLogStream(Collection<String> data) {
        if (this.logStream == null) {
            this.logStream = new LinkedList<String>();
        }
        this.logStream.addAll(data);
    }

    void recordConsoleStream(Collection<String> data) {
        if (this.consoleStream == null) {
            this.consoleStream = new LinkedList<String>();
        }
        for (String elem : data) {
            if (elem.startsWith("> ")) {
                this.onUserInteraction(new MIUserInteraction(this.getConsoleStream()));
                continue;
            }
            this.consoleStream.add(elem);
        }
    }

    public String getLogStream() {
        if (this.logStream == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : this.logStream) {
            sb.append(String.format(s, new Object[0]));
        }
        return sb.toString();
    }

    public String getConsoleStream() {
        if (this.consoleStream == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : this.consoleStream) {
            sb.append(String.format(s, new Object[0]));
        }
        return sb.toString();
    }

    public final boolean isConsoleCommand() {
        return this.consoleCommand;
    }
}

