/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Platform;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIConst;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITListItem;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;

public class GdbVersionPeculiarity {
    private final double version;
    private final Platform platform;
    private final Set<String> features = Collections.synchronizedSet(new HashSet());
    private static final boolean DISABLE_PENDING = Boolean.getBoolean("gdb.breakpoints.pending.disabled");

    private GdbVersionPeculiarity(double version, Platform platform) {
        this.version = version;
        this.platform = platform;
    }

    public static GdbVersionPeculiarity create(double version, Platform platform) {
        return new GdbVersionPeculiarity(version, platform);
    }

    public String environmentDirectoryCommand() {
        if (this.version > 6.3 || this.platform == Platform.MacOSX_x86) {
            return "-environment-directory";
        }
        return "directory";
    }

    public String environmentCdCommand() {
        if (this.version > 6.3) {
            return "-environment-cd";
        }
        return "cd";
    }

    public String execAbortCommand() {
        if (this.version > 6.6) {
            return "-exec-abort";
        }
        return "kill";
    }

    public String listChildrenCommand(String expr, int start, int end) {
        String retVal = "-var-list-children --all-values \"" + expr + "\"";
        if (this.version > 6.8) {
            retVal = retVal + " " + start + " " + end;
        }
        return retVal;
    }

    public boolean isThreadsOutputUnusual() {
        return this.platform == Platform.MacOSX_x86;
    }

    public boolean isSyscallBreakpointsSupported() {
        return this.platform != Platform.MacOSX_x86;
    }

    public String breakPendingFlag() {
        if (!DISABLE_PENDING && (this.version >= 6.8 || this.platform == Platform.MacOSX_x86)) {
            return " -f";
        }
        return "";
    }

    public String breakDisabledFlag() {
        if (this.version >= 6.8 || this.platform == Platform.MacOSX_x86) {
            return " -d";
        }
        return "";
    }

    public boolean isSupported() {
        return this.version >= 6.8 || this.platform == Platform.MacOSX_x86 && this.version >= 6.3;
    }

    public boolean supports(Feature feature) {
        return this.features.contains(feature.command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFeatures(MIRecord result) {
        Set<String> set = this.features;
        synchronized (set) {
            this.features.clear();
            try {
                MITList results = result.results();
                MIValue value = ((MIResult)results.get(0)).value();
                for (MITListItem item : value.asList()) {
                    this.features.add(((MIConst)item).value());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum Feature {
        THREAD_INFO("thread-info"),
        BREAKPOINT_NOTIFICATIONS("breakpoint-notifications");

        private final String command;

        private Feature(String command) {
            this.command = command;
        }
    }
}

