/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.VariableModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchModel;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerImpl;
import org.netbeans.modules.cnd.debugger.gdb2.GdbWatch;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;
import org.openide.util.Exceptions;

class GdbVariable
extends Variable {
    protected final GdbDebuggerImpl debugger;
    private final boolean isWatch;
    private int childrenRequested = 0;
    private final int REQUEST_STEP = 100;
    private String mi_name;
    private String mi_format = "natural";
    private int numchild;
    private boolean editable;
    private boolean changed;
    private boolean inScope = true;
    private boolean dynamic = false;
    private DisplayHint displayHint = DisplayHint.NONE;
    public static final String HAS_MORE = "has_more";

    public GdbVariable(GdbDebuggerImpl debugger, ModelChangeDelegator updater, Variable parent, String name, String type, String value, boolean watch) {
        super(updater, parent, name, type, value);
        this.debugger = debugger;
        this.isWatch = watch;
    }

    public NativeDebugger getDebugger() {
        return this.debugger;
    }

    protected void setChanged(boolean changed) {
        this.changed = changed;
    }

    protected boolean isChanged() {
        return this.changed;
    }

    public boolean isWatch() {
        return this.isWatch;
    }

    public void setInScope(boolean inScope) {
        this.inScope = inScope;
        if (!inScope) {
            this.setNumChild("0");
        }
    }

    public boolean isInScope() {
        return this.inScope;
    }

    public DisplayHint getDisplayHint() {
        return this.displayHint;
    }

    private void setDisplayHint(String hint) {
        try {
            this.displayHint = DisplayHint.valueOf(hint.toUpperCase());
        }
        catch (Exception e) {
            this.displayHint = DisplayHint.NONE;
        }
    }

    public String getAsText() {
        String prefix;
        String string = prefix = Log.Watch.varprefix ? this.mi_name + ": " : "";
        if (this.inScope) {
            String res = super.getAsText();
            if (res != null) {
                res = res.replace("\\\"", "\"");
            }
            return prefix + res;
        }
        return prefix + "<OUT_OF_SCOPE>";
    }

    protected void setEditable(String attr) {
        this.editable = attr.equals("editable");
        if (this.editable && this.numchild > 0) {
            this.setPtr(true);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    void setMIName(String mi_name) {
        this.mi_name = mi_name;
    }

    public void setValue(String v) {
        this.setAsText(v);
    }

    public String getMIName() {
        return this.mi_name;
    }

    void setFormat(String format) {
        this.mi_format = format;
    }

    protected void setNumChild(String child) {
        this.numchild = Integer.parseInt(child);
        if (this.numchild > 0) {
            this.setLeaf(false);
        } else {
            this.setLeaf(true);
        }
    }

    public int getNumChild() {
        return this.numchild;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    private void setDynamic(String value) {
        this.dynamic = "1".equals(value);
    }

    public Variable[] getChildren() {
        if (this.isLeaf()) {
            return new Variable[0];
        }
        if (this.children != null) {
            return this.children;
        }
        if (this.waitingForDebugger) {
            return new Variable[0];
        }
        this.waitingForDebugger = true;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    GdbVariable.this.setChildren();
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        };
        SwingUtilities.invokeLater(r);
        return new Variable[0];
    }

    public void setChildren() {
        this.debugger.getMIChildren(this, this.getMIName(), 0);
    }

    public int getChildrenRequestedCount() {
        return this.childrenRequested;
    }

    public int incrementChildrenRequestedCount() {
        this.childrenRequested += 100;
        return this.childrenRequested;
    }

    public void resetChildrenRequestedCount() {
        this.childrenRequested = 0;
    }

    public void setHasMore(String value) {
        this.hasMore = value == null || value.isEmpty() ? false : !value.equals("0");
    }

    public void getMoreChildren() {
        this.debugger.getMoreMIChildren(this, this.getMIName(), 1);
    }

    public void noteExpanded(boolean isWatch) {
        if (this.isExpanded()) {
            return;
        }
        this.setExpanded(true);
    }

    public void noteCollapsed(boolean isWatch) {
        this.setExpanded(false);
    }

    public void setVariableValue(String assigned_v) {
        if (!assigned_v.equals(this.value)) {
            boolean miName = !"char *".equals(this.type);
            this.debugger.assignVar(this, assigned_v, miName);
        }
    }

    public void removeAllDescendantFromOpenList(boolean isLocal) {
    }

    public String getDebugInfo() {
        return "";
    }

    public boolean getDelta() {
        return false;
    }

    public Action[] getActions(boolean isWatch) {
        if (isWatch) {
            return new Action[]{WatchModel.NEW_WATCH_ACTION, null, new WatchModel.DeleteAllAction(), null, VariableModel.getOutputFormatAction((Variable)this), null};
        }
        return new Action[]{VariableModel.getWatchAction((Variable)this), VariableModel.getOutputFormatAction((Variable)this), null};
    }

    public boolean isArrayBrowsable() {
        return false;
    }

    public void postFormat(String format) {
        this.debugger.postVarFormat(this, format);
    }

    public String getFormat() {
        return this.mi_format;
    }

    public void createWatch() {
        this.debugger.createWatchFromVariable(this);
    }

    void populateFields(MITList results) {
        this.setMIName(results.getConstValue("name"));
        this.setType(results.getConstValue("type"));
        String numchild_l = results.getConstValue("numchild");
        MIValue dynamicVal = results.valueOf("dynamic");
        if (dynamicVal != null) {
            this.setDynamic(dynamicVal.asConst().value());
            this.setDisplayHint(results.getConstValue("displayhint"));
            String hasMoreVal = results.getConstValue(HAS_MORE);
            if (!hasMoreVal.isEmpty()) {
                numchild_l = hasMoreVal;
                this.setHasMore(hasMoreVal);
            } else {
                switch (this.displayHint) {
                    case ARRAY: 
                    case MAP: 
                    case NONE: {
                        numchild_l = "1";
                    }
                }
            }
        }
        this.setNumChild(numchild_l);
    }

    void populateUpdate(MITList results) {
        for (MIResult item : results.getOnly(MIResult.class)) {
            if (item.matches("in_scope")) {
                if (!(this instanceof GdbWatch)) continue;
                this.setInScope(Boolean.parseBoolean(item.value().asConst().value()));
                continue;
            }
            if (item.matches("new_type")) {
                this.setType(item.value().asConst().value());
                continue;
            }
            if (item.matches("new_num_children")) {
                this.setNumChild(item.value().asConst().value());
                this.setChildren(null, false);
                continue;
            }
            if (item.matches("dynamic")) {
                this.setDynamic(item.value().asConst().value());
                continue;
            }
            if (item.matches("displayhint")) {
                this.setDisplayHint(item.value().asConst().value());
                continue;
            }
            if (item.matches(HAS_MORE)) {
                this.setHasMore(item.value().asConst().value());
                if (!this.hasMore) continue;
                this.setNumChild(item.value().asConst().value());
                this.setChildren(null, false);
                continue;
            }
            if (!item.matches("new_children")) continue;
        }
    }

    static enum DisplayHint {
        NONE,
        ARRAY,
        MAP,
        STRING;

    }
}

