/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class GdbLogger {
    private final FileWriter logFile;
    private final String filename;

    public GdbLogger() {
        FileWriter logFileValue = null;
        String logFilename = null;
        try {
            File tmpfile = File.createTempFile("gdb-cmds", ".log");
            logFilename = tmpfile.getAbsolutePath();
            if (!Boolean.getBoolean("gdb.console.savelog")) {
                tmpfile.deleteOnExit();
            }
            logFileValue = new FileWriter(tmpfile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logFile = logFileValue;
        this.filename = logFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMessage(String message) {
        if (message != null && message.length() > 0 && this.logFile != null) {
            FileWriter fileWriter = this.logFile;
            synchronized (fileWriter) {
                try {
                    this.logFile.write(message);
                    if (message.charAt(message.length() - 1) != '\n') {
                        this.logFile.write(10);
                    }
                    this.logFile.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }
}

