/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;

public final class GdbLocal {
    private String name;
    private String type;
    private String value;
    private boolean simple;

    public GdbLocal(MIValue localvar) {
        MITList varlist = localvar.asTuple();
        this.name = varlist.getConstValue("name");
        this.type = varlist.getConstValue("type");
        MIValue valuev = varlist.valueOf("value");
        if (valuev != null) {
            this.value = valuev.asConst().value();
            this.simple = true;
        } else {
            this.value = "{...}";
            this.simple = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSimple() {
        return this.simple;
    }
}

