/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Address;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Handler;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.HandlerCommand;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.HandlerExpert;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.ExceptionBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.ExceptionBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.InstructionBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.SysCallBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.SysCallBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.VariableBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.props.Property;
import org.netbeans.modules.cnd.debugger.common2.values.Action;
import org.netbeans.modules.cnd.debugger.common2.values.FunctionSubEvent;
import org.netbeans.modules.cnd.debugger.gdb2.Catalog;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerImpl;
import org.netbeans.modules.cnd.debugger.gdb2.GdbHandlerCommand;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;

public class GdbHandlerExpert
implements HandlerExpert {
    private static final boolean sendShortPaths = Boolean.getBoolean("gdb.breakpoints.shortpaths");
    static final Integer infinity = new Integer(Integer.MAX_VALUE);
    private final GdbDebuggerImpl debugger;
    private static final Logger LOG = Logger.getLogger(GdbHandlerExpert.class.toString());

    public GdbHandlerExpert(GdbDebuggerImpl debugger) {
        this.debugger = debugger;
    }

    Handler newHandler(NativeBreakpoint template, MIResult result, NativeBreakpoint breakpoint) {
        MIValue bkptValue = result.value();
        MITList props = bkptValue.asTuple();
        if (breakpoint == null) {
            breakpoint = GdbHandlerExpert.createBreakpoint(props, template);
        } else assert (!breakpoint.hasHandler());
        this.update(template, breakpoint, props);
        Handler handler = new Handler((NativeDebugger)this.debugger, breakpoint);
        this.setGenericProperties(handler, props);
        if (!result.matches("bkpt") && !result.matches("wpt")) {
            handler.setError(Catalog.get("MSG_InvalidLocation"));
        }
        return handler;
    }

    Handler replaceHandler(NativeBreakpoint template, Handler originalHandler, MIResult result, NativeBreakpoint ... targetTemplate) {
        if (!result.matches("bkpt") && !result.matches("wpt")) {
            if (targetTemplate.length == 1) {
                String newLine = targetTemplate[0].getPos().propertyByName("lineNumber").toString();
                originalHandler.breakpoint().getPos().propertyByName("lineNumber").setFromString(newLine);
                originalHandler.setError(Catalog.get("MSG_InvalidLocation"));
            }
            return originalHandler;
        }
        MIValue bkptValue = result.value();
        MITList props = bkptValue.asTuple();
        NativeBreakpoint breakpoint = originalHandler.breakpoint();
        this.update(template, breakpoint, props);
        Handler handler = new Handler((NativeDebugger)this.debugger, breakpoint);
        this.setGenericProperties(handler, props);
        return handler;
    }

    private static void assertBkptResult(MIResult result) {
        assert (result.variable().equals("bkpt") || result.variable().equals("wpt")) : "Result " + result + " is not a breakpoint";
    }

    public HandlerExpert.ReplacementPolicy replacementPolicy() {
        return HandlerExpert.ReplacementPolicy.EXPLICIT;
    }

    public Handler childHandler(NativeBreakpoint bpt) {
        NativeBreakpoint breakpoint = bpt.isToplevel() ? bpt.makeSubBreakpointCopy() : bpt;
        Handler handler = new Handler((NativeDebugger)this.debugger, breakpoint);
        return handler;
    }

    private void appendCommandStart(StringBuilder cmd, NativeBreakpoint breakpoint) {
        cmd.append("-break-insert");
        cmd.append(this.debugger.getGdbVersionPeculiarity().breakPendingFlag());
        if (breakpoint.getTemp()) {
            cmd.append(" -t");
        }
        if (breakpoint.getCondition() != null) {
            cmd.append(" -c ").append(GdbHandlerExpert.quote(breakpoint.getCondition()));
        }
        if (breakpoint.hasCountLimit()) {
            if (breakpoint.getCountLimit() == -1L) {
                cmd.append(" -i ").append(infinity);
            } else {
                Long limit = new Long(breakpoint.getCountLimit() - 1L);
                cmd.append(" -i ").append(limit);
            }
        }
        if (breakpoint.getThread() != null) {
            cmd.append(" -p ").append(breakpoint.getThread());
        }
        if (!breakpoint.isEnabled()) {
            cmd.append(this.debugger.getGdbVersionPeculiarity().breakDisabledFlag());
        }
    }

    public HandlerCommand commandFormNew(NativeBreakpoint breakpoint) {
        if (breakpoint.getAction() != Action.STOP) {
            LOG.warning(Catalog.get("MSG_OnlyStopGdb"));
        }
        if (breakpoint.getBreakpointType() instanceof SysCallBreakpointType && !this.debugger.getGdbVersionPeculiarity().isSyscallBreakpointsSupported()) {
            return HandlerCommand.makeError(null);
        }
        if (!IpeUtils.isEmpty((String)breakpoint.getWhileIn())) {
            LOG.warning(Catalog.get("MSG_NoWhileGdb"));
        }
        if (!IpeUtils.isEmpty((String)breakpoint.getLwp())) {
            LOG.warning(Catalog.get("MSG_NoLwpGdb"));
        }
        StringBuilder cmd = new StringBuilder();
        Class<?> bClass = breakpoint.getClass();
        if (bClass == LineBreakpoint.class) {
            String fileLine;
            LineBreakpoint lb = (LineBreakpoint)breakpoint;
            String file = lb.getFileName();
            int line = lb.getLineNumber();
            file = this.debugger.localToRemote("LineBreakpoint", file);
            file = file.replace("\\", "/");
            if (sendShortPaths || file.indexOf(32) != -1) {
                String baseDir = this.debugger.getNDI().getConfiguration().getBaseDir().replace("\\", "/");
                file = file.startsWith(baseDir + '/') ? file.substring(baseDir.length() + 1) : CndPathUtilitities.getBaseName((String)file);
            }
            if (file != null && file.length() > 0) {
                file = this.debugger.fmap().worldToEngine(file);
                fileLine = file + ":" + line;
            } else {
                fileLine = "" + line;
            }
            this.appendCommandStart(cmd, breakpoint);
            cmd.append(" \"").append(fileLine).append('\"');
        } else if (bClass == InstructionBreakpoint.class) {
            InstructionBreakpoint ib = (InstructionBreakpoint)breakpoint;
            this.appendCommandStart(cmd, breakpoint);
            cmd.append(" *").append(ib.getAddress());
        } else if (bClass == FunctionBreakpoint.class) {
            FunctionBreakpoint fb = (FunctionBreakpoint)breakpoint;
            FunctionSubEvent se = fb.getSubEvent();
            String function = null;
            if (se.equals(FunctionSubEvent.IN)) {
                function = fb.getFunction();
            } else {
                if (se.equals(FunctionSubEvent.INFUNCTION)) {
                    return HandlerCommand.makeError(null);
                }
                if (se.equals(FunctionSubEvent.RETURNS)) {
                    return HandlerCommand.makeError(null);
                }
            }
            this.appendCommandStart(cmd, breakpoint);
            cmd.append(" \"").append(function).append('\"');
        } else if (bClass == VariableBreakpoint.class) {
            VariableBreakpoint vb = (VariableBreakpoint)breakpoint;
            cmd.append("-break-watch ");
            cmd.append(vb.getVariable());
        } else if (bClass == ExceptionBreakpoint.class) {
            ExceptionBreakpoint eb = (ExceptionBreakpoint)breakpoint;
            cmd.append("catch throw");
        } else if (bClass == SysCallBreakpoint.class) {
            SysCallBreakpoint sb = (SysCallBreakpoint)breakpoint;
            cmd.append("catch syscall ");
            String sysCall = sb.getSysCall();
            if (sysCall != null) {
                cmd.append(sysCall);
            }
        } else {
            return HandlerCommand.makeError(null);
        }
        return new GdbHandlerCommand(GdbHandlerCommand.Type.REPLACE, cmd.toString());
    }

    public HandlerCommand commandFormCustomize(final NativeBreakpoint clonedBreakpoint, final NativeBreakpoint repairedBreakpoint) {
        Set diff = NativeBreakpoint.diff((NativeBreakpoint)repairedBreakpoint, (NativeBreakpoint)clonedBreakpoint);
        GdbHandlerCommand cmd = null;
        for (Property property : diff) {
            String value;
            GdbHandlerCommand old = cmd;
            if ("PROP_BREAKPOINT_COUNTLIMIT".equals(property.key())) {
                value = "0";
                if (property.getAsObject() != null) {
                    value = property.getAsObject().toString();
                }
                cmd = new GdbHandlerCommand(GdbHandlerCommand.Type.CHANGE, "-break-after " + repairedBreakpoint.getId() + ' ' + value){

                    @Override
                    void onDone() {
                        repairedBreakpoint.setCountLimit(clonedBreakpoint.getCountLimit(), clonedBreakpoint.hasCountLimit());
                        repairedBreakpoint.update();
                    }
                };
                cmd.setNext(old);
                continue;
            }
            if ("PROP_BREAKPOINT_CONDITION".equals(property.key())) {
                value = "";
                if (property.getAsObject() != null) {
                    value = property.getAsObject().toString();
                }
                cmd = new GdbHandlerCommand(GdbHandlerCommand.Type.CHANGE, "-break-condition " + repairedBreakpoint.getId() + ' ' + value){

                    @Override
                    void onDone() {
                        repairedBreakpoint.setCondition(clonedBreakpoint.getCondition());
                        repairedBreakpoint.update();
                    }
                };
                cmd.setNext(old);
                continue;
            }
            return this.commandFormNew(clonedBreakpoint);
        }
        if (cmd != null) {
            return cmd;
        }
        return this.commandFormNew(clonedBreakpoint);
    }

    private static NativeBreakpoint createBreakpoint(MITList results, NativeBreakpoint template) {
        Object type = null;
        type = template != null ? template.getBreakpointType() : ("catchpoint".equals(results.getConstValue("type")) ? new SysCallBreakpointType() : new ExceptionBreakpointType());
        NativeBreakpoint newBreakpoint = null;
        if (type != null) {
            newBreakpoint = type.newInstance(4);
        }
        return newBreakpoint;
    }

    private void update(NativeBreakpoint template, NativeBreakpoint breakpoint, MITList props) {
        breakpoint.removeAnnotations();
        this.setGenericProperties(breakpoint, props);
        this.setSpecificProperties(template, breakpoint, props);
    }

    private void setGenericProperties(Handler handler, MITList props) {
        String enabledString = props.getConstValue("enabled", "y");
        handler.setEnabled("y".equals(enabledString));
        int number = Integer.parseInt(props.getConstValue("number", "0"));
        handler.setId(number);
    }

    private void setGenericProperties(NativeBreakpoint breakpoint, MITList props) {
        String dispString = props.getConstValue("disp");
        breakpoint.setTemp("del".equals(dispString));
        MIValue ignoreValue = props.valueOf("ignore");
        if (ignoreValue != null) {
            String ignoreString = ignoreValue.asConst().value();
            long ignore = Long.parseLong(ignoreString);
            ignore = ignore == (long)infinity.intValue() ? -1L : ++ignore;
            breakpoint.setCountLimit(ignore, true);
        } else {
            breakpoint.setCountLimit(0L, false);
        }
        breakpoint.setThread(props.getConstValue("thread", null));
        breakpoint.setCondition(props.getConstValue("cond", null));
        Action action = Action.STOP;
        breakpoint.setAction(action);
    }

    private String getFileName(MITList props, NativeBreakpoint originalBreakpoint) {
        String filename = null;
        MIValue fullnameValue = props.valueOf("fullname");
        String fullnameString = null;
        if (fullnameValue == null) {
            int pos;
            fullnameValue = props.valueOf("pending");
            if (fullnameValue != null && (pos = (fullnameString = fullnameValue.asConst().value()).lastIndexOf(":")) != -1) {
                fullnameString = fullnameString.substring(0, pos);
            }
        } else {
            fullnameString = fullnameValue.asConst().value();
        }
        if (fullnameString != null) {
            fullnameString = this.debugger.remoteToLocal("getFileName", fullnameString);
            filename = fullnameString = this.debugger.fmap().engineToWorld(fullnameString);
        } else {
            MIValue fileValue = props.valueOf("file");
            if (fileValue == null) {
                return originalBreakpoint.getPos().propertyByName("fileName").toString();
            }
            if (originalBreakpoint instanceof LineBreakpoint) {
                LineBreakpoint olb = (LineBreakpoint)originalBreakpoint;
                filename = olb.getFileName();
            }
        }
        return filename;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getLine(MITList props, NativeBreakpoint originalBreakpoint) {
        String lineString;
        MIValue lineValue = props.valueOf("line");
        if (lineValue == null) {
            MIValue fullnameValue = props.valueOf("pending");
            if (fullnameValue == null) {
                Property lineProperty = originalBreakpoint.getPos().propertyByName("lineNumber");
                if (lineProperty != null) return Integer.parseInt(lineProperty.toString());
                return 0;
            }
            String lineStr = fullnameValue.asConst().value();
            int pos = lineStr.lastIndexOf(":");
            if (pos == -1) return 0;
            lineString = lineStr.substring(pos + 1);
        } else {
            lineString = lineValue.asConst().value();
        }
        try {
            return Integer.parseInt(lineString);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static long getAddr(MITList props) {
        MIValue addrValue = props.valueOf("addr");
        if (addrValue == null) {
            return 0L;
        }
        String addrString = addrValue.asConst().value();
        try {
            return Address.parseAddr((String)addrString);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private void setSpecificProperties(NativeBreakpoint template, NativeBreakpoint breakpoint, MITList props) {
        if (template instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)breakpoint;
            String filename = this.getFileName(props, template);
            int line = GdbHandlerExpert.getLine(props, template);
            lb.setFileAndLine(filename, line);
        } else if (template instanceof FunctionBreakpoint) {
            FunctionBreakpoint fb = (FunctionBreakpoint)breakpoint;
            String funcString = ((FunctionBreakpoint)template).getFunction();
            fb.setFunction(funcString);
        } else if (template instanceof InstructionBreakpoint) {
            InstructionBreakpoint ib = (InstructionBreakpoint)breakpoint;
            long addr = GdbHandlerExpert.getAddr(props);
            ib.setAddress(Address.toHexString0x((long)addr, (boolean)true));
        } else if (template instanceof VariableBreakpoint) {
            VariableBreakpoint vb = (VariableBreakpoint)breakpoint;
            String exp = props.getConstValue("exp");
            vb.setVariable(exp);
        }
    }

    void addAnnotations(Handler handler, NativeBreakpoint breakpoint, NativeBreakpoint template, MIResult result) {
        MIValue bkptValue = result.value();
        MITList props = bkptValue.asTuple();
        int line = GdbHandlerExpert.getLine(props, template);
        String fileName = line != 0 ? this.getFileName(props, template) : null;
        long addr = GdbHandlerExpert.getAddr(props);
        if (fileName == null) {
            line = 0;
        }
        handler.breakpoint().addAnnotation(fileName, line, addr);
    }

    private static String quote(String in) {
        StringBuilder out = new StringBuilder();
        out.append('\"');
        for (int sx = 0; sx < in.length(); ++sx) {
            char c = in.charAt(sx);
            if (c == '\"') {
                out.append('\\');
            }
            out.append(c);
        }
        out.append('\"');
        return out.toString();
    }
}

