/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerSettings;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerSettingsBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Pathmap;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Signals;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerImpl;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerSettings;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;

public final class GdbDebuggerSettingsBridge
extends DebuggerSettingsBridge {
    private final GdbDebuggerImpl gdbDebugger;
    private Pathmap.Item[] shadowPathmap = null;

    public GdbDebuggerSettingsBridge(NativeDebugger debugger) {
        super(debugger, (DebuggerSettings)new GdbDebuggerSettings());
        this.gdbDebugger = (GdbDebuggerImpl)debugger;
    }

    protected DebuggerSettings createSettingsFromTarget(DebugTarget dt) {
        RunProfile newRunProfile = dt.getRunProfile();
        DbgProfile newDbgProfile = dt.getDbgProfile();
        return GdbDebuggerSettings.create(newRunProfile, newDbgProfile);
    }

    protected void setTentativeSettings(NativeDebuggerInfo info) {
        RunProfile newRunProfile = info.getProfile();
        DbgProfile newDbgProfile = info.getDbgProfile();
        assert (newRunProfile != null);
        String exename = info.getTarget();
        this.assignTentativeSettings(GdbDebuggerSettings.create(newRunProfile, newDbgProfile), exename);
    }

    protected void applyPathmap(Pathmap o, Pathmap n) {
        if (o == null) {
            this.shadowPathmap = new Pathmap.Item[0];
            this.applyPathmap(this.shadowPathmap, n.getPathmap());
        } else {
            this.applyPathmap(o.getPathmap(), n.getPathmap());
        }
    }

    private void applyPathmap(Pathmap.Item[] oldMap, Pathmap.Item[] newMap) {
        int i;
        if (oldMap != null) {
            for (i = 0; i < oldMap.length; ++i) {
                if (newMap != null) {
                    int j;
                    for (j = 0; !(j >= newMap.length || newMap[j].from().equals(oldMap[i].from()) && IpeUtils.sameString((String)newMap[j].to(), (String)oldMap[i].to())); ++j) {
                    }
                    if (j < newMap.length) continue;
                }
                this.gdbDebugger.pathmap("unset substitute-path " + oldMap[i].from());
            }
        }
        if (newMap != null) {
            for (i = 0; i < newMap.length; ++i) {
                if (oldMap != null) {
                    int j;
                    for (j = 0; !(j >= oldMap.length || newMap[i].from().equals(oldMap[j].from()) && IpeUtils.sameString((String)newMap[i].to(), (String)oldMap[j].to())); ++j) {
                    }
                    if (j < oldMap.length) continue;
                }
                String pathmap = null;
                pathmap = "set substitute-path " + newMap[i].from();
                if (newMap[i].to() != null) {
                    pathmap = pathmap + " " + newMap[i].to();
                }
                this.gdbDebugger.pathmap(pathmap);
            }
        }
    }

    protected int getProgLoadedDirty() {
        if (this.debugger.getNDI().getPid() != -1L) {
            return -545;
        }
        if (this.debugger.getNDI().getCorefile() != null) {
            return super.getProgLoadedDirty();
        }
        return super.getProgLoadedDirty() & 0xFFFFFDFF;
    }

    void noteAttached() {
        this.initialApply(544);
    }

    void noteFistStop() {
        this.initialApply(512);
    }

    protected void applyRunargs() {
        DebugTarget debugTarget = this.debugger.getNDI().getDebugTarget();
        String runargs = debugTarget != null && debugTarget.getUnparsedArgs() != null ? debugTarget.getUnparsedArgs() : this.getArgsFlatEx();
        if (runargs == null) {
            runargs = "";
        }
        this.gdbDebugger.runArgs(this.ioRedirect(runargs));
    }

    protected void applyRunDirectory() {
        String runDirectory = this.getRunDirectory();
        if (runDirectory != null) {
            this.gdbDebugger.runDir(runDirectory);
        }
    }

    protected void applyClasspath() {
    }

    protected void applyEnvvars() {
        MacroMap macroMap = MacroMap.createEmpty((ExecutionEnvironment)this.gdbDebugger.getExecutionEnvironment());
        RunProfile mainRunProfile = this.getMainSettings().runProfile();
        macroMap.putAll(mainRunProfile.getEnvironment().getenvAsMap());
        this.applyEnvvars(macroMap, null);
    }

    private void applyEnvvars(MacroMap setEnvs, MacroMap unSetEnvs) {
        this.gdbDebugger.getIOPack().updateEnv(setEnvs);
        if (setEnvs != null) {
            for (Map.Entry entry : setEnvs.entrySet()) {
                this.gdbDebugger.setEnv((String)entry.getKey() + '=' + (String)entry.getValue());
            }
        }
        if (unSetEnvs != null) {
            for (Map.Entry entry : unSetEnvs.entrySet()) {
                this.gdbDebugger.unSetEnv((String)entry.getKey());
            }
        }
    }

    protected void applyEnvvars(String[][] o, String[][] n) {
        MacroMap setEnvs = MacroMap.createEmpty((ExecutionEnvironment)this.gdbDebugger.getExecutionEnvironment());
        for (int i = 0; i < n.length; ++i) {
            setEnvs.put(n[i][0], n[i][1]);
        }
        MacroMap unSetEnvs = MacroMap.createEmpty((ExecutionEnvironment)this.gdbDebugger.getExecutionEnvironment());
        for (int ox = 0; ox < o.length; ++ox) {
            boolean found = false;
            for (int nx = 0; nx < n.length; ++nx) {
                if (!o[ox][0].equals(n[nx][0])) continue;
                found = true;
                break;
            }
            if (found) continue;
            unSetEnvs.put(o[ox][0], o[ox][1]);
        }
        this.applyEnvvars(setEnvs, unSetEnvs);
    }

    protected void applySignals(Signals o, Signals n) {
    }

    protected void applyInterceptList() {
    }

    static String[] detectRedirect(String runargs, String type) {
        String[] res = new String[]{null, runargs};
        int argPos = runargs.indexOf(type);
        if (argPos != -1) {
            res[1] = runargs.substring(0, argPos);
            try {
                while (runargs.charAt(++argPos) == ' ') {
                }
            }
            catch (IndexOutOfBoundsException e) {
                argPos = -1;
            }
            if (argPos != -1) {
                int endPos = runargs.charAt(argPos) == '\"' ? (runargs.indexOf(34, argPos + 1) == -1 ? runargs.length() : runargs.indexOf(34, argPos + 1) + 1) : (runargs.indexOf(32, argPos) == -1 ? runargs.length() : runargs.indexOf(32, argPos));
                res[0] = runargs.substring(argPos, endPos);
                res[1] = res[1] + runargs.substring(Math.min(endPos + 1, runargs.length()));
            }
        }
        return res;
    }

    private String ioRedirect(String runargs) {
        String outFile;
        String[] files = this.gdbDebugger.getIOPack().getIOFiles();
        if (files == null) {
            return runargs;
        }
        String[] res = GdbDebuggerSettingsBridge.detectRedirect(runargs, "<");
        String inArg = res[0];
        runargs = res[1];
        res = GdbDebuggerSettingsBridge.detectRedirect(runargs, ">");
        String outArg = res[0];
        runargs = res[1];
        HostInfo.OSFamily osFamily = HostInfo.OSFamily.UNKNOWN;
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.gdbDebugger.getExecutionEnvironment());
            osFamily = hostInfo.getOSFamily();
        }
        catch (ConnectionManager.CancellationException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        StringBuilder inRedir = new StringBuilder();
        inRedir.append(runargs);
        String inFile = inArg == null ? files[0] : inArg;
        String string = outFile = outArg == null ? files[1] : outArg;
        if (osFamily == HostInfo.OSFamily.WINDOWS) {
            inFile = this.gdbDebugger.fmap().worldToEngine(inFile);
            outFile = this.gdbDebugger.fmap().worldToEngine(outFile);
        }
        if (osFamily == HostInfo.OSFamily.MACOSX) {
            inRedir.append(" < ").append(inFile).append(" > ").append(outFile).append(" 2> ").append(outFile);
        } else {
            String shell = (String)HostInfoProvider.getEnv((ExecutionEnvironment)this.gdbDebugger.getExecutionEnvironment()).get("SHELL");
            if (shell != null && shell.endsWith("csh")) {
                inRedir.append(" < ").append(inFile).append(" >& ").append(outFile);
            } else {
                inRedir.append(" < ").append(inFile).append(" > ").append(outFile).append(" 2>&1");
            }
        }
        return inRedir.toString();
    }
}

