/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.File;
import org.netbeans.lib.profiler.global.ProfilingPointServerHandler;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.system.HeapDump;
import org.netbeans.lib.profiler.server.system.Timers;

public class TakeHeapdumpProfilingPointHandler
extends ProfilingPointServerHandler {
    private static ProfilingPointServerHandler instance;
    private static final String TAKEN_HEAPDUMP_PREFIX = "heapdump-";
    private static final String HEAPDUMP_EXTENSION = "hprof";
    private String heapdumpFilePrefix;
    private boolean remoteProfiling;

    private TakeHeapdumpProfilingPointHandler(String dir) {
        this.heapdumpFilePrefix = dir + File.separatorChar + TAKEN_HEAPDUMP_PREFIX;
        this.remoteProfiling = ProfilerServer.getProfilingSessionStatus().remoteProfiling;
    }

    public static synchronized ProfilingPointServerHandler getInstance(String clientInfo) {
        if (instance == null) {
            instance = new TakeHeapdumpProfilingPointHandler(clientInfo);
        }
        return instance;
    }

    public void profilingPointHit(int id) {
        String heapdumpName;
        String error;
        boolean cpuProfiling;
        int instrType = ProfilerInterface.getCurrentInstrType();
        boolean bl = cpuProfiling = instrType == 3 || instrType == 4;
        if (cpuProfiling) {
            ProfilerRuntimeCPU.suspendCurrentThreadTimer();
        }
        long absTimeStamp = Timers.getCurrentTimeInCounts();
        if (!this.remoteProfiling && (error = HeapDump.takeHeapDump((String)(heapdumpName = this.getHeapDumpName(absTimeStamp)))) != null) {
            System.err.println("Dump to " + heapdumpName + " failed with " + error);
        }
        super.profilingPointHit(id, absTimeStamp);
        if (cpuProfiling) {
            ProfilerRuntimeCPU.resumeCurrentThreadTimer();
        }
    }

    private String getHeapDumpName(long time) {
        return this.heapdumpFilePrefix + (time & 0xFFFFFFFFFFFFFFL) + "." + HEAPDUMP_EXTENSION;
    }
}

