/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.wireprotocol.HeapHistogramResponse;

class HeapHistogramManager {
    private static final String BOOLEAN_TEXT = "boolean";
    private static final String CHAR_TEXT = "char";
    private static final String BYTE_TEXT = "byte";
    private static final String SHORT_TEXT = "short";
    private static final String INT_TEXT = "int";
    private static final String LONG_TEXT = "long";
    private static final String FLOAT_TEXT = "float";
    private static final String DOUBLE_TEXT = "double";
    private static final String VOID_TEXT = "void";
    private static final char BOOLEAN_CODE = 'Z';
    private static final char CHAR_CODE = 'C';
    private static final char BYTE_CODE = 'B';
    private static final char SHORT_CODE = 'S';
    private static final char INT_CODE = 'I';
    private static final char LONG_CODE = 'J';
    private static final char FLOAT_CODE = 'F';
    private static final char DOUBLE_CODE = 'D';
    private static final char OBJECT_CODE = 'L';
    private static final Map permGenNames = new HashMap();
    Map classesIdMap = new HashMap(8000);
    boolean isJrockitVM;

    HeapHistogramManager() {
        String vmName = System.getProperty("java.vm.name");
        if (vmName != null) {
            if ("BEA JRockit(R)".equals(vmName)) {
                this.isJrockitVM = true;
            } else if ("Oracle JRockit(R)".equals(vmName)) {
                this.isJrockitVM = true;
            }
        }
    }

    HeapHistogramResponse computeHistogram(InputStream in) {
        if (in == null) {
            return null;
        }
        HeapHistogramResponse histogram = this.isJrockitVM ? this.computeHistogramJRockit(in) : this.computeHistogramImpl(in);
        try {
            in.close();
        }
        catch (IOException ex) {
            System.err.println("*** Profiler engine warning: " + this.getClass() + "cannot close InputStream");
        }
        return histogram;
    }

    private HeapHistogramResponse computeHistogramJRockit(InputStream in) {
        long totalHeapBytes = 0L;
        long totalHeapInstances = 0L;
        long totalInstances = 0L;
        long totalBytes = 0L;
        HashMap classesMap = new HashMap(1024);
        Date time = new Date();
        Scanner sc = new Scanner(in, "UTF-8");
        sc.useRadix(10);
        sc.nextLine();
        sc.skip("-+");
        sc.nextLine();
        while (sc.hasNext("[0-9]+\\.[0-9]%")) {
            JRockitClassInfoImpl newClInfo = new JRockitClassInfoImpl(sc);
            if (ProfilerInterface.serverInternalClassName(newClInfo.getName())) continue;
            HeapHistogramManager.storeClassInfo(newClInfo, classesMap);
            totalHeapBytes += newClInfo.getBytes();
            totalHeapInstances += newClInfo.getInstancesCount();
        }
        totalInstances = totalHeapInstances;
        totalBytes = totalHeapBytes;
        return this.getResponse(classesMap, time);
    }

    private HeapHistogramResponse computeHistogramImpl(InputStream in) {
        long totalBytes = 0L;
        long totalInstances = 0L;
        long totalHeapBytes = 0L;
        long totalHeapInstances = 0L;
        long totalPermGenBytes = 0L;
        long totalPermgenInstances = 0L;
        HashMap permGenMap = new HashMap(1024);
        HashMap classesMap = new HashMap(1024);
        Date time = new Date();
        Scanner sc = new Scanner(in, "UTF-8");
        sc.useRadix(10);
        sc.nextLine();
        sc.nextLine();
        sc.skip("-+");
        sc.nextLine();
        while (sc.hasNext("[0-9]+:")) {
            ClassInfoImpl newClInfo = new ClassInfoImpl(sc);
            if (ProfilerInterface.serverInternalClassName(newClInfo.getName())) continue;
            if (newClInfo.isPermGen()) {
                HeapHistogramManager.storeClassInfo(newClInfo, permGenMap);
                totalPermGenBytes += newClInfo.getBytes();
                totalPermgenInstances += newClInfo.getInstancesCount();
                continue;
            }
            HeapHistogramManager.storeClassInfo(newClInfo, classesMap);
            totalHeapBytes += newClInfo.getBytes();
            totalHeapInstances += newClInfo.getInstancesCount();
        }
        sc.next("Total");
        totalInstances = sc.nextLong();
        totalBytes = sc.nextLong();
        return this.getResponse(classesMap, time);
    }

    static void storeClassInfo(ClassInfoImpl newClInfo, Map map) {
        ClassInfoImpl oldClInfo = (ClassInfoImpl)map.get(newClInfo.getName());
        if (oldClInfo == null) {
            map.put(newClInfo.getName(), newClInfo);
        } else {
            oldClInfo.bytes += newClInfo.getBytes();
            oldClInfo.instances += newClInfo.getInstancesCount();
        }
    }

    private HeapHistogramResponse getResponse(Map classesMap, Date time) {
        HashMap<String, Integer> newClassNames = new HashMap<String, Integer>(100);
        int[] ids = new int[classesMap.size()];
        long[] instances = new long[classesMap.size()];
        long[] bytes = new long[classesMap.size()];
        int outIndex = 0;
        Iterator<Object> it = classesMap.values().iterator();
        while (it.hasNext()) {
            ClassInfoImpl ci = (ClassInfoImpl)it.next();
            String name = ci.getName();
            Integer cindex = (Integer)this.classesIdMap.get(name);
            if (cindex == null) {
                cindex = new Integer(this.classesIdMap.size());
                this.classesIdMap.put(name, cindex);
                newClassNames.put(name, cindex);
            }
            ids[outIndex] = cindex;
            instances[outIndex] = ci.instances;
            bytes[outIndex] = ci.bytes;
            ++outIndex;
        }
        int[] newids = new int[newClassNames.size()];
        String[] newNames = new String[newClassNames.size()];
        outIndex = 0;
        it = newClassNames.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry newClassEntry = (Map.Entry)it.next();
            newids[outIndex] = (Integer)newClassEntry.getValue();
            newNames[outIndex] = (String)newClassEntry.getKey();
            ++outIndex;
        }
        return new HeapHistogramResponse(time, newNames, newids, ids, instances, bytes);
    }

    static {
        permGenNames.put("<methodKlass>", "Read-Write Method Metadata");
        permGenNames.put("<constMethodKlass>", "Read-Only Method Metadata");
        permGenNames.put("<methodDataKlass>", "Method Profiling Information");
        permGenNames.put("<constantPoolKlass>", "Constant Pool Metadata");
        permGenNames.put("<constantPoolCacheKlass>", "Class Resolution Optimization Metadata");
        permGenNames.put("<symbolKlass>", "VM Symbol Metadata");
        permGenNames.put("<compiledICHolderKlass>", "Inline Cache Metadata");
        permGenNames.put("<instanceKlassKlass>", "Instance Class Metadata");
        permGenNames.put("<objArrayKlassKlass>", "Object Array Class Metadata");
        permGenNames.put("<typeArrayKlassKlass>", "Scalar Array Class Metadata");
        permGenNames.put("<klassKlass>", "Base Class Metadata");
        permGenNames.put("<arrayKlassKlass>", "Base Array Class Metadata");
    }

    static class JRockitClassInfoImpl
    extends ClassInfoImpl {
        JRockitClassInfoImpl(Scanner sc) {
            sc.next();
            this.bytes = this.computeBytes(sc.next());
            this.instances = sc.nextLong();
            sc.next();
            String jvmName = sc.next();
            this.name = this.convertJVMName(jvmName.replace('/', '.'));
        }

        private long computeBytes(String size) {
            String multi = size.substring(size.length() - 1);
            long bytes = Long.parseLong(size.substring(0, size.length() - 1));
            if ("K".equalsIgnoreCase(multi)) {
                bytes *= 1024L;
            } else if ("M".equalsIgnoreCase(multi)) {
                bytes *= 0x100000L;
            } else if ("G".equalsIgnoreCase(multi)) {
                bytes *= 0x40000000L;
            }
            return bytes;
        }
    }

    static class ClassInfoImpl {
        long instances;
        long bytes;
        String name;
        boolean permGen;

        ClassInfoImpl() {
        }

        ClassInfoImpl(Scanner sc) {
            sc.next();
            this.instances = sc.nextLong();
            this.bytes = sc.nextLong();
            String jvmName = sc.next();
            this.permGen = jvmName.charAt(0) == '<';
            this.name = this.convertJVMName(jvmName);
        }

        public String getName() {
            return this.name;
        }

        public long getInstancesCount() {
            return this.instances;
        }

        public long getBytes() {
            return this.bytes;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassInfoImpl) {
                return this.getName().equals(((ClassInfoImpl)obj).getName());
            }
            return false;
        }

        private boolean isPermGen() {
            return this.permGen;
        }

        String convertJVMName(String jvmName) {
            String name = null;
            int index = jvmName.lastIndexOf(91);
            if (index != -1) {
                switch (jvmName.charAt(index + 1)) {
                    case 'Z': {
                        name = HeapHistogramManager.BOOLEAN_TEXT;
                        break;
                    }
                    case 'C': {
                        name = HeapHistogramManager.CHAR_TEXT;
                        break;
                    }
                    case 'B': {
                        name = HeapHistogramManager.BYTE_TEXT;
                        break;
                    }
                    case 'S': {
                        name = HeapHistogramManager.SHORT_TEXT;
                        break;
                    }
                    case 'I': {
                        name = HeapHistogramManager.INT_TEXT;
                        break;
                    }
                    case 'J': {
                        name = HeapHistogramManager.LONG_TEXT;
                        break;
                    }
                    case 'F': {
                        name = HeapHistogramManager.FLOAT_TEXT;
                        break;
                    }
                    case 'D': {
                        name = HeapHistogramManager.DOUBLE_TEXT;
                        break;
                    }
                    case 'L': {
                        name = jvmName.substring(index + 2, jvmName.length() - 1);
                        break;
                    }
                    default: {
                        System.err.println("Uknown name " + jvmName);
                        name = jvmName;
                    }
                }
                for (int i = 0; i <= index; ++i) {
                    name = name + "[]";
                }
            } else if (this.isPermGen()) {
                name = (String)permGenNames.get(jvmName);
            }
            if (name == null) {
                name = jvmName;
            }
            return name;
        }
    }
}

