/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.lib.profiler.global.Platform;

public class ClassBytesLoader {
    private static Map jarCache = new HashMap();

    public static byte[] getClassFileBytes(String className) {
        String resourceName = className.replace('.', '/') + ".class";
        URL classUrl = ClassLoader.getSystemResource(resourceName);
        if (classUrl == null) {
            if (Platform.getJDKVersionNumber() == 5) {
                return null;
            }
            System.err.println("***Profiler agent warning: could not get .class file for a synthetic class " + className + " in ClassBytesLoader.getClassFileBytes");
            return null;
        }
        String proto = classUrl.getProtocol();
        if (proto == null) {
            System.err.println("***Profiler agent critical error: could not get .class file for class " + className + " in ClassBytesLoader.getClassFileBytes");
            return null;
        }
        try {
            if (proto.equals("jar")) {
                return ClassBytesLoader.readJar(classUrl);
            }
            if (proto.equals("file")) {
                return ClassBytesLoader.readFile(classUrl);
            }
            System.err.println("***Profiler agent critical error: Invalid URL " + classUrl);
            return null;
        }
        catch (IOException ex) {
            System.err.println("*** Profiler agent critical error: caught IOException in ClassBytesLoadergetClassFileBytes: " + ex);
            ex.printStackTrace();
            System.err.println("*** End Profiler agent critical error message ---------------------------");
            return null;
        }
        catch (URISyntaxException ex) {
            System.err.println("*** Profiler agent critical error: caught URISyntaxException in ClassBytesLoadergetClassFileBytes: " + ex);
            ex.printStackTrace();
            System.err.println("*** End Profiler agent critical error message ---------------------------");
            return null;
        }
    }

    public static void preloadClasses() {
        ClassBytesLoader.getClassFileBytes("sun.misc.Launcher");
        new FilePermission("*", "read");
        HashMap h = new HashMap();
        h.keySet().iterator();
        Deflater d = new Deflater();
    }

    private static byte[] readFile(URL classUrl) throws IOException, URISyntaxException {
        URI uri = new URI(classUrl.toString());
        File file = new File(uri);
        RandomAccessFile f = new RandomAccessFile(file, "r");
        byte[] buf = new byte[(int)f.length()];
        f.readFully(buf);
        f.close();
        return buf;
    }

    private static byte[] readJar(URL classUrl) throws IOException {
        String filePart = classUrl.getFile();
        int sep = filePart.lastIndexOf(33);
        String file = filePart.substring(0, sep);
        String entry = filePart.substring(sep + 2);
        ZipFile jarFile = (ZipFile)jarCache.get(file);
        int pos = 0;
        if (jarFile == null) {
            jarFile = new ZipFile(new File(URI.create(file)));
            jarCache.put(file, jarFile);
        }
        ZipEntry zipEntry = jarFile.getEntry(entry);
        InputStream is = jarFile.getInputStream(zipEntry);
        byte[] buf = new byte[(int)zipEntry.getSize()];
        while (pos < buf.length) {
            pos += is.read(buf, pos, buf.length - pos);
        }
        is.close();
        return buf;
    }
}

