/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.dd.spi.web.WebAppMetadataModelFactory;
import org.netbeans.modules.j2ee.dd.spi.webservices.WebservicesMetadataModelFactory;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.j2ee.BaseEEModuleImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation2;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class WebModuleImpl
extends BaseEEModuleImpl
implements WebModuleImplementation2,
J2eeModuleImplementation2 {
    private static final String WEB_INF = "WEB-INF";
    private MetadataModel<WebAppMetadata> webAppMetadataModel;
    private MetadataModel<WebAppMetadata> webAppAnnMetadataModel;
    private MetadataModel<WebservicesMetadata> webservicesMetadataModel;
    private boolean inplace = false;

    public WebModuleImpl(Project project, WebModuleProviderImpl provider) {
        super(project, provider, "web.xml", "WEB-INF/web.xml");
    }

    public J2eeModule.Type getModuleType() {
        return J2eeModule.Type.WAR;
    }

    public FileObject getArchive() throws IOException {
        return this.getArchive("org.apache.maven.plugins", "maven-war-plugin", "war", "war");
    }

    public FileObject getWebInf() {
        FileObject root = this.getDocumentBase();
        if (root != null) {
            return root.getFileObject(WEB_INF);
        }
        return null;
    }

    public FileObject createWebInf() throws IOException {
        FileObject root = this.getDocumentBase();
        if (root != null) {
            return root.createFolder(WEB_INF);
        }
        return null;
    }

    public FileObject getDocumentBase() {
        Sources srcs = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] grp = srcs.getSourceGroups("doc_root");
        if (grp.length > 0) {
            return grp[0].getRootFolder();
        }
        return null;
    }

    public void setWarInplace(boolean inplace) {
        this.inplace = inplace;
    }

    public Profile getJ2eeProfile() {
        Profile propProfile = this.getPropertyJ2eeProfile();
        Profile descriptorProfile = this.getDescriptorJ2eeProfile();
        if (descriptorProfile != null) {
            if (descriptorProfile.equals(Profile.JAVA_EE_6_WEB) && propProfile != null && propProfile.equals(Profile.JAVA_EE_6_FULL)) {
                return propProfile;
            }
            return descriptorProfile;
        }
        if (propProfile != null) {
            return propProfile;
        }
        return Profile.JAVA_EE_5;
    }

    public Profile getPropertyJ2eeProfile() {
        String version;
        AuxiliaryProperties prop = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        if (prop != null && (version = prop.get("netbeans.hint.j2eeVersion", true)) != null) {
            return Profile.fromPropertiesString((String)version);
        }
        return null;
    }

    public Profile getDescriptorJ2eeProfile() {
        DDProvider prov = DDProvider.getDefault();
        FileObject dd = this.getDeploymentDescriptor();
        if (dd != null) {
            try {
                WebApp wa = prov.getDDRoot(dd);
                String waVersion = wa.getVersion();
                if ("2.4".equals(waVersion)) {
                    return Profile.J2EE_14;
                }
                if ("2.5".equals(waVersion)) {
                    return Profile.JAVA_EE_5;
                }
                if ("3.0".equals(waVersion)) {
                    return Profile.JAVA_EE_6_WEB;
                }
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            return null;
        }
        return Profile.JAVA_EE_6_WEB;
    }

    @Override
    public File getDDFile(String path) {
        URI webappDir = this.mavenproject().getWebAppDirectory();
        File file = new File(new File(webappDir), path);
        return FileUtil.normalizeFile((File)file);
    }

    @Override
    public FileObject getDeploymentDescriptor() {
        File dd = this.getDDFile("WEB-INF/web.xml");
        if (dd != null) {
            return FileUtil.toFileObject((File)dd);
        }
        return null;
    }

    public String getContextPath() {
        Profile prof = this.getJ2eeProfile();
        if (this.getDeploymentDescriptor() != null || prof == Profile.JAVA_EE_6_FULL || prof == Profile.JAVA_EE_6_WEB) {
            try {
                String path = this.provider.getConfigSupport().getWebContextRoot();
                if (path != null) {
                    return path;
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return "/" + this.mavenproject().getMavenProject().getArtifactId();
    }

    public void setContextPath(String newPath) {
        Profile prof = this.getJ2eeProfile();
        if (this.getDeploymentDescriptor() != null || prof == Profile.JAVA_EE_6_FULL || prof == Profile.JAVA_EE_6_WEB) {
            try {
                this.provider.getConfigSupport().setWebContextRoot(newPath);
            }
            catch (ConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public String getModuleVersion() {
        WebApp wapp = this.getWebApp();
        String version = null;
        if (wapp != null) {
            version = wapp.getVersion();
        }
        if (version == null) {
            version = "3.0";
        }
        return version;
    }

    private WebApp getWebApp() {
        try {
            FileObject deploymentDescriptor = this.getDeploymentDescriptor();
            if (deploymentDescriptor != null) {
                return DDProvider.getDefault().getDDRoot(deploymentDescriptor);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().log(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public FileObject getContentDirectory() throws IOException {
        FileObject webappFO;
        if (this.inplace) {
            webappFO = this.getDocumentBase();
        } else {
            MavenProject mavenProject = this.mavenproject().getMavenProject();
            String webappLocation = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-war-plugin", (String)"webappDirectory", (String)"war", null);
            if (webappLocation == null) {
                webappLocation = mavenProject.getBuild().getDirectory() + File.separator + mavenProject.getBuild().getFinalName();
            }
            File webapp = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)webappLocation);
            webappFO = FileUtil.toFileObject((File)webapp);
        }
        if (webappFO != null) {
            webappFO.refresh();
        }
        return webappFO;
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
        if (type == WebAppMetadata.class) {
            MetadataModel<WebAppMetadata> model = this.getAnnotationMetadataModel();
            return model;
        }
        if (type == WebservicesMetadata.class) {
            MetadataModel<WebservicesMetadata> model = this.getWebservicesMetadataModel();
            return model;
        }
        return null;
    }

    public synchronized MetadataModel<WebAppMetadata> getMetadataModel() {
        if (this.webAppMetadataModel == null) {
            FileObject ddFO = this.getDeploymentDescriptor();
            final FileObject webInf = this.getOrCreateWebInf();
            if (ddFO == null && webInf != null) {
                webInf.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDataCreated(FileEvent fe) {
                        if ("web.xml".equals(fe.getFile().getNameExt())) {
                            webInf.removeFileChangeListener((FileChangeListener)this);
                            WebModuleImpl.this.resetMetadataModel();
                        }
                    }
                });
            }
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webAppMetadataModel = WebAppMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit, (boolean)true);
        }
        return this.webAppMetadataModel;
    }

    private FileObject getOrCreateWebInf() {
        FileObject webInf = this.getWebInf();
        if (webInf == null) {
            try {
                webInf = this.createWebInf();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return webInf;
    }

    private synchronized void resetMetadataModel() {
        this.webAppMetadataModel = null;
    }

    private synchronized MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        if (this.webservicesMetadataModel == null) {
            FileObject ddFO = this.getWebServicesDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webservicesMetadataModel = WebservicesMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit);
        }
        return this.webservicesMetadataModel;
    }

    private FileObject getWebServicesDeploymentDescriptor() {
        FileObject root = this.getDocumentBase();
        if (root != null) {
            return root.getFileObject("WEB-INF/webservices.xml");
        }
        return null;
    }

    public synchronized MetadataModel<WebAppMetadata> getAnnotationMetadataModel() {
        if (this.webAppAnnMetadataModel == null) {
            FileObject ddFO = this.getDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webAppAnnMetadataModel = WebAppMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit, (boolean)false);
        }
        return this.webAppAnnMetadataModel;
    }
}

