/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.customizer;

import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.j2ee.customizer.BaseRunCustomizer;
import org.netbeans.modules.maven.j2ee.utils.LoggingUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CustomizerRunEar
extends BaseRunCustomizer {
    private Ear module;
    private JCheckBox cbBrowser;
    private JComboBox comServer;
    private JLabel dosDescription;
    private JCheckBox jCheckBoxDeployOnSave;
    private JLabel lblJ2EEVersion;
    private JLabel lblServer;
    private JTextField txtJ2EEVersion;

    public CustomizerRunEar(ModelHandle2 handle, Project project) {
        super(handle, project);
        this.initComponents();
        this.module = Ear.getEar((FileObject)project.getProjectDirectory());
        if (this.module != null) {
            this.loadServerModel(this.comServer, J2eeModule.Type.EAR, this.module.getJ2eeProfile());
            this.txtJ2EEVersion.setText(this.module.getJ2eePlatformVersion());
        }
        this.initValues();
        this.initDeployOnSaveComponent(this.jCheckBoxDeployOnSave, this.dosDescription);
        this.initServerComponent(this.comServer, this.lblServer);
    }

    private void initValues() {
        String browser = (String)this.project.getProjectDirectory().getAttribute("netbeans.deploy.showBrowser");
        boolean selected = browser != null ? Boolean.parseBoolean(browser) : true;
        this.cbBrowser.setSelected(selected);
    }

    @Override
    public void applyChangesInAWT() {
        boolean browserSelected = this.cbBrowser.isSelected();
        try {
            this.project.getProjectDirectory().setAttribute("netbeans.deploy.showBrowser", (Object)(browserSelected ? null : Boolean.FALSE.toString()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Object obj = this.comServer.getSelectedItem();
        if (obj != null) {
            LoggingUtils.logUsage(CustomizerRunEar.class, "USG_PROJECT_CONFIG_MAVEN_SERVER", new Object[]{obj.toString()}, "maven");
        }
    }

    @Override
    public void applyChanges() {
        this.changeServer(this.comServer);
    }

    private void initComponents() {
        this.lblServer = new JLabel();
        this.comServer = new JComboBox();
        this.lblJ2EEVersion = new JLabel();
        this.txtJ2EEVersion = new JTextField();
        this.cbBrowser = new JCheckBox();
        this.jCheckBoxDeployOnSave = new JCheckBox();
        this.dosDescription = new JLabel();
        this.lblServer.setText(NbBundle.getMessage(CustomizerRunEar.class, (String)"LBL_Server"));
        this.lblJ2EEVersion.setText(NbBundle.getMessage(CustomizerRunEar.class, (String)"LBL_J2EE_Version"));
        this.txtJ2EEVersion.setEditable(false);
        this.cbBrowser.setText(NbBundle.getMessage(CustomizerRunEar.class, (String)"LBL_Display_on_Run"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxDeployOnSave, (String)NbBundle.getMessage(CustomizerRunEar.class, (String)"EarRunCustomizerPanel.jCheckBoxDeployOnSave.text"));
        this.dosDescription.setText(NbBundle.getMessage(CustomizerRunEar.class, (String)"EarRunCustomizerPanel.dosDescription.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblJ2EEVersion).addComponent(this.lblServer)).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comServer, GroupLayout.Alignment.TRAILING, 0, 309, Short.MAX_VALUE).addComponent(this.txtJ2EEVersion, GroupLayout.Alignment.TRAILING, -1, 309, Short.MAX_VALUE))).addComponent(this.cbBrowser).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.dosDescription, -1, 379, Short.MAX_VALUE)).addComponent(this.jCheckBoxDeployOnSave)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblServer).addComponent(this.comServer, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblJ2EEVersion).addComponent(this.txtJ2EEVersion, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.cbBrowser).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDeployOnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dosDescription, -2, -1, -2).addContainerGap(90, Short.MAX_VALUE)));
        this.cbBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRunEar.class, (String)"EarRunCustomizerPanel.cbBrowser.AccessibleContext.accessibleDescription"));
    }
}

