/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.customizer;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.customizer.support.CheckBoxUpdater;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.Wrapper;
import org.netbeans.modules.maven.j2ee.customizer.ApplyChangesCustomizer;
import org.netbeans.modules.maven.j2ee.customizer.CustomizerRunWeb;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.openide.util.NbBundle;

public abstract class BaseRunCustomizer
extends JPanel
implements ApplyChangesCustomizer {
    protected Project project;
    protected ModelHandle2 handle;
    protected CheckBoxUpdater deployOnSaveUpdater;
    protected ComboBoxUpdater<Wrapper> serverModelUpdater;

    public BaseRunCustomizer(ModelHandle2 handle, Project project) {
        this.handle = handle;
        this.project = project;
    }

    protected void changeServer(JComboBox selectedServerComboBox) {
        Wrapper selectedServer;
        SessionContent sc = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
        if (this.serverModelUpdater.getValue() != null) {
            sc.setServerInstanceId(null);
        }
        if ("DEV-NULL".equals((selectedServer = (Wrapper)selectedServerComboBox.getSelectedItem()).getServerInstanceID())) {
            MavenProjectSupport.setServerID(this.project, null);
            MavenProjectSupport.setServerInstanceID(this.project, null);
            MavenProjectSupport.setOldServerInstanceID(this.project, null);
        }
        MavenProjectSupport.changeServer(this.project, false);
    }

    protected void initDeployOnSaveComponent(final JCheckBox dosCheckBox, final JLabel dosDescription) {
        this.deployOnSaveUpdater = new CheckBoxUpdater(dosCheckBox){

            public Boolean getValue() {
                String s = BaseRunCustomizer.this.handle.getRawAuxiliaryProperty("netbeans.deploy.on.save", true);
                if (s != null) {
                    return Boolean.valueOf(s);
                }
                return null;
            }

            public void setValue(Boolean value) {
                BaseRunCustomizer.this.handle.setRawAuxiliaryProperty("netbeans.deploy.on.save", value == null ? null : Boolean.toString(value), true);
            }

            public boolean getDefaultValue() {
                return true;
            }
        };
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                BaseRunCustomizer.this.updateDoSEnablement(dosCheckBox, dosDescription);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    protected void initServerComponent(JComboBox serverComboBox, JLabel serverLabel) {
        this.serverModelUpdater = Wrapper.createComboBoxUpdater(this.handle, serverComboBox, serverLabel);
    }

    private void updateDoSEnablement(JCheckBox dosCheckBox, JLabel dosDescription) {
        String cos = this.handle.getRawAuxiliaryProperty("netbeans.compile.on.save", true);
        boolean enabled = cos == null || "all".equalsIgnoreCase(cos) || "app".equalsIgnoreCase(cos);
        dosCheckBox.setEnabled(enabled);
        dosDescription.setEnabled(enabled);
        if (enabled) {
            dosDescription.setText(NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.dosDescription.text"));
        } else {
            dosDescription.setText(NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.dosDescriptionIfDisabled.text"));
        }
    }

    protected void loadServerModel(JComboBox serverModel, J2eeModule.Type type, Profile profile) {
        String[] ids = Deployment.getDefault().getServerInstanceIDs(Collections.singleton(type), profile);
        ArrayList<Wrapper> col = new ArrayList<Wrapper>();
        SessionContent sc = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
        if (sc != null && sc.getServerInstanceId() != null) {
            col.add(new Wrapper("DEV-NULL", sc.getServerInstanceId()));
        } else {
            col.add(new Wrapper("DEV-NULL"));
        }
        for (String id : ids) {
            col.add(new Wrapper(id));
        }
        serverModel.setModel(new DefaultComboBoxModel<Object>(col.toArray()));
    }
}

