/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.CopyOnSave;
import org.netbeans.modules.maven.j2ee.ExecutionChecker;
import org.netbeans.modules.maven.j2ee.utils.LoggingUtils;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ProjectHookImpl
extends ProjectOpenedHook {
    private static final RequestProcessor RP = new RequestProcessor(ProjectHookImpl.class);
    private final Project project;
    private PropertyChangeListener refreshListener;
    private J2eeModuleProvider lastJ2eeProvider;

    public ProjectHookImpl(Project project) {
        this.project = project;
    }

    protected void projectOpened() {
        MavenProjectSupport.changeServer(this.project, false);
        CopyOnSave copyOnSave = (CopyOnSave)this.project.getLookup().lookup(CopyOnSave.class);
        if (copyOnSave != null) {
            copyOnSave.initialize();
        }
        if (this.refreshListener == null) {
            NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            this.refreshListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        MavenProjectSupport.changeServer(ProjectHookImpl.this.project, false);
                    }
                }
            };
            watcher.addPropertyChangeListener(this.refreshListener);
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                LoggingUtils.logUsage(ExecutionChecker.class, "USG_PROJECT_OPEN_MAVEN_EE", new Object[]{ProjectHookImpl.this.getServerName(), ProjectHookImpl.this.getEEversion()}, "maven");
            }
        });
    }

    protected void projectClosed() {
        CopyOnSave copyOnSave;
        if (this.refreshListener != null) {
            NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            watcher.removePropertyChangeListener(this.refreshListener);
            this.refreshListener = null;
        }
        if (this.lastJ2eeProvider != null) {
            Deployment.getDefault().disableCompileOnSaveSupport(this.lastJ2eeProvider);
            this.lastJ2eeProvider = null;
        }
        if ((copyOnSave = (CopyOnSave)this.project.getLookup().lookup(CopyOnSave.class)) != null) {
            copyOnSave.cleanup();
        }
    }

    private String getServerName() {
        String serverName = MavenProjectSupport.obtainServerName(this.project);
        if (serverName == null) {
            serverName = NbBundle.getMessage(ProjectHookImpl.class, (String)"MSG_No_Server");
        }
        return serverName;
    }

    private String getEEversion() {
        String eeVersion = null;
        NbMavenProject mavProj = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (mavProj != null) {
            EjbJar ejbProj;
            String pkgType = mavProj.getPackagingType();
            if ("ear".equals(pkgType)) {
                Ear earProj = Ear.getEar((FileObject)this.project.getProjectDirectory());
                if (earProj != null) {
                    eeVersion = earProj.getJ2eePlatformVersion();
                }
            } else if ("war".equals(pkgType)) {
                WebModule webM = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
                if (webM != null) {
                    eeVersion = webM.getJ2eePlatformVersion();
                }
            } else if ("ejb".equals(pkgType) && (ejbProj = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory())) != null) {
                eeVersion = ejbProj.getJ2eePlatformVersion();
            }
        }
        if (eeVersion == null) {
            eeVersion = NbBundle.getMessage(ProjectHookImpl.class, (String)"TXT_UnknownEEVersion");
        }
        return eeVersion;
    }
}

