/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class J2eeMavenSourcesImpl
implements Sources {
    public static final String TYPE_DOC_ROOT = "doc_root";
    public static final String TYPE_WEB_INF = "web_inf";
    private final Object lock = new Object();
    private final Project project;
    private final List<ChangeListener> listeners;
    private SourceGroup webDocSrcGroup;

    public J2eeMavenSourcesImpl(Project project) {
        this.project = project;
        this.listeners = new ArrayList<ChangeListener>();
        NbMavenProject.addPropertyChangeListener((Project)project, (PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("MavenProject".equals(event.getPropertyName())) {
                    J2eeMavenSourcesImpl.this.checkChanges(true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChanges(boolean synchronous) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            NbMavenProject mavenproject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            MavenProject mp = mavenproject.getMavenProject();
            FileObject fo = null;
            if (mp != null) {
                fo = FileUtilities.convertURItoFileObject((URI)mavenproject.getWebAppDirectory());
            }
            changed = this.checkWebDocGroupCache(fo);
        }
        if (changed) {
            if (synchronous) {
                this.fireChange();
            } else {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        J2eeMavenSourcesImpl.this.fireChange();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> currList;
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            currList = new ArrayList<ChangeListener>(this.listeners);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener list2 : currList) {
            list2.stateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    public SourceGroup[] getSourceGroups(String str) {
        if (TYPE_DOC_ROOT.equals(str)) {
            return this.createWebDocRoot();
        }
        return new SourceGroup[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceGroup[] createWebDocRoot() {
        FileObject folder = FileUtilities.convertURItoFileObject((URI)((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getWebAppDirectory());
        SourceGroup grp = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkWebDocGroupCache(folder);
            grp = this.webDocSrcGroup;
        }
        if (grp != null) {
            return new SourceGroup[]{grp};
        }
        return new SourceGroup[0];
    }

    private boolean checkWebDocGroupCache(FileObject root) {
        if (root == null && this.webDocSrcGroup != null) {
            this.webDocSrcGroup = null;
            return true;
        }
        if (root == null) {
            return false;
        }
        boolean changed = false;
        if (this.webDocSrcGroup == null || !this.webDocSrcGroup.getRootFolder().equals(root)) {
            this.webDocSrcGroup = GenericSources.group((Project)this.project, (FileObject)root, (String)TYPE_DOC_ROOT, (String)NbBundle.getMessage(J2eeMavenSourcesImpl.class, (String)"LBL_WebPages"), null, null);
            changed = true;
        }
        return changed;
    }
}

