/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.j2ee.BaseEEModuleProvider;
import org.netbeans.modules.maven.j2ee.EjbChangeDescriptorImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public abstract class BaseEEModuleImpl
implements J2eeModuleImplementation2,
ModuleChangeReporter {
    protected final Project project;
    protected final BaseEEModuleProvider provider;
    protected final String ddName;
    protected final String ddPath;

    public BaseEEModuleImpl(Project project, BaseEEModuleProvider provider, String ddName, String ddPath) {
        this.project = project;
        this.provider = provider;
        this.ddName = ddName;
        this.ddPath = ddPath;
    }

    protected final NbMavenProject mavenproject() {
        return (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
    }

    public FileObject getDeploymentDescriptor() {
        FileObject metaInf = this.getMetaInf();
        if (metaInf != null) {
            return metaInf.getFileObject(this.ddName);
        }
        return null;
    }

    public FileObject getMetaInf() {
        Sources srcs = ProjectUtils.getSources((Project)this.project);
        if (srcs != null) {
            SourceGroup[] grp = srcs.getSourceGroups("resources");
            for (int i = 0; i < grp.length; ++i) {
                FileObject fo;
                if (grp[i] == null || grp[i].getRootFolder() == null || (fo = grp[i].getRootFolder().getFileObject("META-INF")) == null) continue;
                return fo;
            }
        }
        return null;
    }

    public String getUrl() {
        return "/" + this.mavenproject().getMavenProject().getBuild().getFinalName();
    }

    public FileObject[] getJavaSources() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] sourceGroup = sources.getSourceGroups("java");
        ArrayList<FileObject> toRet = new ArrayList<FileObject>();
        if (sourceGroup != null) {
            for (SourceGroup group : sourceGroup) {
                toRet.add(group.getRootFolder());
            }
        }
        return toRet.toArray(new FileObject[toRet.size()]);
    }

    protected final FileObject getArchive(String groupID, String artifactID, String goal, String archiveType) throws IOException {
        MavenProject projectModel = this.mavenproject().getMavenProject();
        String archiveName = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)groupID, (String)artifactID, (String)(archiveType + "Name"), (String)goal);
        if (archiveName == null) {
            archiveName = projectModel.getBuild().getFinalName();
        }
        String archiveDir = projectModel.getBuild().getDirectory();
        File archiveFile = FileUtil.normalizeFile((File)new File(archiveDir, archiveName + "." + archiveType));
        return FileUtil.toFileObject((File)archiveFile);
    }

    protected final RootInterface getDeploymentDescriptor(String location) {
        if (this.ddName.equals(location)) {
            location = this.ddPath;
        }
        if (this.ddPath.equals(location)) {
            try {
                FileObject deploymentDescriptor;
                URI[] uris;
                FileObject content = this.getContentDirectory();
                if (content == null && (uris = this.mavenproject().getResources(false)).length > 0) {
                    content = URLMapper.findFileObject((URL)uris[0].toURL());
                }
                if (content != null && (deploymentDescriptor = content.getFileObject(this.ddPath)) != null) {
                    return DDProvider.getDefault().getDDRoot(deploymentDescriptor);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().log(e.getLocalizedMessage());
            }
        }
        return null;
    }

    public Iterator<J2eeModule.RootedEntry> getArchiveContents() throws IOException {
        FileObject fo = this.getContentDirectory();
        if (fo != null) {
            return new ContentIterator(fo);
        }
        return null;
    }

    public FileObject getContentDirectory() throws IOException {
        File file = this.mavenproject().getOutputDirectory(false);
        FileObject fo = FileUtil.toFileObject((File)file.getParentFile());
        if (fo != null) {
            fo.refresh();
        }
        return FileUtil.toFileObject((File)file);
    }

    public File getResourceDirectory() {
        return new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "src" + File.separator + "main" + File.separator + "setup");
    }

    public File getDeploymentConfigurationFile(String name) {
        if (name == null) {
            return null;
        }
        if (this.ddName.equals(name)) {
            name = this.ddPath;
        } else {
            String path = this.provider.getConfigSupport().getContentRelativePath(name);
            if (path != null) {
                name = path;
            }
        }
        return this.getDDFile(name);
    }

    public File getDDFile(String path) {
        URI[] dir = this.mavenproject().getResources(false);
        if (dir.length == 0) {
            return null;
        }
        File file = new File(new File(dir[0]), path);
        return FileUtil.normalizeFile((File)file);
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public boolean isManifestChanged(long timestamp) {
        return false;
    }

    public EjbChangeDescriptor getEjbChanges(long timestamp) {
        return new EjbChangeDescriptorImpl();
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        private FileObject f;
        private FileObject root;

        FSRootRE(FileObject rt, FileObject fo) {
            this.f = fo;
            this.root = rt;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static final class ContentIterator
    implements Iterator<J2eeModule.RootedEntry> {
        private ArrayList<FileObject> ch = new ArrayList();
        private FileObject root;

        private ContentIterator(FileObject f) {
            this.ch.add(f);
            this.root = f;
        }

        @Override
        public boolean hasNext() {
            return !this.ch.isEmpty();
        }

        @Override
        public J2eeModule.RootedEntry next() {
            FileObject f = this.ch.get(0);
            this.ch.remove(0);
            if (f.isFolder()) {
                f.refresh();
                for (FileObject fo : f.getChildren()) {
                    this.ch.add(fo);
                }
            }
            return new FSRootRE(this.root, f);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

