/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.primefaces.util.ComponentUtils;

public class AjaxRequestBuilder {
    protected StringBuilder buffer = new StringBuilder();
    private boolean preventDefault = false;

    public AjaxRequestBuilder() {
        this.buffer.append("PrimeFaces.ab({");
    }

    public AjaxRequestBuilder source(String source) {
        if (source != null) {
            this.buffer.append("source:").append("'").append(source).append("'");
        } else {
            this.buffer.append("source:").append("this");
        }
        return this;
    }

    public AjaxRequestBuilder form(String form) {
        if (form != null) {
            this.buffer.append(",formId:'").append(form).append("'");
        }
        return this;
    }

    private String[] parseIds(String ids) {
        String regular;
        String selector;
        Pattern p = Pattern.compile("@\\(.+\\)\\s*");
        Matcher m = p.matcher(ids);
        if (m.find()) {
            selector = m.group().trim();
            regular = m.replaceAll("");
        } else {
            selector = null;
            regular = ids;
        }
        if (this.isValueBlank(regular)) {
            regular = null;
        }
        return new String[]{regular, selector};
    }

    private boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    public AjaxRequestBuilder process(FacesContext context, UIComponent component, String ids) {
        this.addIds(context, component, ids, "process", "processSelector");
        return this;
    }

    public AjaxRequestBuilder update(FacesContext context, UIComponent component, String ids) {
        this.addIds(context, component, ids, "update", "updateSelector");
        return this;
    }

    private AjaxRequestBuilder addIds(FacesContext context, UIComponent component, String ids, String key, String keySel) {
        if (!this.isValueBlank(ids)) {
            String[] parsed = this.parseIds(ids);
            String regular = parsed[0];
            String selector = parsed[1];
            if (regular != null) {
                this.buffer.append(",").append(key).append(":'").append(ComponentUtils.findClientIds(context, component, regular)).append("'");
            }
            if (selector != null) {
                this.buffer.append(",").append(keySel).append(":'").append(selector).append("'");
            }
        }
        return this;
    }

    public AjaxRequestBuilder event(String event) {
        this.buffer.append(",event:'").append(event).append("'");
        return this;
    }

    public AjaxRequestBuilder async(boolean async) {
        if (async) {
            this.buffer.append(",async:true");
        }
        return this;
    }

    public AjaxRequestBuilder global(boolean global) {
        if (!global) {
            this.buffer.append(",global:false");
        }
        return this;
    }

    public AjaxRequestBuilder partialSubmit(boolean value, boolean partialSubmitSet) {
        boolean partialSubmit;
        boolean bl = partialSubmit = partialSubmitSet ? value : ComponentUtils.isPartialSubmitEnabled(FacesContext.getCurrentInstance());
        if (partialSubmit) {
            this.buffer.append(",partialSubmit:true");
        }
        return this;
    }

    public AjaxRequestBuilder onstart(String onstart) {
        if (onstart != null) {
            this.buffer.append(",onstart:function(cfg){").append(onstart).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder onerror(String onerror) {
        if (onerror != null) {
            this.buffer.append(",onerror:function(xhr,status,error){").append(onerror).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder onsuccess(String onsuccess) {
        if (onsuccess != null) {
            this.buffer.append(",onsuccess:function(data,status,xhr){").append(onsuccess).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder oncomplete(String oncomplete) {
        if (oncomplete != null) {
            this.buffer.append(",oncomplete:function(xhr,status,args){").append(oncomplete).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder params(UIComponent component) {
        boolean paramWritten = false;
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            if (!paramWritten) {
                paramWritten = true;
                this.buffer.append(",params:[");
            } else {
                this.buffer.append(",");
            }
            this.buffer.append("{name:").append("'").append(parameter.getName()).append("',value:'").append(parameter.getValue()).append("'}");
        }
        if (paramWritten) {
            this.buffer.append("]");
        }
        return this;
    }

    public AjaxRequestBuilder passParams() {
        this.buffer.append(",params:arguments[0]");
        return this;
    }

    public AjaxRequestBuilder preventDefault() {
        this.preventDefault = true;
        return this;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public String build() {
        this.buffer.append("});");
        if (this.preventDefault) {
            this.buffer.append("return false;");
        }
        String request = this.buffer.toString();
        this.buffer.setLength(0);
        return request;
    }

    public String buildBehavior() {
        this.buffer.append("}, arguments[1]);");
        if (this.preventDefault) {
            this.buffer.append("return false;");
        }
        String request = this.buffer.toString();
        this.buffer.setLength(0);
        return request;
    }
}

