/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.FacesContext;
import org.primefaces.context.RequestContext;
import org.primefaces.visit.ResetInputVisitCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRequestContext
extends RequestContext {
    private static final String CALLBACK_PARAMS_KEY = "CALLBACK_PARAMS";
    private static final String EXECUTE_SCRIPT_KEY = "EXECUTE_SCRIPT";
    private Map<String, Object> attributes = new HashMap<String, Object>();

    @Override
    public boolean isAjaxRequest() {
        return FacesContext.getCurrentInstance().getPartialViewContext().isAjaxRequest();
    }

    @Override
    public void addCallbackParam(String name, Object value) {
        this.getCallbackParams().put(name, value);
    }

    @Override
    public void execute(String script) {
        this.getScriptsToExecute().add(script);
    }

    @Override
    public Map<String, Object> getCallbackParams() {
        if (this.attributes.get(CALLBACK_PARAMS_KEY) == null) {
            this.attributes.put(CALLBACK_PARAMS_KEY, new HashMap());
        }
        return (Map)this.attributes.get(CALLBACK_PARAMS_KEY);
    }

    @Override
    public List<String> getScriptsToExecute() {
        if (this.attributes.get(EXECUTE_SCRIPT_KEY) == null) {
            this.attributes.put(EXECUTE_SCRIPT_KEY, new ArrayList());
        }
        return (List)this.attributes.get(EXECUTE_SCRIPT_KEY);
    }

    @Override
    public void scrollTo(String clientId) {
        this.execute("PrimeFaces.scrollTo('" + clientId + "');");
    }

    @Override
    public void update(String clientId) {
        FacesContext.getCurrentInstance().getPartialViewContext().getRenderIds().add(clientId);
    }

    @Override
    public void update(Collection<String> collection) {
        FacesContext.getCurrentInstance().getPartialViewContext().getRenderIds().addAll(collection);
    }

    @Override
    public void reset(Collection<String> ids) {
        FacesContext context = FacesContext.getCurrentInstance();
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, hints);
        ResetInputVisitCallback visitCallback = new ResetInputVisitCallback();
        UIViewRoot root = context.getViewRoot();
        for (String id : ids) {
            UIComponent targetComponent = root.findComponent(id);
            if (targetComponent == null) {
                throw new FacesException("Cannot find component with identifier \"" + id + "\" referenced from viewroot.");
            }
            targetComponent.visitTree(visitContext, (VisitCallback)visitCallback);
        }
    }

    @Override
    public void reset(String id) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(id);
        this.reset(list);
    }
}

