/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tree;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tree.Tree;
import org.primefaces.component.tree.UITreeNode;
import org.primefaces.model.TreeNode;
import org.primefaces.renderkit.CoreRenderer;

public class TreeRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Tree tree = (Tree)component;
        this.decodeSelection(context, tree);
        this.decodeBehaviors(context, (UIComponent)tree);
    }

    public void decodeSelection(FacesContext context, Tree tree) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(context);
        if (tree.getSelectionMode() != null) {
            String selection = (String)params.get(clientId + "_selection");
            boolean isSingle = tree.getSelectionMode().equalsIgnoreCase("single");
            if (this.isValueBlank(selection)) {
                if (isSingle) {
                    tree.setSelection(null);
                } else {
                    tree.setSelection(new TreeNode[0]);
                }
            } else {
                String[] selectedRowKeys = selection.split(",");
                if (isSingle) {
                    tree.setRowKey(selectedRowKeys[0]);
                    tree.setSelection(tree.getRowNode());
                } else {
                    TreeNode[] selectedNodes = new TreeNode[selectedRowKeys.length];
                    for (int i = 0; i < selectedRowKeys.length; ++i) {
                        tree.setRowKey(selectedRowKeys[i]);
                        selectedNodes[i] = tree.getRowNode();
                    }
                    tree.setSelection(selectedNodes);
                }
                tree.setRowKey(null);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Tree tree = (Tree)component;
        if (tree.isNodeExpandRequest(context)) {
            String clientId = tree.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            String rowKey = (String)params.get(clientId + "_expandNode");
            tree.setRowKey(rowKey);
            TreeNode node = tree.getRowNode();
            node.setExpanded(true);
            this.encodeTreeNodeChildren(context, tree, node, clientId, rowKey, tree.isDynamic(), tree.isCheckboxSelection());
            tree.setRowKey(null);
        } else {
            this.encodeMarkup(context, tree);
            this.encodeScript(context, tree);
        }
    }

    protected void encodeScript(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getClientId(context);
        boolean dynamic = tree.isDynamic();
        String selectionMode = tree.getSelectionMode();
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('Tree','" + tree.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",dynamic:" + dynamic);
        if (dynamic) {
            writer.write(",cache:" + tree.isCache());
        }
        if (selectionMode != null) {
            writer.write(",selectionMode:'" + selectionMode + "'");
            writer.write(",highlight:" + tree.isHighlight());
        }
        if (tree.getOnNodeClick() != null) {
            writer.write(",onNodeClick:function(node) {" + tree.getOnNodeClick() + "}");
        }
        if (tree.isAnimate()) {
            writer.write(",animate:true");
        }
        this.encodeIconStates(context, tree);
        this.encodeClientBehaviors(context, tree);
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getClientId(context);
        TreeNode root = tree.getValue();
        boolean dynamic = tree.isDynamic();
        String selectionMode = tree.getSelectionMode();
        boolean selectable = selectionMode != null;
        boolean multiselectable = selectable && selectionMode.equals("single");
        boolean checkbox = selectable && selectionMode.equals("checkbox");
        String containerClass = tree.getStyleClass() == null ? Tree.CONTAINER_CLASS : Tree.CONTAINER_CLASS + " " + tree.getStyleClass();
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.writeAttribute("role", (Object)"tree", null);
        writer.writeAttribute("aria-multiselectable", (Object)String.valueOf(multiselectable), null);
        if (tree.getStyle() != null) {
            writer.writeAttribute("style", (Object)tree.getStyle(), null);
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)Tree.ROOT_NODES_CLASS, null);
        if (root != null) {
            root.setExpanded(true);
            this.encodeTreeNode(context, tree, root, clientId, null, dynamic, checkbox);
        }
        writer.endElement("ul");
        if (selectable) {
            this.encodeSelectionHolder(context, tree);
        }
        writer.endElement("div");
    }

    public void encodeTreeNode(FacesContext context, Tree tree, TreeNode node, String clientId, String rowKey, boolean dynamic, boolean checkbox) throws IOException {
        if (rowKey != null) {
            ResponseWriter writer = context.getResponseWriter();
            tree.setRowKey(rowKey);
            boolean isLeaf = node.isLeaf();
            boolean expanded = node.isExpanded();
            boolean selectable = node.isSelectable();
            String toggleIcon = expanded ? Tree.EXPANDED_ICON_CLASS : Tree.COLLAPSED_ICON_CLASS;
            String stateIcon = isLeaf ? Tree.LEAF_ICON_CLASS : toggleIcon;
            UITreeNode uiTreeNode = tree.getUITreeNodeByType(node.getType());
            Object datakey = tree.getDatakey();
            String nodeId = clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + rowKey;
            boolean selected = node.isSelected();
            if (selected) {
                tree.getSelectedRowKeys().add(rowKey);
            }
            String containerClass = isLeaf ? Tree.LEAF_NODE_CLASS : Tree.PARENT_NODE_CLASS;
            containerClass = uiTreeNode.getStyleClass() == null ? containerClass : containerClass + " " + uiTreeNode.getStyleClass();
            containerClass = containerClass + " " + uiTreeNode.getType();
            writer.startElement("li", null);
            writer.writeAttribute("id", (Object)nodeId, null);
            writer.writeAttribute("data-rowkey", (Object)rowKey, null);
            writer.writeAttribute("class", (Object)containerClass, null);
            writer.writeAttribute("role", (Object)"treeitem", null);
            if (datakey != null) {
                writer.writeAttribute("data-datakey", datakey, null);
            }
            String contentClass = selectable ? Tree.SELECTABLE_NODE_CONTENT_CLASS : Tree.NODE_CONTENT_CLASS;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)contentClass, null);
            writer.writeAttribute("aria-expanded", (Object)String.valueOf(expanded), null);
            writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
            if (checkbox) {
                writer.writeAttribute("aria-checked", (Object)String.valueOf(selected), null);
            }
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)stateIcon, null);
            writer.endElement("span");
            if (checkbox && selectable) {
                this.encodeCheckbox(context, tree, node, selected);
            }
            writer.startElement("span", null);
            String icon = uiTreeNode.getIconToRender(expanded);
            if (icon != null) {
                writer.writeAttribute("class", (Object)(Tree.NODE_ICON_CLASS + " " + icon), null);
            }
            writer.endElement("span");
            String nodeLabelClass = selected && !checkbox ? Tree.NODE_LABEL_CLASS + " ui-state-highlight" : Tree.NODE_LABEL_CLASS;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)nodeLabelClass, null);
            uiTreeNode.encodeAll(context);
            writer.endElement("span");
            writer.endElement("span");
            boolean shouldRender = dynamic && expanded || !dynamic;
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)Tree.CHILDREN_NODES_CLASS, null);
            if (!expanded) {
                writer.writeAttribute("style", (Object)"display:none", null);
            }
            if (shouldRender) {
                this.encodeTreeNodeChildren(context, tree, node, clientId, rowKey, dynamic, checkbox);
            }
            writer.endElement("ul");
            writer.endElement("li");
        } else {
            this.encodeTreeNodeChildren(context, tree, node, clientId, rowKey, dynamic, checkbox);
        }
    }

    public void encodeTreeNodeChildren(FacesContext context, Tree tree, TreeNode node, String clientId, String rowKey, boolean dynamic, boolean checkbox) throws IOException {
        int childIndex = 0;
        Iterator<TreeNode> iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            String childRowKey = rowKey == null ? String.valueOf(childIndex) : rowKey + "_" + childIndex;
            this.encodeTreeNode(context, tree, iterator.next(), clientId, childRowKey, dynamic, checkbox);
            ++childIndex;
        }
    }

    protected void encodeIconStates(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map<String, UITreeNode> nodes = tree.getTreeNodes();
        writer.write(",iconStates:{");
        boolean firstWritten = false;
        for (String type : nodes.keySet()) {
            UITreeNode node = nodes.get(type);
            String expandedIcon = node.getExpandedIcon();
            String collapsedIcon = node.getCollapsedIcon();
            if (expandedIcon == null || collapsedIcon == null) continue;
            if (firstWritten) {
                writer.write(",");
            }
            writer.write("'" + node.getType() + "' : {");
            writer.write("expandedIcon:'" + expandedIcon + "'");
            writer.write(",collapsedIcon:'" + collapsedIcon + "'");
            writer.write("}");
            firstWritten = true;
        }
        writer.write("}");
    }

    protected void encodeSelectionHolder(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = tree.getClientId(context) + "_selection";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("value", (Object)tree.getSelectedRowKeysAsString(), null);
        writer.endElement("input");
    }

    protected void encodeCheckbox(FacesContext context, Tree tree, TreeNode node, boolean selected) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String iconClass = selected ? "ui-chkbox-icon ui-icon ui-icon-check" : "ui-chkbox-icon";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chkbox ui-widget", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chkbox-box ui-widget ui-corner-all ui-state-default", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

