/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tieredmenu;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.separator.Separator;
import org.primefaces.component.submenu.Submenu;
import org.primefaces.component.tieredmenu.TieredMenu;

public class TieredMenuRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TieredMenu menu = (TieredMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('TieredMenu','" + menu.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",autoDisplay:" + menu.isAutoDisplay());
        if (menu.isOverlay()) {
            this.encodeOverlayConfig(context, menu);
        }
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        TieredMenu menu = (TieredMenu)abstractMenu;
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        String defaultStyleClass = menu.isOverlay() ? "ui-menu ui-tieredmenu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow" : "ui-menu ui-tieredmenu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix";
        styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        this.encodeMenu(context, menu, style, styleClass, "menu");
    }

    protected void encodeMenu(FacesContext context, AbstractMenu component, String style, String styleClass, String role) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("role", (Object)"menubar", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        this.encodeMenuContent(context, (UIComponent)component);
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeMenuContent(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, (MenuItem)child);
                writer.endElement("li");
                continue;
            }
            if (child instanceof Submenu) {
                Submenu submenu = (Submenu)child;
                String style = submenu.getStyle();
                String styleClass = submenu.getStyleClass();
                styleClass = styleClass == null ? "ui-widget ui-menuitem ui-corner-all ui-menu-parent" : "ui-widget ui-menuitem ui-corner-all ui-menu-parent " + styleClass;
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)styleClass, null);
                if (style != null) {
                    writer.writeAttribute("style", (Object)style, null);
                }
                writer.writeAttribute("role", (Object)"menuitem", null);
                writer.writeAttribute("aria-haspopup", (Object)"true", null);
                this.encodeSubmenu(context, (Submenu)child);
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)child);
        }
    }

    protected void encodeSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getIcon();
        String label = submenu.getLabel();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"javascript:void(0)", null);
        writer.writeAttribute("class", (Object)"ui-menuitem-link ui-corner-all", null);
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
            writer.endElement("span");
        }
        if (label != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
            writer.writeText((Object)submenu.getLabel(), "value");
            writer.endElement("span");
        }
        this.encodeSubmenuIcon(context, submenu);
        writer.endElement("a");
        if (submenu.getChildCount() > 0) {
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-menu-list ui-corner-all ui-helper-clearfix ui-menu-child ui-shadow", null);
            writer.writeAttribute("role", (Object)"menu", null);
            this.encodeMenuContent(context, (UIComponent)submenu);
            writer.endElement("ul");
        }
    }

    protected void encodeSubmenuIcon(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-e", null);
        writer.endElement("span");
    }
}

